﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

using EffectMaker.DataModel.Attributes;
using EffectMaker.DataModel.DataModels;
using EffectMaker.DataModel.Extensions;
using EffectMaker.DataModel.Specific.DataModels;
using EffectMaker.Foundation.Primitives;
using EffectMaker.Foundation.Serialization;
using System;
using System.Linq;
using System.Xml.Serialization;

using CurrVersion = EffectMaker.DataModel.Specific.DataModels;
using CurrVersionSerializer = EffectMaker.DataModel.Specific.Serializer;

namespace EffectMaker.DataModel.Specific.DataModels
{
    /// <summary>
    /// [AUTO GENERATED SOURCE CODE, DO NOT MODIFY]
    /// ビューアノード/背景画像タブ/背景画像グループです。
    /// </summary>
    [Serializable]
    public class ViewerBackgroundImageData : DataModelBase
    {
        /// <summary>
        /// 背景画像への乗算カラーです。
        /// </summary>
        private ColorRgba multiplyColor = null;

        /// <summary>
        /// コンストラクタです.
        /// </summary>
        public ViewerBackgroundImageData() :
            base()
        {
            this.ImageFilePath = string.Empty;

            this.PostConstruct();
        }

        /// <summary>
        /// ファイルパスです。
        /// </summary>
        [DataModelPropertyGuid("a39794d3-ce12-4837-b34c-e85e4aea3d83")]
        public string ImageFilePath { get; set; }

        /// <summary>
        /// 背景画像への乗算カラーです。
        /// </summary>
        [DataModelPropertyGuid("6d91aba4-32bb-4660-8a46-69ddf6786b69")]
        public ColorRgba MultiplyColor
        {
            get { return this.GetObjectFromField(ref this.multiplyColor, false); }
            set { this.SetISettableToField(ref this.multiplyColor, value); }
        }

        /// <summary>
        /// 入力データモデルからの値を設定します.
        /// </summary>
        /// <param name="src">入力データモデルです.</param>
        /// <returns>設定に成功したらtrueを返却します.</returns>
        public override bool Set(object src)
        {
            var srcDataModel = src as CurrVersion.ViewerBackgroundImageData;
            if (srcDataModel == null)
            {
                return false;
            }

            if (base.Set(src) == false)
            {
                return false;
            }

            this.ImageFilePath = srcDataModel.ImageFilePath;
            this.MultiplyColor = srcDataModel.MultiplyColor;

            return true;
        }

        /// <summary>
        /// Write the data model to XML document.
        /// </summary>
        /// <param name="context">Holds the data needed for serialization.</param>
        /// <returns>True on success.</returns>
        public override bool WriteXml(XmlDocSerializationContext context)
        {
            // Serialize the base class.
            bool success = base.WriteXml(context);

            this.WriteElement(context, "ImageFilePath", this.ImageFilePath);
            this.WriteElement(context, "MultiplyColor", this.MultiplyColor);

            return success;
        }

        /// <summary>
        /// Read the data model from XML document.
        /// </summary>
        /// <param name="context">Holds the data needed for deserialization.</param>
        /// <returns>True on success.</returns>
        public override bool ReadXml(XmlDocSerializationContext context)
        {
            // Deserialize the base class.
            bool success = base.ReadXml(context);

            this.ImageFilePath = this.ReadElement(context, "ImageFilePath", this.ImageFilePath);
            this.MultiplyColor = this.ReadElement(context, "MultiplyColor", this.MultiplyColor);

            return success;
        }
    }
}
