﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

using EffectMaker.DataModel.Attributes;
using EffectMaker.DataModel.DataModels;
using EffectMaker.DataModel.Extensions;
using EffectMaker.DataModel.Specific.DataModels;
using EffectMaker.Foundation.Primitives;
using EffectMaker.Foundation.Serialization;
using System;
using System.Linq;
using System.Xml.Serialization;

using CurrVersion = EffectMaker.DataModel.Specific.DataModels.Version_0_0_0_0;
using CurrVersionSerializer = EffectMaker.DataModel.Specific.Serializer.Version_0_0_0_0;

namespace EffectMaker.DataModel.Specific.DataModels.Version_0_0_0_0
{
    /// <summary>
    /// [AUTO GENERATED SOURCE CODE, DO NOT MODIFY]
    /// エミッタノード/スケールタブ/その他スケール設定グループデータです。
    /// </summary>
    [Serializable]
    public class EmitterScaleAdditionalAnimationData : DataModelBase
    {
        /// <summary>
        /// コンストラクタです.
        /// </summary>
        public EmitterScaleAdditionalAnimationData() :
            base()
        {
            this.EnableScaleVelAddY = false;
            this.ScaleVelAddY = 0.0f;

            this.PostConstruct();
        }

        /// <summary>
        /// 速度で頂点を変形のOn/Offを取得または設定します。
        /// </summary>
        [DataModelPropertyGuid("ab943196-7e5b-4bf1-bee5-a00d30cfec7a")]
        public bool EnableScaleVelAddY { get; set; }

        /// <summary>
        /// 速度で頂点を変形の加算値を取得または設定します。
        /// </summary>
        [DataModelPropertyGuid("3c003fd6-0c70-4ffc-b375-6888c1462e5e")]
        public float ScaleVelAddY { get; set; }

        /// <summary>
        /// 入力データモデルからの値を設定します.
        /// </summary>
        /// <param name="src">入力データモデルです.</param>
        /// <returns>設定に成功したらtrueを返却します.</returns>
        public override bool Set(object src)
        {
            var srcDataModel = src as CurrVersion.EmitterScaleAdditionalAnimationData;
            if (srcDataModel == null)
            {
                return false;
            }

            if (base.Set(src) == false)
            {
                return false;
            }

            this.EnableScaleVelAddY = srcDataModel.EnableScaleVelAddY;
            this.ScaleVelAddY = srcDataModel.ScaleVelAddY;

            return true;
        }

        /// <summary>
        /// Write the data model to XML document.
        /// </summary>
        /// <param name="context">Holds the data needed for serialization.</param>
        /// <returns>True on success.</returns>
        public override bool WriteXml(XmlDocSerializationContext context)
        {
            // Serialize the base class.
            bool success = base.WriteXml(context);

            this.WriteElement(context, "EnableScaleVelAddY", this.EnableScaleVelAddY);
            this.WriteElement(context, "ScaleVelAddY", this.ScaleVelAddY);

            return success;
        }

        /// <summary>
        /// Read the data model from XML document.
        /// </summary>
        /// <param name="context">Holds the data needed for deserialization.</param>
        /// <returns>True on success.</returns>
        public override bool ReadXml(XmlDocSerializationContext context)
        {
            // Deserialize the base class.
            bool success = base.ReadXml(context);

            this.EnableScaleVelAddY = this.ReadElement(context, "EnableScaleVelAddY", this.EnableScaleVelAddY);
            this.ScaleVelAddY = this.ReadElement(context, "ScaleVelAddY", this.ScaleVelAddY);

            return success;
        }
    }
}
