﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

using EffectMaker.DataModel.Attributes;
using EffectMaker.DataModel.DataModels;
using EffectMaker.DataModel.Extensions;
using EffectMaker.DataModel.Specific.DataModels;
using EffectMaker.Foundation.Primitives;
using EffectMaker.Foundation.Serialization;
using System;
using System.Linq;
using System.Xml.Serialization;

using CurrVersion = EffectMaker.DataModel.Specific.DataModels.Version_0_0_0_0;
using CurrVersionSerializer = EffectMaker.DataModel.Specific.Serializer.Version_0_0_0_0;

namespace EffectMaker.DataModel.Specific.DataModels.Version_0_0_0_0
{
    /// <summary>
    /// [AUTO GENERATED SOURCE CODE, DO NOT MODIFY]
    /// エミッタノード/パーティクルタブ/揺らぎ設定グループデータです。
    /// </summary>
    [Serializable]
    public class EmitterParticleFluctuationData : DataModelBase
    {
        /// <summary>
        /// 振幅を取得または設定します。
        /// </summary>
        private Vector2f amplitude = null;

        /// <summary>
        /// 周期を取得または設定します。
        /// </summary>
        private Vector2i frequency = null;

        /// <summary>
        /// 初期位相を取得または設定します。
        /// </summary>
        private Vector2i initPhase = null;

        /// <summary>
        /// 位相ランダムの値を取得または設定します。
        /// </summary>
        private Vector2i phaseRandom = null;

        /// <summary>
        /// コンストラクタです.
        /// </summary>
        public EmitterParticleFluctuationData() :
            base()
        {
            this.WaveType = 1<<3;
            this.ApplyAlpha = false;
            this.ApplyScale = false;
            this.ApplyScaleY = false;
            this.Amplitude = new Vector2f(1.0f, 1.0f);
            this.Frequency = new Vector2i(20, 20);
            this.InitPhase = new Vector2i(0, 0);
            this.PhaseRandom = new Vector2i(0, 0);

            this.PostConstruct();
        }

        /// <summary>
        /// 波形タイプを取得または設定します。
        /// </summary>
        [DataModelPropertyGuid("8c71cebb-d015-4097-83cb-befd1ea054e5")]
        public int WaveType { get; set; }

        /// <summary>
        /// 揺らぎの適用のアルファのOn/Offを取得または設定します。
        /// </summary>
        [DataModelPropertyGuid("1b7c70ed-f587-4735-80dc-e12ee27e5f15")]
        public bool ApplyAlpha { get; set; }

        /// <summary>
        /// 揺らぎの適用のスケールのOn/Offを取得または設定します。
        /// </summary>
        [DataModelPropertyGuid("9680e636-8134-47e5-a7e2-2779f03e5bbc")]
        public bool ApplyScale { get; set; }

        /// <summary>
        /// スケールYを個別に設定のOn/Offを取得または設定します。
        /// </summary>
        [DataModelPropertyGuid("52bf9594-cfbb-41ed-b64a-8625e74a7050")]
        public bool ApplyScaleY { get; set; }

        /// <summary>
        /// 振幅を取得または設定します。
        /// </summary>
        [DataModelPropertyGuid("d63a980e-0744-40e5-89ce-867192dd4729")]
        public Vector2f Amplitude
        {
            get { return this.GetObjectFromField(ref this.amplitude, false); }
            set { this.SetISettableToField(ref this.amplitude, value); }
        }

        /// <summary>
        /// 周期を取得または設定します。
        /// </summary>
        [DataModelPropertyGuid("e5921adb-1451-44ff-b2f0-bac02357ff55")]
        public Vector2i Frequency
        {
            get { return this.GetObjectFromField(ref this.frequency, false); }
            set { this.SetISettableToField(ref this.frequency, value); }
        }

        /// <summary>
        /// 初期位相を取得または設定します。
        /// </summary>
        [DataModelPropertyGuid("2328400b-c37f-4261-b151-cef0b8e32699")]
        public Vector2i InitPhase
        {
            get { return this.GetObjectFromField(ref this.initPhase, false); }
            set { this.SetISettableToField(ref this.initPhase, value); }
        }

        /// <summary>
        /// 位相ランダムの値を取得または設定します。
        /// </summary>
        [DataModelPropertyGuid("5b66b689-8dde-46af-a122-089123f75da6")]
        public Vector2i PhaseRandom
        {
            get { return this.GetObjectFromField(ref this.phaseRandom, false); }
            set { this.SetISettableToField(ref this.phaseRandom, value); }
        }

        /// <summary>
        /// 入力データモデルからの値を設定します.
        /// </summary>
        /// <param name="src">入力データモデルです.</param>
        /// <returns>設定に成功したらtrueを返却します.</returns>
        public override bool Set(object src)
        {
            var srcDataModel = src as CurrVersion.EmitterParticleFluctuationData;
            if (srcDataModel == null)
            {
                return false;
            }

            if (base.Set(src) == false)
            {
                return false;
            }

            this.WaveType = srcDataModel.WaveType;
            this.ApplyAlpha = srcDataModel.ApplyAlpha;
            this.ApplyScale = srcDataModel.ApplyScale;
            this.ApplyScaleY = srcDataModel.ApplyScaleY;
            this.Amplitude = srcDataModel.Amplitude;
            this.Frequency = srcDataModel.Frequency;
            this.InitPhase = srcDataModel.InitPhase;
            this.PhaseRandom = srcDataModel.PhaseRandom;

            return true;
        }

        /// <summary>
        /// Write the data model to XML document.
        /// </summary>
        /// <param name="context">Holds the data needed for serialization.</param>
        /// <returns>True on success.</returns>
        public override bool WriteXml(XmlDocSerializationContext context)
        {
            // Serialize the base class.
            bool success = base.WriteXml(context);

            this.WriteElement(context, "WaveType", this.WaveType);
            this.WriteElement(context, "ApplyAlpha", this.ApplyAlpha);
            this.WriteElement(context, "ApplyScale", this.ApplyScale);
            this.WriteElement(context, "ApplyScaleY", this.ApplyScaleY);
            this.WriteElement(context, "Amplitude", this.Amplitude);
            this.WriteElement(context, "Frequency", this.Frequency);
            this.WriteElement(context, "InitPhase", this.InitPhase);
            this.WriteElement(context, "PhaseRandom", this.PhaseRandom);

            return success;
        }

        /// <summary>
        /// Read the data model from XML document.
        /// </summary>
        /// <param name="context">Holds the data needed for deserialization.</param>
        /// <returns>True on success.</returns>
        public override bool ReadXml(XmlDocSerializationContext context)
        {
            // Deserialize the base class.
            bool success = base.ReadXml(context);

            this.WaveType = this.ReadElement(context, "WaveType", this.WaveType);
            this.ApplyAlpha = this.ReadElement(context, "ApplyAlpha", this.ApplyAlpha);
            this.ApplyScale = this.ReadElement(context, "ApplyScale", this.ApplyScale);
            this.ApplyScaleY = this.ReadElement(context, "ApplyScaleY", this.ApplyScaleY);
            this.Amplitude = this.ReadElement(context, "Amplitude", this.Amplitude);
            this.Frequency = this.ReadElement(context, "Frequency", this.Frequency);
            this.InitPhase = this.ReadElement(context, "InitPhase", this.InitPhase);
            this.PhaseRandom = this.ReadElement(context, "PhaseRandom", this.PhaseRandom);

            return success;
        }
    }
}
