﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

using EffectMaker.DataModel.Attributes;
using EffectMaker.DataModel.DataModels;
using EffectMaker.DataModel.Extensions;
using EffectMaker.DataModel.Specific.DataModels;
using EffectMaker.Foundation.Primitives;
using EffectMaker.Foundation.Serialization;
using System;
using System.Linq;
using System.Xml.Serialization;

using CurrVersion = EffectMaker.DataModel.Specific.DataModels.Version_0_0_0_0;
using CurrVersionSerializer = EffectMaker.DataModel.Specific.Serializer.Version_0_0_0_0;

namespace EffectMaker.DataModel.Specific.DataModels.Version_0_0_0_0
{
    /// <summary>
    /// [AUTO GENERATED SOURCE CODE, DO NOT MODIFY]
    /// エミッタノード/放出タブ/放出設定グループデータです。
    /// </summary>
    [Serializable]
    public class EmitterEmissionTimingData : DataModelBase
    {
        /// <summary>
        /// 放出タイミング／放出レートのアニメーションデータセットです。
        /// </summary>
        private EmitterAnimationCommonData emitTimeRateAnimation = null;

        /// <summary>
        /// コンストラクタです.
        /// </summary>
        public EmitterEmissionTimingData() :
            base()
        {
            this.EnableOnce = false;
            this.EmitStartFrame = 0;
            this.EmitTimingRate = 0;
            this.EmitDuration = 1;
            this.EmitDistUnitType = 0;
            this.EmitTimeEmissionRate = 1.0f;
            this.EmitTimeEmissionRateRandom = 0;
            this.EmitTimeDistUnit = 10;
            this.EmitTimeDistUnitRandom = 0;
            this.EmitDistParticleMax = 100;
            this.EmitDistDistUnit = 1.0f;
            this.EmitDistMaxDistPerFrame = 10.0f;
            this.EmitDistMinDistPerFrame = 0.0f;
            this.EmitDistMargin = 0.0f;

            this.PostConstruct();
        }

        /// <summary>
        /// ワンタイムのOn/Offを取得または設定します。
        /// </summary>
        [DataModelPropertyGuid("1b04f515-a95c-479f-9177-0d93bcdd3d22")]
        public bool EnableOnce { get; set; }

        /// <summary>
        /// 放出開始フレームを取得または設定します。
        /// ルートエミッタのとき有効になります。
        /// </summary>
        [DataModelPropertyGuid("34d20b2b-a524-48d7-8c56-05f14355f8b2")]
        public uint EmitStartFrame { get; set; }

        /// <summary>
        /// 放出タイミング(%)を取得または設定します。
        /// チャイルドエミッタのとき有効になります。
        /// </summary>
        [DataModelPropertyGuid("819e4495-0bce-404e-a363-a2461a30cade")]
        public uint EmitTimingRate { get; set; }

        /// <summary>
        /// 放出時間を取得または設定します。
        /// ワンタイムがOnのとき有効になります。
        /// </summary>
        [DataModelPropertyGuid("52232b57-d9bc-4367-aaf2-4b69b0e6ffa8")]
        public uint EmitDuration { get; set; }

        /// <summary>
        /// 放出間隔タイプを取得または設定します。
        /// </summary>
        [DataModelPropertyGuid("822ff6b1-1b69-4bbc-b648-12fcd423157b")]
        public int EmitDistUnitType { get; set; }

        /// <summary>
        /// [時間]放出レート
        /// </summary>
        [DataModelPropertyGuid("7875e582-f633-4061-a109-b28b00a52be2")]
        public float EmitTimeEmissionRate { get; set; }

        /// <summary>
        /// [時間]放出レートランダム
        /// </summary>
        [DataModelPropertyGuid("34459cdc-eac8-42e5-8d7c-fe05826a4422")]
        public int EmitTimeEmissionRateRandom { get; set; }

        /// <summary>
        /// 放出タイミング／放出レートのアニメーションデータセットです。
        /// </summary>
        [DataModelPropertyGuid("a1e0278a-7e85-4101-a856-48c8100ce96c")]
        public EmitterAnimationCommonData EmitTimeRateAnimation
        {
            get { return this.GetDataModelFromField(ref this.emitTimeRateAnimation, false); }
            set { this.SetDataModelToField(ref this.emitTimeRateAnimation, value); }
        }

        /// <summary>
        /// [時間]放出間隔.
        /// </summary>
        [DataModelPropertyGuid("b9760e3f-96aa-406c-9f2a-65e4a3af6673")]
        public int EmitTimeDistUnit { get; set; }

        /// <summary>
        /// 放出間隔タイプ「時間」の放出間隔ランダムの値を取得または設定します。
        /// </summary>
        [DataModelPropertyGuid("32515364-df87-40e2-8ca8-b0e39a28992f")]
        public int EmitTimeDistUnitRandom { get; set; }

        /// <summary>
        /// 放出間隔タイプ「距離」のパーティクル放出最大数を取得または設定します。
        /// </summary>
        [DataModelPropertyGuid("531bb35e-22e9-475d-bcab-1f39012c8edc")]
        public int EmitDistParticleMax { get; set; }

        /// <summary>
        /// 放出間隔タイプ「距離」の放出間隔を取得または設定します。
        /// </summary>
        [DataModelPropertyGuid("b0350656-1910-4ce7-bc9f-cff94a80d61a")]
        public float EmitDistDistUnit { get; set; }

        /// <summary>
        /// 放出間隔タイプ「距離」の1フレームあたりの最大移動距離を取得または設定します。
        /// </summary>
        [DataModelPropertyGuid("1d424ed1-3827-46ac-ab3a-84cbebf0d139")]
        public float EmitDistMaxDistPerFrame { get; set; }

        /// <summary>
        /// 放出間隔タイプ「距離」の1フレームあたりの最小移動距離を取得または設定します。
        /// </summary>
        [DataModelPropertyGuid("7e946152-862a-4acd-92c5-6f7f0c4a1458")]
        public float EmitDistMinDistPerFrame { get; set; }

        /// <summary>
        /// 放出間隔タイプ「距離」の移動距離切り捨ての閾値を取得または設定します。
        /// </summary>
        [DataModelPropertyGuid("c336e42f-e73e-464b-a323-25b4698b82eb")]
        public float EmitDistMargin { get; set; }

        /// <summary>
        /// 入力データモデルからの値を設定します.
        /// </summary>
        /// <param name="src">入力データモデルです.</param>
        /// <returns>設定に成功したらtrueを返却します.</returns>
        public override bool Set(object src)
        {
            var srcDataModel = src as CurrVersion.EmitterEmissionTimingData;
            if (srcDataModel == null)
            {
                return false;
            }

            if (base.Set(src) == false)
            {
                return false;
            }

            this.EnableOnce = srcDataModel.EnableOnce;
            this.EmitStartFrame = srcDataModel.EmitStartFrame;
            this.EmitTimingRate = srcDataModel.EmitTimingRate;
            this.EmitDuration = srcDataModel.EmitDuration;
            this.EmitDistUnitType = srcDataModel.EmitDistUnitType;
            this.EmitTimeEmissionRate = srcDataModel.EmitTimeEmissionRate;
            this.EmitTimeEmissionRateRandom = srcDataModel.EmitTimeEmissionRateRandom;
            this.EmitTimeRateAnimation = srcDataModel.EmitTimeRateAnimation;
            this.EmitTimeDistUnit = srcDataModel.EmitTimeDistUnit;
            this.EmitTimeDistUnitRandom = srcDataModel.EmitTimeDistUnitRandom;
            this.EmitDistParticleMax = srcDataModel.EmitDistParticleMax;
            this.EmitDistDistUnit = srcDataModel.EmitDistDistUnit;
            this.EmitDistMaxDistPerFrame = srcDataModel.EmitDistMaxDistPerFrame;
            this.EmitDistMinDistPerFrame = srcDataModel.EmitDistMinDistPerFrame;
            this.EmitDistMargin = srcDataModel.EmitDistMargin;

            return true;
        }

        /// <summary>
        /// Write the data model to XML document.
        /// </summary>
        /// <param name="context">Holds the data needed for serialization.</param>
        /// <returns>True on success.</returns>
        public override bool WriteXml(XmlDocSerializationContext context)
        {
            // Serialize the base class.
            bool success = base.WriteXml(context);

            this.WriteElement(context, "EnableOnce", this.EnableOnce);
            this.WriteElement(context, "EmitStartFrame", this.EmitStartFrame);
            this.WriteElement(context, "EmitTimingRate", this.EmitTimingRate);
            this.WriteElement(context, "EmitDuration", this.EmitDuration);
            this.WriteElement(context, "EmitDistUnitType", this.EmitDistUnitType);
            this.WriteElement(context, "EmitTimeEmissionRate", this.EmitTimeEmissionRate);
            this.WriteElement(context, "EmitTimeEmissionRateRandom", this.EmitTimeEmissionRateRandom);
            this.WriteElement(context, "EmitTimeRateAnimation", this.EmitTimeRateAnimation);
            this.WriteElement(context, "EmitTimeDistUnit", this.EmitTimeDistUnit);
            this.WriteElement(context, "EmitTimeDistUnitRandom", this.EmitTimeDistUnitRandom);
            this.WriteElement(context, "EmitDistParticleMax", this.EmitDistParticleMax);
            this.WriteElement(context, "EmitDistDistUnit", this.EmitDistDistUnit);
            this.WriteElement(context, "EmitDistMaxDistPerFrame", this.EmitDistMaxDistPerFrame);
            this.WriteElement(context, "EmitDistMinDistPerFrame", this.EmitDistMinDistPerFrame);
            this.WriteElement(context, "EmitDistMargin", this.EmitDistMargin);

            return success;
        }

        /// <summary>
        /// Read the data model from XML document.
        /// </summary>
        /// <param name="context">Holds the data needed for deserialization.</param>
        /// <returns>True on success.</returns>
        public override bool ReadXml(XmlDocSerializationContext context)
        {
            // Deserialize the base class.
            bool success = base.ReadXml(context);

            this.EnableOnce = this.ReadElement(context, "EnableOnce", this.EnableOnce);
            this.EmitStartFrame = this.ReadElement(context, "EmitStartFrame", this.EmitStartFrame);
            this.EmitTimingRate = this.ReadElement(context, "EmitTimingRate", this.EmitTimingRate);
            this.EmitDuration = this.ReadElement(context, "EmitDuration", this.EmitDuration);
            this.EmitDistUnitType = this.ReadElement(context, "EmitDistUnitType", this.EmitDistUnitType);
            this.EmitTimeEmissionRate = this.ReadElement(context, "EmitTimeEmissionRate", this.EmitTimeEmissionRate);
            this.EmitTimeEmissionRateRandom = this.ReadElement(context, "EmitTimeEmissionRateRandom", this.EmitTimeEmissionRateRandom);
            this.EmitTimeRateAnimation = this.ReadElement(context, "EmitTimeRateAnimation", this.EmitTimeRateAnimation);
            this.EmitTimeDistUnit = this.ReadElement(context, "EmitTimeDistUnit", this.EmitTimeDistUnit);
            this.EmitTimeDistUnitRandom = this.ReadElement(context, "EmitTimeDistUnitRandom", this.EmitTimeDistUnitRandom);
            this.EmitDistParticleMax = this.ReadElement(context, "EmitDistParticleMax", this.EmitDistParticleMax);
            this.EmitDistDistUnit = this.ReadElement(context, "EmitDistDistUnit", this.EmitDistDistUnit);
            this.EmitDistMaxDistPerFrame = this.ReadElement(context, "EmitDistMaxDistPerFrame", this.EmitDistMaxDistPerFrame);
            this.EmitDistMinDistPerFrame = this.ReadElement(context, "EmitDistMinDistPerFrame", this.EmitDistMinDistPerFrame);
            this.EmitDistMargin = this.ReadElement(context, "EmitDistMargin", this.EmitDistMargin);

            return success;
        }
    }
}
