﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

using EffectMaker.DataModel.Attributes;
using EffectMaker.DataModel.DataModels;
using EffectMaker.DataModel.Extensions;
using EffectMaker.DataModel.Specific.DataModels;
using EffectMaker.Foundation.Serialization;
using System;
using System.Linq;
using System.Xml.Serialization;

using CurrVersion = EffectMaker.DataModel.Specific.DataModels.Version_0_0_0_0;
using CurrVersionSerializer = EffectMaker.DataModel.Specific.Serializer.Version_0_0_0_0;

namespace EffectMaker.DataModel.Specific.DataModels.Version_0_0_0_0
{
    /// <summary>
    /// [AUTO GENERATED SOURCE CODE, DO NOT MODIFY]
    /// チャイルドエミッタのみ有効となる、継承項目設定用のデータモデルです.
    /// </summary>
    [Serializable]
    public class EmitterBasicInheritanceData : DataModelBase
    {
        /// <summary>
        /// コンストラクタです.
        /// </summary>
        public EmitterBasicInheritanceData() :
            base()
        {
            this.MemEnableVelocity = false;
            this.MemVelocityInheritanceRate = 1;
            this.MemEnableScale = true;
            this.MemScaleInheritanceRate = 1;
            this.MemEnableRotation = true;
            this.MemEnableDrawPath = true;
            this.MemEnablePreDraw = false;
            this.MemEnableColorScale = false;
            this.MemEnableColor0 = false;
            this.MemEnableColor1 = false;
            this.MemEnableAlpha0 = true;
            this.MemEnableAlpha1 = true;

            this.PostConstruct();
        }

        /// <summary>
        /// 速度の継承を有効にするか
        /// </summary>
        [DataModelPropertyGuid("6f8e55da-ff39-40fa-894e-9080a3912f8d")]
        public bool EnableVelocity
        {
            get
            {
                if (this.IsChildEmitter == false)
                {
                    return false;
                }

                return this.MemEnableVelocity;
            }

            set
            {
                this.MemEnableVelocity = value;
            }
        }

        /// <summary>
        /// 速度の継承率
        /// </summary>
        [DataModelPropertyGuid("8fe59739-2165-4a21-85b7-b76a6f819c7e")]
        public float VelocityInheritanceRate
        {
            get
            {
                if (this.IsChildEmitter == false)
                {
                    return 1.0f;
                }

                return this.MemVelocityInheritanceRate;
            }

            set
            {
                this.MemVelocityInheritanceRate = value;
            }
        }

        /// <summary>
        /// スケールの継承を有効にするか
        /// </summary>
        [DataModelPropertyGuid("7cdf37c1-5e2e-4c36-ae68-894e2b1ece08")]
        public bool EnableScale
        {
            get
            {
                if (this.IsChildEmitter == false)
                {
                    return false;
                }

                return this.MemEnableScale;
            }

            set
            {
                this.MemEnableScale = value;
            }
        }

        /// <summary>
        /// スケールの継承率
        /// </summary>
        [DataModelPropertyGuid("891a8c11-ec71-445e-adcf-4ccced4e507d")]
        public float ScaleInheritanceRate
        {
            get
            {
                if (this.IsChildEmitter == false)
                {
                    return 1.0f;
                }

                return this.MemScaleInheritanceRate;
            }

            set
            {
                this.MemScaleInheritanceRate = value;
            }
        }

        /// <summary>
        /// 回転の継承を有効にするか
        /// </summary>
        [DataModelPropertyGuid("54f0bd8c-7e80-4b67-b484-2fc039a26423")]
        public bool EnableRotation
        {
            get
            {
                if (this.IsChildEmitter == false)
                {
                    return false;
                }

                return this.MemEnableRotation;
            }

            set
            {
                this.MemEnableRotation = value;
            }
        }

        /// <summary>
        /// 描画パスの継承を有効にするか
        /// </summary>
        [DataModelPropertyGuid("9d6ce869-a9be-4f9a-a139-f0fd5c3e3149")]
        public bool EnableDrawPath
        {
            get
            {
                if (this.IsChildEmitter == false)
                {
                    return false;
                }

                return this.MemEnableDrawPath;
            }

            set
            {
                this.MemEnableDrawPath = value;
            }
        }

        /// <summary>
        /// 上位の階層より先に描画するか
        /// </summary>
        [DataModelPropertyGuid("4033fdb9-0ce6-484c-9502-390de423657a")]
        public bool EnablePreDraw
        {
            get
            {
                if (this.IsChildEmitter == false)
                {
                    return false;
                }

                return this.MemEnablePreDraw;
            }

            set
            {
                this.MemEnablePreDraw = value;
            }
        }

        /// <summary>
        /// カラースケールの継承を有効にするか
        /// </summary>
        [DataModelPropertyGuid("c0ecf499-bf5c-4a7e-bcc8-e1d6a21cec26")]
        public bool EnableColorScale
        {
            get
            {
                if (this.IsChildEmitter == false)
                {
                    return false;
                }

                return this.MemEnableColorScale;
            }

            set
            {
                this.MemEnableColorScale = value;
            }
        }

        /// <summary>
        /// カラー0の継承を有効にするか
        /// </summary>
        [DataModelPropertyGuid("46f13bc0-3915-46a9-8930-d0336331f8ad")]
        public bool EnableColor0
        {
            get
            {
                if (this.IsChildEmitter == false)
                {
                    return false;
                }

                return this.MemEnableColor0;
            }

            set
            {
                this.MemEnableColor0 = value;
            }
        }

        /// <summary>
        /// カラー1の継承を有効にするか
        /// </summary>
        [DataModelPropertyGuid("050a32cd-1ae3-4a47-936d-11efdf60603b")]
        public bool EnableColor1
        {
            get
            {
                if (this.IsChildEmitter == false)
                {
                    return false;
                }

                return this.MemEnableColor1;
            }

            set
            {
                this.MemEnableColor1 = value;
            }
        }

        /// <summary>
        /// アルファ0の継承を有効にするか
        /// </summary>
        [DataModelPropertyGuid("31d8e7a9-ab26-4a79-8bc3-5112898d5a8c")]
        public bool EnableAlpha0
        {
            get
            {
                if (this.IsChildEmitter == false)
                {
                    return false;
                }

                return this.MemEnableAlpha0;
            }

            set
            {
                this.MemEnableAlpha0 = value;
            }
        }

        /// <summary>
        /// アルファ1の継承を有効にするか
        /// </summary>
        [DataModelPropertyGuid("7d72c737-a69f-4d72-a557-1eb5b42ee750")]
        public bool EnableAlpha1
        {
            get
            {
                if (this.IsChildEmitter == false)
                {
                    return false;
                }

                return this.MemEnableAlpha1;
            }

            set
            {
                this.MemEnableAlpha1 = value;
            }
        }

        /// <summary>
        /// チャイルドエミッタか
        /// </summary>
        [XmlIgnore]
        [DataModelPropertyGuid("fcd3b94a-e58a-4f8b-a514-1bb2eb4f7f5a")]
        public bool IsChildEmitter
        {
            get
            {
                // DataModelManager.GetDefaultDataModel()でデフォルト値をチャイルドに合わせるため
                // this.Parentがnullのときはチャイルドとしてふるまう
                if (this.Parent == null)
                {
                    return true;
                }

                DataModelBase parent = this;

                for (int i = 0; i < 2; ++i)
                {
                    if (parent != null)
                    {
                        parent = parent.Parent;
                    }

                    while (parent != null)
                    {
                        if (parent is EmitterData)
                        {
                            break;
                        }

                        parent = parent.Parent;
                    }
                }

                return parent != null;
            }
        }

        /// <summary>
        /// 速度の継承を有効にするか
        /// </summary>
        [XmlIgnore]
        [DataModelPropertyGuid("a47321d2-aba7-4485-a414-a2f0eae59583")]
        public bool MemEnableVelocity { get; set; }

        /// <summary>
        /// 速度の継承率
        /// </summary>
        [XmlIgnore]
        [DataModelPropertyGuid("e1de42bb-ab41-4b2c-bf04-7041c50ed9d5")]
        public float MemVelocityInheritanceRate { get; set; }

        /// <summary>
        /// スケールの継承を有効にするか
        /// </summary>
        [XmlIgnore]
        [DataModelPropertyGuid("4d2735de-b01d-48be-a823-f20be9da2c11")]
        public bool MemEnableScale { get; set; }

        /// <summary>
        /// スケールの継承率
        /// </summary>
        [XmlIgnore]
        [DataModelPropertyGuid("d2bf729a-e7c5-4dc8-bf59-f2ed40c56294")]
        public float MemScaleInheritanceRate { get; set; }

        /// <summary>
        /// 回転の継承を有効にするか
        /// </summary>
        [XmlIgnore]
        [DataModelPropertyGuid("be49199d-08a2-4f2d-b8c2-f4d836263eef")]
        public bool MemEnableRotation { get; set; }

        /// <summary>
        /// 描画パスの継承を有効にするか
        /// </summary>
        [XmlIgnore]
        [DataModelPropertyGuid("3300cbcb-6b9b-4b7d-86f1-8a73bf3d7162")]
        public bool MemEnableDrawPath { get; set; }

        /// <summary>
        /// 上位の階層より先に描画するか
        /// </summary>
        [XmlIgnore]
        [DataModelPropertyGuid("82ff3206-c915-4028-baa5-bd4bd3d8bc89")]
        public bool MemEnablePreDraw { get; set; }

        /// <summary>
        /// カラースケールの継承を有効にするか
        /// </summary>
        [XmlIgnore]
        [DataModelPropertyGuid("2c169c08-ebed-42a7-8862-2a4716399c72")]
        public bool MemEnableColorScale { get; set; }

        /// <summary>
        /// カラー0の継承を有効にするか
        /// </summary>
        [XmlIgnore]
        [DataModelPropertyGuid("fcd5cc1c-05b8-45c3-b666-ab330229be8b")]
        public bool MemEnableColor0 { get; set; }

        /// <summary>
        /// カラー1の継承を有効にするか
        /// </summary>
        [XmlIgnore]
        [DataModelPropertyGuid("a9e900e0-2e92-4674-b38b-421c1acb8cc8")]
        public bool MemEnableColor1 { get; set; }

        /// <summary>
        /// アルファ0の継承を有効にするか
        /// </summary>
        [XmlIgnore]
        [DataModelPropertyGuid("fd2644ff-cd35-4afc-b3eb-9715721f83c2")]
        public bool MemEnableAlpha0 { get; set; }

        /// <summary>
        /// アルファ1の継承を有効にするか
        /// </summary>
        [XmlIgnore]
        [DataModelPropertyGuid("6a9be55e-ddf1-49de-a6e8-348a648772d9")]
        public bool MemEnableAlpha1 { get; set; }

        /// <summary>
        /// 入力データモデルからの値を設定します.
        /// </summary>
        /// <param name="src">入力データモデルです.</param>
        /// <returns>設定に成功したらtrueを返却します.</returns>
        public override bool Set(object src)
        {
            var srcDataModel = src as CurrVersion.EmitterBasicInheritanceData;
            if (srcDataModel == null)
            {
                return false;
            }

            if (base.Set(src) == false)
            {
                return false;
            }

            this.EnableVelocity = srcDataModel.EnableVelocity;
            this.VelocityInheritanceRate = srcDataModel.VelocityInheritanceRate;
            this.EnableScale = srcDataModel.EnableScale;
            this.ScaleInheritanceRate = srcDataModel.ScaleInheritanceRate;
            this.EnableRotation = srcDataModel.EnableRotation;
            this.EnableDrawPath = srcDataModel.EnableDrawPath;
            this.EnablePreDraw = srcDataModel.EnablePreDraw;
            this.EnableColorScale = srcDataModel.EnableColorScale;
            this.EnableColor0 = srcDataModel.EnableColor0;
            this.EnableColor1 = srcDataModel.EnableColor1;
            this.EnableAlpha0 = srcDataModel.EnableAlpha0;
            this.EnableAlpha1 = srcDataModel.EnableAlpha1;
            this.MemEnableVelocity = srcDataModel.MemEnableVelocity;
            this.MemVelocityInheritanceRate = srcDataModel.MemVelocityInheritanceRate;
            this.MemEnableScale = srcDataModel.MemEnableScale;
            this.MemScaleInheritanceRate = srcDataModel.MemScaleInheritanceRate;
            this.MemEnableRotation = srcDataModel.MemEnableRotation;
            this.MemEnableDrawPath = srcDataModel.MemEnableDrawPath;
            this.MemEnablePreDraw = srcDataModel.MemEnablePreDraw;
            this.MemEnableColorScale = srcDataModel.MemEnableColorScale;
            this.MemEnableColor0 = srcDataModel.MemEnableColor0;
            this.MemEnableColor1 = srcDataModel.MemEnableColor1;
            this.MemEnableAlpha0 = srcDataModel.MemEnableAlpha0;
            this.MemEnableAlpha1 = srcDataModel.MemEnableAlpha1;

            return true;
        }

        /// <summary>
        /// Write the data model to XML document.
        /// </summary>
        /// <param name="context">Holds the data needed for serialization.</param>
        /// <returns>True on success.</returns>
        public override bool WriteXml(XmlDocSerializationContext context)
        {
            // Serialize the base class.
            bool success = base.WriteXml(context);

            this.WriteElement(context, "EnableVelocity", this.EnableVelocity);
            this.WriteElement(context, "VelocityInheritanceRate", this.VelocityInheritanceRate);
            this.WriteElement(context, "EnableScale", this.EnableScale);
            this.WriteElement(context, "ScaleInheritanceRate", this.ScaleInheritanceRate);
            this.WriteElement(context, "EnableRotation", this.EnableRotation);
            this.WriteElement(context, "EnableDrawPath", this.EnableDrawPath);
            this.WriteElement(context, "EnablePreDraw", this.EnablePreDraw);
            this.WriteElement(context, "EnableColorScale", this.EnableColorScale);
            this.WriteElement(context, "EnableColor0", this.EnableColor0);
            this.WriteElement(context, "EnableColor1", this.EnableColor1);
            this.WriteElement(context, "EnableAlpha0", this.EnableAlpha0);
            this.WriteElement(context, "EnableAlpha1", this.EnableAlpha1);

            return success;
        }

        /// <summary>
        /// Read the data model from XML document.
        /// </summary>
        /// <param name="context">Holds the data needed for deserialization.</param>
        /// <returns>True on success.</returns>
        public override bool ReadXml(XmlDocSerializationContext context)
        {
            // Deserialize the base class.
            bool success = base.ReadXml(context);

            this.EnableVelocity = this.ReadElement(context, "EnableVelocity", this.EnableVelocity);
            this.VelocityInheritanceRate = this.ReadElement(context, "VelocityInheritanceRate", this.VelocityInheritanceRate);
            this.EnableScale = this.ReadElement(context, "EnableScale", this.EnableScale);
            this.ScaleInheritanceRate = this.ReadElement(context, "ScaleInheritanceRate", this.ScaleInheritanceRate);
            this.EnableRotation = this.ReadElement(context, "EnableRotation", this.EnableRotation);
            this.EnableDrawPath = this.ReadElement(context, "EnableDrawPath", this.EnableDrawPath);
            this.EnablePreDraw = this.ReadElement(context, "EnablePreDraw", this.EnablePreDraw);
            this.EnableColorScale = this.ReadElement(context, "EnableColorScale", this.EnableColorScale);
            this.EnableColor0 = this.ReadElement(context, "EnableColor0", this.EnableColor0);
            this.EnableColor1 = this.ReadElement(context, "EnableColor1", this.EnableColor1);
            this.EnableAlpha0 = this.ReadElement(context, "EnableAlpha0", this.EnableAlpha0);
            this.EnableAlpha1 = this.ReadElement(context, "EnableAlpha1", this.EnableAlpha1);

            return success;
        }
    }
}
