﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

using System;
using System.Collections.Generic;
using System.Linq;
using System.Xml.Serialization;

using EffectMaker.DataModel.Attributes;
using EffectMaker.DataModel.DataModels;
using EffectMaker.DataModel.Extensions;
using EffectMaker.DataModel.Manager;
using EffectMaker.Foundation.Primitives;

namespace EffectMaker.DataModel.Specific.DataModels
{
    /// <summary>
    /// Data model for texture resource information.
    /// This data model is made for writing binary data.
    /// </summary>
    /// <remarks>
    /// This data model is not generated from the DataModelMaker, do not overwrite it.
    /// </remarks>
    public class TextureResourceData : DataModelBase
    {
        /// <summary>
        /// Constructor.
        /// </summary>
        public TextureResourceData() :
            base()
        {
        }

        /// <summary>
        /// Get or set the texture path.
        /// </summary>
        public string TexturePath { get; set; }

        /// <summary>
        /// Set up the data model with the given source object.
        /// </summary>
        /// <param name="src">The source object to set from.</param>
        /// <returns>True on success.</returns>
        public override bool Set(object src)
        {
            var srcDataModel = src as TextureResourceData;
            if (srcDataModel == null)
            {
                return false;
            }

            if (base.Set(src) == false)
            {
                return false;
            }

            this.TexturePath = srcDataModel.TexturePath;

            return true;
        }
    }
}
