﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

using System;
using System.Collections.Generic;
using EffectMaker.DataModel.DataModels;
using EffectMaker.DataModel.Extensions;

namespace EffectMaker.DataModel.Specific.DataModels
{
    /// <summary>
    /// Data model for an array of textures.
    /// This data model is made for writing binary data.
    /// </summary>
    /// <remarks>
    /// This data model is not generated from the DataModelMaker, do not overwrite it.
    /// </remarks>
    public class GfxTextureArrayData : DataModelBase
    {
        /// <summary>
        /// テクスチャファイルパスリストです。
        /// </summary>
        private List<string> texturePaths = new List<string>();

        /// <summary>
        /// テクスチャテーブルデータです。
        /// </summary>
        private GfxTextureTableData tableData = new GfxTextureTableData();

        /// <summary>
        /// コンストラクタです。
        /// </summary>
        public GfxTextureArrayData() :　base()
        {
        }

        /// <summary>
        /// テクスチャファイルパスリストを取得します。
        /// </summary>
        public IEnumerable<string> TexturePaths
        {
            get { return this.texturePaths; }
        }

        /// <summary>
        /// テクスチャテーブルデータモデルを取得します。
        /// </summary>
        public GfxTextureTableData TableData
        {
            get { return this.tableData; }
        }

        /// <summary>
        /// Add a new texture path to the texture array, the corresponding
        /// texture resource data and texture binary data will be automatically
        /// created.
        /// </summary>
        /// <param name="path">The texture path.</param>
        public void AddTexturePath(string path)
        {
            this.texturePaths.Add(path);
            this.tableData.AddTexturePath(path);
        }

        /// <summary>
        /// Set up the data model with the given source object.
        /// </summary>
        /// <param name="src">The source object to set from.</param>
        /// <returns>True on success.</returns>
        public override bool Set(object src)
        {
            var srcDataModel = src as GfxTextureArrayData;
            if (srcDataModel == null)
            {
                return false;
            }

            if (base.Set(src) == false)
            {
                return false;
            }

            this.texturePaths = new List<string>(srcDataModel.texturePaths);

            this.SetDataModelToField(ref this.tableData, srcDataModel.tableData);

            return true;
        }
    }
}
