﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

using System;
using EffectMaker.DataModel.DataModels;

namespace EffectMaker.DataModel.Specific.DataModels
{
    /// <summary>
    /// Data model for shader resource information.
    /// This data model is made for writing binary data.
    /// </summary>
    /// <remarks>
    /// This data model is not generated from the DataModelMaker, do not overwrite it.
    /// </remarks>
    public class ShaderResourceData : DataModelBase
    {
        /// <summary>
        /// Constructor.
        /// </summary>
        public ShaderResourceData() :
            base()
        {
        }

        /// <summary>
        /// Get or set the shader source code.
        /// </summary>
        public string ShaderCode { get; set; }

        /// <summary>
        /// Get or set the shader type.
        /// </summary>
        public ShaderTypes ShaderType { get; set; }

        /// <summary>
        /// Set up the data model with the given source object.
        /// </summary>
        /// <param name="src">The source object to set from.</param>
        /// <returns>True on success.</returns>
        public override bool Set(object src)
        {
            var srcDataModel = src as ShaderResourceData;
            if (srcDataModel == null)
            {
                return false;
            }

            if (base.Set(src) == false)
            {
                return false;
            }

            this.ShaderCode = srcDataModel.ShaderCode;
            this.ShaderType = srcDataModel.ShaderType;

            return true;
        }
    }
}
