﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

using System;
using System.Collections.ObjectModel;

using EffectMaker.DataModel.DataModels;
using EffectMaker.DataModel.Specific.DataModels;
using EffectMaker.Foundation.Attributes;

namespace EffectMaker.UILogic.ViewModels
{
    /// <summary>
    /// Class for the view model of the ViewerData.
    /// </summary>
    [CommandStackOwner]
    public class ViewerViewModel : WorkspaceNodeViewModelBase<ViewerData>, IModificationFlagOwner
    {
        /// <summary>
        /// The constructor.
        /// </summary>
        /// <param name="parent">The parent view model.</param>
        /// <param name="dataModel">The data model to encapsulate.</param>
        public ViewerViewModel(HierarchyViewModel parent, ViewerData dataModel)
            : base(parent, dataModel)
        {
            this.ViewerBasicViewModel = new ViewerBasicViewModel(this, dataModel.ViewerBasicData);
            this.Children.Add(this.ViewerBasicViewModel);

            this.ViewerCameraViewModel = new ViewerCameraViewModel(this, dataModel.ViewerCameraData);
            this.Children.Add(this.ViewerCameraViewModel);

            this.ViewerBackgroundViewModel = new ViewerBackgroundViewModel(this, dataModel.ViewerBackgroundData);
            this.Children.Add(this.ViewerBackgroundViewModel);

            foreach (ModelData modelData in dataModel.ModelList)
            {
                var modelViewModel = new ModelViewModel(this, modelData);
                this.Children.Add(modelViewModel);
            }

            // Always create the modification flag view model IN THE END of the constructor
            // to prevent any initialization triggers the modification events.
            this.ModificationFlagViewModel = new ModificationFlagViewModel(this);
        }

        /// <summary>
        /// Get the view model that holds the modification flags of
        /// this view model's properties.
        /// </summary>
        public ModificationFlagViewModel ModificationFlagViewModel { get; private set; }

        /// <summary>
        /// The default property page view model to use
        /// on the first time the workspace node is selected.
        /// </summary>
        public override HierarchyViewModel DefaultPropertyPageViewModel
        {
            get
            {
                if (this.Children.Count > 0)
                {
                    return this.Children[0] as HierarchyViewModel;
                }
                else
                {
                    return null;
                }
            }
        }

        /// <summary>
        /// Get the selected item.
        /// </summary>
        public HierarchyViewModel SelectedItem { get; set; }

        /// <summary>
        /// ViewerBasicViewModel を取得または設定します。
        /// </summary>
        public ViewerBasicViewModel ViewerBasicViewModel { get; private set; }

        /// <summary>
        /// ViewerCameraViewModel を取得または設定します。
        /// </summary>
        public ViewerCameraViewModel ViewerCameraViewModel { get; private set; }

        /// <summary>
        /// ViewerBackgroundViewModel を取得または設定します。
        /// </summary>
        public ViewerBackgroundViewModel ViewerBackgroundViewModel { get; private set; }
    }
}
