﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace EffectMaker.UILogic.ViewModels
{
    /// <summary>
    /// サブノードのタイプ.
    /// フィールド、カスタムアクション、ストライプなどを含む.
    /// </summary>
    public enum SubNodeTypes
    {
        /// <summary>新ランダム.</summary>
        Random,

        /// <summary>磁力.</summary>
        Magnet,

        /// <summary>スピン.</summary>
        Spin,

        /// <summary>収束.</summary>
        Converge,

        /// <summary>位置に加算.</summary>
        AddLocation,

        /// <summary>シンプルコリジョン.</summary>
        Collision,

        /// <summary>カールノイズ.</summary>
        CurlNoise,

        /// <summary>ランダム</summary>
        RandomFe1,

        /// <summary>カスタムフィールド</summary>
        CustomField,

        /// <summary>カスタムアクション</summary>
        CustomAction,

        /// <summary>エミッタプラグイン</summary>
        ReservedShader,

        /// <summary>エミッタ拡張パラメータ</summary>
        EmitterExtParams,
    }
}
