﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace EffectMaker.UILogic.ViewModels
{
    /// <summary>
    /// The preset mode.
    /// </summary>
    public enum PresetMode
    {
        /// <summary>
        /// エミッタセットとエミッタを両方表示
        /// </summary>
        EmitterSetAndEmitter,

        /// <summary>
        /// エミッタのみを表示(エミッタ新規作成用)
        /// </summary>
        Emitter,

        /// <summary>
        /// エミッタセットのみを表示(ワークスペース用)
        /// </summary>
        EmitterSet,
    }

    /// <summary>
    /// プリセットの設定タイプです。
    /// </summary>
    public enum PresetSettingTypes
    {
        /// <summary>
        /// ユーザー設定
        /// </summary>
        User,

        /// <summary>
        /// プロジェクト設定
        /// </summary>
        Project,

        /// <summary>
        /// なし
        /// </summary>
        None,
    }

    /// <summary>
    /// プリセットの項目クラスです。
    /// </summary>
    public class PresetItem
    {
        /// <summary>
        /// 表示名を設定または取得します。
        /// </summary>
        public string Key { get; private set; }

        /// <summary>
        /// データ本体を設定または取得します。
        /// </summary>
        public object Value { get; private set; }

        /// <summary>
        /// セパレータかどうかを設定または取得します。
        /// </summary>
        public bool IsSeparator { get; private set; }

        /// <summary>
        /// 未選択項目かどうかを設定または取得します。
        /// </summary>
        public bool IsUnselected { get; private set; }

        /// <summary>
        /// 設定タイプを設定または取得します。
        /// </summary>
        public PresetSettingTypes SettingType { get; private set; }

        /// <summary>
        /// コンストラクタです。
        /// </summary>
        /// <param name="key">表示名です。</param>
        /// <param name="value">データ本体です。</param>
        /// <param name="isSeparator">セパレータです。</param>
        /// <param name="isUnselected">未選択項目です。</param>
        /// <param name="settingType">設定タイプです。</param>
        public PresetItem(
            string key = null,
            object value = null,
            bool isSeparator = false,
            bool isUnselected = false,
            PresetSettingTypes settingType = PresetSettingTypes.None)
        {
            this.Key = key;
            this.Value = value;
            this.IsSeparator = isSeparator;
            this.IsUnselected = isUnselected;
            this.SettingType = settingType;
        }
    }
}
