﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

using EffectMaker.DataModel.Specific.DataModels;

namespace EffectMaker.UILogic.ViewModels
{
    /// <summary>
    /// ModelBasicSettingData に対応するビューモデルです。
    /// </summary>
    public class ModelBasicViewModel : PropertyPageViewModel<ModelBasicSettingData>, IModificationFlagOwner
    {
        /// <summary>
        /// コンストラクタです。
        /// </summary>
        /// <param name="parent">親ビューモデル</param>
        /// <param name="dataModel">データモデル</param>
        public ModelBasicViewModel(HierarchyViewModel parent, ModelBasicSettingData dataModel)
            : base(parent, dataModel)
        {
            this.ModelBasicModelViewModel = new ModelBasicModelViewModel(this, dataModel.ModelBasicModelData);
            this.Children.Add(this.ModelBasicModelViewModel);

            this.ModelBasicAnimationViewModel = new ModelBasicAnimationViewModel(this, dataModel.ModelBasicAnimationData);
            this.Children.Add(this.ModelBasicAnimationViewModel);

            this.ModelBasicVisibilityAnimationViewModel = new ModelBasicVisibilityAnimationViewModel(this, dataModel.ModelBasicVisibilityAnimationData);
            this.Children.Add(this.ModelBasicVisibilityAnimationViewModel);

            // ModificationFlagViewModel を初期化
            // 初期化中に変更イベントが発生するのを防ぐため、必ずコンストラクタの最後で行ってください。
            this.ModificationFlagViewModel = new ModificationFlagViewModel(this);
        }

        /// <summary>
        /// ModelBasicModelViewModel を取得します。
        /// </summary>
        public ModelBasicModelViewModel ModelBasicModelViewModel { get; private set; }

        /// <summary>
        /// ModelBasicAnimationViewModel を取得します。
        /// </summary>
        public ModelBasicAnimationViewModel ModelBasicAnimationViewModel { get; private set; }

        /// <summary>
        /// ModelBasicVisibilityAnimationViewModel を取得します。
        /// </summary>
        public ModelBasicVisibilityAnimationViewModel ModelBasicVisibilityAnimationViewModel { get; private set; }

        /// <summary>
        /// ModificationFlagViewModel を取得します。
        /// </summary>
        public ModificationFlagViewModel ModificationFlagViewModel { get; private set; }
    }
}
