﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

namespace EffectMaker.UILogic.ViewModels
{
    /// <summary>
    /// エミッタセット読み込み結果
    /// </summary>
    public enum LoadEmitterSetResults
    {
        /// <summary>
        /// 成功
        /// </summary>
        Success,

        /// <summary>
        /// ファイルが見つからない
        /// </summary>
        FileNotFound,

        /// <summary>
        /// ファイルオープンに失敗
        /// </summary>
        FileOpenError,

        /// <summary>
        /// デシリアライズに失敗
        /// </summary>
        DeserializeError,

        /// <summary>
        /// バージョン不一致
        /// </summary>
        VersionMismatch,
    }
}
