﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using EffectMaker.BusinessLogic.UserData;
using EffectMaker.DataModel.DataModels;
using EffectMaker.Foundation.Attributes;
using EffectMaker.Foundation.Primitives;

namespace EffectMaker.UILogic.ViewModels
{
    /// <summary>
    /// プロパティに露出していないViewModelをバインドするためのインタフェースです。
    /// </summary>
    public interface INamedViewModel
    {
        /// <summary>
        /// バインディング名を取得します。
        /// </summary>
        string BindingName { get; }
    }

    /// <summary>
    /// ユーザーデータ情報を公開するためのインタフェースです。
    /// </summary>
    public interface IUserDataInfoExportViewModel
    {
        /// <summary>
        /// ビューモデルに関連するユーザーデータ情報を取得します。
        /// </summary>
        UserDataInfo UserDataInfo { get; }
    }

    /// <summary>
    /// UDD2.0上で定義されたグループ分けをViewModelでサポートするためのユーティリティです。
    /// </summary>
    public static class UserDataSubGroupUtil
    {
        public static void SetupSubGroups(
            HierarchyViewModel viewModel,
            DataModelBase dataModel,
            Func<string, PropertyGroupViewModel> addNormalGroup,
            Func<string, PropertyGroupViewModel> addColorGroup)
        {
            // プロパティの属性からグループ名を抽出します。
            var dataModelType = dataModel.GetType();
            var propsMap = new Dictionary<string, string>();
            var properties = dataModelType.GetProperties();
            foreach (var prop in properties)
            {
                var att = prop.GetCustomAttributes(typeof(TagAttribute), true).Cast<TagAttribute>().FirstOrDefault();
                if (att != null && att.ID.Contains("Group"))
                {
                    var splittedFirst = att.ID.Split(',').First();
                    if (!propsMap.ContainsKey(splittedFirst))
                    {
                        propsMap.Add(splittedFirst, "Normal");
                    }

                    if (prop.PropertyType == typeof(ColorRgba))
                    {
                        propsMap[splittedFirst] = "Color";
                    }
                }
            }

            // カラーグループとそうでないものをより分けつつサブグループビューモデルを生成します。
            // ついでにグループに属するプロパティのみをコピペの対象にするようにします。
            foreach (var vmInfo in propsMap)
            {
                var addedVm = vmInfo.Value == "Color" ? addColorGroup(vmInfo.Key) : addNormalGroup(vmInfo.Key);
                var ignoreList = new List<string>();
                foreach (var prop in properties)
                {
                    var att = prop.GetCustomAttributes(typeof(TagAttribute), true)
                        .Cast<TagAttribute>().FirstOrDefault();
                    if (att == null || string.IsNullOrEmpty(att.ID))
                    {
                        continue;
                    }

                    var splitted = att.ID.Split(',');
                    if (splitted.First() != vmInfo.Key)
                    {
                        ignoreList.Add(prop.Name);
                    }

                    if (splitted.Length >= 2 && splitted[1] == "BitField")
                    {
                        if (!addedVm.PropertyAttributes.ContainsKey(prop.Name))
                        {
                            addedVm.PropertyAttributes.Add(prop.Name, "BitField");
                        }
                    }
                }

                addedVm.AddIgnoreCopyProperties(ignoreList.ToArray());
            }
        }
    }
}
