﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

using System;
using System.Collections.Generic;
using EffectMaker.DataModel.AnimationTable;
using EffectMaker.DataModel.DataModels;
using EffectMaker.DataModel.Specific.DataModels;
using EffectMaker.Foundation.Attributes;
using EffectMaker.Foundation.Command;
using EffectMaker.Foundation.EventArguments;
using EffectMaker.Foundation.Input;
using EffectMaker.Foundation.Interfaces;
using EffectMaker.Foundation.Primitives;
using EffectMaker.Foundation.Utility;
using EffectMaker.UILogic.Attributes;
using EffectMaker.BusinessLogic.Options;

namespace EffectMaker.UILogic.ViewModels
{
    /// <summary>
    /// Class for the view model of the CustomBasicParamViewModel.
    /// </summary>
    public class CustomBasicFlagViewModel : PropertyGroupViewModel<CustomFieldFlagData>, IModificationFlagOwner
    {
        /// <summary>
        /// The constructor.
        /// </summary>
        /// <param name="parent">The parent view model.</param>
        /// <param name="dataModel">The data model to encapsulate.</param>
        public CustomBasicFlagViewModel(
            HierarchyViewModel parent, CustomFieldFlagData dataModel)
            : base(parent, dataModel)
        {
            this.PropertyAttributes.Add("Flags", "BitField");

            // デフォルト値を更新
            this.UpdatePropertyDescriptors();

            // Always create the modification flag view model IN THE END of the constructor
            // to prevent any initialization triggers the modification events.
            this.ModificationFlagViewModel = new ModificationFlagViewModel(this);

            // データ変更フラグをクリア。
            this.ModificationFlagViewModel.ClearModificationFlags();
            this.ModificationFlagViewModel.ClearChildModificationFlags();
        }

        /// <summary>
        /// Get the view model that holds the modification flags of
        /// this view model's properties.
        /// </summary>
        public ModificationFlagViewModel ModificationFlagViewModel { get; private set; }

        /// <summary>
        /// ビットのラベルを取得または設定します.
        /// </summary>
        public IEnumerable<string> BitLabels
        {
            get
            {
                string[] labels = new string[16];
                var setting = OptionStore.ProjectConfig.CustomFieldDataSetting;

                for (int i = 0; i < Math.Min(setting.BitLabel.Count, 16); ++i)
                {
                    labels[i] = setting.BitLabel[i];
                }

                for (int i = setting.BitLabel.Count; i < 16; ++i)
                {
                    labels[i] = string.Format("[{0}]", i);
                }

                return labels;
            }
        }

        /// <summary>
        /// オプションを変更したときの処理を行います.
        /// </summary>
        /// <param name="sender">The sender.</param>
        /// <param name="e">The event arguments.</param>
        protected override void OnOptionChanged(object sender, EventArgs e)
        {
            base.OnOptionChanged(sender, e);
            this.OnPropertyChanged(() => this.BitLabels);
        }
    }
}
