﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

using System.Collections.Generic;
using EffectMaker.DataModel.DataModels;
using EffectMaker.DataModel.Specific.DataModels;
using EffectMaker.Foundation.Attributes;
using EffectMaker.Foundation.Input;
using EffectMaker.Foundation.Interfaces;
using EffectMaker.UILogic.Attributes;

namespace EffectMaker.UILogic.ViewModels
{
    /// <summary>
    /// Class for the view model of the CollisionBasicParamViewModel.
    /// </summary>
    public class CollisionBasicParamViewModel : PropertyGroupViewModel<CollisionParamData>, IModificationFlagOwner
    {
        /// <summary>
        /// The constructor.
        /// </summary>
        /// <param name="parent">The parent view model.</param>
        /// <param name="dataModel">The data model to encapsulate.</param>
        public CollisionBasicParamViewModel(HierarchyViewModel parent, CollisionParamData dataModel)
            : base(parent, dataModel)
        {
            this.CollisionActionTypeItems = new []
            {
                new KeyValuePair<string, object>(Properties.Resources.FieldCollisionActionTypeReflection, 1),
                new KeyValuePair<string, object>(Properties.Resources.FieldCollisionActionTypeDeath, 0),
                new KeyValuePair<string, object>(Properties.Resources.FieldCollisionActionTypeCustomShader, 2),
            };

            // Always create the modification flag view model IN THE END of the constructor
            // to prevent any initialization triggers the modification events.
            this.ModificationFlagViewModel = new ModificationFlagViewModel(this);
        }

        /// <summary>
        /// ヒット時の挙動タイプの項目を取得します.
        /// </summary>
        public IEnumerable<KeyValuePair<string, object>> CollisionActionTypeItems { get; private set; }

        /// <summary>
        /// Get the view model that holds the modification flags of
        /// this view model's properties.
        /// </summary>
        public ModificationFlagViewModel ModificationFlagViewModel { get; private set; }
    }
}
