﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

using System;
using System.Collections.Generic;
using System.Linq;
using EffectMaker.DataModel.DataModels;
using EffectMaker.DataModel.Specific.DataModels;
using EffectMaker.Foundation.Attributes;
using EffectMaker.Foundation.Command;
using EffectMaker.Foundation.EventArguments;
using EffectMaker.Foundation.Input;
using EffectMaker.Foundation.Interfaces;
using EffectMaker.Foundation.Utility;

namespace EffectMaker.UILogic.ViewModels
{
    /// <summary>
    /// Class for the view model of the EmitterRotationXViewModel.
    /// </summary>
    public class EmitterRotationXViewModel : PropertyGroupViewModel<EmitterRotationXData>, IModificationFlagOwner
    {
        /// <summary>
        /// 変更の対象に含めないプロパティ名のリストです.
        /// </summary>
        private readonly string[] ignorePropertyNames = new string[]
        {
            "GroupVisibility",
        };

        /// <summary>
        /// グループの表示状態.
        /// </summary>
        private bool groupVisibility = false;

        /// <summary>
        /// The constructor.
        /// </summary>
        /// <param name="parent">The parent view model.</param>
        /// <param name="dataModel">The data model to encapsulate.</param>
        public EmitterRotationXViewModel(HierarchyViewModel parent, EmitterRotationXData dataModel)
            : base(parent, dataModel)
        {
            var initialRotationParamsProperties = EnumerableUtility.Enumerate(
                ViewModelBase.NameOf(() => dataModel.InitialRotation),
                ViewModelBase.NameOf(() => dataModel.InitialRotationRandom));

            var rotationSpeedParamsProperties = EnumerableUtility.Enumerate(
                ViewModelBase.NameOf(() => dataModel.RotationSpeed),
                ViewModelBase.NameOf(() => dataModel.RotationSpeedRandom));

            // Always create the modification flag view model IN THE END of the constructor
            // to prevent any initialization triggers the modification events.
            var mmfvm = new MultipleModificationFlagsViewModel(this);
            mmfvm.SetPropertyDictionary("InitialRotationParams", initialRotationParamsProperties);
            mmfvm.SetPropertyDictionary("RotationSpeedParams", rotationSpeedParamsProperties);
            this.ModificationFlagViewModel = mmfvm;

            this.ModificationFlagViewModel.AddIgnoreProperties(this.ignorePropertyNames);
        }

        /// <summary>
        /// グループの表示状態.
        /// </summary>
        public bool GroupVisibility
        {
            get { return this.groupVisibility; }
            set { this.SetValue(ref this.groupVisibility, value); }
        }

        /// <summary>
        /// Get the view model that holds the modification flags of
        /// this view model's properties.
        /// </summary>
        public ModificationFlagViewModel ModificationFlagViewModel { get; private set; }
    }
}
