﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using EffectMaker.Foundation.Interfaces;

namespace EffectMaker.UILogic.ValueConverters
{
    /// <summary>
    /// ValueChangedModificationFlagConverter
    /// </summary>
    public class ValueChangedModificationFlagConverter : IValueConverter
    {
        /// <summary>
        /// Convert a value from a type to another.
        /// </summary>
        /// <param name="value">The value to convert.</param>
        /// <param name="targetType">The type to convert to.</param>
        /// <param name="parameter">A custom parameter.</param>
        /// <returns>Returns the converted value.</returns>
        public object Convert(object value, Type targetType, object parameter)
        {
            var data = value as EffectMaker.UILogic.ViewModels.ModificationFlagViewModel.ModificationData;
            if (data == null)
            {
                return true;
            }

            return data.IsModified;
        }

        /// <summary>
        /// Convert a value from a type to another.
        /// </summary>
        /// <param name="value">The value to convert.</param>
        /// <param name="targetType">The type to convert to.</param>
        /// <param name="parameter">A custom parameter.</param>
        /// <returns>Returns the converted value.</returns>
        public object ConvertBack(object value, Type targetType, object parameter)
        {
            return null;
        }
    }
}
