﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

using System;
using EffectMaker.Foundation.Utility;

namespace EffectMaker.UILogic.Manager
{
    /// <summary>
    /// テクスチャビュダイアログアマネージャー
    /// </summary>
    public static class TextureViewerDialogManager
    {
        /// <summary>
        /// 対象カラーチャンネル
        /// </summary>
        private static ColorChannelFlags targetColorChannel = ColorChannelFlags.Rgb;

        /// <summary>
        /// 対象テクスチャパス
        /// </summary>
        private static string targetTexturePath = string.Empty;

        /// <summary>
        /// 対象カラーチャンネル変更イベント
        /// </summary>
        public static event EventHandler TargetColorChannelChanged;

        /// <summary>
        /// 対象テクスチャ変更イベント
        /// </summary>
        public static event EventHandler TargetTextureChanged;

        /// <summary>
        /// カラーチャンネル
        /// </summary>
        public static ColorChannelFlags TargetColorChannel
        {
            get
            {
                return targetColorChannel;
            }

            set
            {
                targetColorChannel = value;

                if (TargetColorChannelChanged != null)
                {
                    TargetColorChannelChanged(null, EventArgs.Empty);
                }
            }
        }

        /// <summary>
        /// 対象テクスチャパス
        /// </summary>
        public static string TargetTexturePath
        {
            get
            {
                return targetTexturePath;
            }

            set
            {
                targetTexturePath = value;

                if (TargetTextureChanged != null)
                {
                    TargetTextureChanged(null, EventArgs.Empty);
                }
            }
        }

        /// <summary>
        /// ダイアログ表示中か
        /// </summary>
        public static bool IsVisibleDialog { get; set; }
    }
}
