﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using System;
using System.Collections.Generic;

namespace EffectMaker.ProcessBridge
{
    /// <summary>
    /// EffectMakerBridgeリモートオブジェクトです。
    /// </summary>
    public class BridgeRemoteObject : MarshalByRefObject
    {
        /// <summary>
        /// コマンド実行イベントです。
        /// </summary>
        public event EventHandler Process;

        /// <summary>
        /// コマンドの実行をトリガーします。
        /// </summary>
        public void TriggerProcess()
        {
            if (this.Process != null)
            {
                this.Process(this, EventArgs.Empty);
            }
        }

        /// <summary>
        /// コマンドタイプを取得または設定します。
        /// </summary>
        public BridgeCommandType CommandType { get; set; }

        /// <summary>
        /// ファイルパスリストを取得または設定します。
        /// </summary>
        public List<string> Paths { get; set; }

        /// <summary>
        /// ライフタイムサービスオブジェクトを初期化します。
        /// デフォルトでは5分くらいで自動切断されてしまうのでオーバーライドして切断しないようにします。
        /// </summary>
        /// <returns>ライフタイムサービスオブジェクトを返します。</returns>
        public override object InitializeLifetimeService()
        {
            return null;
        }

        /// <summary>
        /// IPCチャンネル名
        /// </summary>
        public const string IpcChannelName = "EffectMakerBridge_IPC_CHANNEL";

        /// <summary>
        /// IPC URL
        /// </summary>
        public const string IpcUrl = "EffectMakerBridge_IPC_URL";
    }

    /// <summary>
    /// リモートコマンドタイプです。
    /// </summary>
    public enum BridgeCommandType
    {
        /// <summary>
        /// 無効値
        /// </summary>
        Invalid,

        /// <summary>
        /// load-files
        /// </summary>
        LoadFiles
    }
}
