﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace EffectMaker.DataModelLogic
{
    /// <summary>
    /// Enum for binary field types.
    /// </summary>
    public enum BinaryFieldTypes
    {
        /// <summary>Normal binary field.</summary>
        Normal = 0,

        /// <summary>Fixed size binary field.</summary>
        FixedSize = 1,

        /// <summary>Binary field for alignment to specified byte alignment.</summary>
        ByteAlignment = 2,

        /// <summary>Binary field that stores the offset of a binary data.</summary>
        DataOffset = 3,

        /// <summary>Binary field that stores the size of a binary data.</summary>
        DataSize = 4,

        /// <summary>Binary field that selects underlying binary structure by it's input data.</summary>
        SelectBinaryData = 5,
    }

    /// <summary>
    /// Enum for the types of data modification message send to the viewer.
    /// </summary>
    public enum SendModificationTypes
    {
        /// <summary>バイナリデータにパッチを当てるだけで済む、リアルタイム編集項目に指定します。</summary>
        ModifiedDataOnly = 0,

        /// <summary>リアルタイム編集だが内部のバッファリセットで済む変更の時に指定します。</summary>
        ModifiedWithReset = 2,

        /// <summary>バイナリのサイズ変更を伴い、全体的なリロードが必要な項目で指定します。</summary>
        FullBinary = 1,
    }

    /// <summary>
    /// Enum for the shader compile results.
    /// </summary>
    public enum ShaderCompileResult
    {
        /// <summary>Shader successfully compiled.</summary>
        Success = 0,

        /// <summary>Shader compiled, but some warnings have been returned.</summary>
        Warning = 1,

        /// <summary>Shader compile failed.</summary>
        Error = 2,
    }
}
