﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

using System;
using System.Collections.Generic;
using System.Linq;
using EffectMaker.BusinessLogic.UserData;
using EffectMaker.DataModel.DataModels;
using EffectMaker.DataModel.Manager;
using EffectMaker.DataModel.Specific.DataModels;
using EffectMaker.Foundation.Log;

namespace EffectMaker.DataModelLogic.DataModelProxies
{
    /// <summary>
    /// Data model proxy for preview data.
    /// </summary>
    public class StripeDataProxy : DataModelProxy
    {
        /// <summary>
        /// Constructor.
        /// </summary>
        /// <param name="dataModel">The data model for the proxy.</param>
        public StripeDataProxy(DataModelBase dataModel) :
            base(dataModel)
        {
            this.UpdateUserData();
        }

        /// <summary>
        /// ユーザー定義データをロードします.
        /// </summary>
        public void UpdateUserData()
        {
            var dataModel = this.DataModel as StripeData;
            if (dataModel == null)
            {
                return;
            }

            // ストライプユーザ・データを更新する.
            var userData =
                UserDataManager.CreateUserDataForOwner(dataModel.GetType()).FirstOrDefault();
            if (userData == null)
            {
                Logger.Log(LogLevels.Warning, "StripeDataProxy.UpdateStripeUserData : Failed updating stripe user page data.");
                return;
            }

            if (dataModel is StripeComplexData)
            {
                var dm = dataModel as StripeComplexData;
                if (dm.UserPageData == null ||
                    dm.UserPageData.GetType() != userData.GetType())
                {
                    dm.UserPageData = userData;
                }
                else
                {
                    return;
                }
            }
            else if (dataModel is StripeHistoryData)
            {
                var dm = dataModel as StripeHistoryData;
                if (dm.UserPageData == null ||
                    dm.UserPageData.GetType() != userData.GetType())
                {
                    dm.UserPageData = userData;
                }
                else
                {
                    return;
                }
            }
            else if (dataModel is StripeSuperData)
            {
                var dm = dataModel as StripeSuperData;
                if (dm.UserPageData == null ||
                    dm.UserPageData.GetType() != userData.GetType())
                {
                    dm.UserPageData = userData;
                }
                else
                {
                    return;
                }
            }

            // Fire event.
            this.TriggerPropertyModifiedEvent("UserPageData");
        }
    }
}
