﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

using System;
using System.Collections.Generic;
using EffectMaker.DataModel.DataModels;
using EffectMaker.DataModel.Manager;
using EffectMaker.DataModel.Specific.DataModels;

namespace EffectMaker.DataModelLogic.DataModelProxies
{
    /// <summary>
    /// Data model proxy for preview data.
    /// </summary>
    public class PreviewDataProxy : DataModelProxy
    {
        /// <summary>
        /// Constructor.
        /// </summary>
        /// <param name="dataModel">The data model for the proxy.</param>
        public PreviewDataProxy(DataModelBase dataModel) :
            base(dataModel)
        {
            // Need to confirm with 袋野さん about this.
            // This UpdateUserData call might be redundant because
            // the user data model is already updated in the view
            // model and shouldn't be necessary to be updated again
            // here.
            ////this.UpdateUserData();
        }
    }
}
