﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using EffectMaker.DataModel.DataModels;
using EffectMaker.DataModel.Specific.DataModels;

namespace EffectMaker.DataModelLogic.DataModelProxies
{
    /// <summary>
    /// Represent an instance that can create EmitterData.
    /// </summary>
    public interface IEmitterBuilder
    {
        /// <summary>
        /// Creates an EmitterData instance.
        /// </summary>
        /// <param name="name">The name to give to the created EmitterData instance.</param>
        /// <returns>Returns an instance of EmitterData.</returns>
        EmitterData CreateEmitter(string name);

        /// <summary>
        /// Add the given emitter data.
        /// </summary>
        /// <param name="emitterData">The emitter data.</param>
        void AddEmitter(EmitterData emitterData);
    }
}
