﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

using System;

using EffectMaker.BusinessLogic.Manager;
using EffectMaker.BusinessLogic.UserData;
using EffectMaker.DataModel.Attributes;
using EffectMaker.Foundation.Texture;
using EffectMaker.Foundation.Utility;

namespace EffectMaker.DataModelLogic.BinaryConverters
{
    /// <summary>
    /// Converter for converting custom action index to its ID.
    /// </summary>
    public class CustomActionIDConverter : ConverterBase
    {
        /// <summary>
        /// Constructor.
        /// </summary>
        public CustomActionIDConverter() :
            base(null)
        {
        }

        /// <summary>
        /// Get the maximum number of input values.
        /// </summary>
        public override int MaxInputValueCount
        {
            get { return 1; }
        }

        /// <summary>
        /// Get the description of the converter.
        /// </summary>
        public override string Description
        {
            get { return Properties.Resources.CustomActionIDConverterDesc; }
        }

        /// <summary>
        /// Get the output value description.
        /// </summary>
        public override string OutputValueDescription
        {
            get { return Properties.Resources.CustomActionIDConverterOutputValueDesc; }
        }

        /// <summary>
        /// Get the description of the input value.
        /// </summary>
        /// <param name="index">The index to the input value.</param>
        /// <returns>The description.</returns>
        public override string GetInputValueDescription(int index)
        {
            if (index == 0)
            {
                return Properties.Resources.CustomActionIDConverterInputValue0Desc;
            }
            else
            {
                return Properties.Resources.WarningInvalidConverterInputValueIndex;
            }
        }

        /// <summary>
        /// Convert values.
        /// </summary>
        /// <returns>True on success.</returns>
        public override bool Convert()
        {
            object inputValue = this.GetInputValue(0);
            if ((inputValue is int) == false)
            {
                return false;
            }

            var index = (int)inputValue;

            var info = CustomActionUserDataManager.GetCustomActionDefinition(index);
            if (info == null)
            {
                this.SetOutputValue(0);
            }
            else
            {
                this.SetOutputValue(info.CallbackId);
            }

            return true;
        }
    }
}
