﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

using System;

using EffectMaker.Foundation.Primitives;
using EffectMaker.Foundation.Utility;

namespace EffectMaker.DataModelLogic.BinaryConverters
{
    /// <summary>
    /// RGBとAからVEC4を合成します.
    /// </summary>
    public class ColorSeparateAlphaToVec4Converter : ConverterBase
    {
        /// <summary>
        /// Constructor.
        /// </summary>
        public ColorSeparateAlphaToVec4Converter() :
            base(null)
        {
        }

        /// <summary>
        /// Get the maximum number of input values.
        /// </summary>
        public override int MaxInputValueCount
        {
            get { return 2; }
        }

        /// <summary>
        /// Get the description of the converter.
        /// </summary>
        public override string Description
        {
            get { return Properties.Resources.ColorSeparateAlphaToVec4ConverterDesc; }
        }

        /// <summary>
        /// Get the output value description.
        /// </summary>
        public override string OutputValueDescription
        {
            get { return Properties.Resources.ColorSeparateAlphaToVec4ConverterOutputValueDesc; }
        }

        /// <summary>
        /// Get the description of the input value.
        /// </summary>
        /// <param name="index">The index to the input value.</param>
        /// <returns>The description.</returns>
        public override string GetInputValueDescription(int index)
        {
            if (index == 0)
            {
                return Properties.Resources.ColorSeparateAlphaToVec4ConverterInputValue0Desc;
            }
            else if (index == 1)
            {
                return Properties.Resources.ColorSeparateAlphaToVec4ConverterInputValue1Desc;
            }
            else
            {
                return Properties.Resources.WarningInvalidConverterInputValueIndex;
            }
        }

        /// <summary>
        /// Convert data model field values.
        /// </summary>
        /// <returns>True on success.</returns>
        public override bool Convert()
        {
            var inputColor = this.GetInputValue(0) as ColorRgba;
            var inputAlpha = (float)this.GetInputValue(1);
            if (inputColor == null)
            {
                return false;
            }

            this.SetOutputValue(new Vector4f(inputColor.R, inputColor.G, inputColor.B, inputAlpha));

            return true;
        }
    }
}
