﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

using System;
using System.Collections;

using EffectMaker.DataModel.Attributes;
using EffectMaker.DataModel.DataModels;
using EffectMaker.DataModel.Specific.DataModels;

namespace EffectMaker.DataModelLogic.BinaryConverters
{
    /// <summary>
    /// Class for the converter that simply pass an IEnumerable of data models to output.
    /// </summary>
    /// <remarks>The binary output for this converter is always null.</remarks>
    [ConverterInput(0, typeof(ICollection), "The collection.")]
    [ConverterOutput(typeof(ICollection), "The collection.")]
    public class AssignCollectionConverter : ConverterBase
    {
        /// <summary>
        /// Get the number of input values.
        /// </summary>
        public override int InputValueCount
        {
            get { return 1; }
        }

        /// <summary>
        /// Convert data model field values.
        /// </summary>
        /// <returns>True on success.</returns>
        public override bool Convert()
        {
            var collection = this.GetInputValue(0) as ICollection;
            if (collection == null)
            {
                return false;
            }

            this.SetOutputValue(collection);

            return true;
        }
    }
}
