﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

using System;
using System.Collections.Generic;
using System.Reflection;

using EffectMaker.DataModel.Attributes;
using EffectMaker.DataModel.DataModels;
using EffectMaker.DataModel.Specific.DataModels;
using EffectMaker.DataModelLogic.BinaryConverters;
using EffectMaker.DataModelLogic.BinaryData;
using EffectMaker.DataModelLogic.Utilities;

using ConverterParam = System.Collections.Generic.KeyValuePair<string, object>;

namespace EffectMaker.DataModelLogic.BinaryConversionInfo
{
    /// <summary>
    /// [AUTO GENERATED CLASS, DO NOT MODIFY]
    /// Auto-generated class for converting data model values.
    /// </summary>
    public class ViewerBinaryConversionInfo : BinaryConversionInfoBase
    {
        /// <summary>A flag to prevent the static constructor being called more than once.</summary>
        private static bool isStaticConstructorCalled = false;

        /// <summary>The root binary structure definition.</summary>
        private static BinaryStructDefinition rootBinaryDefinition = null;

        /// <summary>The list of instance.</summary>
        private static Dictionary<DataModelBase, BinaryConversionInfoBase> instanceMap = null;

        /// <summary>The root binary structure instance.</summary>
        private BinaryStructInstance rootBinaryInstance = null;

        /// <summary>
        /// The constructor.
        /// </summary>
        static ViewerBinaryConversionInfo()
        {
            if (isStaticConstructorCalled == true)
            {
                return;
            }

            isStaticConstructorCalled = true;

            instanceMap = new Dictionary<DataModelBase, BinaryConversionInfoBase>();

            var viewerBinary = new BinaryStructDefinition(typeof(ViewerData)) { HasBinaryHeader = true };

            // Output : isRealtimeEditing
            // Inputs : None
            BinaryConversionInfoBase.AddFixedSizeFieldDefinition(
                1,
                viewerBinary,
                SendModificationTypes.ModifiedDataOnly,
                null,
                new ConverterDefinition(typeof(DefaultConverter)),
                null
            );

            // Output : displayDebugInformation
            // Inputs : DisplayDebugInformation
            BinaryConversionInfoBase.AddBinaryFieldDefinition(
                viewerBinary,
                SendModificationTypes.ModifiedDataOnly,
                null,
                new ConverterDefinition(typeof(SwitchCaseConverter),
                    new ConverterParam("Cases", new SwitchCase[] { new SwitchCase(true, (byte)1) }),
                    new ConverterParam("DefaultOutput", (byte)0)),
                null,
                new InputPropertyDefinition("ViewerBasicData.SceneData.DisplayDebugInformation", new Guid("026fd5a5-e0a2-462e-94f4-3d7c0c601544"))
            );

            // Output : displayGpuProfile
            // Inputs : DisplayGpuProfile
            BinaryConversionInfoBase.AddBinaryFieldDefinition(
                viewerBinary,
                SendModificationTypes.ModifiedDataOnly,
                null,
                new ConverterDefinition(typeof(SwitchCaseConverter),
                    new ConverterParam("Cases", new SwitchCase[] { new SwitchCase(true, (byte)1) }),
                    new ConverterParam("DefaultOutput", (byte)0)),
                null,
                new InputPropertyDefinition("ViewerBasicData.SceneData.DisplayGpuProfile", new Guid("9dd998da-594d-4c98-9f9b-30150a8a589a"))
            );

            // Output : reserved0
            // Inputs : None
            BinaryConversionInfoBase.AddFixedSizeFieldDefinition(
                1,
                viewerBinary,
                SendModificationTypes.ModifiedDataOnly,
                null,
                new ConverterDefinition(typeof(DefaultConverter)),
                null
            );

            // Output : gridType
            // Inputs : GridType
            BinaryConversionInfoBase.AddBinaryFieldDefinition(
                viewerBinary,
                SendModificationTypes.ModifiedDataOnly,
                null,
                new ConverterDefinition(typeof(DefaultConverter)),
                null,
                new InputPropertyDefinition("ViewerBasicData.SceneData.GridType", new Guid("89944c6f-9ab7-4943-adc4-24b9f8443096"))
            );

            // Output : gridSize
            // Inputs : GridSize
            BinaryConversionInfoBase.AddBinaryFieldDefinition(
                viewerBinary,
                SendModificationTypes.ModifiedDataOnly,
                null,
                new ConverterDefinition(typeof(DefaultConverter)),
                null,
                new InputPropertyDefinition("ViewerBasicData.SceneData.GridSize", new Guid("9163739e-495b-49cf-9d8e-a40cfa681fb6"))
            );

            // Output : gridDivisionNumber
            // Inputs : GridDivisionNumber
            BinaryConversionInfoBase.AddBinaryFieldDefinition(
                viewerBinary,
                SendModificationTypes.ModifiedDataOnly,
                null,
                new ConverterDefinition(typeof(DefaultConverter)),
                null,
                new InputPropertyDefinition("ViewerBasicData.SceneData.GridDivisionNumber", new Guid("2ceeed37-9609-4731-a95f-507a9d37a43b"))
            );

            // Output : glareLevel
            // Inputs : GlareLevel
            BinaryConversionInfoBase.AddBinaryFieldDefinition(
                viewerBinary,
                SendModificationTypes.ModifiedDataOnly,
                null,
                new ConverterDefinition(typeof(DefaultConverter)),
                null,
                new InputPropertyDefinition("ViewerBasicData.SceneData.GlareLevel", new Guid("7b807b5c-1b98-4299-b4dc-b07ee35acb20"))
            );

            // Output : frameRate
            // Inputs : FrameRate
            BinaryConversionInfoBase.AddBinaryFieldDefinition(
                viewerBinary,
                SendModificationTypes.ModifiedDataOnly,
                null,
                new ConverterDefinition(typeof(DefaultConverter)),
                null,
                new InputPropertyDefinition("ViewerBasicData.SceneData.FrameRate", new Guid("884bf906-1450-4e8d-8810-9cf8527e63c4"))
            );

            // Output : position
            // Inputs : CameraPosition
            BinaryConversionInfoBase.AddBinaryFieldDefinition(
                viewerBinary,
                SendModificationTypes.ModifiedDataOnly,
                null,
                new ConverterDefinition(typeof(DefaultConverter)),
                null,
                new InputPropertyDefinition("ViewerCameraData.ViewProjectionData.CameraPosition", new Guid("7fb72e00-4c96-44be-b5c6-35fe407918a1"))
            );

            // Output : target
            // Inputs : CameraTarget
            BinaryConversionInfoBase.AddBinaryFieldDefinition(
                viewerBinary,
                SendModificationTypes.ModifiedDataOnly,
                null,
                new ConverterDefinition(typeof(DefaultConverter)),
                null,
                new InputPropertyDefinition("ViewerCameraData.ViewProjectionData.CameraTarget", new Guid("34b15ed0-01e9-4621-bc8f-667370f98f38"))
            );

            // Output : rotation
            // Inputs : CameraRotation
            BinaryConversionInfoBase.AddBinaryFieldDefinition(
                viewerBinary,
                SendModificationTypes.ModifiedDataOnly,
                null,
                new ConverterDefinition(typeof(RadianConverter)),
                null,
                new InputPropertyDefinition("ViewerCameraData.ViewProjectionData.CameraRotation", new Guid("9f1ed308-6e31-43b8-b993-5bc9632de948"))
            );

            // Output : projectionType
            // Inputs : ProjectionType
            BinaryConversionInfoBase.AddBinaryFieldDefinition(
                viewerBinary,
                SendModificationTypes.ModifiedDataOnly,
                null,
                new ConverterDefinition(typeof(DefaultConverter)),
                null,
                new InputPropertyDefinition("ViewerCameraData.ViewProjectionData.ProjectionType", new Guid("e02c374b-2c82-49f3-b74c-01357f6b1dfd"))
            );

            // Output : aspectRatio
            // Inputs : AspectRatio
            BinaryConversionInfoBase.AddBinaryFieldDefinition(
                viewerBinary,
                SendModificationTypes.ModifiedDataOnly,
                null,
                new ConverterDefinition(typeof(DefaultConverter)),
                null,
                new InputPropertyDefinition("ViewerCameraData.ViewProjectionData.AspectRatio", new Guid("f6400c72-c61e-4d12-9b9b-570796cfaf84"))
            );

            // Output : fieldOfView
            // Inputs : FieldOfView
            BinaryConversionInfoBase.AddBinaryFieldDefinition(
                viewerBinary,
                SendModificationTypes.ModifiedDataOnly,
                null,
                new ConverterDefinition(typeof(RadianConverter)),
                null,
                new InputPropertyDefinition("ViewerCameraData.ViewProjectionData.FieldOfView", new Guid("46c2e3c8-7a7b-48fc-9194-89e1e01e860d"))
            );

            // Output : imageHeight
            // Inputs : ImageSize
            BinaryConversionInfoBase.AddBinaryFieldDefinition(
                viewerBinary,
                SendModificationTypes.ModifiedDataOnly,
                null,
                new ConverterDefinition(typeof(DefaultConverter)),
                null,
                new InputPropertyDefinition("ViewerCameraData.ViewProjectionData.ImageSize", new Guid("9c31edbc-1aa2-4f30-9100-b979435d5252"))
            );

            // Output : nearClip
            // Inputs : NearClip
            BinaryConversionInfoBase.AddBinaryFieldDefinition(
                viewerBinary,
                SendModificationTypes.ModifiedDataOnly,
                null,
                new ConverterDefinition(typeof(DefaultConverter)),
                null,
                new InputPropertyDefinition("ViewerCameraData.ViewProjectionData.NearClip", new Guid("b260efa2-0ed8-4a2a-a047-ea6ad4d9f667"))
            );

            // Output : farClip
            // Inputs : FarClip
            BinaryConversionInfoBase.AddBinaryFieldDefinition(
                viewerBinary,
                SendModificationTypes.ModifiedDataOnly,
                null,
                new ConverterDefinition(typeof(DefaultConverter)),
                null,
                new InputPropertyDefinition("ViewerCameraData.ViewProjectionData.FarClip", new Guid("195f3b61-78fb-44a8-a0d3-4f3effaa0b86"))
            );

            // Output : bgColor
            // Inputs : ClearColor
            BinaryConversionInfoBase.AddBinaryFieldDefinition(
                viewerBinary,
                SendModificationTypes.ModifiedDataOnly,
                null,
                new ConverterDefinition(typeof(DefaultConverter)),
                null,
                new InputPropertyDefinition("ViewerBackgroundData.ClearColor", new Guid("c2f15930-2cc7-44c0-9ce4-1b18b3f2b042"))
            );

            // Output : guid
            // Inputs : None
            BinaryConversionInfoBase.AddFixedSizeFieldDefinition(
                4,
                viewerBinary,
                SendModificationTypes.ModifiedDataOnly,
                null,
                new ConverterDefinition(typeof(DefaultConverter)),
                null
            );

            // Output : imageColor
            // Inputs : MultiplyColor
            BinaryConversionInfoBase.AddBinaryFieldDefinition(
                viewerBinary,
                SendModificationTypes.ModifiedDataOnly,
                null,
                new ConverterDefinition(typeof(DefaultConverter)),
                null,
                new InputPropertyDefinition("ViewerBackgroundData.MultiplyColor", new Guid("1c7de476-23a2-4eb3-87d1-7bfcce18b1c6"))
            );

            // Output : enablePad
            // Inputs : EnablePad
            BinaryConversionInfoBase.AddBinaryFieldDefinition(
                viewerBinary,
                SendModificationTypes.ModifiedDataOnly,
                null,
                new ConverterDefinition(typeof(SwitchCaseConverter),
                    new ConverterParam("Cases", new SwitchCase[] { new SwitchCase(true, (byte)1) }),
                    new ConverterParam("DefaultOutput", (byte)0)),
                null,
                new InputPropertyDefinition("ViewerBasicData.SceneData.EnablePad", new Guid("93ead31b-b115-4ea0-820d-fe61a49cc323"))
            );

            // Output : displayGrid
            // Inputs : DisplayGrid
            BinaryConversionInfoBase.AddBinaryFieldDefinition(
                viewerBinary,
                SendModificationTypes.ModifiedDataOnly,
                null,
                new ConverterDefinition(typeof(SwitchCaseConverter),
                    new ConverterParam("Cases", new SwitchCase[] { new SwitchCase(true, (byte)1) }),
                    new ConverterParam("DefaultOutput", (byte)0)),
                null,
                new InputPropertyDefinition("ViewerBasicData.SceneData.DisplayGrid", new Guid("17632e8d-fbc9-4dab-8f0d-612203313d1c"))
            );

            // Output : displayParentEmitterShape
            // Inputs : DisplayParentEmitterShape
            BinaryConversionInfoBase.AddBinaryFieldDefinition(
                viewerBinary,
                SendModificationTypes.ModifiedDataOnly,
                null,
                new ConverterDefinition(typeof(SwitchCaseConverter),
                    new ConverterParam("Cases", new SwitchCase[] { new SwitchCase(true, (byte)1) }),
                    new ConverterParam("DefaultOutput", (byte)0)),
                null,
                new InputPropertyDefinition("ViewerBasicData.SceneData.DisplayParentEmitterShape", new Guid("48cfe8cc-5ce1-4966-bf81-e78dac50df95"))
            );

            // Output : displayChildEmitterShape
            // Inputs : DisplayChildEmitterShape
            BinaryConversionInfoBase.AddBinaryFieldDefinition(
                viewerBinary,
                SendModificationTypes.ModifiedDataOnly,
                null,
                new ConverterDefinition(typeof(SwitchCaseConverter),
                    new ConverterParam("Cases", new SwitchCase[] { new SwitchCase(true, (byte)1) }),
                    new ConverterParam("DefaultOutput", (byte)0)),
                null,
                new InputPropertyDefinition("ViewerBasicData.SceneData.DisplayChildEmitterShape", new Guid("a84e5cf0-b901-4401-9e68-c5e4737fa9c0"))
            );

            // Output : displayFieldShape
            // Inputs : DisplayFieldShape
            BinaryConversionInfoBase.AddBinaryFieldDefinition(
                viewerBinary,
                SendModificationTypes.ModifiedDataOnly,
                null,
                new ConverterDefinition(typeof(DefaultConverter)),
                null,
                new InputPropertyDefinition("ViewerBasicData.SceneData.DisplayFieldShape", new Guid("9dd7c295-00ce-4b96-861a-c890390d609b"))
            );

            // Output : restrainViewerWarnings
            // Inputs : RestrainViewrWarnings
            BinaryConversionInfoBase.AddBinaryFieldDefinition(
                viewerBinary,
                SendModificationTypes.ModifiedDataOnly,
                null,
                new ConverterDefinition(typeof(DefaultConverter)),
                null,
                new InputPropertyDefinition("ViewerBasicData.SceneData.RestrainViewrWarnings", new Guid("68508c58-ce0b-4b72-b139-40dd38150113"))
            );

            // Output : enableOverDrawMode
            // Inputs : IsOverDrawMode
            BinaryConversionInfoBase.AddBinaryFieldDefinition(
                viewerBinary,
                SendModificationTypes.ModifiedDataOnly,
                null,
                new ConverterDefinition(typeof(DefaultConverter)),
                null,
                new InputPropertyDefinition("ViewerBasicData.SceneData.IsOverDrawMode", new Guid("a3342cc5-5ac2-4b7a-af13-3d3612100a24"))
            );

            // Output : reserved1
            // Inputs : None
            BinaryConversionInfoBase.AddFixedSizeFieldDefinition(
                1,
                viewerBinary,
                SendModificationTypes.ModifiedDataOnly,
                null,
                new ConverterDefinition(typeof(DefaultConverter)),
                null
            );

            var viewerPtclBinary = new BinaryStructDefinition(typeof(ViewerBasicPtclData)) { HasBinaryHeader = true };

            // Output : ViewerPtclBinary
            // Inputs : PtclData
            BinaryConversionInfoBase.AddBinaryFieldDefinition(
                viewerBinary,
                SendModificationTypes.FullBinary,
                null,
                new ConverterDefinition(typeof(AssignDataModelConverter)),
                viewerPtclBinary,
                new InputPropertyDefinition("ViewerBasicData.PtclData", new Guid("ead863c6-417a-4465-b3fe-9634b7a4c754"))
            );

            // Output : reloadCtrl
            // Inputs : ReloadCtrl
            BinaryConversionInfoBase.AddBinaryFieldDefinition(
                viewerPtclBinary,
                SendModificationTypes.ModifiedDataOnly,
                null,
                new ConverterDefinition(typeof(DefaultConverter)),
                null,
                new InputPropertyDefinition("ReloadCtrl", new Guid("db71bedd-3c01-45ea-aa36-ae4129933af2"))
            );

            // Output : esetIndexCtrl
            // Inputs : EsetIndexCtrl
            BinaryConversionInfoBase.AddBinaryFieldDefinition(
                viewerPtclBinary,
                SendModificationTypes.ModifiedDataOnly,
                null,
                new ConverterDefinition(typeof(DefaultConverter)),
                null,
                new InputPropertyDefinition("EsetIndexCtrl", new Guid("cbdbf85c-9d0c-49a8-9785-b9ccd228a7eb"))
            );

            // Output : pathLength
            // Inputs : FilePath
            BinaryConversionInfoBase.AddBinaryFieldDefinition(
                viewerPtclBinary,
                SendModificationTypes.FullBinary,
                null,
                new ConverterDefinition(typeof(StringLengthConverter)),
                null,
                new InputPropertyDefinition("FilePath", new Guid("3de86594-3e79-4c73-8012-8159ca2ce408"))
            );

            // Output : filePath
            // Inputs : FilePath
            BinaryConversionInfoBase.AddBinaryFieldDefinition(
                viewerPtclBinary,
                SendModificationTypes.FullBinary,
                null,
                new ConverterDefinition(typeof(StringConverter)),
                null,
                new InputPropertyDefinition("FilePath", new Guid("3de86594-3e79-4c73-8012-8159ca2ce408"))
            );


            //-----------------------------------------------------------------
            // Save the binary structure definition.
            //-----------------------------------------------------------------
            rootBinaryDefinition = viewerBinary;

            //-----------------------------------------------------------------
            // Register events.
            //-----------------------------------------------------------------
            BinaryConversionInfoManager.DataModelCreated   += OnDataModelCreated;
            BinaryConversionInfoManager.DataModelDestroyed += OnDataModelDestroyed;
        }

        /// <summary>
        /// The constructor.
        /// </summary>
        /// <param name="dataModel">The data model to convert.</param>
        private ViewerBinaryConversionInfo(DataModelBase dataModel)
        {
            this.rootBinaryInstance = rootBinaryDefinition.CreateInstance(null, dataModel);
            this.rootBinaryInstance.ConvertBinary();
        }

        /// <summary>
        /// Dispose.
        /// </summary>
        public override void Dispose()
        {
            // Dispose the binary structure instance.
            if (this.rootBinaryInstance != null)
            {
                this.rootBinaryInstance.Dispose();
            }
        }

        /// <summary>
        /// Handle DataModelCreated event from the manager.
        /// </summary>
        /// <param name="sender">The sender of the event, should be null.</param>
        /// <param name="dataModel">The created data model.</param>
        private static void OnDataModelCreated(object sender, DataModelBase dataModel)
        {
            if (typeof(ViewerData).IsInstanceOfType(dataModel) == true)
            {
                var instance = new ViewerBinaryConversionInfo(dataModel);
                instanceMap.Add(dataModel, instance);

                SendModifiedBinaryContext.BeginSession();
                SendModifiedBinaryContext.AddBinaryStructToSend(instance.rootBinaryInstance);
                SendModifiedBinaryContext.EndSession();
            }
        }

        /// <summary>
        /// Handle DataModelCreated event from the manager.
        /// </summary>
        /// <param name="sender">The sender of the event, should be null.</param>
        /// <param name="dataModel">The created data model.</param>
        private static void OnDataModelDestroyed(object sender, DataModelBase dataModel)
        {
            if (typeof(ViewerData).IsInstanceOfType(dataModel) == true)
            {
                if (instanceMap.ContainsKey(dataModel))
                {
                    var instance = instanceMap[dataModel];
                    instanceMap.Remove(dataModel);
                    instance.Dispose();
                }
            }
        }

    }
}
