﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

using System;
using System.Collections.Generic;
using System.Reflection;

using EffectMaker.DataModel.Attributes;
using EffectMaker.DataModel.DataModels;
using EffectMaker.DataModel.Specific.DataModels;
using EffectMaker.DataModelLogic.BinaryConverters;
using EffectMaker.DataModelLogic.BinaryData;
using EffectMaker.DataModelLogic.Utilities;

using ConverterParam = System.Collections.Generic.KeyValuePair<string, object>;

namespace EffectMaker.DataModelLogic.BinaryConversionInfo
{
    /// <summary>
    /// [AUTO GENERATED CLASS, DO NOT MODIFY]
    /// Auto-generated class for converting data model values.
    /// </summary>
    public class EmitterSetBinaryConversionInfo : BinaryConversionInfoBase
    {
        /// <summary>A flag to prevent the static constructor being called more than once.</summary>
        private static bool isStaticConstructorCalled = false;

        /// <summary>The root binary structure definition.</summary>
        private static BinaryStructDefinition rootBinaryDefinition = null;

        /// <summary>The list of instance.</summary>
        private static Dictionary<DataModelBase, BinaryConversionInfoBase> instanceMap = null;

        /// <summary>The root binary structure instance.</summary>
        private BinaryStructInstance rootBinaryInstance = null;

        /// <summary>
        /// The constructor.
        /// </summary>
        static EmitterSetBinaryConversionInfo()
        {
            if (isStaticConstructorCalled == true)
            {
                return;
            }

            isStaticConstructorCalled = true;

            instanceMap = new Dictionary<DataModelBase, BinaryConversionInfoBase>();

            var emitterBinary = new BinaryStructDefinition(typeof(EmitterData)) { HasBinaryHeader = true };

            // Output : flag
            // Inputs : None
            BinaryConversionInfoBase.AddFixedSizeFieldDefinition(
                4,
                emitterBinary,
                SendModificationTypes.ModifiedDataOnly,
                null,
                new ConverterDefinition(typeof(DefaultConverter)),
                null
            );

            // Output : randomSeed
            // Inputs : None
            BinaryConversionInfoBase.AddFixedSizeFieldDefinition(
                4,
                emitterBinary,
                SendModificationTypes.ModifiedDataOnly,
                null,
                new ConverterDefinition(typeof(DefaultConverter)),
                null
            );

            // Output : reserved0
            // Inputs : None
            BinaryConversionInfoBase.AddFixedSizeFieldDefinition(
                8,
                emitterBinary,
                SendModificationTypes.ModifiedDataOnly,
                null,
                new ConverterDefinition(typeof(DefaultConverter)),
                null
            );

            // Output : name
            // Inputs : Name
            BinaryConversionInfoBase.AddBinaryFieldDefinition(
                emitterBinary,
                SendModificationTypes.ModifiedDataOnly,
                null,
                new ConverterDefinition(typeof(FixSizeStringConverter),
                    new ConverterParam("CharArrayLength", 64)),
                null,
                new InputPropertyDefinition("Name", new Guid("2d4eb3ba-cee7-4748-8696-fe3bafe9c92a"))
            );

            // Output : flag
            // Inputs : None
            BinaryConversionInfoBase.AddFixedSizeFieldDefinition(
                16,
                emitterBinary,
                SendModificationTypes.ModifiedDataOnly,
                null,
                new ConverterDefinition(typeof(DefaultConverter)),
                null
            );

            // Output : color0AnimKeynum
            // Inputs : Color0BehaviorType, ColorAnimation0, RandomColor0
            BinaryConversionInfoBase.AddBinaryFieldDefinition(
                emitterBinary,
                SendModificationTypes.ModifiedDataOnly,
                null,
                new ConverterDefinition(typeof(ColorAnimationTableCountConverter)),
                null,
                new InputPropertyDefinition("EmitterColorData.ParticleColor.EmitterColorSettingsData.Color0BehaviorType", new Guid("3044c1e9-782d-4fa2-aa98-ffb8cc3c656f")),
                new InputPropertyDefinition("EmitterColorData.ParticleColor.EmitterColorSettingsData.ColorAnimation0", new Guid("c3ec057b-ef8d-44f9-9675-3b5383bb6acd")),
                new InputPropertyDefinition("EmitterColorData.ParticleColor.EmitterColorSettingsData.RandomColor0", new Guid("92953cca-f2d8-4289-97e6-23646e681827"))
            );

            // Output : alpha0AnimKeyNum
            // Inputs : AlphaAnimation0
            BinaryConversionInfoBase.AddBinaryFieldDefinition(
                emitterBinary,
                SendModificationTypes.ModifiedDataOnly,
                null,
                new ConverterDefinition(typeof(AnimationTableCountConverter)),
                null,
                new InputPropertyDefinition("EmitterColorData.ParticleColor.EmitterColorSettingsData.AlphaAnimation0", new Guid("af62b763-00ec-4582-bbf3-99b06aacef10"))
            );

            // Output : color1AnimKeynum
            // Inputs : Color1BehaviorType, ColorAnimation1, RandomColor1
            BinaryConversionInfoBase.AddBinaryFieldDefinition(
                emitterBinary,
                SendModificationTypes.ModifiedDataOnly,
                null,
                new ConverterDefinition(typeof(ColorAnimationTableCountConverter)),
                null,
                new InputPropertyDefinition("EmitterColorData.ParticleColor.EmitterColorSettingsData.Color1BehaviorType", new Guid("47c9193c-6eb9-4aa9-9cec-eec7b8382e2b")),
                new InputPropertyDefinition("EmitterColorData.ParticleColor.EmitterColorSettingsData.ColorAnimation1", new Guid("0c155e74-73f4-46ba-aca7-0af4ef27320d")),
                new InputPropertyDefinition("EmitterColorData.ParticleColor.EmitterColorSettingsData.RandomColor1", new Guid("3bb877f8-9a60-4a72-af14-ccb8abac1cbf"))
            );

            // Output : alpha1AnimKeyNum
            // Inputs : AlphaAnimation1
            BinaryConversionInfoBase.AddBinaryFieldDefinition(
                emitterBinary,
                SendModificationTypes.ModifiedDataOnly,
                null,
                new ConverterDefinition(typeof(AnimationTableCountConverter)),
                null,
                new InputPropertyDefinition("EmitterColorData.ParticleColor.EmitterColorSettingsData.AlphaAnimation1", new Guid("6d8a08e1-9624-48d3-b78e-27f95989a442"))
            );

            // Output : scaleAnimKeyNum
            // Inputs : AnimationTable
            BinaryConversionInfoBase.AddBinaryFieldDefinition(
                emitterBinary,
                SendModificationTypes.ModifiedDataOnly,
                null,
                new ConverterDefinition(typeof(AnimationTableCountConverter)),
                null,
                new InputPropertyDefinition("EmitterScaleData.EmitterScaleAnimationCurveData.AnimationTable", new Guid("f655bd21-a7e6-45c4-998d-429c3ef2a2b0"))
            );

            // Output : shaderAnimKeyNum
            // Inputs : ShaderType, CombinerEditorProjectPath, CoefficientAnimationTable, AnimationTable
            BinaryConversionInfoBase.AddBinaryFieldDefinition(
                emitterBinary,
                SendModificationTypes.ModifiedDataOnly,
                null,
                new ConverterDefinition(typeof(CombinerShaderAnimationTableCountConverter)),
                null,
                new InputPropertyDefinition("EmitterCombinerData.EmitterCombinerShaderData.ShaderType", new Guid("52df718b-e6e5-4ded-bcfa-53c84db9a3d0")),
                new InputPropertyDefinition("EmitterCombinerData.EmitterCombinerEditorData.CombinerEditorProjectPath", new Guid("c07be36b-2ce7-4ab5-b66d-bbfb169e6b45")),
                new InputPropertyDefinition("EmitterCombinerData.EmitterCombinerShaderData.CoefficientAnimationTable", new Guid("2d76c03e-1aad-4219-865b-4daaf18d6cbc")),
                new InputPropertyDefinition("EmitterCombinerData.EmitterCombinerEditorData.EmitterCombinerEditorAnimationCurveData0.AnimationTable", new Guid("f56be7de-c309-422d-988f-591004c2b353"))
            );

            // Output : reserved0
            // Inputs : None
            BinaryConversionInfoBase.AddFixedSizeFieldDefinition(
                8,
                emitterBinary,
                SendModificationTypes.ModifiedDataOnly,
                null,
                new ConverterDefinition(typeof(DefaultConverter)),
                null
            );

            // Output : color0AnimLoopRate
            // Inputs : None
            BinaryConversionInfoBase.AddFixedSizeFieldDefinition(
                4,
                emitterBinary,
                SendModificationTypes.ModifiedDataOnly,
                null,
                new ConverterDefinition(typeof(DefaultConverter)),
                null
            );

            // Output : alpha0AnimLoopRate
            // Inputs : None
            BinaryConversionInfoBase.AddFixedSizeFieldDefinition(
                4,
                emitterBinary,
                SendModificationTypes.ModifiedDataOnly,
                null,
                new ConverterDefinition(typeof(DefaultConverter)),
                null
            );

            // Output : color1AnimLoopRate
            // Inputs : None
            BinaryConversionInfoBase.AddFixedSizeFieldDefinition(
                4,
                emitterBinary,
                SendModificationTypes.ModifiedDataOnly,
                null,
                new ConverterDefinition(typeof(DefaultConverter)),
                null
            );

            // Output : alpha1AnimLoopRate
            // Inputs : None
            BinaryConversionInfoBase.AddFixedSizeFieldDefinition(
                4,
                emitterBinary,
                SendModificationTypes.ModifiedDataOnly,
                null,
                new ConverterDefinition(typeof(DefaultConverter)),
                null
            );

            // Output : scaleAnimLoopRate
            // Inputs : None
            BinaryConversionInfoBase.AddFixedSizeFieldDefinition(
                4,
                emitterBinary,
                SendModificationTypes.ModifiedDataOnly,
                null,
                new ConverterDefinition(typeof(DefaultConverter)),
                null
            );

            // Output : color0AnimIsLoopInitRandom
            // Inputs : None
            BinaryConversionInfoBase.AddFixedSizeFieldDefinition(
                4,
                emitterBinary,
                SendModificationTypes.ModifiedDataOnly,
                null,
                new ConverterDefinition(typeof(DefaultConverter)),
                null
            );

            // Output : alpha0AnimIsLoopInitRandom
            // Inputs : None
            BinaryConversionInfoBase.AddFixedSizeFieldDefinition(
                4,
                emitterBinary,
                SendModificationTypes.ModifiedDataOnly,
                null,
                new ConverterDefinition(typeof(DefaultConverter)),
                null
            );

            // Output : color1AnimIsLoopInitRandom
            // Inputs : None
            BinaryConversionInfoBase.AddFixedSizeFieldDefinition(
                4,
                emitterBinary,
                SendModificationTypes.ModifiedDataOnly,
                null,
                new ConverterDefinition(typeof(DefaultConverter)),
                null
            );

            // Output : alpha1AnimIsLoopInitRandom
            // Inputs : None
            BinaryConversionInfoBase.AddFixedSizeFieldDefinition(
                4,
                emitterBinary,
                SendModificationTypes.ModifiedDataOnly,
                null,
                new ConverterDefinition(typeof(DefaultConverter)),
                null
            );

            // Output : scaleAnimIsLoopInitRandom
            // Inputs : None
            BinaryConversionInfoBase.AddFixedSizeFieldDefinition(
                4,
                emitterBinary,
                SendModificationTypes.ModifiedDataOnly,
                null,
                new ConverterDefinition(typeof(DefaultConverter)),
                null
            );

            // Output : reserved1
            // Inputs : None
            BinaryConversionInfoBase.AddFixedSizeFieldDefinition(
                8,
                emitterBinary,
                SendModificationTypes.ModifiedDataOnly,
                null,
                new ConverterDefinition(typeof(DefaultConverter)),
                null
            );

            // Output : gravity
            // Inputs : GravityDir
            BinaryConversionInfoBase.AddBinaryFieldDefinition(
                emitterBinary,
                SendModificationTypes.ModifiedDataOnly,
                null,
                new ConverterDefinition(typeof(DefaultConverter)),
                null,
                new InputPropertyDefinition("EmitterEmissionData.EmitterEmissionGravityData.GravityDir", new Guid("c15a47b8-3599-43c5-9972-9b03a4379851"))
            );

            // Output : gravityScale
            // Inputs : GravityVolume
            BinaryConversionInfoBase.AddBinaryFieldDefinition(
                emitterBinary,
                SendModificationTypes.ModifiedDataOnly,
                null,
                new ConverterDefinition(typeof(ValueScalingConverter),
                    new ConverterParam("Scale", 0.01)),
                null,
                new InputPropertyDefinition("EmitterEmissionData.EmitterEmissionGravityData.GravityVolume", new Guid("fd6cf51f-3d47-41ae-ab8e-f0bf1b1760ca"))
            );

            // Output : airRegist
            // Inputs : AirRegist
            BinaryConversionInfoBase.AddBinaryFieldDefinition(
                emitterBinary,
                SendModificationTypes.ModifiedDataOnly,
                null,
                new ConverterDefinition(typeof(DefaultConverter)),
                null,
                new InputPropertyDefinition("EmitterEmissionData.EmitterEmissionGravityData.AirRegist", new Guid("8e207911-a1e0-4a52-b7b3-2163ad92ad55"))
            );

            // Output : reserved2
            // Inputs : None
            BinaryConversionInfoBase.AddFixedSizeFieldDefinition(
                12,
                emitterBinary,
                SendModificationTypes.ModifiedDataOnly,
                null,
                new ConverterDefinition(typeof(DefaultConverter)),
                null
            );

            // Output : center
            // Inputs : Scale
            BinaryConversionInfoBase.AddBinaryFieldDefinition(
                emitterBinary,
                SendModificationTypes.ModifiedDataOnly,
                null,
                new ConverterDefinition(typeof(DefaultConverter)),
                null,
                new InputPropertyDefinition("EmitterParticleData.EmitterParticleShapeData.Scale", new Guid("9508dcb1-6f74-43bf-8ede-a4b317a6afab"))
            );

            // Output : offset
            // Inputs : CameraOffsetValue
            BinaryConversionInfoBase.AddBinaryFieldDefinition(
                emitterBinary,
                SendModificationTypes.ModifiedDataOnly,
                null,
                new ConverterDefinition(typeof(DefaultConverter)),
                null,
                new InputPropertyDefinition("EmitterParticleData.EmitterParticleShapeData.CameraOffsetValue", new Guid("ea5e2784-b797-4cc1-8f19-5291ed8b6e7a"))
            );

            // Output : reserved3
            // Inputs : None
            BinaryConversionInfoBase.AddFixedSizeFieldDefinition(
                4,
                emitterBinary,
                SendModificationTypes.ModifiedDataOnly,
                null,
                new ConverterDefinition(typeof(DefaultConverter)),
                null
            );

            // Output : amplitude
            // Inputs : Amplitude
            BinaryConversionInfoBase.AddBinaryFieldDefinition(
                emitterBinary,
                SendModificationTypes.ModifiedDataOnly,
                null,
                new ConverterDefinition(typeof(PrimitiveComponentTypeConversionConverter),
                    new ConverterParam("TargetType", typeof(System.Single))),
                null,
                new InputPropertyDefinition("EmitterParticleData.EmitterParticleFluctutaionData.Amplitude", new Guid("d63a980e-0744-40e5-89ce-867192dd4729"))
            );

            // Output : cycle
            // Inputs : Frequency
            BinaryConversionInfoBase.AddBinaryFieldDefinition(
                emitterBinary,
                SendModificationTypes.ModifiedDataOnly,
                null,
                new ConverterDefinition(typeof(PrimitiveComponentTypeConversionConverter),
                    new ConverterParam("TargetType", typeof(System.Single))),
                null,
                new InputPropertyDefinition("EmitterParticleData.EmitterParticleFluctutaionData.Frequency", new Guid("e5921adb-1451-44ff-b2f0-bac02357ff55"))
            );

            // Output : phaseRnd
            // Inputs : PhaseRandom
            BinaryConversionInfoBase.AddBinaryFieldDefinition(
                emitterBinary,
                SendModificationTypes.ModifiedDataOnly,
                null,
                new ConverterDefinition(typeof(PrimitiveComponentTypeConversionConverter),
                    new ConverterParam("TargetType", typeof(System.Single))),
                null,
                new InputPropertyDefinition("EmitterParticleData.EmitterParticleFluctutaionData.PhaseRandom", new Guid("5b66b689-8dde-46af-a122-089123f75da6"))
            );

            // Output : phaseInit
            // Inputs : InitPhase
            BinaryConversionInfoBase.AddBinaryFieldDefinition(
                emitterBinary,
                SendModificationTypes.ModifiedDataOnly,
                null,
                new ConverterDefinition(typeof(PrimitiveComponentTypeConversionConverter),
                    new ConverterParam("TargetType", typeof(System.Single))),
                null,
                new InputPropertyDefinition("EmitterParticleData.EmitterParticleFluctutaionData.InitPhase", new Guid("2328400b-c37f-4261-b151-cef0b8e32699"))
            );

            // Output : coefficient0
            // Inputs : Coefficient
            BinaryConversionInfoBase.AddBinaryFieldDefinition(
                emitterBinary,
                SendModificationTypes.ModifiedDataOnly,
                null,
                new ConverterDefinition(typeof(SelectPrimitiveChannelConverter),
                    new ConverterParam("ChannelIndex", 0),
                    new ConverterParam("RadianConvertMode", 0)),
                null,
                new InputPropertyDefinition("EmitterCombinerData.EmitterCombinerShaderData.Coefficient", new Guid("48128336-4a72-423c-b9fe-4b680232f833"))
            );

            // Output : coefficient1
            // Inputs : Coefficient
            BinaryConversionInfoBase.AddBinaryFieldDefinition(
                emitterBinary,
                SendModificationTypes.ModifiedDataOnly,
                null,
                new ConverterDefinition(typeof(SelectPrimitiveChannelConverter),
                    new ConverterParam("ChannelIndex", 1),
                    new ConverterParam("RadianConvertMode", 0)),
                null,
                new InputPropertyDefinition("EmitterCombinerData.EmitterCombinerShaderData.Coefficient", new Guid("48128336-4a72-423c-b9fe-4b680232f833"))
            );

            // Output : reserved4
            // Inputs : None
            BinaryConversionInfoBase.AddFixedSizeFieldDefinition(
                8,
                emitterBinary,
                SendModificationTypes.ModifiedDataOnly,
                null,
                new ConverterDefinition(typeof(DefaultConverter)),
                null
            );

            // Output : ptnTableNum
            // Inputs : PatternTableCount
            BinaryConversionInfoBase.AddBinaryFieldDefinition(
                emitterBinary,
                SendModificationTypes.ModifiedDataOnly,
                null,
                new ConverterDefinition(typeof(TypeConversionConverter),
                    new ConverterParam("TargetType", typeof(System.Single))),
                null,
                new InputPropertyDefinition("Textures.Texture0.EmitterTexturePatternAnimationData.PatternTableCount", new Guid("a01a612a-d8e9-4adf-a82a-04d2c33a4e50"))
            );

            // Output : ptnFreq
            // Inputs : DurationCountPerFrame
            BinaryConversionInfoBase.AddBinaryFieldDefinition(
                emitterBinary,
                SendModificationTypes.ModifiedDataOnly,
                null,
                new ConverterDefinition(typeof(TypeConversionConverter),
                    new ConverterParam("TargetType", typeof(System.Single))),
                null,
                new InputPropertyDefinition("Textures.Texture0.EmitterTexturePatternAnimationData.DurationCountPerFrame", new Guid("795849ff-cffc-4a89-8be0-bdc45a02dbc0"))
            );

            // Output : ptnNum
            // Inputs : RandomPatternTableCount
            BinaryConversionInfoBase.AddBinaryFieldDefinition(
                emitterBinary,
                SendModificationTypes.ModifiedDataOnly,
                null,
                new ConverterDefinition(typeof(TypeConversionConverter),
                    new ConverterParam("TargetType", typeof(System.Single))),
                null,
                new InputPropertyDefinition("Textures.Texture0.EmitterTexturePatternAnimationData.RandomPatternTableCount", new Guid("18503eae-62fc-4a60-aa1e-4d81f561ea17"))
            );

            // Output : loopCount
            // Inputs : LoopCount
            BinaryConversionInfoBase.AddBinaryFieldDefinition(
                emitterBinary,
                SendModificationTypes.ModifiedDataOnly,
                null,
                new ConverterDefinition(typeof(TypeConversionConverter),
                    new ConverterParam("TargetType", typeof(System.Single))),
                null,
                new InputPropertyDefinition("Textures.Texture0.EmitterTexturePatternAnimationData.LoopCount", new Guid("1f272c69-14c3-4845-922c-6b1000acfd64"))
            );

            // Output : ptnTable
            // Inputs : PatternTable
            BinaryConversionInfoBase.AddBinaryFieldDefinition(
                emitterBinary,
                SendModificationTypes.ModifiedDataOnly,
                null,
                new ConverterDefinition(typeof(CollectionValueConverter),
                    new ConverterParam("ElementCount", 32),
                    new ConverterParam("ElementType", typeof(System.Int32))),
                null,
                new InputPropertyDefinition("Textures.Texture0.EmitterTexturePatternAnimationData.PatternTable", new Guid("36352cd0-4606-4234-81ec-258f0adb9ab8"))
            );

            // Output : ptnTableNum
            // Inputs : PatternTableCount
            BinaryConversionInfoBase.AddBinaryFieldDefinition(
                emitterBinary,
                SendModificationTypes.ModifiedDataOnly,
                null,
                new ConverterDefinition(typeof(TypeConversionConverter),
                    new ConverterParam("TargetType", typeof(System.Single))),
                null,
                new InputPropertyDefinition("Textures.Texture1.EmitterTexturePatternAnimationData.PatternTableCount", new Guid("a01a612a-d8e9-4adf-a82a-04d2c33a4e50"))
            );

            // Output : ptnFreq
            // Inputs : DurationCountPerFrame
            BinaryConversionInfoBase.AddBinaryFieldDefinition(
                emitterBinary,
                SendModificationTypes.ModifiedDataOnly,
                null,
                new ConverterDefinition(typeof(TypeConversionConverter),
                    new ConverterParam("TargetType", typeof(System.Single))),
                null,
                new InputPropertyDefinition("Textures.Texture1.EmitterTexturePatternAnimationData.DurationCountPerFrame", new Guid("795849ff-cffc-4a89-8be0-bdc45a02dbc0"))
            );

            // Output : ptnNum
            // Inputs : RandomPatternTableCount
            BinaryConversionInfoBase.AddBinaryFieldDefinition(
                emitterBinary,
                SendModificationTypes.ModifiedDataOnly,
                null,
                new ConverterDefinition(typeof(TypeConversionConverter),
                    new ConverterParam("TargetType", typeof(System.Single))),
                null,
                new InputPropertyDefinition("Textures.Texture1.EmitterTexturePatternAnimationData.RandomPatternTableCount", new Guid("18503eae-62fc-4a60-aa1e-4d81f561ea17"))
            );

            // Output : loopCount
            // Inputs : LoopCount
            BinaryConversionInfoBase.AddBinaryFieldDefinition(
                emitterBinary,
                SendModificationTypes.ModifiedDataOnly,
                null,
                new ConverterDefinition(typeof(TypeConversionConverter),
                    new ConverterParam("TargetType", typeof(System.Single))),
                null,
                new InputPropertyDefinition("Textures.Texture1.EmitterTexturePatternAnimationData.LoopCount", new Guid("1f272c69-14c3-4845-922c-6b1000acfd64"))
            );

            // Output : ptnTable
            // Inputs : PatternTable
            BinaryConversionInfoBase.AddBinaryFieldDefinition(
                emitterBinary,
                SendModificationTypes.ModifiedDataOnly,
                null,
                new ConverterDefinition(typeof(CollectionValueConverter),
                    new ConverterParam("ElementCount", 32),
                    new ConverterParam("ElementType", typeof(System.Int32))),
                null,
                new InputPropertyDefinition("Textures.Texture1.EmitterTexturePatternAnimationData.PatternTable", new Guid("36352cd0-4606-4234-81ec-258f0adb9ab8"))
            );

            // Output : ptnTableNum
            // Inputs : PatternTableCount
            BinaryConversionInfoBase.AddBinaryFieldDefinition(
                emitterBinary,
                SendModificationTypes.ModifiedDataOnly,
                null,
                new ConverterDefinition(typeof(TypeConversionConverter),
                    new ConverterParam("TargetType", typeof(System.Single))),
                null,
                new InputPropertyDefinition("Textures.Texture2.EmitterTexturePatternAnimationData.PatternTableCount", new Guid("a01a612a-d8e9-4adf-a82a-04d2c33a4e50"))
            );

            // Output : ptnFreq
            // Inputs : DurationCountPerFrame
            BinaryConversionInfoBase.AddBinaryFieldDefinition(
                emitterBinary,
                SendModificationTypes.ModifiedDataOnly,
                null,
                new ConverterDefinition(typeof(TypeConversionConverter),
                    new ConverterParam("TargetType", typeof(System.Single))),
                null,
                new InputPropertyDefinition("Textures.Texture2.EmitterTexturePatternAnimationData.DurationCountPerFrame", new Guid("795849ff-cffc-4a89-8be0-bdc45a02dbc0"))
            );

            // Output : ptnNum
            // Inputs : RandomPatternTableCount
            BinaryConversionInfoBase.AddBinaryFieldDefinition(
                emitterBinary,
                SendModificationTypes.ModifiedDataOnly,
                null,
                new ConverterDefinition(typeof(TypeConversionConverter),
                    new ConverterParam("TargetType", typeof(System.Single))),
                null,
                new InputPropertyDefinition("Textures.Texture2.EmitterTexturePatternAnimationData.RandomPatternTableCount", new Guid("18503eae-62fc-4a60-aa1e-4d81f561ea17"))
            );

            // Output : loopCount
            // Inputs : LoopCount
            BinaryConversionInfoBase.AddBinaryFieldDefinition(
                emitterBinary,
                SendModificationTypes.ModifiedDataOnly,
                null,
                new ConverterDefinition(typeof(TypeConversionConverter),
                    new ConverterParam("TargetType", typeof(System.Single))),
                null,
                new InputPropertyDefinition("Textures.Texture2.EmitterTexturePatternAnimationData.LoopCount", new Guid("1f272c69-14c3-4845-922c-6b1000acfd64"))
            );

            // Output : ptnTable
            // Inputs : PatternTable
            BinaryConversionInfoBase.AddBinaryFieldDefinition(
                emitterBinary,
                SendModificationTypes.ModifiedDataOnly,
                null,
                new ConverterDefinition(typeof(CollectionValueConverter),
                    new ConverterParam("ElementCount", 32),
                    new ConverterParam("ElementType", typeof(System.Int32))),
                null,
                new InputPropertyDefinition("Textures.Texture2.EmitterTexturePatternAnimationData.PatternTable", new Guid("36352cd0-4606-4234-81ec-258f0adb9ab8"))
            );

            // Output : scrollAdd
            // Inputs : UvScrollAddValue
            BinaryConversionInfoBase.AddBinaryFieldDefinition(
                emitterBinary,
                SendModificationTypes.ModifiedDataOnly,
                null,
                new ConverterDefinition(typeof(DefaultConverter)),
                null,
                new InputPropertyDefinition("Textures.Texture0.EmitterTextureUvAnimationData.UvScrollAddValue", new Guid("755c9505-599b-4c9a-a1a4-2b0d4078848d"))
            );

            // Output : scrollInit
            // Inputs : UvScrollInitialValue
            BinaryConversionInfoBase.AddBinaryFieldDefinition(
                emitterBinary,
                SendModificationTypes.ModifiedDataOnly,
                null,
                new ConverterDefinition(typeof(DefaultConverter)),
                null,
                new InputPropertyDefinition("Textures.Texture0.EmitterTextureUvAnimationData.UvScrollInitialValue", new Guid("515f9b88-3c9c-4ce5-beeb-f8394f24dae4"))
            );

            // Output : scrollInitRand
            // Inputs : UvScrollInitialRandomValue
            BinaryConversionInfoBase.AddBinaryFieldDefinition(
                emitterBinary,
                SendModificationTypes.ModifiedDataOnly,
                null,
                new ConverterDefinition(typeof(DefaultConverter)),
                null,
                new InputPropertyDefinition("Textures.Texture0.EmitterTextureUvAnimationData.UvScrollInitialRandomValue", new Guid("e2508e6a-0c9c-4d78-bfac-33fa9589ea9b"))
            );

            // Output : scaleAdd
            // Inputs : UvScaleAddValue
            BinaryConversionInfoBase.AddBinaryFieldDefinition(
                emitterBinary,
                SendModificationTypes.ModifiedDataOnly,
                null,
                new ConverterDefinition(typeof(DefaultConverter)),
                null,
                new InputPropertyDefinition("Textures.Texture0.EmitterTextureUvAnimationData.UvScaleAddValue", new Guid("f02abd81-835e-4dee-8d3c-27765ad45584"))
            );

            // Output : scaleInit
            // Inputs : UvScaleInitialValue
            BinaryConversionInfoBase.AddBinaryFieldDefinition(
                emitterBinary,
                SendModificationTypes.ModifiedDataOnly,
                null,
                new ConverterDefinition(typeof(DefaultConverter)),
                null,
                new InputPropertyDefinition("Textures.Texture0.EmitterTextureUvAnimationData.UvScaleInitialValue", new Guid("05086c12-4be1-485f-a5ba-11540e41fbdc"))
            );

            // Output : scaleInitRand
            // Inputs : UvScaleInitialRandomValue
            BinaryConversionInfoBase.AddBinaryFieldDefinition(
                emitterBinary,
                SendModificationTypes.ModifiedDataOnly,
                null,
                new ConverterDefinition(typeof(DefaultConverter)),
                null,
                new InputPropertyDefinition("Textures.Texture0.EmitterTextureUvAnimationData.UvScaleInitialRandomValue", new Guid("db31e5be-c6f5-4993-ad5c-e38629f3d2d7"))
            );

            // Output : rotAdd
            // Inputs : UvRotationAddValue
            BinaryConversionInfoBase.AddBinaryFieldDefinition(
                emitterBinary,
                SendModificationTypes.ModifiedDataOnly,
                null,
                new ConverterDefinition(typeof(RadianConverter)),
                null,
                new InputPropertyDefinition("Textures.Texture0.EmitterTextureUvAnimationData.UvRotationAddValue", new Guid("1b6f37c4-0352-4c24-b0bc-11bba56db2ed"))
            );

            // Output : rotInit
            // Inputs : UvRotationInitialValue
            BinaryConversionInfoBase.AddBinaryFieldDefinition(
                emitterBinary,
                SendModificationTypes.ModifiedDataOnly,
                null,
                new ConverterDefinition(typeof(RadianConverter)),
                null,
                new InputPropertyDefinition("Textures.Texture0.EmitterTextureUvAnimationData.UvRotationInitialValue", new Guid("369a82cc-4391-4bea-9a9f-820053d2241e"))
            );

            // Output : rotInitRand
            // Inputs : UvRotationInitialRandomValue
            BinaryConversionInfoBase.AddBinaryFieldDefinition(
                emitterBinary,
                SendModificationTypes.ModifiedDataOnly,
                null,
                new ConverterDefinition(typeof(RadianConverter)),
                null,
                new InputPropertyDefinition("Textures.Texture0.EmitterTextureUvAnimationData.UvRotationInitialRandomValue", new Guid("3ba74e99-315a-4702-825e-c85f27bcddb2"))
            );

            // Output : randomType
            // Inputs : None
            BinaryConversionInfoBase.AddFixedSizeFieldDefinition(
                4,
                emitterBinary,
                SendModificationTypes.ModifiedDataOnly,
                null,
                new ConverterDefinition(typeof(DefaultConverter)),
                null
            );

            // Output : uvScale
            // Inputs : None
            BinaryConversionInfoBase.AddFixedSizeFieldDefinition(
                8,
                emitterBinary,
                SendModificationTypes.ModifiedDataOnly,
                null,
                new ConverterDefinition(typeof(DefaultConverter)),
                null
            );

            // Output : uvDiv
            // Inputs : PatternDivU, PatternDivV
            BinaryConversionInfoBase.AddBinaryFieldDefinition(
                emitterBinary,
                SendModificationTypes.ModifiedDataOnly,
                null,
                new ConverterDefinition(typeof(CompositionConverter),
                    new ConverterParam("ElementCount", 2),
                    new ConverterParam("ElementType", typeof(System.Single))),
                null,
                new InputPropertyDefinition("Textures.Texture0.EmitterTextureFileData.PatternDivU", new Guid("701302eb-69aa-4cc9-ad9a-7bb0e6ba98e7")),
                new InputPropertyDefinition("Textures.Texture0.EmitterTextureFileData.PatternDivV", new Guid("a8ffa8a2-3e3f-4059-a787-a63e1e2925a1"))
            );

            // Output : scrollAdd
            // Inputs : UvScrollAddValue
            BinaryConversionInfoBase.AddBinaryFieldDefinition(
                emitterBinary,
                SendModificationTypes.ModifiedDataOnly,
                null,
                new ConverterDefinition(typeof(DefaultConverter)),
                null,
                new InputPropertyDefinition("Textures.Texture1.EmitterTextureUvAnimationData.UvScrollAddValue", new Guid("755c9505-599b-4c9a-a1a4-2b0d4078848d"))
            );

            // Output : scrollInit
            // Inputs : UvScrollInitialValue
            BinaryConversionInfoBase.AddBinaryFieldDefinition(
                emitterBinary,
                SendModificationTypes.ModifiedDataOnly,
                null,
                new ConverterDefinition(typeof(DefaultConverter)),
                null,
                new InputPropertyDefinition("Textures.Texture1.EmitterTextureUvAnimationData.UvScrollInitialValue", new Guid("515f9b88-3c9c-4ce5-beeb-f8394f24dae4"))
            );

            // Output : scrollInitRand
            // Inputs : UvScrollInitialRandomValue
            BinaryConversionInfoBase.AddBinaryFieldDefinition(
                emitterBinary,
                SendModificationTypes.ModifiedDataOnly,
                null,
                new ConverterDefinition(typeof(DefaultConverter)),
                null,
                new InputPropertyDefinition("Textures.Texture1.EmitterTextureUvAnimationData.UvScrollInitialRandomValue", new Guid("e2508e6a-0c9c-4d78-bfac-33fa9589ea9b"))
            );

            // Output : scaleAdd
            // Inputs : UvScaleAddValue
            BinaryConversionInfoBase.AddBinaryFieldDefinition(
                emitterBinary,
                SendModificationTypes.ModifiedDataOnly,
                null,
                new ConverterDefinition(typeof(DefaultConverter)),
                null,
                new InputPropertyDefinition("Textures.Texture1.EmitterTextureUvAnimationData.UvScaleAddValue", new Guid("f02abd81-835e-4dee-8d3c-27765ad45584"))
            );

            // Output : scaleInit
            // Inputs : UvScaleInitialValue
            BinaryConversionInfoBase.AddBinaryFieldDefinition(
                emitterBinary,
                SendModificationTypes.ModifiedDataOnly,
                null,
                new ConverterDefinition(typeof(DefaultConverter)),
                null,
                new InputPropertyDefinition("Textures.Texture1.EmitterTextureUvAnimationData.UvScaleInitialValue", new Guid("05086c12-4be1-485f-a5ba-11540e41fbdc"))
            );

            // Output : scaleInitRand
            // Inputs : UvScaleInitialRandomValue
            BinaryConversionInfoBase.AddBinaryFieldDefinition(
                emitterBinary,
                SendModificationTypes.ModifiedDataOnly,
                null,
                new ConverterDefinition(typeof(DefaultConverter)),
                null,
                new InputPropertyDefinition("Textures.Texture1.EmitterTextureUvAnimationData.UvScaleInitialRandomValue", new Guid("db31e5be-c6f5-4993-ad5c-e38629f3d2d7"))
            );

            // Output : rotAdd
            // Inputs : UvRotationAddValue
            BinaryConversionInfoBase.AddBinaryFieldDefinition(
                emitterBinary,
                SendModificationTypes.ModifiedDataOnly,
                null,
                new ConverterDefinition(typeof(RadianConverter)),
                null,
                new InputPropertyDefinition("Textures.Texture1.EmitterTextureUvAnimationData.UvRotationAddValue", new Guid("1b6f37c4-0352-4c24-b0bc-11bba56db2ed"))
            );

            // Output : rotInit
            // Inputs : UvRotationInitialValue
            BinaryConversionInfoBase.AddBinaryFieldDefinition(
                emitterBinary,
                SendModificationTypes.ModifiedDataOnly,
                null,
                new ConverterDefinition(typeof(RadianConverter)),
                null,
                new InputPropertyDefinition("Textures.Texture1.EmitterTextureUvAnimationData.UvRotationInitialValue", new Guid("369a82cc-4391-4bea-9a9f-820053d2241e"))
            );

            // Output : rotInitRand
            // Inputs : UvRotationInitialRandomValue
            BinaryConversionInfoBase.AddBinaryFieldDefinition(
                emitterBinary,
                SendModificationTypes.ModifiedDataOnly,
                null,
                new ConverterDefinition(typeof(RadianConverter)),
                null,
                new InputPropertyDefinition("Textures.Texture1.EmitterTextureUvAnimationData.UvRotationInitialRandomValue", new Guid("3ba74e99-315a-4702-825e-c85f27bcddb2"))
            );

            // Output : randomType
            // Inputs : None
            BinaryConversionInfoBase.AddFixedSizeFieldDefinition(
                4,
                emitterBinary,
                SendModificationTypes.ModifiedDataOnly,
                null,
                new ConverterDefinition(typeof(DefaultConverter)),
                null
            );

            // Output : uvScale
            // Inputs : None
            BinaryConversionInfoBase.AddFixedSizeFieldDefinition(
                8,
                emitterBinary,
                SendModificationTypes.ModifiedDataOnly,
                null,
                new ConverterDefinition(typeof(DefaultConverter)),
                null
            );

            // Output : uvDiv
            // Inputs : PatternDivU, PatternDivV
            BinaryConversionInfoBase.AddBinaryFieldDefinition(
                emitterBinary,
                SendModificationTypes.ModifiedDataOnly,
                null,
                new ConverterDefinition(typeof(CompositionConverter),
                    new ConverterParam("ElementCount", 2),
                    new ConverterParam("ElementType", typeof(System.Single))),
                null,
                new InputPropertyDefinition("Textures.Texture1.EmitterTextureFileData.PatternDivU", new Guid("701302eb-69aa-4cc9-ad9a-7bb0e6ba98e7")),
                new InputPropertyDefinition("Textures.Texture1.EmitterTextureFileData.PatternDivV", new Guid("a8ffa8a2-3e3f-4059-a787-a63e1e2925a1"))
            );

            // Output : scrollAdd
            // Inputs : UvScrollAddValue
            BinaryConversionInfoBase.AddBinaryFieldDefinition(
                emitterBinary,
                SendModificationTypes.ModifiedDataOnly,
                null,
                new ConverterDefinition(typeof(DefaultConverter)),
                null,
                new InputPropertyDefinition("Textures.Texture2.EmitterTextureUvAnimationData.UvScrollAddValue", new Guid("755c9505-599b-4c9a-a1a4-2b0d4078848d"))
            );

            // Output : scrollInit
            // Inputs : UvScrollInitialValue
            BinaryConversionInfoBase.AddBinaryFieldDefinition(
                emitterBinary,
                SendModificationTypes.ModifiedDataOnly,
                null,
                new ConverterDefinition(typeof(DefaultConverter)),
                null,
                new InputPropertyDefinition("Textures.Texture2.EmitterTextureUvAnimationData.UvScrollInitialValue", new Guid("515f9b88-3c9c-4ce5-beeb-f8394f24dae4"))
            );

            // Output : scrollInitRand
            // Inputs : UvScrollInitialRandomValue
            BinaryConversionInfoBase.AddBinaryFieldDefinition(
                emitterBinary,
                SendModificationTypes.ModifiedDataOnly,
                null,
                new ConverterDefinition(typeof(DefaultConverter)),
                null,
                new InputPropertyDefinition("Textures.Texture2.EmitterTextureUvAnimationData.UvScrollInitialRandomValue", new Guid("e2508e6a-0c9c-4d78-bfac-33fa9589ea9b"))
            );

            // Output : scaleAdd
            // Inputs : UvScaleAddValue
            BinaryConversionInfoBase.AddBinaryFieldDefinition(
                emitterBinary,
                SendModificationTypes.ModifiedDataOnly,
                null,
                new ConverterDefinition(typeof(DefaultConverter)),
                null,
                new InputPropertyDefinition("Textures.Texture2.EmitterTextureUvAnimationData.UvScaleAddValue", new Guid("f02abd81-835e-4dee-8d3c-27765ad45584"))
            );

            // Output : scaleInit
            // Inputs : UvScaleInitialValue
            BinaryConversionInfoBase.AddBinaryFieldDefinition(
                emitterBinary,
                SendModificationTypes.ModifiedDataOnly,
                null,
                new ConverterDefinition(typeof(DefaultConverter)),
                null,
                new InputPropertyDefinition("Textures.Texture2.EmitterTextureUvAnimationData.UvScaleInitialValue", new Guid("05086c12-4be1-485f-a5ba-11540e41fbdc"))
            );

            // Output : scaleInitRand
            // Inputs : UvScaleInitialRandomValue
            BinaryConversionInfoBase.AddBinaryFieldDefinition(
                emitterBinary,
                SendModificationTypes.ModifiedDataOnly,
                null,
                new ConverterDefinition(typeof(DefaultConverter)),
                null,
                new InputPropertyDefinition("Textures.Texture2.EmitterTextureUvAnimationData.UvScaleInitialRandomValue", new Guid("db31e5be-c6f5-4993-ad5c-e38629f3d2d7"))
            );

            // Output : rotAdd
            // Inputs : UvRotationAddValue
            BinaryConversionInfoBase.AddBinaryFieldDefinition(
                emitterBinary,
                SendModificationTypes.ModifiedDataOnly,
                null,
                new ConverterDefinition(typeof(RadianConverter)),
                null,
                new InputPropertyDefinition("Textures.Texture2.EmitterTextureUvAnimationData.UvRotationAddValue", new Guid("1b6f37c4-0352-4c24-b0bc-11bba56db2ed"))
            );

            // Output : rotInit
            // Inputs : UvRotationInitialValue
            BinaryConversionInfoBase.AddBinaryFieldDefinition(
                emitterBinary,
                SendModificationTypes.ModifiedDataOnly,
                null,
                new ConverterDefinition(typeof(RadianConverter)),
                null,
                new InputPropertyDefinition("Textures.Texture2.EmitterTextureUvAnimationData.UvRotationInitialValue", new Guid("369a82cc-4391-4bea-9a9f-820053d2241e"))
            );

            // Output : rotInitRand
            // Inputs : UvRotationInitialRandomValue
            BinaryConversionInfoBase.AddBinaryFieldDefinition(
                emitterBinary,
                SendModificationTypes.ModifiedDataOnly,
                null,
                new ConverterDefinition(typeof(RadianConverter)),
                null,
                new InputPropertyDefinition("Textures.Texture2.EmitterTextureUvAnimationData.UvRotationInitialRandomValue", new Guid("3ba74e99-315a-4702-825e-c85f27bcddb2"))
            );

            // Output : randomType
            // Inputs : None
            BinaryConversionInfoBase.AddFixedSizeFieldDefinition(
                4,
                emitterBinary,
                SendModificationTypes.ModifiedDataOnly,
                null,
                new ConverterDefinition(typeof(DefaultConverter)),
                null
            );

            // Output : uvScale
            // Inputs : None
            BinaryConversionInfoBase.AddFixedSizeFieldDefinition(
                8,
                emitterBinary,
                SendModificationTypes.ModifiedDataOnly,
                null,
                new ConverterDefinition(typeof(DefaultConverter)),
                null
            );

            // Output : uvDiv
            // Inputs : PatternDivU, PatternDivV
            BinaryConversionInfoBase.AddBinaryFieldDefinition(
                emitterBinary,
                SendModificationTypes.ModifiedDataOnly,
                null,
                new ConverterDefinition(typeof(CompositionConverter),
                    new ConverterParam("ElementCount", 2),
                    new ConverterParam("ElementType", typeof(System.Single))),
                null,
                new InputPropertyDefinition("Textures.Texture2.EmitterTextureFileData.PatternDivU", new Guid("701302eb-69aa-4cc9-ad9a-7bb0e6ba98e7")),
                new InputPropertyDefinition("Textures.Texture2.EmitterTextureFileData.PatternDivV", new Guid("a8ffa8a2-3e3f-4059-a787-a63e1e2925a1"))
            );

            // Output : colorScale
            // Inputs : ColorScale
            BinaryConversionInfoBase.AddBinaryFieldDefinition(
                emitterBinary,
                SendModificationTypes.ModifiedDataOnly,
                null,
                new ConverterDefinition(typeof(DefaultConverter)),
                null,
                new InputPropertyDefinition("EmitterColorData.ParticleColor.EmitterColorCalculationData.ColorScale", new Guid("ce747b39-a8df-4d5b-a30f-b361c0d41125"))
            );

            // Output : reserved5
            // Inputs : None
            BinaryConversionInfoBase.AddFixedSizeFieldDefinition(
                12,
                emitterBinary,
                SendModificationTypes.ModifiedDataOnly,
                null,
                new ConverterDefinition(typeof(DefaultConverter)),
                null
            );

            // Output : color0Anim
            // Inputs : Color0BehaviorType, ColorAnimation0, RandomColor0
            BinaryConversionInfoBase.AddBinaryFieldDefinition(
                emitterBinary,
                SendModificationTypes.ModifiedDataOnly,
                null,
                new ConverterDefinition(typeof(ColorAnimationTableConverter),
                    new ConverterParam("MaxKeyFrameCount", 8)),
                null,
                new InputPropertyDefinition("EmitterColorData.ParticleColor.EmitterColorSettingsData.Color0BehaviorType", new Guid("3044c1e9-782d-4fa2-aa98-ffb8cc3c656f")),
                new InputPropertyDefinition("EmitterColorData.ParticleColor.EmitterColorSettingsData.ColorAnimation0", new Guid("c3ec057b-ef8d-44f9-9675-3b5383bb6acd")),
                new InputPropertyDefinition("EmitterColorData.ParticleColor.EmitterColorSettingsData.RandomColor0", new Guid("92953cca-f2d8-4289-97e6-23646e681827"))
            );

            // Output : alpha0Anim
            // Inputs : AlphaAnimation0
            BinaryConversionInfoBase.AddBinaryFieldDefinition(
                emitterBinary,
                SendModificationTypes.ModifiedDataOnly,
                null,
                new ConverterDefinition(typeof(AlphaAnimationTableConverter),
                    new ConverterParam("MaxKeyFrameCount", 8)),
                null,
                new InputPropertyDefinition("EmitterColorData.ParticleColor.EmitterColorSettingsData.AlphaAnimation0", new Guid("af62b763-00ec-4582-bbf3-99b06aacef10"))
            );

            // Output : color1Anim
            // Inputs : Color1BehaviorType, ColorAnimation1, RandomColor1
            BinaryConversionInfoBase.AddBinaryFieldDefinition(
                emitterBinary,
                SendModificationTypes.ModifiedDataOnly,
                null,
                new ConverterDefinition(typeof(ColorAnimationTableConverter),
                    new ConverterParam("MaxKeyFrameCount", 8)),
                null,
                new InputPropertyDefinition("EmitterColorData.ParticleColor.EmitterColorSettingsData.Color1BehaviorType", new Guid("47c9193c-6eb9-4aa9-9cec-eec7b8382e2b")),
                new InputPropertyDefinition("EmitterColorData.ParticleColor.EmitterColorSettingsData.ColorAnimation1", new Guid("0c155e74-73f4-46ba-aca7-0af4ef27320d")),
                new InputPropertyDefinition("EmitterColorData.ParticleColor.EmitterColorSettingsData.RandomColor1", new Guid("3bb877f8-9a60-4a72-af14-ccb8abac1cbf"))
            );

            // Output : alpha1Anim
            // Inputs : AlphaAnimation1
            BinaryConversionInfoBase.AddBinaryFieldDefinition(
                emitterBinary,
                SendModificationTypes.ModifiedDataOnly,
                null,
                new ConverterDefinition(typeof(AlphaAnimationTableConverter),
                    new ConverterParam("MaxKeyFrameCount", 8)),
                null,
                new InputPropertyDefinition("EmitterColorData.ParticleColor.EmitterColorSettingsData.AlphaAnimation1", new Guid("6d8a08e1-9624-48d3-b78e-27f95989a442"))
            );

            // Output : softEdgeParam
            // Inputs : AlphaFadeStartAlphaOffset, AlphaSamplingRadius
            BinaryConversionInfoBase.AddBinaryFieldDefinition(
                emitterBinary,
                SendModificationTypes.ModifiedDataOnly,
                null,
                new ConverterDefinition(typeof(CompositionConverter),
                    new ConverterParam("ElementCount", 2),
                    new ConverterParam("ElementType", typeof(System.Single))),
                null,
                new InputPropertyDefinition("EmitterColorData.ParticleColor.EmitterColorAlphaProcessData.AlphaFadeStartAlphaOffset", new Guid("d615208b-6018-4c43-b711-7291a51ab076")),
                new InputPropertyDefinition("EmitterColorData.ParticleColor.EmitterColorAlphaProcessData.AlphaSamplingRadius", new Guid("f0377134-a7a5-4011-a147-70d8615bc6ac"))
            );

            // Output : fresnelAlphaParam
            // Inputs : MinimumAlphaAngle, MaximumAlphaAngle
            BinaryConversionInfoBase.AddBinaryFieldDefinition(
                emitterBinary,
                SendModificationTypes.ModifiedDataOnly,
                null,
                new ConverterDefinition(typeof(CompositionConverter),
                    new ConverterParam("ElementCount", 2),
                    new ConverterParam("ElementType", typeof(System.Single))),
                null,
                new InputPropertyDefinition("EmitterColorData.ParticleColor.EmitterColorAlphaProcessData.MinimumAlphaAngle", new Guid("e6b78f19-334c-4be4-8c51-649848451d7c")),
                new InputPropertyDefinition("EmitterColorData.ParticleColor.EmitterColorAlphaProcessData.MaximumAlphaAngle", new Guid("819634d9-c4d2-4480-bcfb-88cd067dd793"))
            );

            // Output : nearDistAlphaParam
            // Inputs : NearAlphaZeroDistance, NearAlphaOneDistance
            BinaryConversionInfoBase.AddBinaryFieldDefinition(
                emitterBinary,
                SendModificationTypes.ModifiedDataOnly,
                null,
                new ConverterDefinition(typeof(CompositionConverter),
                    new ConverterParam("ElementCount", 2),
                    new ConverterParam("ElementType", typeof(System.Single))),
                null,
                new InputPropertyDefinition("EmitterColorData.ParticleColor.EmitterColorAlphaProcessData.NearAlphaZeroDistance", new Guid("7df2584c-81cc-414c-b06b-5636923e2ea5")),
                new InputPropertyDefinition("EmitterColorData.ParticleColor.EmitterColorAlphaProcessData.NearAlphaOneDistance", new Guid("6ca3ad32-92a0-4a52-b97e-49df6c567366"))
            );

            // Output : farDistAlphaParam
            // Inputs : FarAlphaOneDistance, FarAlphaZeroDistance
            BinaryConversionInfoBase.AddBinaryFieldDefinition(
                emitterBinary,
                SendModificationTypes.ModifiedDataOnly,
                null,
                new ConverterDefinition(typeof(CompositionConverter),
                    new ConverterParam("ElementCount", 2),
                    new ConverterParam("ElementType", typeof(System.Single))),
                null,
                new InputPropertyDefinition("EmitterColorData.ParticleColor.EmitterColorAlphaProcessData.FarAlphaOneDistance", new Guid("87e915b9-0eea-4809-8759-aa48f7d96841")),
                new InputPropertyDefinition("EmitterColorData.ParticleColor.EmitterColorAlphaProcessData.FarAlphaZeroDistance", new Guid("f98685c9-bf33-4d33-ba00-abd5251bbdd6"))
            );

            // Output : decalParam
            // Inputs : DecalAlphaOneDistance
            BinaryConversionInfoBase.AddBinaryFieldDefinition(
                emitterBinary,
                SendModificationTypes.ModifiedDataOnly,
                null,
                new ConverterDefinition(typeof(CompositionConverter),
                    new ConverterParam("ElementCount", 2),
                    new ConverterParam("ElementType", typeof(System.Single))),
                null,
                new InputPropertyDefinition("EmitterColorData.ParticleColor.EmitterColorAlphaProcessData.DecalAlphaOneDistance", new Guid("31158800-3fdb-466e-adbc-7226fdb3680d"))
            );

            // Output : alphaThreshold
            // Inputs : AlphaThreshold
            BinaryConversionInfoBase.AddBinaryFieldDefinition(
                emitterBinary,
                SendModificationTypes.ModifiedDataOnly,
                null,
                new ConverterDefinition(typeof(DefaultConverter)),
                null,
                new InputPropertyDefinition("EmitterBasicSettingData.EmitterBasicRenderData.AlphaThreshold", new Guid("91f1d241-6d43-4dc4-ba3d-de26c8898456"))
            );

            // Output : reserved6
            // Inputs : None
            BinaryConversionInfoBase.AddFixedSizeFieldDefinition(
                4,
                emitterBinary,
                SendModificationTypes.ModifiedDataOnly,
                null,
                new ConverterDefinition(typeof(DefaultConverter)),
                null
            );

            // Output : addVelToScale
            // Inputs : ScaleVelAddY
            BinaryConversionInfoBase.AddBinaryFieldDefinition(
                emitterBinary,
                SendModificationTypes.ModifiedDataOnly,
                null,
                new ConverterDefinition(typeof(DefaultConverter)),
                null,
                new InputPropertyDefinition("EmitterScaleData.EmitterScaleAnimationData.ScaleVelAddY", new Guid("3c003fd6-0c70-4ffc-b375-6888c1462e5e"))
            );

            // Output : softPartcileDist
            // Inputs : FeedStartDistance
            BinaryConversionInfoBase.AddBinaryFieldDefinition(
                emitterBinary,
                SendModificationTypes.ModifiedDataOnly,
                null,
                new ConverterDefinition(typeof(DefaultConverter)),
                null,
                new InputPropertyDefinition("EmitterColorData.ParticleColor.EmitterColorAlphaProcessData.FeedStartDistance", new Guid("181cd012-f007-4a39-8fac-a5c250acfe68"))
            );

            // Output : softParticleVolume
            // Inputs : VolumeValue
            BinaryConversionInfoBase.AddBinaryFieldDefinition(
                emitterBinary,
                SendModificationTypes.ModifiedDataOnly,
                null,
                new ConverterDefinition(typeof(DefaultConverter)),
                null,
                new InputPropertyDefinition("EmitterColorData.ParticleColor.EmitterColorAlphaProcessData.VolumeValue", new Guid("193bf19e-4d71-491e-baac-49765e023d26"))
            );

            // Output : reserved7
            // Inputs : None
            BinaryConversionInfoBase.AddFixedSizeFieldDefinition(
                4,
                emitterBinary,
                SendModificationTypes.ModifiedDataOnly,
                null,
                new ConverterDefinition(typeof(DefaultConverter)),
                null
            );

            // Output : scale8keyAnim
            // Inputs : AnimationTable
            BinaryConversionInfoBase.AddBinaryFieldDefinition(
                emitterBinary,
                SendModificationTypes.ModifiedDataOnly,
                null,
                new ConverterDefinition(typeof(AnimationTableConverter),
                    new ConverterParam("MaxKeyFrameCount", 8),
                    new ConverterParam("FrameConvertMode", 0)),
                null,
                new InputPropertyDefinition("EmitterScaleData.EmitterScaleAnimationCurveData.AnimationTable", new Guid("f655bd21-a7e6-45c4-998d-429c3ef2a2b0"))
            );

            // Output : shaderAnim
            // Inputs : ShaderType, CombinerEditorProjectPath, CoefficientAnimationTable, AnimationTable
            BinaryConversionInfoBase.AddBinaryFieldDefinition(
                emitterBinary,
                SendModificationTypes.ModifiedDataOnly,
                null,
                new ConverterDefinition(typeof(CombinerShaderAnimationTableConverter),
                    new ConverterParam("MaxKeyFrameCount", 8)),
                null,
                new InputPropertyDefinition("EmitterCombinerData.EmitterCombinerShaderData.ShaderType", new Guid("52df718b-e6e5-4ded-bcfa-53c84db9a3d0")),
                new InputPropertyDefinition("EmitterCombinerData.EmitterCombinerEditorData.CombinerEditorProjectPath", new Guid("c07be36b-2ce7-4ab5-b66d-bbfb169e6b45")),
                new InputPropertyDefinition("EmitterCombinerData.EmitterCombinerShaderData.CoefficientAnimationTable", new Guid("2d76c03e-1aad-4219-865b-4daaf18d6cbc")),
                new InputPropertyDefinition("EmitterCombinerData.EmitterCombinerEditorData.EmitterCombinerEditorAnimationCurveData0.AnimationTable", new Guid("f56be7de-c309-422d-988f-591004c2b353"))
            );

            // Output : rotateInit
            // Inputs : InitialRotation, InitialRotation, InitialRotation
            BinaryConversionInfoBase.AddBinaryFieldDefinition(
                emitterBinary,
                SendModificationTypes.ModifiedDataOnly,
                null,
                new ConverterDefinition(typeof(CompositionRadianConverter),
                    new ConverterParam("ElementCount", 4),
                    new ConverterParam("ElementType", typeof(System.Single))),
                null,
                new InputPropertyDefinition("EmitterRotationData.EmitterRotationXData.InitialRotation", new Guid("9652748f-cd87-409c-a2c5-5b8f265f8a8c")),
                new InputPropertyDefinition("EmitterRotationData.EmitterRotationYData.InitialRotation", new Guid("2c2a1be3-cad2-4ac7-bf79-06050964c05b")),
                new InputPropertyDefinition("EmitterRotationData.EmitterRotationZData.InitialRotation", new Guid("39fb86ff-8c37-4e03-a36c-cab1fd26803b"))
            );

            // Output : rotateInitRand
            // Inputs : InitialRotationRandom, InitialRotationRandom, InitialRotationRandom
            BinaryConversionInfoBase.AddBinaryFieldDefinition(
                emitterBinary,
                SendModificationTypes.ModifiedDataOnly,
                null,
                new ConverterDefinition(typeof(CompositionRadianConverter),
                    new ConverterParam("ElementCount", 4),
                    new ConverterParam("ElementType", typeof(System.Single))),
                null,
                new InputPropertyDefinition("EmitterRotationData.EmitterRotationXData.InitialRotationRandom", new Guid("aab40f58-4618-4fc0-8703-a306ac0c0c02")),
                new InputPropertyDefinition("EmitterRotationData.EmitterRotationYData.InitialRotationRandom", new Guid("1a226c00-d732-4313-b825-47671e8a04d0")),
                new InputPropertyDefinition("EmitterRotationData.EmitterRotationZData.InitialRotationRandom", new Guid("12783381-edfc-414e-afc9-32f87f0bc5da"))
            );

            // Output : rotateAdd
            // Inputs : RotationSpeed, RotationSpeed, RotationSpeed
            BinaryConversionInfoBase.AddBinaryFieldDefinition(
                emitterBinary,
                SendModificationTypes.ModifiedDataOnly,
                null,
                new ConverterDefinition(typeof(CompositionRadianConverter),
                    new ConverterParam("ElementCount", 3),
                    new ConverterParam("ElementType", typeof(System.Single))),
                null,
                new InputPropertyDefinition("EmitterRotationData.EmitterRotationXData.RotationSpeed", new Guid("a825d6e8-4462-49e5-a97c-34b4d40f629a")),
                new InputPropertyDefinition("EmitterRotationData.EmitterRotationYData.RotationSpeed", new Guid("cad0cd41-45ee-4f20-9823-79de97ff95c9")),
                new InputPropertyDefinition("EmitterRotationData.EmitterRotationZData.RotationSpeed", new Guid("fe6b5953-01f4-4883-9e66-aad447c1ce7f"))
            );

            // Output : rotateRegist
            // Inputs : RotationAttenuation
            BinaryConversionInfoBase.AddBinaryFieldDefinition(
                emitterBinary,
                SendModificationTypes.ModifiedDataOnly,
                null,
                new ConverterDefinition(typeof(DefaultConverter)),
                null,
                new InputPropertyDefinition("EmitterRotationData.EmitterRotationBasicData.RotationAttenuation", new Guid("687a7828-de71-4ef5-9b32-411c99068d24"))
            );

            // Output : rotateAddRand
            // Inputs : RotationSpeedRandom, RotationSpeedRandom, RotationSpeedRandom
            BinaryConversionInfoBase.AddBinaryFieldDefinition(
                emitterBinary,
                SendModificationTypes.ModifiedDataOnly,
                null,
                new ConverterDefinition(typeof(CompositionRadianConverter),
                    new ConverterParam("ElementCount", 3),
                    new ConverterParam("ElementType", typeof(System.Single))),
                null,
                new InputPropertyDefinition("EmitterRotationData.EmitterRotationXData.RotationSpeedRandom", new Guid("2b566c9e-f297-416c-bba7-8c9da04fa9ca")),
                new InputPropertyDefinition("EmitterRotationData.EmitterRotationYData.RotationSpeedRandom", new Guid("3691a4ea-fa0a-4257-8c39-da933701f0b2")),
                new InputPropertyDefinition("EmitterRotationData.EmitterRotationZData.RotationSpeedRandom", new Guid("846ff311-ffb4-4e32-be31-c5013aa46e3d"))
            );

            // Output : reserved8
            // Inputs : None
            BinaryConversionInfoBase.AddFixedSizeFieldDefinition(
                4,
                emitterBinary,
                SendModificationTypes.ModifiedDataOnly,
                null,
                new ConverterDefinition(typeof(DefaultConverter)),
                null
            );

            // Output : scaleLimitDistNear
            // Inputs : ScaleLimitDistNear
            BinaryConversionInfoBase.AddBinaryFieldDefinition(
                emitterBinary,
                SendModificationTypes.ModifiedDataOnly,
                null,
                new ConverterDefinition(typeof(DefaultConverter)),
                null,
                new InputPropertyDefinition("EmitterScaleData.EmitterScaleAnimationData.ScaleLimitDistNear", new Guid("d9a8b4b2-6f8a-4b5f-a1d9-297e4c9c50ac"))
            );

            // Output : scaleLimitDistFar
            // Inputs : ScaleLimitDistFar
            BinaryConversionInfoBase.AddBinaryFieldDefinition(
                emitterBinary,
                SendModificationTypes.ModifiedDataOnly,
                null,
                new ConverterDefinition(typeof(DefaultConverter)),
                null,
                new InputPropertyDefinition("EmitterScaleData.EmitterScaleAnimationData.ScaleLimitDistFar", new Guid("bb582107-852a-4eff-9d6b-8f1bf3d60899"))
            );

            // Output : reserved9
            // Inputs : None
            BinaryConversionInfoBase.AddFixedSizeFieldDefinition(
                8,
                emitterBinary,
                SendModificationTypes.ModifiedDataOnly,
                null,
                new ConverterDefinition(typeof(DefaultConverter)),
                null
            );

            // Output : isParticleDraw
            // Inputs : EnableDispParticle
            BinaryConversionInfoBase.AddBinaryFieldDefinition(
                emitterBinary,
                SendModificationTypes.ModifiedDataOnly,
                null,
                new ConverterDefinition(typeof(SwitchCaseConverter),
                    new ConverterParam("Cases", new SwitchCase[] { new SwitchCase(true, (byte)1) }),
                    new ConverterParam("DefaultOutput", (byte)0)),
                null,
                new InputPropertyDefinition("EmitterBasicSettingData.EmitterBasicRenderData.EnableDispParticle", new Guid("cc192167-b4d7-4ad6-9f58-49dc8b62b28a"))
            );

            // Output : sortType
            // Inputs : ParticleSortOrder
            BinaryConversionInfoBase.AddBinaryFieldDefinition(
                emitterBinary,
                SendModificationTypes.FullBinary,
                null,
                new ConverterDefinition(typeof(TypeConversionConverter),
                    new ConverterParam("TargetType", typeof(System.Byte))),
                null,
                new InputPropertyDefinition("EmitterBasicSettingData.EmitterBasicRenderData.ParticleSortOrder", new Guid("5f1daae5-157c-4931-a0f4-403dc805a19b"))
            );

            // Output : calcType
            // Inputs : ProcessType
            BinaryConversionInfoBase.AddBinaryFieldDefinition(
                emitterBinary,
                SendModificationTypes.ModifiedDataOnly,
                null,
                new ConverterDefinition(typeof(TypeConversionConverter),
                    new ConverterParam("TargetType", typeof(System.Byte))),
                null,
                new InputPropertyDefinition("EmitterBasicSettingData.EmitterBasicBasicData.ProcessType", new Guid("4e81e16e-9a7c-40a3-acae-ea1826075646"))
            );

            // Output : followType
            // Inputs : ParticleFollowType
            BinaryConversionInfoBase.AddBinaryFieldDefinition(
                emitterBinary,
                SendModificationTypes.FullBinary,
                null,
                new ConverterDefinition(typeof(TypeConversionConverter),
                    new ConverterParam("TargetType", typeof(System.Byte))),
                null,
                new InputPropertyDefinition("EmitterBasicSettingData.EmitterBasicBasicData.ParticleFollowType", new Guid("ad1366d9-3dba-4cb4-a8ed-8987929b4b5f"))
            );

            // Output : isFadeEmit
            // Inputs : EnableEndProcess
            BinaryConversionInfoBase.AddBinaryFieldDefinition(
                emitterBinary,
                SendModificationTypes.FullBinary,
                null,
                new ConverterDefinition(typeof(SwitchCaseConverter),
                    new ConverterParam("Cases", new SwitchCase[] { new SwitchCase(true, (byte)1) }),
                    new ConverterParam("DefaultOutput", (byte)0)),
                null,
                new InputPropertyDefinition("EmitterBasicSettingData.EmitterBasicBasicData.EnableEndProcess", new Guid("5376956e-e460-47dd-b9df-a6d805397fbb"))
            );

            // Output : isFadeAlphaFade
            // Inputs : EnableAlphaFade
            BinaryConversionInfoBase.AddBinaryFieldDefinition(
                emitterBinary,
                SendModificationTypes.FullBinary,
                null,
                new ConverterDefinition(typeof(SwitchCaseConverter),
                    new ConverterParam("Cases", new SwitchCase[] { new SwitchCase(true, (byte)1) }),
                    new ConverterParam("DefaultOutput", (byte)0)),
                null,
                new InputPropertyDefinition("EmitterBasicSettingData.EmitterBasicBasicData.EnableAlphaFade", new Guid("b6d5c6b5-e628-4763-b68f-9130fbddcf37"))
            );

            // Output : isScaleFade
            // Inputs : EnableScaleFade
            BinaryConversionInfoBase.AddBinaryFieldDefinition(
                emitterBinary,
                SendModificationTypes.FullBinary,
                null,
                new ConverterDefinition(typeof(SwitchCaseConverter),
                    new ConverterParam("Cases", new SwitchCase[] { new SwitchCase(true, (byte)1) }),
                    new ConverterParam("DefaultOutput", (byte)0)),
                null,
                new InputPropertyDefinition("EmitterBasicSettingData.EmitterBasicBasicData.EnableScaleFade", new Guid("b888fc78-253d-4300-8793-4ec7505385f5"))
            );

            // Output : randomSeedType
            // Inputs : RandomType
            BinaryConversionInfoBase.AddBinaryFieldDefinition(
                emitterBinary,
                SendModificationTypes.ModifiedWithReset,
                null,
                new ConverterDefinition(typeof(TypeConversionConverter),
                    new ConverterParam("TargetType", typeof(System.Byte))),
                null,
                new InputPropertyDefinition("EmitterBasicSettingData.EmitterBasicRandomData.RandomType", new Guid("078dae7d-c0b0-4301-b263-694c782a195f"))
            );

            // Output : isUpdateMatrixByEmit
            // Inputs : EnableUpdateRandom
            BinaryConversionInfoBase.AddBinaryFieldDefinition(
                emitterBinary,
                SendModificationTypes.ModifiedDataOnly,
                null,
                new ConverterDefinition(typeof(SwitchCaseConverter),
                    new ConverterParam("Cases", new SwitchCase[] { new SwitchCase(true, (byte)1) }),
                    new ConverterParam("DefaultOutput", (byte)0)),
                null,
                new InputPropertyDefinition("EmitterEmitterData.EmitterEmitterTransformData.EnableUpdateRandom", new Guid("ff7accd1-f169-44f7-abba-9ebc73cf5291"))
            );

            // Output : testAlways
            // Inputs : TestAlways
            BinaryConversionInfoBase.AddBinaryFieldDefinition(
                emitterBinary,
                SendModificationTypes.ModifiedDataOnly,
                null,
                new ConverterDefinition(typeof(SwitchCaseConverter),
                    new ConverterParam("Cases", new SwitchCase[] { new SwitchCase(true, (byte)1) }),
                    new ConverterParam("DefaultOutput", (byte)0)),
                null,
                new InputPropertyDefinition("EmitterBasicSettingData.EmitterBasicLodData.TestAlways", new Guid("90d7f38f-adda-49b9-94bc-3416f31627b0"))
            );

            // Output : interpolateEmissionAmount
            // Inputs : InterpolateEmissionAmount
            BinaryConversionInfoBase.AddBinaryFieldDefinition(
                emitterBinary,
                SendModificationTypes.ModifiedDataOnly,
                null,
                new ConverterDefinition(typeof(SwitchCaseConverter),
                    new ConverterParam("Cases", new SwitchCase[] { new SwitchCase(true, (byte)1) }),
                    new ConverterParam("DefaultOutput", (byte)0)),
                null,
                new InputPropertyDefinition("EmitterBasicSettingData.EmitterBasicLodData.InterpolateEmissionAmount", new Guid("8267f9d4-e5d1-48ab-8bb9-84b464909efe"))
            );

            // Output : isAlphaFadeIn
            // Inputs : EnableAlphaFadeIn
            BinaryConversionInfoBase.AddBinaryFieldDefinition(
                emitterBinary,
                SendModificationTypes.FullBinary,
                null,
                new ConverterDefinition(typeof(SwitchCaseConverter),
                    new ConverterParam("Cases", new SwitchCase[] { new SwitchCase(true, (byte)1) }),
                    new ConverterParam("DefaultOutput", (byte)0)),
                null,
                new InputPropertyDefinition("EmitterBasicSettingData.EmitterBasicBasicData.EnableAlphaFadeIn", new Guid("8535cabc-250a-4ec7-a919-61f500714728"))
            );

            // Output : isScaleFadeIn
            // Inputs : EnableScaleFadeIn
            BinaryConversionInfoBase.AddBinaryFieldDefinition(
                emitterBinary,
                SendModificationTypes.FullBinary,
                null,
                new ConverterDefinition(typeof(SwitchCaseConverter),
                    new ConverterParam("Cases", new SwitchCase[] { new SwitchCase(true, (byte)1) }),
                    new ConverterParam("DefaultOutput", (byte)0)),
                null,
                new InputPropertyDefinition("EmitterBasicSettingData.EmitterBasicBasicData.EnableScaleFadeIn", new Guid("173426e2-2363-4756-92b8-f081a4aae6b9"))
            );

            // Output : dummy
            // Inputs : None
            BinaryConversionInfoBase.AddFixedSizeFieldDefinition(
                3,
                emitterBinary,
                SendModificationTypes.ModifiedDataOnly,
                null,
                new ConverterDefinition(typeof(DefaultConverter)),
                null
            );

            // Output : randomSeed
            // Inputs : FixedRandomSeed
            BinaryConversionInfoBase.AddBinaryFieldDefinition(
                emitterBinary,
                SendModificationTypes.ModifiedWithReset,
                null,
                new ConverterDefinition(typeof(TypeConversionConverter),
                    new ConverterParam("TargetType", typeof(System.UInt32))),
                null,
                new InputPropertyDefinition("EmitterBasicSettingData.EmitterBasicRandomData.FixedRandomSeed", new Guid("7cf415c0-3e13-46b4-9a92-1e176d6cd758"))
            );

            // Output : drawPath
            // Inputs : DrawPath
            BinaryConversionInfoBase.AddBinaryFieldDefinition(
                emitterBinary,
                SendModificationTypes.FullBinary,
                null,
                new ConverterDefinition(typeof(TypeConversionConverter),
                    new ConverterParam("TargetType", typeof(System.UInt32))),
                null,
                new InputPropertyDefinition("EmitterBasicSettingData.EmitterBasicRenderData.DrawPath", new Guid("0899dfa3-117d-40b1-abc2-36ecf4f0ebc7"))
            );

            // Output : alphaFadeTime
            // Inputs : AlphaFadeTime
            BinaryConversionInfoBase.AddBinaryFieldDefinition(
                emitterBinary,
                SendModificationTypes.ModifiedDataOnly,
                null,
                new ConverterDefinition(typeof(DefaultConverter)),
                null,
                new InputPropertyDefinition("EmitterBasicSettingData.EmitterBasicBasicData.AlphaFadeTime", new Guid("bf9e6d74-7ef2-4bd6-91d0-9972a7abb46a"))
            );

            // Output : fadeInTime
            // Inputs : AlphaFadeInTime
            BinaryConversionInfoBase.AddBinaryFieldDefinition(
                emitterBinary,
                SendModificationTypes.ModifiedDataOnly,
                null,
                new ConverterDefinition(typeof(DefaultConverter)),
                null,
                new InputPropertyDefinition("EmitterBasicSettingData.EmitterBasicBasicData.AlphaFadeInTime", new Guid("b01f23b9-438b-49ca-bfc9-514457d4abc2"))
            );

            // Output : trans
            // Inputs : EmitterPosition
            BinaryConversionInfoBase.AddBinaryFieldDefinition(
                emitterBinary,
                SendModificationTypes.ModifiedDataOnly,
                null,
                new ConverterDefinition(typeof(DefaultConverter)),
                null,
                new InputPropertyDefinition("EmitterEmitterData.EmitterEmitterTransformData.EmitterPosition", new Guid("5d2e5c5a-f53d-46ea-b054-8f5cb0ff385b"))
            );

            // Output : transRand
            // Inputs : EmitterPositionRandom
            BinaryConversionInfoBase.AddBinaryFieldDefinition(
                emitterBinary,
                SendModificationTypes.ModifiedDataOnly,
                null,
                new ConverterDefinition(typeof(DefaultConverter)),
                null,
                new InputPropertyDefinition("EmitterEmitterData.EmitterEmitterTransformData.EmitterPositionRandom", new Guid("4151f056-901d-4bd7-9706-0ae225f56bae"))
            );

            // Output : rotate
            // Inputs : EmitterRotation
            BinaryConversionInfoBase.AddBinaryFieldDefinition(
                emitterBinary,
                SendModificationTypes.ModifiedDataOnly,
                null,
                new ConverterDefinition(typeof(RadianConverter)),
                null,
                new InputPropertyDefinition("EmitterEmitterData.EmitterEmitterTransformData.EmitterRotation", new Guid("d86d9d9f-557b-46ba-8cf7-ad9310a729db"))
            );

            // Output : rotateRand
            // Inputs : EmitterRotationRandom
            BinaryConversionInfoBase.AddBinaryFieldDefinition(
                emitterBinary,
                SendModificationTypes.ModifiedDataOnly,
                null,
                new ConverterDefinition(typeof(RadianConverter)),
                null,
                new InputPropertyDefinition("EmitterEmitterData.EmitterEmitterTransformData.EmitterRotationRandom", new Guid("5d025a7f-e72d-4d42-948e-0da466399311"))
            );

            // Output : scale
            // Inputs : EmitterScale
            BinaryConversionInfoBase.AddBinaryFieldDefinition(
                emitterBinary,
                SendModificationTypes.ModifiedDataOnly,
                null,
                new ConverterDefinition(typeof(DefaultConverter)),
                null,
                new InputPropertyDefinition("EmitterEmitterData.EmitterEmitterTransformData.EmitterScale", new Guid("fed24bcb-449a-49b8-9e75-5a7aca2da84a"))
            );

            // Output : color0
            // Inputs : Color0Value, Alpha0Value
            BinaryConversionInfoBase.AddBinaryFieldDefinition(
                emitterBinary,
                SendModificationTypes.ModifiedDataOnly,
                null,
                new ConverterDefinition(typeof(ColorSeparateAlphaToVec4Converter)),
                null,
                new InputPropertyDefinition("EmitterColorData.EmitterColor.Color0Value", new Guid("dd965a68-dd33-41d0-9808-d32a9da2a3ba")),
                new InputPropertyDefinition("EmitterColorData.EmitterColor.Alpha0Value", new Guid("b9097d11-888f-4abb-b5aa-e0a03a0a4627"))
            );

            // Output : color1
            // Inputs : Color1Value, Alpha1Value
            BinaryConversionInfoBase.AddBinaryFieldDefinition(
                emitterBinary,
                SendModificationTypes.ModifiedDataOnly,
                null,
                new ConverterDefinition(typeof(ColorSeparateAlphaToVec4Converter)),
                null,
                new InputPropertyDefinition("EmitterColorData.EmitterColor.Color1Value", new Guid("1fa01116-787c-499e-869e-67c429a036c6")),
                new InputPropertyDefinition("EmitterColorData.EmitterColor.Alpha1Value", new Guid("fd48afec-2c9b-4c94-a81c-d2e1f46dae48"))
            );

            // Output : emissionRangeNear
            // Inputs : EmissionRangeNear
            BinaryConversionInfoBase.AddBinaryFieldDefinition(
                emitterBinary,
                SendModificationTypes.ModifiedDataOnly,
                null,
                new ConverterDefinition(typeof(DefaultConverter)),
                null,
                new InputPropertyDefinition("EmitterBasicSettingData.EmitterBasicLodData.EmissionRangeNear", new Guid("4cf33665-6f80-469e-a217-ae555e287df9"))
            );

            // Output : emissionRangeFar
            // Inputs : EmissionRangeFar
            BinaryConversionInfoBase.AddBinaryFieldDefinition(
                emitterBinary,
                SendModificationTypes.ModifiedDataOnly,
                null,
                new ConverterDefinition(typeof(DefaultConverter)),
                null,
                new InputPropertyDefinition("EmitterBasicSettingData.EmitterBasicLodData.EmissionRangeFar", new Guid("eb544911-5c6d-492a-861d-1fe93ad0bb17"))
            );

            // Output : emissionRatioFar
            // Inputs : EmissionRatioFar
            BinaryConversionInfoBase.AddBinaryFieldDefinition(
                emitterBinary,
                SendModificationTypes.ModifiedDataOnly,
                null,
                new ConverterDefinition(typeof(DefaultConverter)),
                null,
                new InputPropertyDefinition("EmitterBasicSettingData.EmitterBasicLodData.EmissionRatioFar", new Guid("7c708af2-eb91-4e56-b70e-9d716bc66520"))
            );

            // Output : velocity
            // Inputs : EnableVelocity
            BinaryConversionInfoBase.AddBinaryFieldDefinition(
                emitterBinary,
                SendModificationTypes.ModifiedDataOnly,
                null,
                new ConverterDefinition(typeof(DefaultConverter)),
                null,
                new InputPropertyDefinition("EmitterBasicSettingData.EmitterBasicInheritanceData.EnableVelocity", new Guid("6f8e55da-ff39-40fa-894e-9080a3912f8d"))
            );

            // Output : scale
            // Inputs : EnableScale
            BinaryConversionInfoBase.AddBinaryFieldDefinition(
                emitterBinary,
                SendModificationTypes.ModifiedDataOnly,
                null,
                new ConverterDefinition(typeof(DefaultConverter)),
                null,
                new InputPropertyDefinition("EmitterBasicSettingData.EmitterBasicInheritanceData.EnableScale", new Guid("7cdf37c1-5e2e-4c36-ae68-894e2b1ece08"))
            );

            // Output : rotate
            // Inputs : EnableRotation
            BinaryConversionInfoBase.AddBinaryFieldDefinition(
                emitterBinary,
                SendModificationTypes.ModifiedDataOnly,
                null,
                new ConverterDefinition(typeof(DefaultConverter)),
                null,
                new InputPropertyDefinition("EmitterBasicSettingData.EmitterBasicInheritanceData.EnableRotation", new Guid("54f0bd8c-7e80-4b67-b484-2fc039a26423"))
            );

            // Output : colorScale
            // Inputs : EnableColorScale
            BinaryConversionInfoBase.AddBinaryFieldDefinition(
                emitterBinary,
                SendModificationTypes.ModifiedDataOnly,
                null,
                new ConverterDefinition(typeof(DefaultConverter)),
                null,
                new InputPropertyDefinition("EmitterBasicSettingData.EmitterBasicInheritanceData.EnableColorScale", new Guid("c0ecf499-bf5c-4a7e-bcc8-e1d6a21cec26"))
            );

            // Output : color0
            // Inputs : EnableColor0
            BinaryConversionInfoBase.AddBinaryFieldDefinition(
                emitterBinary,
                SendModificationTypes.ModifiedDataOnly,
                null,
                new ConverterDefinition(typeof(DefaultConverter)),
                null,
                new InputPropertyDefinition("EmitterBasicSettingData.EmitterBasicInheritanceData.EnableColor0", new Guid("46f13bc0-3915-46a9-8930-d0336331f8ad"))
            );

            // Output : color1
            // Inputs : EnableColor1
            BinaryConversionInfoBase.AddBinaryFieldDefinition(
                emitterBinary,
                SendModificationTypes.ModifiedDataOnly,
                null,
                new ConverterDefinition(typeof(DefaultConverter)),
                null,
                new InputPropertyDefinition("EmitterBasicSettingData.EmitterBasicInheritanceData.EnableColor1", new Guid("050a32cd-1ae3-4a47-936d-11efdf60603b"))
            );

            // Output : alpha0
            // Inputs : EnableAlpha0
            BinaryConversionInfoBase.AddBinaryFieldDefinition(
                emitterBinary,
                SendModificationTypes.ModifiedDataOnly,
                null,
                new ConverterDefinition(typeof(DefaultConverter)),
                null,
                new InputPropertyDefinition("EmitterBasicSettingData.EmitterBasicInheritanceData.EnableAlpha0", new Guid("31d8e7a9-ab26-4a79-8bc3-5112898d5a8c"))
            );

            // Output : alpha1
            // Inputs : EnableAlpha1
            BinaryConversionInfoBase.AddBinaryFieldDefinition(
                emitterBinary,
                SendModificationTypes.ModifiedDataOnly,
                null,
                new ConverterDefinition(typeof(DefaultConverter)),
                null,
                new InputPropertyDefinition("EmitterBasicSettingData.EmitterBasicInheritanceData.EnableAlpha1", new Guid("7d72c737-a69f-4d72-a557-1eb5b42ee750"))
            );

            // Output : drawPath
            // Inputs : EnableDrawPath
            BinaryConversionInfoBase.AddBinaryFieldDefinition(
                emitterBinary,
                SendModificationTypes.ModifiedDataOnly,
                null,
                new ConverterDefinition(typeof(DefaultConverter)),
                null,
                new InputPropertyDefinition("EmitterBasicSettingData.EmitterBasicInheritanceData.EnableDrawPath", new Guid("9d6ce869-a9be-4f9a-a139-f0fd5c3e3149"))
            );

            // Output : preDraw
            // Inputs : EnablePreDraw
            BinaryConversionInfoBase.AddBinaryFieldDefinition(
                emitterBinary,
                SendModificationTypes.ModifiedDataOnly,
                null,
                new ConverterDefinition(typeof(DefaultConverter)),
                null,
                new InputPropertyDefinition("EmitterBasicSettingData.EmitterBasicInheritanceData.EnablePreDraw", new Guid("4033fdb9-0ce6-484c-9502-390de423657a"))
            );

            // Output : alpha0EachFrame
            // Inputs : EnableAlpha0EachFrame
            BinaryConversionInfoBase.AddBinaryFieldDefinition(
                emitterBinary,
                SendModificationTypes.ModifiedDataOnly,
                null,
                new ConverterDefinition(typeof(DefaultConverter)),
                null,
                new InputPropertyDefinition("EmitterBasicSettingData.EmitterBasicInheritanceData.EnableAlpha0EachFrame", new Guid("edc8a80b-fabd-432a-835c-0047260eb647"))
            );

            // Output : alpha1EachFrame
            // Inputs : EnableAlpha1EachFrame
            BinaryConversionInfoBase.AddBinaryFieldDefinition(
                emitterBinary,
                SendModificationTypes.ModifiedDataOnly,
                null,
                new ConverterDefinition(typeof(DefaultConverter)),
                null,
                new InputPropertyDefinition("EmitterBasicSettingData.EmitterBasicInheritanceData.EnableAlpha1EachFrame", new Guid("85852330-c262-4a63-8c30-3ecb3b98f3c2"))
            );

            // Output : enableEmitterParticle
            // Inputs : EnableEmitterParticle
            BinaryConversionInfoBase.AddBinaryFieldDefinition(
                emitterBinary,
                SendModificationTypes.FullBinary,
                null,
                new ConverterDefinition(typeof(DefaultConverter)),
                null,
                new InputPropertyDefinition("EmitterBasicSettingData.EmitterBasicInheritanceData.EnableEmitterParticle", new Guid("0c9605b0-d082-4cde-b062-42a44ff982b9"))
            );

            // Output : reserved0
            // Inputs : None
            BinaryConversionInfoBase.AddFixedSizeFieldDefinition(
                3,
                emitterBinary,
                SendModificationTypes.ModifiedDataOnly,
                null,
                new ConverterDefinition(typeof(DefaultConverter)),
                null
            );

            // Output : velocityRate
            // Inputs : VelocityInheritanceRate
            BinaryConversionInfoBase.AddBinaryFieldDefinition(
                emitterBinary,
                SendModificationTypes.ModifiedDataOnly,
                null,
                new ConverterDefinition(typeof(DefaultConverter)),
                null,
                new InputPropertyDefinition("EmitterBasicSettingData.EmitterBasicInheritanceData.VelocityInheritanceRate", new Guid("8fe59739-2165-4a21-85b7-b76a6f819c7e"))
            );

            // Output : scaleRate
            // Inputs : ScaleInheritanceRate
            BinaryConversionInfoBase.AddBinaryFieldDefinition(
                emitterBinary,
                SendModificationTypes.ModifiedDataOnly,
                null,
                new ConverterDefinition(typeof(DefaultConverter)),
                null,
                new InputPropertyDefinition("EmitterBasicSettingData.EmitterBasicInheritanceData.ScaleInheritanceRate", new Guid("891a8c11-ec71-445e-adcf-4ccced4e507d"))
            );

            // Output : isOneTime
            // Inputs : EnableOnce
            BinaryConversionInfoBase.AddBinaryFieldDefinition(
                emitterBinary,
                SendModificationTypes.FullBinary,
                null,
                new ConverterDefinition(typeof(SwitchCaseConverter),
                    new ConverterParam("Cases", new SwitchCase[] { new SwitchCase(true, (byte)1) }),
                    new ConverterParam("DefaultOutput", (byte)0)),
                null,
                new InputPropertyDefinition("EmitterEmissionData.EmitterEmissionTimingData.EnableOnce", new Guid("1b04f515-a95c-479f-9177-0d93bcdd3d22"))
            );

            // Output : isWorldGravity
            // Inputs : EnableWorldCoordinate
            BinaryConversionInfoBase.AddBinaryFieldDefinition(
                emitterBinary,
                SendModificationTypes.FullBinary,
                null,
                new ConverterDefinition(typeof(SwitchCaseConverter),
                    new ConverterParam("Cases", new SwitchCase[] { new SwitchCase(true, (byte)1) }),
                    new ConverterParam("DefaultOutput", (byte)0)),
                null,
                new InputPropertyDefinition("EmitterEmissionData.EmitterEmissionGravityData.EnableWorldCoordinate", new Guid("57ba2be1-c49d-4121-9658-b7f0c2f2d6fc"))
            );

            // Output : isEmitDistEnabled
            // Inputs : EmitDistUnitType
            BinaryConversionInfoBase.AddBinaryFieldDefinition(
                emitterBinary,
                SendModificationTypes.FullBinary,
                null,
                new ConverterDefinition(typeof(TypeConversionConverter),
                    new ConverterParam("TargetType", typeof(System.Byte))),
                null,
                new InputPropertyDefinition("EmitterEmissionData.EmitterEmissionTimingData.EmitDistUnitType", new Guid("822ff6b1-1b69-4bbc-b648-12fcd423157b"))
            );

            // Output : isWorldOrientedVelocity
            // Inputs : EnableOrientedVelocityOnWorldCoordinate
            BinaryConversionInfoBase.AddBinaryFieldDefinition(
                emitterBinary,
                SendModificationTypes.ModifiedDataOnly,
                null,
                new ConverterDefinition(typeof(SwitchCaseConverter),
                    new ConverterParam("Cases", new SwitchCase[] { new SwitchCase(true, (byte)1) })),
                null,
                new InputPropertyDefinition("EmitterEmissionData.EmitterEmissionVelocityData.EnableOrientedVelocityOnWorldCoordinate", new Guid("34679dda-0d5b-49df-9b07-e31b9d743194"))
            );

            // Output : start
            // Inputs : EmitStartFrame
            BinaryConversionInfoBase.AddBinaryFieldDefinition(
                emitterBinary,
                SendModificationTypes.ModifiedWithReset,
                null,
                new ConverterDefinition(typeof(DefaultConverter)),
                null,
                new InputPropertyDefinition("EmitterEmissionData.EmitterEmissionTimingData.EmitStartFrame", new Guid("34d20b2b-a524-48d7-8c56-05f14355f8b2"))
            );

            // Output : emitTiming
            // Inputs : EmitTimingRate
            BinaryConversionInfoBase.AddBinaryFieldDefinition(
                emitterBinary,
                SendModificationTypes.ModifiedWithReset,
                null,
                new ConverterDefinition(typeof(DefaultConverter)),
                null,
                new InputPropertyDefinition("EmitterEmissionData.EmitterEmissionTimingData.EmitTimingRate", new Guid("819e4495-0bce-404e-a363-a2461a30cade"))
            );

            // Output : emitDuration
            // Inputs : EmitDuration
            BinaryConversionInfoBase.AddBinaryFieldDefinition(
                emitterBinary,
                SendModificationTypes.ModifiedWithReset,
                null,
                new ConverterDefinition(typeof(DefaultConverter)),
                null,
                new InputPropertyDefinition("EmitterEmissionData.EmitterEmissionTimingData.EmitDuration", new Guid("52232b57-d9bc-4367-aaf2-4b69b0e6ffa8"))
            );

            // Output : rate
            // Inputs : EmitTimeEmissionRate
            BinaryConversionInfoBase.AddBinaryFieldDefinition(
                emitterBinary,
                SendModificationTypes.ModifiedWithReset,
                null,
                new ConverterDefinition(typeof(DefaultConverter)),
                null,
                new InputPropertyDefinition("EmitterEmissionData.EmitterEmissionTimingData.EmitTimeEmissionRate", new Guid("7875e582-f633-4061-a109-b28b00a52be2"))
            );

            // Output : rateRandom
            // Inputs : EmitTimeEmissionRateRandom
            BinaryConversionInfoBase.AddBinaryFieldDefinition(
                emitterBinary,
                SendModificationTypes.ModifiedWithReset,
                null,
                new ConverterDefinition(typeof(DefaultConverter)),
                null,
                new InputPropertyDefinition("EmitterEmissionData.EmitterEmissionTimingData.EmitTimeEmissionRateRandom", new Guid("34459cdc-eac8-42e5-8d7c-fe05826a4422"))
            );

            // Output : interval
            // Inputs : EmitTimeDistUnit
            BinaryConversionInfoBase.AddBinaryFieldDefinition(
                emitterBinary,
                SendModificationTypes.ModifiedWithReset,
                null,
                new ConverterDefinition(typeof(ValueAdditionConverter),
                    new ConverterParam("Additional", -1)),
                null,
                new InputPropertyDefinition("EmitterEmissionData.EmitterEmissionTimingData.EmitTimeDistUnit", new Guid("b9760e3f-96aa-406c-9f2a-65e4a3af6673"))
            );

            // Output : intervalRandom
            // Inputs : EmitTimeDistUnitRandom
            BinaryConversionInfoBase.AddBinaryFieldDefinition(
                emitterBinary,
                SendModificationTypes.ModifiedWithReset,
                null,
                new ConverterDefinition(typeof(DefaultConverter)),
                null,
                new InputPropertyDefinition("EmitterEmissionData.EmitterEmissionTimingData.EmitTimeDistUnitRandom", new Guid("32515364-df87-40e2-8ca8-b0e39a28992f"))
            );

            // Output : posRand
            // Inputs : RandomPosition
            BinaryConversionInfoBase.AddBinaryFieldDefinition(
                emitterBinary,
                SendModificationTypes.ModifiedDataOnly,
                null,
                new ConverterDefinition(typeof(DefaultConverter)),
                null,
                new InputPropertyDefinition("EmitterEmitterData.EmitterEmitterShapeData.RandomPosition", new Guid("204b115b-2dd2-4c23-9734-332526256643"))
            );

            // Output : gravityScale
            // Inputs : GravityVolume
            BinaryConversionInfoBase.AddBinaryFieldDefinition(
                emitterBinary,
                SendModificationTypes.ModifiedDataOnly,
                null,
                new ConverterDefinition(typeof(ValueScalingConverter),
                    new ConverterParam("Scale", 0.01)),
                null,
                new InputPropertyDefinition("EmitterEmissionData.EmitterEmissionGravityData.GravityVolume", new Guid("fd6cf51f-3d47-41ae-ab8e-f0bf1b1760ca"))
            );

            // Output : gravityDir
            // Inputs : GravityDir
            BinaryConversionInfoBase.AddBinaryFieldDefinition(
                emitterBinary,
                SendModificationTypes.ModifiedDataOnly,
                null,
                new ConverterDefinition(typeof(DefaultConverter)),
                null,
                new InputPropertyDefinition("EmitterEmissionData.EmitterEmissionGravityData.GravityDir", new Guid("c15a47b8-3599-43c5-9972-9b03a4379851"))
            );

            // Output : emitDistUnit
            // Inputs : EmitDistDistUnit
            BinaryConversionInfoBase.AddBinaryFieldDefinition(
                emitterBinary,
                SendModificationTypes.ModifiedDataOnly,
                null,
                new ConverterDefinition(typeof(DefaultConverter)),
                null,
                new InputPropertyDefinition("EmitterEmissionData.EmitterEmissionTimingData.EmitDistDistUnit", new Guid("b0350656-1910-4ce7-bc9f-cff94a80d61a"))
            );

            // Output : emitDistMin
            // Inputs : EmitDistMinDistPerFrame
            BinaryConversionInfoBase.AddBinaryFieldDefinition(
                emitterBinary,
                SendModificationTypes.ModifiedDataOnly,
                null,
                new ConverterDefinition(typeof(DefaultConverter)),
                null,
                new InputPropertyDefinition("EmitterEmissionData.EmitterEmissionTimingData.EmitDistMinDistPerFrame", new Guid("7e946152-862a-4acd-92c5-6f7f0c4a1458"))
            );

            // Output : emitDistMax
            // Inputs : EmitDistMaxDistPerFrame
            BinaryConversionInfoBase.AddBinaryFieldDefinition(
                emitterBinary,
                SendModificationTypes.ModifiedDataOnly,
                null,
                new ConverterDefinition(typeof(DefaultConverter)),
                null,
                new InputPropertyDefinition("EmitterEmissionData.EmitterEmissionTimingData.EmitDistMaxDistPerFrame", new Guid("1d424ed1-3827-46ac-ab3a-84cbebf0d139"))
            );

            // Output : emitDistMargin
            // Inputs : EmitDistMargin
            BinaryConversionInfoBase.AddBinaryFieldDefinition(
                emitterBinary,
                SendModificationTypes.ModifiedDataOnly,
                null,
                new ConverterDefinition(typeof(DefaultConverter)),
                null,
                new InputPropertyDefinition("EmitterEmissionData.EmitterEmissionTimingData.EmitDistMargin", new Guid("c336e42f-e73e-464b-a323-25b4698b82eb"))
            );

            // Output : emitDistParticleMax
            // Inputs : EmitDistParticleMax
            BinaryConversionInfoBase.AddBinaryFieldDefinition(
                emitterBinary,
                SendModificationTypes.ModifiedWithReset,
                null,
                new ConverterDefinition(typeof(DefaultConverter)),
                null,
                new InputPropertyDefinition("EmitterEmissionData.EmitterEmissionTimingData.EmitDistParticleMax", new Guid("531bb35e-22e9-475d-bcab-1f39012c8edc"))
            );

            // Output : volumeType
            // Inputs : EmitterType
            BinaryConversionInfoBase.AddBinaryFieldDefinition(
                emitterBinary,
                SendModificationTypes.FullBinary,
                null,
                new ConverterDefinition(typeof(TypeConversionConverter),
                    new ConverterParam("TargetType", typeof(System.Byte))),
                null,
                new InputPropertyDefinition("EmitterEmitterData.EmitterEmitterShapeData.EmitterType", new Guid("57060530-1832-4606-99e3-04b0397a4b62"))
            );

            // Output : sweepStartRandom
            // Inputs : EmitterShapeStartArcRandom
            BinaryConversionInfoBase.AddBinaryFieldDefinition(
                emitterBinary,
                SendModificationTypes.ModifiedDataOnly,
                null,
                new ConverterDefinition(typeof(SwitchCaseConverter),
                    new ConverterParam("Cases", new SwitchCase[] { new SwitchCase(true, (byte)1) }),
                    new ConverterParam("DefaultOutput", (byte)0)),
                null,
                new InputPropertyDefinition("EmitterEmitterData.EmitterEmitterShapeData.EmitterShapeStartArcRandom", new Guid("39dfe493-c5ea-483b-88e0-858265c9025e"))
            );

            // Output : arcType
            // Inputs : EmitterShapeArcType
            BinaryConversionInfoBase.AddBinaryFieldDefinition(
                emitterBinary,
                SendModificationTypes.ModifiedDataOnly,
                null,
                new ConverterDefinition(typeof(TypeConversionConverter),
                    new ConverterParam("TargetType", typeof(System.Byte))),
                null,
                new InputPropertyDefinition("EmitterEmitterData.EmitterEmitterShapeData.EmitterShapeArcType", new Guid("b56dbaf4-ec97-47c9-b829-3e1153df2e91"))
            );

            // Output : isVolumeLatitudeEnabled
            // Inputs : None
            BinaryConversionInfoBase.AddFixedSizeFieldDefinition(
                1,
                emitterBinary,
                SendModificationTypes.ModifiedDataOnly,
                null,
                new ConverterDefinition(typeof(DefaultConverter)),
                null
            );

            // Output : volumeTblIndex
            // Inputs : EmitterShapeSphereAndDivisionDivision
            BinaryConversionInfoBase.AddBinaryFieldDefinition(
                emitterBinary,
                SendModificationTypes.ModifiedDataOnly,
                null,
                new ConverterDefinition(typeof(TypeConversionConverter),
                    new ConverterParam("TargetType", typeof(System.Byte))),
                null,
                new InputPropertyDefinition("EmitterEmitterData.EmitterEmitterShapeData.EmitterShapeSphereAndDivisionDivision", new Guid("8a095826-5248-440b-aadd-2364376b4913"))
            );

            // Output : volumeTblIndex64
            // Inputs : EmitterShapeSphereAndDivision64Division
            BinaryConversionInfoBase.AddBinaryFieldDefinition(
                emitterBinary,
                SendModificationTypes.ModifiedDataOnly,
                null,
                new ConverterDefinition(typeof(TypeConversionConverter),
                    new ConverterParam("TargetType", typeof(System.Byte))),
                null,
                new InputPropertyDefinition("EmitterEmitterData.EmitterEmitterShapeData.EmitterShapeSphereAndDivision64Division", new Guid("0ebecd54-c857-4e56-9dee-da2ad13539a2"))
            );

            // Output : volumeLatitudeDir
            // Inputs : EmitterShapeSphereAxis
            BinaryConversionInfoBase.AddBinaryFieldDefinition(
                emitterBinary,
                SendModificationTypes.ModifiedDataOnly,
                null,
                new ConverterDefinition(typeof(TypeConversionConverter),
                    new ConverterParam("TargetType", typeof(System.Byte))),
                null,
                new InputPropertyDefinition("EmitterEmitterData.EmitterEmitterShapeData.EmitterShapeSphereAxis", new Guid("6e39450e-7854-4754-bb8f-8395123ee931"))
            );

            // Output : isGpuEmitter
            // Inputs : ProcessType
            BinaryConversionInfoBase.AddBinaryFieldDefinition(
                emitterBinary,
                SendModificationTypes.FullBinary,
                null,
                new ConverterDefinition(typeof(TypeConversionConverter),
                    new ConverterParam("TargetType", typeof(System.Byte))),
                null,
                new InputPropertyDefinition("EmitterBasicSettingData.EmitterBasicBasicData.ProcessType", new Guid("4e81e16e-9a7c-40a3-acae-ea1826075646"))
            );

            // Output : sweepLongitude
            // Inputs : EmitterShapeLongitudeArcLength
            BinaryConversionInfoBase.AddBinaryFieldDefinition(
                emitterBinary,
                SendModificationTypes.ModifiedDataOnly,
                null,
                new ConverterDefinition(typeof(RadianConverter)),
                null,
                new InputPropertyDefinition("EmitterEmitterData.EmitterEmitterShapeData.EmitterShapeLongitudeArcLength", new Guid("fb5cca22-e58c-467a-bbd1-51b11527c209"))
            );

            // Output : sweepLatitude
            // Inputs : EmitterShapeLatitudeArcLength
            BinaryConversionInfoBase.AddBinaryFieldDefinition(
                emitterBinary,
                SendModificationTypes.ModifiedDataOnly,
                null,
                new ConverterDefinition(typeof(RadianConverter)),
                null,
                new InputPropertyDefinition("EmitterEmitterData.EmitterEmitterShapeData.EmitterShapeLatitudeArcLength", new Guid("c835f0b0-d3cf-4cea-bb9c-05cc811b684a"))
            );

            // Output : sweepStart
            // Inputs : EmitterShapeStartArc
            BinaryConversionInfoBase.AddBinaryFieldDefinition(
                emitterBinary,
                SendModificationTypes.ModifiedDataOnly,
                null,
                new ConverterDefinition(typeof(RadianConverter)),
                null,
                new InputPropertyDefinition("EmitterEmitterData.EmitterEmitterShapeData.EmitterShapeStartArc", new Guid("6ec1c64a-9826-4c6e-a452-4148ad9666ef"))
            );

            // Output : volumeSurfacePosRand
            // Inputs : EmitterShapeRandomPos
            BinaryConversionInfoBase.AddBinaryFieldDefinition(
                emitterBinary,
                SendModificationTypes.ModifiedDataOnly,
                null,
                new ConverterDefinition(typeof(RadianConverter)),
                null,
                new InputPropertyDefinition("EmitterEmitterData.EmitterEmitterShapeData.EmitterShapeRandomPos", new Guid("5adf3683-3bea-4b37-b26c-0f58f7072d9b"))
            );

            // Output : caliberRatio
            // Inputs : EmitterShapeHollowRatio
            BinaryConversionInfoBase.AddBinaryFieldDefinition(
                emitterBinary,
                SendModificationTypes.ModifiedDataOnly,
                null,
                new ConverterDefinition(typeof(ValueExpressionConverter),
                    new ConverterParam("Expression", "(100 - {0}) / 100")),
                null,
                new InputPropertyDefinition("EmitterEmitterData.EmitterEmitterShapeData.EmitterShapeHollowRatio", new Guid("8a403650-39a9-4de6-aa46-9b82f608f90f"))
            );

            // Output : lineCenter
            // Inputs : EmitterShapeLineCenter
            BinaryConversionInfoBase.AddBinaryFieldDefinition(
                emitterBinary,
                SendModificationTypes.ModifiedDataOnly,
                null,
                new ConverterDefinition(typeof(DefaultConverter)),
                null,
                new InputPropertyDefinition("EmitterEmitterData.EmitterEmitterShapeData.EmitterShapeLineCenter", new Guid("96268159-7be2-448b-ad48-8dd00defe4ce"))
            );

            // Output : lineLength
            // Inputs : EmitterShapeLineLength
            BinaryConversionInfoBase.AddBinaryFieldDefinition(
                emitterBinary,
                SendModificationTypes.ModifiedDataOnly,
                null,
                new ConverterDefinition(typeof(DefaultConverter)),
                null,
                new InputPropertyDefinition("EmitterEmitterData.EmitterEmitterShapeData.EmitterShapeLineLength", new Guid("e3ed7182-a103-4b2f-9c5c-bb4b378bad30"))
            );

            // Output : volumeRadius
            // Inputs : EmitterTypeEmitterRadius
            BinaryConversionInfoBase.AddBinaryFieldDefinition(
                emitterBinary,
                SendModificationTypes.ModifiedDataOnly,
                null,
                new ConverterDefinition(typeof(DefaultConverter)),
                null,
                new InputPropertyDefinition("EmitterEmitterData.EmitterEmitterShapeData.EmitterTypeEmitterRadius", new Guid("b52fbefd-d776-48d1-8f3a-2a443c53a305"))
            );

            // Output : volumeFormScale
            // Inputs : EmitterScaleShapeScale
            BinaryConversionInfoBase.AddBinaryFieldDefinition(
                emitterBinary,
                SendModificationTypes.ModifiedDataOnly,
                null,
                new ConverterDefinition(typeof(DefaultConverter)),
                null,
                new InputPropertyDefinition("EmitterEmitterData.EmitterEmitterShapeData.EmitterScaleShapeScale", new Guid("3b128820-5139-4f0d-8117-d0d5f01b8bb7"))
            );

            // Output : primEmitType
            // Inputs : EmitterShapeEmissionType
            BinaryConversionInfoBase.AddBinaryFieldDefinition(
                emitterBinary,
                SendModificationTypes.FullBinary,
                null,
                new ConverterDefinition(typeof(DefaultConverter)),
                null,
                new InputPropertyDefinition("EmitterEmitterData.EmitterEmitterShapeData.EmitterShapeEmissionType", new Guid("4eb1daff-7e94-48b6-a65e-dd8f2b8c4d25"))
            );

            // Output : primitiveIndex
            // Inputs : PrimitiveFilePath, EmitterType
            BinaryConversionInfoBase.AddBinaryFieldDefinition(
                emitterBinary,
                SendModificationTypes.FullBinary,
                null,
                new ConverterDefinition(typeof(PrimitiveIDConverter),
                    new ConverterParam("ValidId", 15)),
                null,
                new InputPropertyDefinition("EmitterEmitterData.EmitterEmitterShapeData.PrimitiveFilePath", new Guid("d22026c5-73ff-427d-99e2-cb8a17496747")),
                new InputPropertyDefinition("EmitterEmitterData.EmitterEmitterShapeData.EmitterType", new Guid("57060530-1832-4606-99e3-04b0397a4b62"))
            );

            // Output : numDivideCircle
            // Inputs : EmitterShapeCircleDivision
            BinaryConversionInfoBase.AddBinaryFieldDefinition(
                emitterBinary,
                SendModificationTypes.ModifiedDataOnly,
                null,
                new ConverterDefinition(typeof(DefaultConverter)),
                null,
                new InputPropertyDefinition("EmitterEmitterData.EmitterEmitterShapeData.EmitterShapeCircleDivision", new Guid("32e764c6-f8cb-4ac3-ae73-31ab0f421e7f"))
            );

            // Output : numDivideCircleRandom
            // Inputs : EmitterShapeCircleDivisionRandom
            BinaryConversionInfoBase.AddBinaryFieldDefinition(
                emitterBinary,
                SendModificationTypes.ModifiedDataOnly,
                null,
                new ConverterDefinition(typeof(DefaultConverter)),
                null,
                new InputPropertyDefinition("EmitterEmitterData.EmitterEmitterShapeData.EmitterShapeCircleDivisionRandom", new Guid("8a412eff-dce2-4d80-8af7-907cfad2e054"))
            );

            // Output : numDivideLine
            // Inputs : EmitterShapeLineDivision
            BinaryConversionInfoBase.AddBinaryFieldDefinition(
                emitterBinary,
                SendModificationTypes.ModifiedDataOnly,
                null,
                new ConverterDefinition(typeof(DefaultConverter)),
                null,
                new InputPropertyDefinition("EmitterEmitterData.EmitterEmitterShapeData.EmitterShapeLineDivision", new Guid("db6cdfad-11b4-4112-82c3-533062f719db"))
            );

            // Output : numDivideLineRandom
            // Inputs : EmitterShapeLineDivisionRandom
            BinaryConversionInfoBase.AddBinaryFieldDefinition(
                emitterBinary,
                SendModificationTypes.ModifiedDataOnly,
                null,
                new ConverterDefinition(typeof(DefaultConverter)),
                null,
                new InputPropertyDefinition("EmitterEmitterData.EmitterEmitterShapeData.EmitterShapeLineDivisionRandom", new Guid("c4877566-8ce6-45ea-b599-fa94b1fecd9a"))
            );

            // Output : isOnAnotherBinaryVolumePrimitive
            // Inputs : PrimitiveFilePath
            BinaryConversionInfoBase.AddBinaryFieldDefinition(
                emitterBinary,
                SendModificationTypes.ModifiedDataOnly,
                null,
                new ConverterDefinition(typeof(PrimitiveLocationConverter)),
                null,
                new InputPropertyDefinition("EmitterEmitterData.EmitterEmitterShapeData.PrimitiveFilePath", new Guid("d22026c5-73ff-427d-99e2-cb8a17496747"))
            );

            // Output : reserved0
            // Inputs : None
            BinaryConversionInfoBase.AddFixedSizeFieldDefinition(
                7,
                emitterBinary,
                SendModificationTypes.ModifiedDataOnly,
                null,
                new ConverterDefinition(typeof(DefaultConverter)),
                null
            );

            // Output : isBlendEnable
            // Inputs : IsBlendEnable
            BinaryConversionInfoBase.AddBinaryFieldDefinition(
                emitterBinary,
                SendModificationTypes.ModifiedDataOnly,
                null,
                new ConverterDefinition(typeof(SwitchCaseConverter),
                    new ConverterParam("Cases", new SwitchCase[] { new SwitchCase(true, (byte)1) }),
                    new ConverterParam("DefaultOutput", (byte)0)),
                null,
                new InputPropertyDefinition("EmitterBasicSettingData.EmitterBasicRenderData.IsBlendEnable", new Guid("3ebb4e3e-7cb3-4fa4-ba31-0bd23f7e11ce"))
            );

            // Output : isDepthTest
            // Inputs : IsDepthTest
            BinaryConversionInfoBase.AddBinaryFieldDefinition(
                emitterBinary,
                SendModificationTypes.ModifiedDataOnly,
                null,
                new ConverterDefinition(typeof(SwitchCaseConverter),
                    new ConverterParam("Cases", new SwitchCase[] { new SwitchCase(true, (byte)1) }),
                    new ConverterParam("DefaultOutput", (byte)0)),
                null,
                new InputPropertyDefinition("EmitterBasicSettingData.EmitterBasicRenderData.IsDepthTest", new Guid("5f819ccd-53f0-49db-a226-1de7814ae4a3"))
            );

            // Output : depthFunc
            // Inputs : DepthFunc
            BinaryConversionInfoBase.AddBinaryFieldDefinition(
                emitterBinary,
                SendModificationTypes.ModifiedDataOnly,
                null,
                new ConverterDefinition(typeof(TypeConversionConverter),
                    new ConverterParam("TargetType", typeof(System.Byte))),
                null,
                new InputPropertyDefinition("EmitterBasicSettingData.EmitterBasicRenderData.DepthFunc", new Guid("63ffb885-c7c0-4675-9dbb-8a8113ffa2fb"))
            );

            // Output : isDepthMask
            // Inputs : IsDepthMask
            BinaryConversionInfoBase.AddBinaryFieldDefinition(
                emitterBinary,
                SendModificationTypes.ModifiedWithReset,
                null,
                new ConverterDefinition(typeof(SwitchCaseConverter),
                    new ConverterParam("Cases", new SwitchCase[] { new SwitchCase(true, (byte)1) }),
                    new ConverterParam("DefaultOutput", (byte)0)),
                null,
                new InputPropertyDefinition("EmitterBasicSettingData.EmitterBasicRenderData.IsDepthMask", new Guid("8d5fcf70-92d3-4edf-a78a-aaffcb0d60a8"))
            );

            // Output : isAlphaTest
            // Inputs : IsAlphaTest
            BinaryConversionInfoBase.AddBinaryFieldDefinition(
                emitterBinary,
                SendModificationTypes.FullBinary,
                null,
                new ConverterDefinition(typeof(SwitchCaseConverter),
                    new ConverterParam("Cases", new SwitchCase[] { new SwitchCase(true, (byte)1) }),
                    new ConverterParam("DefaultOutput", (byte)0)),
                null,
                new InputPropertyDefinition("EmitterBasicSettingData.EmitterBasicRenderData.IsAlphaTest", new Guid("d11c48cf-20ca-4bd6-a082-f287936d16d1"))
            );

            // Output : alphaFunc
            // Inputs : AlphaFunc
            BinaryConversionInfoBase.AddBinaryFieldDefinition(
                emitterBinary,
                SendModificationTypes.FullBinary,
                null,
                new ConverterDefinition(typeof(TypeConversionConverter),
                    new ConverterParam("TargetType", typeof(System.Byte))),
                null,
                new InputPropertyDefinition("EmitterBasicSettingData.EmitterBasicRenderData.AlphaFunc", new Guid("e151ea35-f10f-42d0-bd93-48bec4d202fa"))
            );

            // Output : blendType
            // Inputs : BlendType
            BinaryConversionInfoBase.AddBinaryFieldDefinition(
                emitterBinary,
                SendModificationTypes.ModifiedDataOnly,
                null,
                new ConverterDefinition(typeof(TypeConversionConverter),
                    new ConverterParam("TargetType", typeof(System.Byte))),
                null,
                new InputPropertyDefinition("EmitterBasicSettingData.EmitterBasicRenderData.BlendType", new Guid("54a85cdf-eb38-4a82-a483-a5c6579cdcb6"))
            );

            // Output : displaySide
            // Inputs : DisplaySurface
            BinaryConversionInfoBase.AddBinaryFieldDefinition(
                emitterBinary,
                SendModificationTypes.ModifiedDataOnly,
                null,
                new ConverterDefinition(typeof(TypeConversionConverter),
                    new ConverterParam("TargetType", typeof(System.Byte))),
                null,
                new InputPropertyDefinition("EmitterBasicSettingData.EmitterBasicRenderData.DisplaySurface", new Guid("0ab41910-8daa-4a2e-8cf4-b687ae4ace31"))
            );

            // Output : alphaThreshold
            // Inputs : AlphaThreshold
            BinaryConversionInfoBase.AddBinaryFieldDefinition(
                emitterBinary,
                SendModificationTypes.FullBinary,
                null,
                new ConverterDefinition(typeof(DefaultConverter)),
                null,
                new InputPropertyDefinition("EmitterBasicSettingData.EmitterBasicRenderData.AlphaThreshold", new Guid("91f1d241-6d43-4dc4-ba3d-de26c8898456"))
            );

            // Output : reserved0
            // Inputs : None
            BinaryConversionInfoBase.AddFixedSizeFieldDefinition(
                4,
                emitterBinary,
                SendModificationTypes.ModifiedDataOnly,
                null,
                new ConverterDefinition(typeof(DefaultConverter)),
                null
            );

            // Output : isLifeInfinity
            // Inputs : EnableInfinityLife
            BinaryConversionInfoBase.AddBinaryFieldDefinition(
                emitterBinary,
                SendModificationTypes.FullBinary,
                null,
                new ConverterDefinition(typeof(SwitchCaseConverter),
                    new ConverterParam("Cases", new SwitchCase[] { new SwitchCase(true, (byte)1) }),
                    new ConverterParam("DefaultOutput", (byte)0)),
                null,
                new InputPropertyDefinition("EmitterParticleData.EmitterParticleLifeData.EnableInfinityLife", new Guid("e075d30a-d94b-455f-a196-7e3632114da4"))
            );

            // Output : isTriming
            // Inputs : EnableTrimming
            BinaryConversionInfoBase.AddBinaryFieldDefinition(
                emitterBinary,
                SendModificationTypes.FullBinary,
                null,
                new ConverterDefinition(typeof(SwitchCaseConverter),
                    new ConverterParam("Cases", new SwitchCase[] { new SwitchCase(true, (byte)1) }),
                    new ConverterParam("DefaultOutput", (byte)0)),
                null,
                new InputPropertyDefinition("EmitterParticleData.EmitterParticleShapeData.EnableTrimming", new Guid("b9201b1f-a63a-409d-bd8e-9b1c5168a62a"))
            );

            // Output : billboardType
            // Inputs : ParticleType
            BinaryConversionInfoBase.AddBinaryFieldDefinition(
                emitterBinary,
                SendModificationTypes.FullBinary,
                null,
                new ConverterDefinition(typeof(TypeConversionConverter),
                    new ConverterParam("TargetType", typeof(System.Byte))),
                null,
                new InputPropertyDefinition("EmitterParticleData.EmitterParticleShapeData.ParticleType", new Guid("42daf081-d3ae-417f-bd6c-83a79036eca7"))
            );

            // Output : rotType
            // Inputs : RotationType
            BinaryConversionInfoBase.AddBinaryFieldDefinition(
                emitterBinary,
                SendModificationTypes.FullBinary,
                null,
                new ConverterDefinition(typeof(TypeConversionConverter),
                    new ConverterParam("TargetType", typeof(System.Byte))),
                null,
                new InputPropertyDefinition("EmitterRotationData.EmitterRotationBasicData.RotationType", new Guid("a88ffd8a-1b31-4911-855b-5df33c50093d"))
            );

            // Output : offsetType
            // Inputs : CameraOffsetProcessType
            BinaryConversionInfoBase.AddBinaryFieldDefinition(
                emitterBinary,
                SendModificationTypes.FullBinary,
                null,
                new ConverterDefinition(typeof(TypeConversionConverter),
                    new ConverterParam("TargetType", typeof(System.Byte))),
                null,
                new InputPropertyDefinition("EmitterParticleData.EmitterParticleShapeData.CameraOffsetProcessType", new Guid("ae5e9bb8-1804-4d15-8970-8d088f695a1f"))
            );

            // Output : rotRevRandX
            // Inputs : EnableRotationRandom
            BinaryConversionInfoBase.AddBinaryFieldDefinition(
                emitterBinary,
                SendModificationTypes.ModifiedDataOnly,
                null,
                new ConverterDefinition(typeof(SwitchCaseConverter),
                    new ConverterParam("Cases", new SwitchCase[] { new SwitchCase(true, (byte)1) }),
                    new ConverterParam("DefaultOutput", (byte)0)),
                null,
                new InputPropertyDefinition("EmitterRotationData.EmitterRotationXData.EnableRotationRandom", new Guid("94acadb3-e7fd-4a4f-8e27-ce3a1d6e9945"))
            );

            // Output : rotRevRandY
            // Inputs : EnableRotationRandom
            BinaryConversionInfoBase.AddBinaryFieldDefinition(
                emitterBinary,
                SendModificationTypes.ModifiedDataOnly,
                null,
                new ConverterDefinition(typeof(SwitchCaseConverter),
                    new ConverterParam("Cases", new SwitchCase[] { new SwitchCase(true, (byte)1) }),
                    new ConverterParam("DefaultOutput", (byte)0)),
                null,
                new InputPropertyDefinition("EmitterRotationData.EmitterRotationYData.EnableRotationRandom", new Guid("966aa19d-9a98-4691-837b-509702f76fc5"))
            );

            // Output : rotRevRandZ
            // Inputs : EnableRotationRandom
            BinaryConversionInfoBase.AddBinaryFieldDefinition(
                emitterBinary,
                SendModificationTypes.ModifiedDataOnly,
                null,
                new ConverterDefinition(typeof(SwitchCaseConverter),
                    new ConverterParam("Cases", new SwitchCase[] { new SwitchCase(true, (byte)1) }),
                    new ConverterParam("DefaultOutput", (byte)0)),
                null,
                new InputPropertyDefinition("EmitterRotationData.EmitterRotationZData.EnableRotationRandom", new Guid("3994a931-d120-492e-8241-34d8716aa150"))
            );

            // Output : isRotateX
            // Inputs : EnableRotationAxisX
            BinaryConversionInfoBase.AddBinaryFieldDefinition(
                emitterBinary,
                SendModificationTypes.FullBinary,
                null,
                new ConverterDefinition(typeof(DefaultConverter)),
                null,
                new InputPropertyDefinition("EmitterRotationData.EmitterRotationBasicData.EnableRotationAxisX", new Guid("c071fc6c-5537-4a58-a948-97a63c88ec70"))
            );

            // Output : isRotateY
            // Inputs : EnableRotationAxisY
            BinaryConversionInfoBase.AddBinaryFieldDefinition(
                emitterBinary,
                SendModificationTypes.FullBinary,
                null,
                new ConverterDefinition(typeof(DefaultConverter)),
                null,
                new InputPropertyDefinition("EmitterRotationData.EmitterRotationBasicData.EnableRotationAxisY", new Guid("b3ff1b03-9219-4276-8953-4fb986cdac70"))
            );

            // Output : isRotateZ
            // Inputs : EnableRotationAxisZ
            BinaryConversionInfoBase.AddBinaryFieldDefinition(
                emitterBinary,
                SendModificationTypes.FullBinary,
                null,
                new ConverterDefinition(typeof(DefaultConverter)),
                null,
                new InputPropertyDefinition("EmitterRotationData.EmitterRotationBasicData.EnableRotationAxisZ", new Guid("9f044a34-4d60-49f7-a4e4-dedc024c09dd"))
            );

            // Output : primitiveScaleType
            // Inputs : None
            BinaryConversionInfoBase.AddFixedSizeFieldDefinition(
                1,
                emitterBinary,
                SendModificationTypes.ModifiedDataOnly,
                null,
                new ConverterDefinition(typeof(TypeConversionConverter),
                    new ConverterParam("TargetType", typeof(System.Byte))),
                null
            );

            // Output : isTextureCommonRandom
            // Inputs : FixedUvAnim
            BinaryConversionInfoBase.AddBinaryFieldDefinition(
                emitterBinary,
                SendModificationTypes.ModifiedDataOnly,
                null,
                new ConverterDefinition(typeof(DefaultConverter)),
                null,
                new InputPropertyDefinition("Textures.CommonSettings.FixedUvAnim", new Guid("5462431d-620a-4073-8e0e-f43119f1b111"))
            );

            // Output : connectPtclScaleAndZOffset
            // Inputs : ConnectPtclScaleToZOffset
            BinaryConversionInfoBase.AddBinaryFieldDefinition(
                emitterBinary,
                SendModificationTypes.FullBinary,
                null,
                new ConverterDefinition(typeof(DefaultConverter)),
                null,
                new InputPropertyDefinition("EmitterParticleData.EmitterParticleShapeData.ConnectPtclScaleToZOffset", new Guid("d31c9d5d-ad30-4c86-9c56-ef33f08adce9"))
            );

            // Output : enableAvoidZFighting
            // Inputs : EnableAvoidZFighting
            BinaryConversionInfoBase.AddBinaryFieldDefinition(
                emitterBinary,
                SendModificationTypes.FullBinary,
                null,
                new ConverterDefinition(typeof(SwitchCaseConverter),
                    new ConverterParam("Cases", new SwitchCase[] { new SwitchCase(true, (byte)1) }),
                    new ConverterParam("DefaultOutput", (byte)0)),
                null,
                new InputPropertyDefinition("EmitterParticleData.EmitterParticleShapeData.EnableAvoidZFighting", new Guid("64e48760-11a6-49e2-9ede-e3b861dc5df4"))
            );

            // Output : reserved0
            // Inputs : None
            BinaryConversionInfoBase.AddFixedSizeFieldDefinition(
                1,
                emitterBinary,
                SendModificationTypes.ModifiedDataOnly,
                null,
                new ConverterDefinition(typeof(DefaultConverter)),
                null
            );

            // Output : life
            // Inputs : Life
            BinaryConversionInfoBase.AddBinaryFieldDefinition(
                emitterBinary,
                SendModificationTypes.ModifiedWithReset,
                null,
                new ConverterDefinition(typeof(DefaultConverter)),
                null,
                new InputPropertyDefinition("EmitterParticleData.EmitterParticleLifeData.Life", new Guid("0f365860-f691-427d-84c0-0e5166edf3ba"))
            );

            // Output : lifeRandom
            // Inputs : LifeRandom
            BinaryConversionInfoBase.AddBinaryFieldDefinition(
                emitterBinary,
                SendModificationTypes.ModifiedDataOnly,
                null,
                new ConverterDefinition(typeof(TypeConversionConverter),
                    new ConverterParam("TargetType", typeof(System.Int32))),
                null,
                new InputPropertyDefinition("EmitterParticleData.EmitterParticleLifeData.LifeRandom", new Guid("fcd8e736-c19a-4810-89ad-fdd32559e49b"))
            );

            // Output : dynamicsRand
            // Inputs : MomentumRandom
            BinaryConversionInfoBase.AddBinaryFieldDefinition(
                emitterBinary,
                SendModificationTypes.ModifiedDataOnly,
                null,
                new ConverterDefinition(typeof(DefaultConverter)),
                null,
                new InputPropertyDefinition("EmitterEmissionData.EmitterEmissionGravityData.MomentumRandom", new Guid("477d6abf-2696-4139-a8ba-1d2b842f7094"))
            );

            // Output : primitiveVertexInfoFlags
            // Inputs : PrimitiveFilePath, ShapeType
            BinaryConversionInfoBase.AddBinaryFieldDefinition(
                emitterBinary,
                SendModificationTypes.FullBinary,
                null,
                new ConverterDefinition(typeof(PrimitiveVertexInfoFlagsConverter),
                    new ConverterParam("ValidId", 1)),
                null,
                new InputPropertyDefinition("EmitterParticleData.EmitterParticleShapeData.PrimitiveFilePath", new Guid("0e0ad567-ca95-443b-a07a-253afae9ba45")),
                new InputPropertyDefinition("EmitterParticleData.EmitterParticleShapeData.ShapeType", new Guid("b013818e-bd0e-4e46-aa84-b432528060ed"))
            );

            // Output : primitiveIndex
            // Inputs : PrimitiveFilePath, ShapeType
            BinaryConversionInfoBase.AddBinaryFieldDefinition(
                emitterBinary,
                SendModificationTypes.FullBinary,
                null,
                new ConverterDefinition(typeof(PrimitiveIDConverter),
                    new ConverterParam("ValidId", 1)),
                null,
                new InputPropertyDefinition("EmitterParticleData.EmitterParticleShapeData.PrimitiveFilePath", new Guid("0e0ad567-ca95-443b-a07a-253afae9ba45")),
                new InputPropertyDefinition("EmitterParticleData.EmitterParticleShapeData.ShapeType", new Guid("b013818e-bd0e-4e46-aa84-b432528060ed"))
            );

            // Output : trimmingPrimitiveIndex
            // Inputs : FilePath, ShapeType, EnableTrimming
            BinaryConversionInfoBase.AddBinaryFieldDefinition(
                emitterBinary,
                SendModificationTypes.ModifiedDataOnly,
                null,
                new ConverterDefinition(typeof(TrimmingPrimitiveIDConverter),
                    new ConverterParam("ValidId", 0)),
                null,
                new InputPropertyDefinition("Textures.Texture0.EmitterTextureFileData.FilePath", new Guid("592dc31f-ed3c-4f2b-b100-73e6fbc84159")),
                new InputPropertyDefinition("EmitterParticleData.EmitterParticleShapeData.ShapeType", new Guid("b013818e-bd0e-4e46-aa84-b432528060ed")),
                new InputPropertyDefinition("EmitterParticleData.EmitterParticleShapeData.EnableTrimming", new Guid("b9201b1f-a63a-409d-bd8e-9b1c5168a62a"))
            );

            // Output : color0AnimIsLoop
            // Inputs : EnableLoop
            BinaryConversionInfoBase.AddBinaryFieldDefinition(
                emitterBinary,
                SendModificationTypes.ModifiedDataOnly,
                null,
                new ConverterDefinition(typeof(SwitchCaseConverter),
                    new ConverterParam("Cases", new SwitchCase[] { new SwitchCase(true, (byte)1) }),
                    new ConverterParam("DefaultOutput", (byte)0)),
                null,
                new InputPropertyDefinition("EmitterColorData.ParticleColor.EmitterColorSettingsData.ColorAnimationLoopData0.EnableLoop", new Guid("46f0ba15-16c4-4e86-b322-bc72c410d52e"))
            );

            // Output : alpha0AnimIsLoop
            // Inputs : EnableLoop
            BinaryConversionInfoBase.AddBinaryFieldDefinition(
                emitterBinary,
                SendModificationTypes.ModifiedDataOnly,
                null,
                new ConverterDefinition(typeof(SwitchCaseConverter),
                    new ConverterParam("Cases", new SwitchCase[] { new SwitchCase(true, (byte)1) }),
                    new ConverterParam("DefaultOutput", (byte)0)),
                null,
                new InputPropertyDefinition("EmitterColorData.ParticleColor.EmitterColorSettingsData.AlphaAnimationLoopData0.EnableLoop", new Guid("46f0ba15-16c4-4e86-b322-bc72c410d52e"))
            );

            // Output : color1AnimIsLoop
            // Inputs : EnableLoop
            BinaryConversionInfoBase.AddBinaryFieldDefinition(
                emitterBinary,
                SendModificationTypes.ModifiedDataOnly,
                null,
                new ConverterDefinition(typeof(SwitchCaseConverter),
                    new ConverterParam("Cases", new SwitchCase[] { new SwitchCase(true, (byte)1) }),
                    new ConverterParam("DefaultOutput", (byte)0)),
                null,
                new InputPropertyDefinition("EmitterColorData.ParticleColor.EmitterColorSettingsData.ColorAnimationLoopData1.EnableLoop", new Guid("46f0ba15-16c4-4e86-b322-bc72c410d52e"))
            );

            // Output : alpha1AnimIsLoop
            // Inputs : EnableLoop
            BinaryConversionInfoBase.AddBinaryFieldDefinition(
                emitterBinary,
                SendModificationTypes.ModifiedDataOnly,
                null,
                new ConverterDefinition(typeof(SwitchCaseConverter),
                    new ConverterParam("Cases", new SwitchCase[] { new SwitchCase(true, (byte)1) }),
                    new ConverterParam("DefaultOutput", (byte)0)),
                null,
                new InputPropertyDefinition("EmitterColorData.ParticleColor.EmitterColorSettingsData.AlphaAnimationLoopData1.EnableLoop", new Guid("46f0ba15-16c4-4e86-b322-bc72c410d52e"))
            );

            // Output : scaleAnimIsLoop
            // Inputs : LoopMode
            BinaryConversionInfoBase.AddBinaryFieldDefinition(
                emitterBinary,
                SendModificationTypes.ModifiedDataOnly,
                null,
                new ConverterDefinition(typeof(TypeConversionConverter),
                    new ConverterParam("TargetType", typeof(System.Byte))),
                null,
                new InputPropertyDefinition("EmitterScaleData.EmitterScaleAnimationCurveData.LoopMode", new Guid("2b91f6cc-4d36-4374-94e9-b2bc7c7b3669"))
            );

            // Output : color0AnimIsLoopInitRandom
            // Inputs : EnableStartRandom
            BinaryConversionInfoBase.AddBinaryFieldDefinition(
                emitterBinary,
                SendModificationTypes.ModifiedDataOnly,
                null,
                new ConverterDefinition(typeof(SwitchCaseConverter),
                    new ConverterParam("Cases", new SwitchCase[] { new SwitchCase(true, (byte)1) }),
                    new ConverterParam("DefaultOutput", (byte)0)),
                null,
                new InputPropertyDefinition("EmitterColorData.ParticleColor.EmitterColorSettingsData.ColorAnimationLoopData0.EnableStartRandom", new Guid("1d0a25ca-873d-4a7c-b068-83d310b47296"))
            );

            // Output : alpha0AnimIsLoopInitRandom
            // Inputs : EnableStartRandom
            BinaryConversionInfoBase.AddBinaryFieldDefinition(
                emitterBinary,
                SendModificationTypes.ModifiedDataOnly,
                null,
                new ConverterDefinition(typeof(SwitchCaseConverter),
                    new ConverterParam("Cases", new SwitchCase[] { new SwitchCase(true, (byte)1) }),
                    new ConverterParam("DefaultOutput", (byte)0)),
                null,
                new InputPropertyDefinition("EmitterColorData.ParticleColor.EmitterColorSettingsData.AlphaAnimationLoopData0.EnableStartRandom", new Guid("1d0a25ca-873d-4a7c-b068-83d310b47296"))
            );

            // Output : color1AnimIsLoopInitRandom
            // Inputs : EnableStartRandom
            BinaryConversionInfoBase.AddBinaryFieldDefinition(
                emitterBinary,
                SendModificationTypes.ModifiedDataOnly,
                null,
                new ConverterDefinition(typeof(SwitchCaseConverter),
                    new ConverterParam("Cases", new SwitchCase[] { new SwitchCase(true, (byte)1) }),
                    new ConverterParam("DefaultOutput", (byte)0)),
                null,
                new InputPropertyDefinition("EmitterColorData.ParticleColor.EmitterColorSettingsData.ColorAnimationLoopData1.EnableStartRandom", new Guid("1d0a25ca-873d-4a7c-b068-83d310b47296"))
            );

            // Output : alpha1AnimIsLoopInitRandom
            // Inputs : EnableStartRandom
            BinaryConversionInfoBase.AddBinaryFieldDefinition(
                emitterBinary,
                SendModificationTypes.ModifiedDataOnly,
                null,
                new ConverterDefinition(typeof(SwitchCaseConverter),
                    new ConverterParam("Cases", new SwitchCase[] { new SwitchCase(true, (byte)1) }),
                    new ConverterParam("DefaultOutput", (byte)0)),
                null,
                new InputPropertyDefinition("EmitterColorData.ParticleColor.EmitterColorSettingsData.AlphaAnimationLoopData1.EnableStartRandom", new Guid("1d0a25ca-873d-4a7c-b068-83d310b47296"))
            );

            // Output : scaleAnimIsLoopInitRandom
            // Inputs : Randomize
            BinaryConversionInfoBase.AddBinaryFieldDefinition(
                emitterBinary,
                SendModificationTypes.ModifiedDataOnly,
                null,
                new ConverterDefinition(typeof(TypeConversionConverter),
                    new ConverterParam("TargetType", typeof(System.Byte))),
                null,
                new InputPropertyDefinition("EmitterScaleData.EmitterScaleAnimationCurveData.Randomize", new Guid("67e29ba6-93d6-42d9-8e99-b2a41b9329ea"))
            );

            // Output : isOnAnotherBinaryPrimitive
            // Inputs : PrimitiveFilePath
            BinaryConversionInfoBase.AddBinaryFieldDefinition(
                emitterBinary,
                SendModificationTypes.ModifiedDataOnly,
                null,
                new ConverterDefinition(typeof(ParticlePrimitiveLocationConverter)),
                null,
                new InputPropertyDefinition("EmitterParticleData.EmitterParticleShapeData.PrimitiveFilePath", new Guid("0e0ad567-ca95-443b-a07a-253afae9ba45"))
            );

            // Output : isOnAnotherBinaryTrimmingPrimitive
            // Inputs : FilePath
            BinaryConversionInfoBase.AddBinaryFieldDefinition(
                emitterBinary,
                SendModificationTypes.ModifiedDataOnly,
                null,
                new ConverterDefinition(typeof(PrimitiveLocationConverter)),
                null,
                new InputPropertyDefinition("Textures.Texture0.EmitterTextureFileData.FilePath", new Guid("592dc31f-ed3c-4f2b-b100-73e6fbc84159"))
            );

            // Output : color0AnimLoopRate
            // Inputs : LoopFrame
            BinaryConversionInfoBase.AddBinaryFieldDefinition(
                emitterBinary,
                SendModificationTypes.ModifiedDataOnly,
                null,
                new ConverterDefinition(typeof(DefaultConverter)),
                null,
                new InputPropertyDefinition("EmitterColorData.ParticleColor.EmitterColorSettingsData.ColorAnimationLoopData0.LoopFrame", new Guid("8d47b838-0ea9-4a84-be3c-be095e7907e3"))
            );

            // Output : alpha0AnimLoopRate
            // Inputs : LoopFrame
            BinaryConversionInfoBase.AddBinaryFieldDefinition(
                emitterBinary,
                SendModificationTypes.ModifiedDataOnly,
                null,
                new ConverterDefinition(typeof(DefaultConverter)),
                null,
                new InputPropertyDefinition("EmitterColorData.ParticleColor.EmitterColorSettingsData.AlphaAnimationLoopData0.LoopFrame", new Guid("8d47b838-0ea9-4a84-be3c-be095e7907e3"))
            );

            // Output : color1AnimLoopRate
            // Inputs : LoopFrame
            BinaryConversionInfoBase.AddBinaryFieldDefinition(
                emitterBinary,
                SendModificationTypes.ModifiedDataOnly,
                null,
                new ConverterDefinition(typeof(DefaultConverter)),
                null,
                new InputPropertyDefinition("EmitterColorData.ParticleColor.EmitterColorSettingsData.ColorAnimationLoopData1.LoopFrame", new Guid("8d47b838-0ea9-4a84-be3c-be095e7907e3"))
            );

            // Output : alpha1AnimLoopRate
            // Inputs : LoopFrame
            BinaryConversionInfoBase.AddBinaryFieldDefinition(
                emitterBinary,
                SendModificationTypes.ModifiedDataOnly,
                null,
                new ConverterDefinition(typeof(DefaultConverter)),
                null,
                new InputPropertyDefinition("EmitterColorData.ParticleColor.EmitterColorSettingsData.AlphaAnimationLoopData1.LoopFrame", new Guid("8d47b838-0ea9-4a84-be3c-be095e7907e3"))
            );

            // Output : scaleAnimLoopRate
            // Inputs : LoopEnd
            BinaryConversionInfoBase.AddBinaryFieldDefinition(
                emitterBinary,
                SendModificationTypes.ModifiedDataOnly,
                null,
                new ConverterDefinition(typeof(DefaultConverter)),
                null,
                new InputPropertyDefinition("EmitterScaleData.EmitterScaleAnimationCurveData.LoopEnd", new Guid("0d2450b0-e942-434b-bbda-7aca685b6c85"))
            );

            // Output : colorCombinerProcess
            // Inputs : ColorTextureExpression
            BinaryConversionInfoBase.AddBinaryFieldDefinition(
                emitterBinary,
                SendModificationTypes.FullBinary,
                null,
                new ConverterDefinition(typeof(TypeConversionConverter),
                    new ConverterParam("TargetType", typeof(System.Byte))),
                null,
                new InputPropertyDefinition("EmitterCombinerData.EmitterCombinerEquationData.ColorTextureExpression", new Guid("d87d2ee8-3184-406e-98ab-bc5fc105f8fc"))
            );

            // Output : alphaCombinerProcess
            // Inputs : AlphaExpression
            BinaryConversionInfoBase.AddBinaryFieldDefinition(
                emitterBinary,
                SendModificationTypes.FullBinary,
                null,
                new ConverterDefinition(typeof(TypeConversionConverter),
                    new ConverterParam("TargetType", typeof(System.Byte))),
                null,
                new InputPropertyDefinition("EmitterCombinerData.EmitterCombinerEquationData.AlphaExpression", new Guid("78e1ac34-28cc-430f-8131-9111687bcfb7"))
            );

            // Output : texture1ColorBlend
            // Inputs : ColorTexture1BlendType
            BinaryConversionInfoBase.AddBinaryFieldDefinition(
                emitterBinary,
                SendModificationTypes.FullBinary,
                null,
                new ConverterDefinition(typeof(TypeConversionConverter),
                    new ConverterParam("TargetType", typeof(System.Byte))),
                null,
                new InputPropertyDefinition("EmitterCombinerData.EmitterCombinerEquationData.ColorTexture1BlendType", new Guid("1aef7528-957e-4cbb-a375-42e3a328bfcd"))
            );

            // Output : texture2ColorBlend
            // Inputs : ColorTexture2BlendType
            BinaryConversionInfoBase.AddBinaryFieldDefinition(
                emitterBinary,
                SendModificationTypes.FullBinary,
                null,
                new ConverterDefinition(typeof(TypeConversionConverter),
                    new ConverterParam("TargetType", typeof(System.Byte))),
                null,
                new InputPropertyDefinition("EmitterCombinerData.EmitterCombinerEquationData.ColorTexture2BlendType", new Guid("30adbf8e-e0bd-4009-81b7-fef2188a8c5b"))
            );

            // Output : primitiveColorBlend
            // Inputs : ColorPrimitiveExpression
            BinaryConversionInfoBase.AddBinaryFieldDefinition(
                emitterBinary,
                SendModificationTypes.FullBinary,
                null,
                new ConverterDefinition(typeof(TypeConversionConverter),
                    new ConverterParam("TargetType", typeof(System.Byte))),
                null,
                new InputPropertyDefinition("EmitterCombinerData.EmitterCombinerEquationData.ColorPrimitiveExpression", new Guid("dc258f45-eac8-4619-ac0b-d1fb38fe8b2c"))
            );

            // Output : texture1AlphaBlend
            // Inputs : AlphaTexture1BlendType
            BinaryConversionInfoBase.AddBinaryFieldDefinition(
                emitterBinary,
                SendModificationTypes.FullBinary,
                null,
                new ConverterDefinition(typeof(TypeConversionConverter),
                    new ConverterParam("TargetType", typeof(System.Byte))),
                null,
                new InputPropertyDefinition("EmitterCombinerData.EmitterCombinerEquationData.AlphaTexture1BlendType", new Guid("71424e79-2c84-461b-96da-55e5cd3e4a4f"))
            );

            // Output : texture2AlphaBlend
            // Inputs : AlphaTexture2BlendType
            BinaryConversionInfoBase.AddBinaryFieldDefinition(
                emitterBinary,
                SendModificationTypes.FullBinary,
                null,
                new ConverterDefinition(typeof(TypeConversionConverter),
                    new ConverterParam("TargetType", typeof(System.Byte))),
                null,
                new InputPropertyDefinition("EmitterCombinerData.EmitterCombinerEquationData.AlphaTexture2BlendType", new Guid("b4f57eda-befe-4b19-9ea3-1126eed3a3f3"))
            );

            // Output : primitiveAlphaBlend
            // Inputs : AlphaPrimitiveExpression
            BinaryConversionInfoBase.AddBinaryFieldDefinition(
                emitterBinary,
                SendModificationTypes.FullBinary,
                null,
                new ConverterDefinition(typeof(TypeConversionConverter),
                    new ConverterParam("TargetType", typeof(System.Byte))),
                null,
                new InputPropertyDefinition("EmitterCombinerData.EmitterCombinerEquationData.AlphaPrimitiveExpression", new Guid("41a6784d-e2c9-4958-88c1-c62d4aa1519a"))
            );

            // Output : texColor0InputType
            // Inputs : ColorTexture0Channel
            BinaryConversionInfoBase.AddBinaryFieldDefinition(
                emitterBinary,
                SendModificationTypes.FullBinary,
                null,
                new ConverterDefinition(typeof(TypeConversionConverter),
                    new ConverterParam("TargetType", typeof(System.Byte))),
                null,
                new InputPropertyDefinition("EmitterCombinerData.EmitterCombinerEquationData.ColorTexture0Channel", new Guid("2e6117f7-d00c-4831-81a2-259b83dc8915"))
            );

            // Output : texColor1InputType
            // Inputs : ColorTexture1Channel
            BinaryConversionInfoBase.AddBinaryFieldDefinition(
                emitterBinary,
                SendModificationTypes.FullBinary,
                null,
                new ConverterDefinition(typeof(TypeConversionConverter),
                    new ConverterParam("TargetType", typeof(System.Byte))),
                null,
                new InputPropertyDefinition("EmitterCombinerData.EmitterCombinerEquationData.ColorTexture1Channel", new Guid("0729433e-1152-42d4-a5b2-149100633aa0"))
            );

            // Output : texColor2InputType
            // Inputs : ColorTexture2Channel
            BinaryConversionInfoBase.AddBinaryFieldDefinition(
                emitterBinary,
                SendModificationTypes.FullBinary,
                null,
                new ConverterDefinition(typeof(TypeConversionConverter),
                    new ConverterParam("TargetType", typeof(System.Byte))),
                null,
                new InputPropertyDefinition("EmitterCombinerData.EmitterCombinerEquationData.ColorTexture2Channel", new Guid("96a9b7cc-6740-4e95-8ab9-efbfec66e84a"))
            );

            // Output : texAlpha0InputType
            // Inputs : AlphaTexture0Channel
            BinaryConversionInfoBase.AddBinaryFieldDefinition(
                emitterBinary,
                SendModificationTypes.FullBinary,
                null,
                new ConverterDefinition(typeof(TypeConversionConverter),
                    new ConverterParam("TargetType", typeof(System.Byte))),
                null,
                new InputPropertyDefinition("EmitterCombinerData.EmitterCombinerEquationData.AlphaTexture0Channel", new Guid("4c9b0e58-c1c5-4c54-ad89-0d9f48539137"))
            );

            // Output : texAlpha1InputType
            // Inputs : AlphaTexture1Channel
            BinaryConversionInfoBase.AddBinaryFieldDefinition(
                emitterBinary,
                SendModificationTypes.FullBinary,
                null,
                new ConverterDefinition(typeof(TypeConversionConverter),
                    new ConverterParam("TargetType", typeof(System.Byte))),
                null,
                new InputPropertyDefinition("EmitterCombinerData.EmitterCombinerEquationData.AlphaTexture1Channel", new Guid("25ed6223-edc6-4306-80ec-face7e114406"))
            );

            // Output : texAlpha2InputType
            // Inputs : AlphaTexture2Channel
            BinaryConversionInfoBase.AddBinaryFieldDefinition(
                emitterBinary,
                SendModificationTypes.FullBinary,
                null,
                new ConverterDefinition(typeof(TypeConversionConverter),
                    new ConverterParam("TargetType", typeof(System.Byte))),
                null,
                new InputPropertyDefinition("EmitterCombinerData.EmitterCombinerEquationData.AlphaTexture2Channel", new Guid("f8e38e7c-3a1d-4143-8956-1a0874692130"))
            );

            // Output : primitiveColorInputType
            // Inputs : ColorPrimitiveChannel
            BinaryConversionInfoBase.AddBinaryFieldDefinition(
                emitterBinary,
                SendModificationTypes.FullBinary,
                null,
                new ConverterDefinition(typeof(TypeConversionConverter),
                    new ConverterParam("TargetType", typeof(System.Byte))),
                null,
                new InputPropertyDefinition("EmitterCombinerData.EmitterCombinerEquationData.ColorPrimitiveChannel", new Guid("8f77463e-7436-4fd1-b735-a06c0f6d9a6e"))
            );

            // Output : primitiveAlphaInputType
            // Inputs : AlphaPrimitiveChannel
            BinaryConversionInfoBase.AddBinaryFieldDefinition(
                emitterBinary,
                SendModificationTypes.FullBinary,
                null,
                new ConverterDefinition(typeof(TypeConversionConverter),
                    new ConverterParam("TargetType", typeof(System.Byte))),
                null,
                new InputPropertyDefinition("EmitterCombinerData.EmitterCombinerEquationData.AlphaPrimitiveChannel", new Guid("2be9e502-029d-42e5-9ab3-dea75f219da4"))
            );

            // Output : shaderType
            // Inputs : ShaderType
            BinaryConversionInfoBase.AddBinaryFieldDefinition(
                emitterBinary,
                SendModificationTypes.FullBinary,
                null,
                new ConverterDefinition(typeof(TypeConversionConverter),
                    new ConverterParam("TargetType", typeof(System.Byte))),
                null,
                new InputPropertyDefinition("EmitterCombinerData.EmitterCombinerShaderData.ShaderType", new Guid("52df718b-e6e5-4ded-bcfa-53c84db9a3d0"))
            );

            // Output : applyAlpha
            // Inputs : ParticleApplyAlphaValue
            BinaryConversionInfoBase.AddBinaryFieldDefinition(
                emitterBinary,
                SendModificationTypes.FullBinary,
                null,
                new ConverterDefinition(typeof(SwitchCaseConverter),
                    new ConverterParam("Cases", new SwitchCase[] { new SwitchCase(true, (byte)1) }),
                    new ConverterParam("DefaultOutput", (byte)0)),
                null,
                new InputPropertyDefinition("EmitterCombinerData.EmitterCombinerShaderData.ParticleApplyAlphaValue", new Guid("c0d62625-4540-4f50-a0f0-3fcd3b38946b"))
            );

            // Output : isDistortionByCameraDistance
            // Inputs : IsDistortionByCameraDistance
            BinaryConversionInfoBase.AddBinaryFieldDefinition(
                emitterBinary,
                SendModificationTypes.FullBinary,
                null,
                new ConverterDefinition(typeof(SwitchCaseConverter),
                    new ConverterParam("Cases", new SwitchCase[] { new SwitchCase(true, (byte)1) }),
                    new ConverterParam("DefaultOutput", (byte)0)),
                null,
                new InputPropertyDefinition("EmitterCombinerData.EmitterCombinerShaderData.IsDistortionByCameraDistance", new Guid("75159b94-8f34-48e0-81fe-8cfa122c1142"))
            );

            // Output : reserved0
            // Inputs : None
            BinaryConversionInfoBase.AddFixedSizeFieldDefinition(
                5,
                emitterBinary,
                SendModificationTypes.ModifiedDataOnly,
                null,
                new ConverterDefinition(typeof(DefaultConverter)),
                null
            );

            // Output : shaderType
            // Inputs : ShaderType
            BinaryConversionInfoBase.AddBinaryFieldDefinition(
                emitterBinary,
                SendModificationTypes.FullBinary,
                null,
                new ConverterDefinition(typeof(TypeConversionConverter),
                    new ConverterParam("TargetType", typeof(System.Byte))),
                null,
                new InputPropertyDefinition("EmitterCombinerData.EmitterCombinerShaderData.ShaderType", new Guid("52df718b-e6e5-4ded-bcfa-53c84db9a3d0"))
            );

            // Output : reserved0
            // Inputs : None
            BinaryConversionInfoBase.AddFixedSizeFieldDefinition(
                3,
                emitterBinary,
                SendModificationTypes.ModifiedDataOnly,
                null,
                new ConverterDefinition(typeof(DefaultConverter)),
                null
            );

            // Output : shaderIndex
            // Inputs : None
            BinaryConversionInfoBase.AddFixedSizeFieldDefinition(
                4,
                emitterBinary,
                SendModificationTypes.ModifiedDataOnly,
                null,
                new ConverterDefinition(typeof(DefaultConverter)),
                null
            );

            // Output : computeShaderIndex
            // Inputs : None
            BinaryConversionInfoBase.AddFixedSizeFieldDefinition(
                4,
                emitterBinary,
                SendModificationTypes.ModifiedDataOnly,
                null,
                new ConverterDefinition(typeof(DefaultConverter)),
                null
            );

            // Output : userShaderIndex1
            // Inputs : None
            BinaryConversionInfoBase.AddFixedSizeFieldDefinition(
                4,
                emitterBinary,
                SendModificationTypes.ModifiedDataOnly,
                null,
                new ConverterDefinition(typeof(DefaultConverter)),
                null
            );

            // Output : userShaderIndex2
            // Inputs : None
            BinaryConversionInfoBase.AddFixedSizeFieldDefinition(
                4,
                emitterBinary,
                SendModificationTypes.ModifiedDataOnly,
                null,
                new ConverterDefinition(typeof(DefaultConverter)),
                null
            );

            // Output : customShaderIndex
            // Inputs : SelectedSettingIndex
            BinaryConversionInfoBase.AddBinaryFieldDefinition(
                emitterBinary,
                SendModificationTypes.FullBinary,
                null,
                new ConverterDefinition(typeof(CustomShaderIDConverter)),
                null,
                new InputPropertyDefinition("EmitterCustomShaderData.SelectedSettingIndex", new Guid("dffbc501-1945-4ec1-80af-dff999e7896e"))
            );

            // Output : customShaderFlag
            // Inputs : SelectedSettingFlags
            BinaryConversionInfoBase.AddBinaryFieldDefinition(
                emitterBinary,
                SendModificationTypes.FullBinary,
                null,
                new ConverterDefinition(typeof(DefaultConverter)),
                null,
                new InputPropertyDefinition("EmitterCustomShaderData.SelectedSettingFlags", new Guid("7264c5d7-2884-4d64-bffe-cd32b4bffdbe"))
            );

            // Output : customShaderSwitch
            // Inputs : SelectedSettingSwitches
            BinaryConversionInfoBase.AddBinaryFieldDefinition(
                emitterBinary,
                SendModificationTypes.FullBinary,
                null,
                new ConverterDefinition(typeof(DefaultConverter)),
                null,
                new InputPropertyDefinition("EmitterCustomShaderData.SelectedSettingSwitches", new Guid("13b25cf0-7a61-4b1a-8c0a-4f169c2c178f"))
            );

            // Output : eftCombinerShaderIndex
            // Inputs : None
            BinaryConversionInfoBase.AddFixedSizeFieldDefinition(
                4,
                emitterBinary,
                SendModificationTypes.ModifiedDataOnly,
                "eftCombinerShaderIndex",
                new ConverterDefinition(typeof(DefaultConverter)),
                null
            );

            // Output : reserved1
            // Inputs : ActiveReservedShader
            BinaryConversionInfoBase.AddBinaryFieldDefinition(
                emitterBinary,
                SendModificationTypes.FullBinary,
                null,
                new ConverterDefinition(typeof(ReservedShaderIndexConverter)),
                null,
                new InputPropertyDefinition("ActiveReservedShader", new Guid("5422149a-1c2c-4d4e-a5d0-bc8edeb11d36"))
            );

            // Output : userShaderDefine1
            // Inputs : DrawPathShaderDef1
            BinaryConversionInfoBase.AddBinaryFieldDefinition(
                emitterBinary,
                SendModificationTypes.ModifiedDataOnly,
                null,
                new ConverterDefinition(typeof(FixSizeStringConverter),
                    new ConverterParam("CharArrayLength", 16)),
                null,
                new InputPropertyDefinition("EmitterBasicSettingData.EmitterBasicRenderData.DrawPathShaderDef1", new Guid("6857e2b3-4e74-46a9-aa6b-614c39e9efb1"))
            );

            // Output : userShaderDefine2
            // Inputs : DrawPathShaderDef2
            BinaryConversionInfoBase.AddBinaryFieldDefinition(
                emitterBinary,
                SendModificationTypes.ModifiedDataOnly,
                null,
                new ConverterDefinition(typeof(FixSizeStringConverter),
                    new ConverterParam("CharArrayLength", 16)),
                null,
                new InputPropertyDefinition("EmitterBasicSettingData.EmitterBasicRenderData.DrawPathShaderDef2", new Guid("452a321c-197e-4b2e-a8f1-8e57f102dba7"))
            );

            // Output : customActionIndex
            // Inputs : ActiveCustomActionIndex
            BinaryConversionInfoBase.AddBinaryFieldDefinition(
                emitterBinary,
                SendModificationTypes.FullBinary,
                null,
                new ConverterDefinition(typeof(CustomActionIDConverter)),
                null,
                new InputPropertyDefinition("ActiveCustomActionIndex", new Guid("fd57aec3-9ecf-4d9c-b3dc-25f97635eb84"))
            );

            // Output : allDirection
            // Inputs : OmnidirectionalVelocity
            BinaryConversionInfoBase.AddBinaryFieldDefinition(
                emitterBinary,
                SendModificationTypes.ModifiedDataOnly,
                null,
                new ConverterDefinition(typeof(DefaultConverter)),
                null,
                new InputPropertyDefinition("EmitterEmissionData.EmitterEmissionVelocityData.OmnidirectionalVelocity", new Guid("bf814947-364f-414c-9848-f51f9480b11e"))
            );

            // Output : designatedDirScale
            // Inputs : OrientedVelocity
            BinaryConversionInfoBase.AddBinaryFieldDefinition(
                emitterBinary,
                SendModificationTypes.ModifiedDataOnly,
                null,
                new ConverterDefinition(typeof(DefaultConverter)),
                null,
                new InputPropertyDefinition("EmitterEmissionData.EmitterEmissionVelocityData.OrientedVelocity", new Guid("f0a6c91b-e34d-4e49-bc3c-5c7f657904c2"))
            );

            // Output : designatedDir
            // Inputs : OrientedDirection
            BinaryConversionInfoBase.AddBinaryFieldDefinition(
                emitterBinary,
                SendModificationTypes.ModifiedDataOnly,
                null,
                new ConverterDefinition(typeof(DefaultConverter)),
                null,
                new InputPropertyDefinition("EmitterEmissionData.EmitterEmissionVelocityData.OrientedDirection", new Guid("9d666727-dc45-4fd0-bc73-38b8d27c732e"))
            );

            // Output : diffusionDirAngle
            // Inputs : OrientedDirectionalDiffusionAngle
            BinaryConversionInfoBase.AddBinaryFieldDefinition(
                emitterBinary,
                SendModificationTypes.ModifiedDataOnly,
                null,
                new ConverterDefinition(typeof(DefaultConverter)),
                null,
                new InputPropertyDefinition("EmitterEmissionData.EmitterEmissionVelocityData.OrientedDirectionalDiffusionAngle", new Guid("f2cfe40b-e088-4d1a-923c-91e42b8a5ae7"))
            );

            // Output : xzDiffusion
            // Inputs : YaxisDiffusionVelocity
            BinaryConversionInfoBase.AddBinaryFieldDefinition(
                emitterBinary,
                SendModificationTypes.ModifiedDataOnly,
                null,
                new ConverterDefinition(typeof(DefaultConverter)),
                null,
                new InputPropertyDefinition("EmitterEmissionData.EmitterEmissionVelocityData.YaxisDiffusionVelocity", new Guid("c683265e-e253-40cc-8b29-49d9db1606e8"))
            );

            // Output : diffusion
            // Inputs : DiffusionVelocity
            BinaryConversionInfoBase.AddBinaryFieldDefinition(
                emitterBinary,
                SendModificationTypes.ModifiedDataOnly,
                null,
                new ConverterDefinition(typeof(DefaultConverter)),
                null,
                new InputPropertyDefinition("EmitterEmissionData.EmitterEmissionVelocityData.DiffusionVelocity", new Guid("cd45588b-f068-4f86-8bf0-1478f1619404"))
            );

            // Output : velRandom
            // Inputs : VelocityRandom
            BinaryConversionInfoBase.AddBinaryFieldDefinition(
                emitterBinary,
                SendModificationTypes.ModifiedDataOnly,
                null,
                new ConverterDefinition(typeof(DefaultConverter)),
                null,
                new InputPropertyDefinition("EmitterEmissionData.EmitterEmissionVelocityData.VelocityRandom", new Guid("6caac401-6217-4555-a5fd-9700797860a0"))
            );

            // Output : emVelInherit
            // Inputs : VelocityInheritRate
            BinaryConversionInfoBase.AddBinaryFieldDefinition(
                emitterBinary,
                SendModificationTypes.ModifiedDataOnly,
                null,
                new ConverterDefinition(typeof(DefaultConverter)),
                null,
                new InputPropertyDefinition("EmitterEmissionData.EmitterEmissionGravityData.VelocityInheritRate", new Guid("f1aadb6e-ba3c-4bbe-8620-8ed7777d498f"))
            );

            // Output : isSoftParticle
            // Inputs : SoftParticleProcessType
            BinaryConversionInfoBase.AddBinaryFieldDefinition(
                emitterBinary,
                SendModificationTypes.FullBinary,
                null,
                new ConverterDefinition(typeof(TypeConversionConverter),
                    new ConverterParam("TargetType", typeof(System.Byte))),
                null,
                new InputPropertyDefinition("EmitterColorData.ParticleColor.EmitterColorAlphaProcessData.SoftParticleProcessType", new Guid("8f928456-1a28-46c6-a5f2-9bccf3987fb5"))
            );

            // Output : isFresnelAlpha
            // Inputs : FresnelAlphaProcessType
            BinaryConversionInfoBase.AddBinaryFieldDefinition(
                emitterBinary,
                SendModificationTypes.FullBinary,
                null,
                new ConverterDefinition(typeof(TypeConversionConverter),
                    new ConverterParam("TargetType", typeof(System.Byte))),
                null,
                new InputPropertyDefinition("EmitterColorData.ParticleColor.EmitterColorAlphaProcessData.FresnelAlphaProcessType", new Guid("61714463-9aba-4bb0-bf87-abbc358f0b55"))
            );

            // Output : isNearDistAlpha
            // Inputs : EnableNearAlpha
            BinaryConversionInfoBase.AddBinaryFieldDefinition(
                emitterBinary,
                SendModificationTypes.FullBinary,
                null,
                new ConverterDefinition(typeof(SwitchCaseConverter),
                    new ConverterParam("Cases", new SwitchCase[] { new SwitchCase(true, (byte)1) }),
                    new ConverterParam("DefaultOutput", (byte)0)),
                null,
                new InputPropertyDefinition("EmitterColorData.ParticleColor.EmitterColorAlphaProcessData.EnableNearAlpha", new Guid("7096f9b8-bdfc-4fb8-80f7-011edfc4b7e6"))
            );

            // Output : isFarDistAlpha
            // Inputs : EnableFarAlpha
            BinaryConversionInfoBase.AddBinaryFieldDefinition(
                emitterBinary,
                SendModificationTypes.FullBinary,
                null,
                new ConverterDefinition(typeof(SwitchCaseConverter),
                    new ConverterParam("Cases", new SwitchCase[] { new SwitchCase(true, (byte)1) }),
                    new ConverterParam("DefaultOutput", (byte)0)),
                null,
                new InputPropertyDefinition("EmitterColorData.ParticleColor.EmitterColorAlphaProcessData.EnableFarAlpha", new Guid("328a41f8-691b-49f2-85db-47d15a2b7f5c"))
            );

            // Output : isDecal
            // Inputs : EnableDecal
            BinaryConversionInfoBase.AddBinaryFieldDefinition(
                emitterBinary,
                SendModificationTypes.FullBinary,
                null,
                new ConverterDefinition(typeof(SwitchCaseConverter),
                    new ConverterParam("Cases", new SwitchCase[] { new SwitchCase(true, (byte)1) }),
                    new ConverterParam("DefaultOutput", (byte)0)),
                null,
                new InputPropertyDefinition("EmitterColorData.ParticleColor.EmitterColorAlphaProcessData.EnableDecal", new Guid("9aeea11d-d914-46d3-be2e-f0f2cee1ec50"))
            );

            // Output : dummy
            // Inputs : None
            BinaryConversionInfoBase.AddFixedSizeFieldDefinition(
                3,
                emitterBinary,
                SendModificationTypes.ModifiedDataOnly,
                null,
                new ConverterDefinition(typeof(DefaultConverter)),
                null
            );

            // Output : color0Type
            // Inputs : Color0BehaviorType
            BinaryConversionInfoBase.AddBinaryFieldDefinition(
                emitterBinary,
                SendModificationTypes.FullBinary,
                null,
                new ConverterDefinition(typeof(TypeConversionConverter),
                    new ConverterParam("TargetType", typeof(System.Byte))),
                null,
                new InputPropertyDefinition("EmitterColorData.ParticleColor.EmitterColorSettingsData.Color0BehaviorType", new Guid("3044c1e9-782d-4fa2-aa98-ffb8cc3c656f"))
            );

            // Output : color1Type
            // Inputs : Color1BehaviorType
            BinaryConversionInfoBase.AddBinaryFieldDefinition(
                emitterBinary,
                SendModificationTypes.FullBinary,
                null,
                new ConverterDefinition(typeof(TypeConversionConverter),
                    new ConverterParam("TargetType", typeof(System.Byte))),
                null,
                new InputPropertyDefinition("EmitterColorData.ParticleColor.EmitterColorSettingsData.Color1BehaviorType", new Guid("47c9193c-6eb9-4aa9-9cec-eec7b8382e2b"))
            );

            // Output : alpha0Type
            // Inputs : Alpha0BehaviorType
            BinaryConversionInfoBase.AddBinaryFieldDefinition(
                emitterBinary,
                SendModificationTypes.FullBinary,
                null,
                new ConverterDefinition(typeof(TypeConversionConverter),
                    new ConverterParam("TargetType", typeof(System.Byte))),
                null,
                new InputPropertyDefinition("EmitterColorData.ParticleColor.EmitterColorSettingsData.Alpha0BehaviorType", new Guid("b39effb8-2f0a-4e8e-b4ec-a470c69a0744"))
            );

            // Output : alpha1Type
            // Inputs : Alpha1BehaviorType
            BinaryConversionInfoBase.AddBinaryFieldDefinition(
                emitterBinary,
                SendModificationTypes.FullBinary,
                null,
                new ConverterDefinition(typeof(TypeConversionConverter),
                    new ConverterParam("TargetType", typeof(System.Byte))),
                null,
                new InputPropertyDefinition("EmitterColorData.ParticleColor.EmitterColorSettingsData.Alpha1BehaviorType", new Guid("f12811ab-1b1b-4098-a12a-eaa9cd995abf"))
            );

            // Output : color0
            // Inputs : Color0Value
            BinaryConversionInfoBase.AddBinaryFieldDefinition(
                emitterBinary,
                SendModificationTypes.ModifiedDataOnly,
                null,
                new ConverterDefinition(typeof(ColorToVec3Converter)),
                null,
                new InputPropertyDefinition("EmitterColorData.ParticleColor.EmitterColorSettingsData.Color0Value", new Guid("ed2c40c6-bb31-4913-8f94-0a05a7544990"))
            );

            // Output : alpha0
            // Inputs : Alpha0Value
            BinaryConversionInfoBase.AddBinaryFieldDefinition(
                emitterBinary,
                SendModificationTypes.ModifiedDataOnly,
                null,
                new ConverterDefinition(typeof(DefaultConverter)),
                null,
                new InputPropertyDefinition("EmitterColorData.ParticleColor.EmitterColorSettingsData.Alpha0Value", new Guid("908ade7c-5a25-4aec-8831-ba766363ec3e"))
            );

            // Output : color1
            // Inputs : Color1Value
            BinaryConversionInfoBase.AddBinaryFieldDefinition(
                emitterBinary,
                SendModificationTypes.ModifiedDataOnly,
                null,
                new ConverterDefinition(typeof(ColorToVec3Converter)),
                null,
                new InputPropertyDefinition("EmitterColorData.ParticleColor.EmitterColorSettingsData.Color1Value", new Guid("bc97b7bd-9974-4d96-866f-809a4f20d09e"))
            );

            // Output : alpha1
            // Inputs : Alpha1Value
            BinaryConversionInfoBase.AddBinaryFieldDefinition(
                emitterBinary,
                SendModificationTypes.ModifiedDataOnly,
                null,
                new ConverterDefinition(typeof(DefaultConverter)),
                null,
                new InputPropertyDefinition("EmitterColorData.ParticleColor.EmitterColorSettingsData.Alpha1Value", new Guid("0033ef5f-a0cd-46b6-a88a-089958aa718e"))
            );

            // Output : base
            // Inputs : ScaleBasisValue
            BinaryConversionInfoBase.AddBinaryFieldDefinition(
                emitterBinary,
                SendModificationTypes.ModifiedDataOnly,
                null,
                new ConverterDefinition(typeof(DefaultConverter)),
                null,
                new InputPropertyDefinition("EmitterScaleData.EmitterScaleBasicData.ScaleBasisValue", new Guid("f4086782-7479-44c8-845a-03b7cc4f0330"))
            );

            // Output : baseRandom
            // Inputs : ScaleBasisRandom
            BinaryConversionInfoBase.AddBinaryFieldDefinition(
                emitterBinary,
                SendModificationTypes.ModifiedDataOnly,
                null,
                new ConverterDefinition(typeof(DefaultConverter)),
                null,
                new InputPropertyDefinition("EmitterScaleData.EmitterScaleBasicData.ScaleBasisRandom", new Guid("18eb284d-9076-48cd-8ee7-c90ee0974d43"))
            );

            // Output : enableScalingByCameraDistNear
            // Inputs : EnableScalingByCameraDistNear
            BinaryConversionInfoBase.AddBinaryFieldDefinition(
                emitterBinary,
                SendModificationTypes.FullBinary,
                null,
                new ConverterDefinition(typeof(SwitchCaseConverter),
                    new ConverterParam("Cases", new SwitchCase[] { new SwitchCase(true, (byte)1) }),
                    new ConverterParam("DefaultOutput", (byte)0)),
                null,
                new InputPropertyDefinition("EmitterScaleData.EmitterScaleAnimationData.EnableScalingByCameraDistNear", new Guid("2b74d92b-377d-4b59-a101-3cb748e0b0bf"))
            );

            // Output : enableScalingByCameraDistFar
            // Inputs : EnableScalingByCameraDistFar
            BinaryConversionInfoBase.AddBinaryFieldDefinition(
                emitterBinary,
                SendModificationTypes.FullBinary,
                null,
                new ConverterDefinition(typeof(SwitchCaseConverter),
                    new ConverterParam("Cases", new SwitchCase[] { new SwitchCase(true, (byte)1) }),
                    new ConverterParam("DefaultOutput", (byte)0)),
                null,
                new InputPropertyDefinition("EmitterScaleData.EmitterScaleAnimationData.EnableScalingByCameraDistFar", new Guid("742b627a-8749-4b2e-aefa-1c2e48bf35da"))
            );

            // Output : enableAddScaleY
            // Inputs : EnableScaleVelAddY
            BinaryConversionInfoBase.AddBinaryFieldDefinition(
                emitterBinary,
                SendModificationTypes.FullBinary,
                null,
                new ConverterDefinition(typeof(SwitchCaseConverter),
                    new ConverterParam("Cases", new SwitchCase[] { new SwitchCase(true, (byte)1) }),
                    new ConverterParam("DefaultOutput", (byte)0)),
                null,
                new InputPropertyDefinition("EmitterScaleData.EmitterScaleAnimationData.EnableScaleVelAddY", new Guid("ab943196-7e5b-4bf1-bee5-a00d30cfec7a"))
            );

            // Output : enableLinkFovyToScaleValue
            // Inputs : EnableLinkFovyToScaleValue
            BinaryConversionInfoBase.AddBinaryFieldDefinition(
                emitterBinary,
                SendModificationTypes.FullBinary,
                null,
                new ConverterDefinition(typeof(SwitchCaseConverter),
                    new ConverterParam("Cases", new SwitchCase[] { new SwitchCase(true, (byte)1) })),
                null,
                new InputPropertyDefinition("EmitterScaleData.EmitterScaleAnimationData.EnableLinkFovyToScaleValue", new Guid("0ade8903-b154-42f6-99c5-9bb63fc6e65c"))
            );

            // Output : scaleLimitDistNear
            // Inputs : ScaleLimitDistNear
            BinaryConversionInfoBase.AddBinaryFieldDefinition(
                emitterBinary,
                SendModificationTypes.ModifiedDataOnly,
                null,
                new ConverterDefinition(typeof(DefaultConverter)),
                null,
                new InputPropertyDefinition("EmitterScaleData.EmitterScaleAnimationData.ScaleLimitDistNear", new Guid("d9a8b4b2-6f8a-4b5f-a1d9-297e4c9c50ac"))
            );

            // Output : scaleLimitDistFar
            // Inputs : ScaleLimitDistFar
            BinaryConversionInfoBase.AddBinaryFieldDefinition(
                emitterBinary,
                SendModificationTypes.ModifiedDataOnly,
                null,
                new ConverterDefinition(typeof(DefaultConverter)),
                null,
                new InputPropertyDefinition("EmitterScaleData.EmitterScaleAnimationData.ScaleLimitDistFar", new Guid("bb582107-852a-4eff-9d6b-8f1bf3d60899"))
            );

            // Output : isApplyAlpha
            // Inputs : ApplyAlpha
            BinaryConversionInfoBase.AddBinaryFieldDefinition(
                emitterBinary,
                SendModificationTypes.FullBinary,
                null,
                new ConverterDefinition(typeof(SwitchCaseConverter),
                    new ConverterParam("Cases", new SwitchCase[] { new SwitchCase(true, (byte)1) }),
                    new ConverterParam("DefaultOutput", (byte)0)),
                null,
                new InputPropertyDefinition("EmitterParticleData.EmitterParticleFluctutaionData.ApplyAlpha", new Guid("1b7c70ed-f587-4735-80dc-e12ee27e5f15"))
            );

            // Output : isApplayScale
            // Inputs : ApplyScale
            BinaryConversionInfoBase.AddBinaryFieldDefinition(
                emitterBinary,
                SendModificationTypes.FullBinary,
                null,
                new ConverterDefinition(typeof(SwitchCaseConverter),
                    new ConverterParam("Cases", new SwitchCase[] { new SwitchCase(true, (byte)1) }),
                    new ConverterParam("DefaultOutput", (byte)0)),
                null,
                new InputPropertyDefinition("EmitterParticleData.EmitterParticleFluctutaionData.ApplyScale", new Guid("9680e636-8134-47e5-a7e2-2779f03e5bbc"))
            );

            // Output : isApplayScaleY
            // Inputs : ApplyScaleY
            BinaryConversionInfoBase.AddBinaryFieldDefinition(
                emitterBinary,
                SendModificationTypes.FullBinary,
                null,
                new ConverterDefinition(typeof(SwitchCaseConverter),
                    new ConverterParam("Cases", new SwitchCase[] { new SwitchCase(true, (byte)1) }),
                    new ConverterParam("DefaultOutput", (byte)0)),
                null,
                new InputPropertyDefinition("EmitterParticleData.EmitterParticleFluctutaionData.ApplyScaleY", new Guid("52bf9594-cfbb-41ed-b64a-8625e74a7050"))
            );

            // Output : isWaveType
            // Inputs : WaveType
            BinaryConversionInfoBase.AddBinaryFieldDefinition(
                emitterBinary,
                SendModificationTypes.ModifiedDataOnly,
                null,
                new ConverterDefinition(typeof(TypeConversionConverter),
                    new ConverterParam("TargetType", typeof(System.Byte))),
                null,
                new InputPropertyDefinition("EmitterParticleData.EmitterParticleFluctutaionData.WaveType", new Guid("8c71cebb-d015-4097-83cb-befd1ea054e5"))
            );

            // Output : isPhaseRandomX
            // Inputs : None
            BinaryConversionInfoBase.AddFixedSizeFieldDefinition(
                1,
                emitterBinary,
                SendModificationTypes.ModifiedDataOnly,
                null,
                new ConverterDefinition(typeof(DefaultConverter)),
                null
            );

            // Output : isPhaseRandomY
            // Inputs : None
            BinaryConversionInfoBase.AddFixedSizeFieldDefinition(
                1,
                emitterBinary,
                SendModificationTypes.ModifiedDataOnly,
                null,
                new ConverterDefinition(typeof(DefaultConverter)),
                null
            );

            // Output : reserved0
            // Inputs : None
            BinaryConversionInfoBase.AddFixedSizeFieldDefinition(
                6,
                emitterBinary,
                SendModificationTypes.ModifiedDataOnly,
                null,
                new ConverterDefinition(typeof(DefaultConverter)),
                null
            );

            // Output : guid
            // Inputs : FilePath
            BinaryConversionInfoBase.AddBinaryFieldDefinition(
                emitterBinary,
                SendModificationTypes.FullBinary,
                null,
                new ConverterDefinition(typeof(TextureIDConverter)),
                null,
                new InputPropertyDefinition("Textures.Texture0.EmitterTextureFileData.FilePath", new Guid("592dc31f-ed3c-4f2b-b100-73e6fbc84159"))
            );

            // Output : wrapU
            // Inputs : WrapTypeU
            BinaryConversionInfoBase.AddBinaryFieldDefinition(
                emitterBinary,
                SendModificationTypes.ModifiedWithReset,
                null,
                new ConverterDefinition(typeof(TypeConversionConverter),
                    new ConverterParam("TargetType", typeof(System.Byte))),
                null,
                new InputPropertyDefinition("Textures.Texture0.EmitterTextureFileData.WrapTypeU", new Guid("3aec6259-dee6-4a34-bf6a-51e5af7ac77f"))
            );

            // Output : wrapV
            // Inputs : WrapTypeV
            BinaryConversionInfoBase.AddBinaryFieldDefinition(
                emitterBinary,
                SendModificationTypes.ModifiedWithReset,
                null,
                new ConverterDefinition(typeof(TypeConversionConverter),
                    new ConverterParam("TargetType", typeof(System.Byte))),
                null,
                new InputPropertyDefinition("Textures.Texture0.EmitterTextureFileData.WrapTypeV", new Guid("11f32d42-3add-4b70-a56c-b8bdb1dda0bd"))
            );

            // Output : filter
            // Inputs : FilterMode
            BinaryConversionInfoBase.AddBinaryFieldDefinition(
                emitterBinary,
                SendModificationTypes.ModifiedWithReset,
                null,
                new ConverterDefinition(typeof(TypeConversionConverter),
                    new ConverterParam("TargetType", typeof(System.Byte))),
                null,
                new InputPropertyDefinition("Textures.Texture0.EmitterTextureFileData.FilterMode", new Guid("6883aa33-6884-45f3-ab00-0b096afb0b19"))
            );

            // Output : isSphereMap
            // Inputs : SphericalMap
            BinaryConversionInfoBase.AddBinaryFieldDefinition(
                emitterBinary,
                SendModificationTypes.FullBinary,
                null,
                new ConverterDefinition(typeof(SwitchCaseConverter),
                    new ConverterParam("DefaultOutput", (byte)0),
                    new ConverterParam("Cases", new SwitchCase[] { new SwitchCase(true, (byte)1) })),
                null,
                new InputPropertyDefinition("Textures.Texture0.EmitterTextureFileData.SphericalMap", new Guid("4a71894b-0f60-41b8-a46b-67b04ade9ac7"))
            );

            // Output : mipLevel
            // Inputs : AvailableMipMapLevel
            BinaryConversionInfoBase.AddBinaryFieldDefinition(
                emitterBinary,
                SendModificationTypes.ModifiedDataOnly,
                null,
                new ConverterDefinition(typeof(DefaultConverter)),
                null,
                new InputPropertyDefinition("Textures.Texture0.EmitterTextureFileData.AvailableMipMapLevel", new Guid("6348c8d1-df8d-4f75-9f33-25c75193a9fb"))
            );

            // Output : mipMapBias
            // Inputs : MipMapBias
            BinaryConversionInfoBase.AddBinaryFieldDefinition(
                emitterBinary,
                SendModificationTypes.ModifiedDataOnly,
                null,
                new ConverterDefinition(typeof(DefaultConverter)),
                null,
                new InputPropertyDefinition("Textures.Texture0.EmitterTextureFileData.MipMapBias", new Guid("e875d783-a6d3-4445-b8c6-a231b4555638"))
            );

            // Output : mipLevelLimit
            // Inputs : MipMapLevelLimit
            BinaryConversionInfoBase.AddBinaryFieldDefinition(
                emitterBinary,
                SendModificationTypes.FullBinary,
                null,
                new ConverterDefinition(typeof(DefaultConverter)),
                null,
                new InputPropertyDefinition("Textures.Texture0.EmitterTextureFileData.MipMapLevelLimit", new Guid("9e949eb5-af3e-40bf-8854-3ca091a58914"))
            );

            // Output : isDensityFixedU
            // Inputs : IsDensityFixedU
            BinaryConversionInfoBase.AddBinaryFieldDefinition(
                emitterBinary,
                SendModificationTypes.FullBinary,
                null,
                new ConverterDefinition(typeof(DefaultConverter)),
                null,
                new InputPropertyDefinition("Textures.Texture0.EmitterTextureOptionData.IsDensityFixedU", new Guid("cf3e87a8-6f05-4bf8-9fb0-066cc1f4ce50"))
            );

            // Output : isDensityFixedV
            // Inputs : IsDensityFixedV
            BinaryConversionInfoBase.AddBinaryFieldDefinition(
                emitterBinary,
                SendModificationTypes.FullBinary,
                null,
                new ConverterDefinition(typeof(DefaultConverter)),
                null,
                new InputPropertyDefinition("Textures.Texture0.EmitterTextureOptionData.IsDensityFixedV", new Guid("b15d5a28-e5ed-456c-a888-c71ee0567ff1"))
            );

            // Output : isSquareRgb
            // Inputs : IsSquareRGB
            BinaryConversionInfoBase.AddBinaryFieldDefinition(
                emitterBinary,
                SendModificationTypes.FullBinary,
                null,
                new ConverterDefinition(typeof(DefaultConverter)),
                null,
                new InputPropertyDefinition("Textures.Texture0.EmitterTextureFileData.IsSquareRGB", new Guid("56196fed-b992-4c32-bbf6-3815dcf1c387"))
            );

            // Output : isOnAnotherBinary
            // Inputs : FilePath
            BinaryConversionInfoBase.AddBinaryFieldDefinition(
                emitterBinary,
                SendModificationTypes.ModifiedDataOnly,
                null,
                new ConverterDefinition(typeof(TextureLocationConverter)),
                null,
                new InputPropertyDefinition("Textures.Texture0.EmitterTextureFileData.FilePath", new Guid("592dc31f-ed3c-4f2b-b100-73e6fbc84159"))
            );

            // Output : reserved0
            // Inputs : None
            BinaryConversionInfoBase.AddFixedSizeFieldDefinition(
                7,
                emitterBinary,
                SendModificationTypes.ModifiedDataOnly,
                null,
                new ConverterDefinition(typeof(DefaultConverter)),
                null
            );

            // Output : guid
            // Inputs : FilePath
            BinaryConversionInfoBase.AddBinaryFieldDefinition(
                emitterBinary,
                SendModificationTypes.FullBinary,
                null,
                new ConverterDefinition(typeof(TextureIDConverter)),
                null,
                new InputPropertyDefinition("Textures.Texture1.EmitterTextureFileData.FilePath", new Guid("592dc31f-ed3c-4f2b-b100-73e6fbc84159"))
            );

            // Output : wrapU
            // Inputs : WrapTypeU
            BinaryConversionInfoBase.AddBinaryFieldDefinition(
                emitterBinary,
                SendModificationTypes.ModifiedDataOnly,
                null,
                new ConverterDefinition(typeof(TypeConversionConverter),
                    new ConverterParam("TargetType", typeof(System.Byte))),
                null,
                new InputPropertyDefinition("Textures.Texture1.EmitterTextureFileData.WrapTypeU", new Guid("3aec6259-dee6-4a34-bf6a-51e5af7ac77f"))
            );

            // Output : wrapV
            // Inputs : WrapTypeV
            BinaryConversionInfoBase.AddBinaryFieldDefinition(
                emitterBinary,
                SendModificationTypes.ModifiedDataOnly,
                null,
                new ConverterDefinition(typeof(TypeConversionConverter),
                    new ConverterParam("TargetType", typeof(System.Byte))),
                null,
                new InputPropertyDefinition("Textures.Texture1.EmitterTextureFileData.WrapTypeV", new Guid("11f32d42-3add-4b70-a56c-b8bdb1dda0bd"))
            );

            // Output : filter
            // Inputs : FilterMode
            BinaryConversionInfoBase.AddBinaryFieldDefinition(
                emitterBinary,
                SendModificationTypes.ModifiedDataOnly,
                null,
                new ConverterDefinition(typeof(TypeConversionConverter),
                    new ConverterParam("TargetType", typeof(System.Byte))),
                null,
                new InputPropertyDefinition("Textures.Texture1.EmitterTextureFileData.FilterMode", new Guid("6883aa33-6884-45f3-ab00-0b096afb0b19"))
            );

            // Output : isSphereMap
            // Inputs : SphericalMap
            BinaryConversionInfoBase.AddBinaryFieldDefinition(
                emitterBinary,
                SendModificationTypes.FullBinary,
                null,
                new ConverterDefinition(typeof(SwitchCaseConverter),
                    new ConverterParam("Cases", new SwitchCase[] { new SwitchCase(true, (byte)1) }),
                    new ConverterParam("DefaultOutput", (byte)0)),
                null,
                new InputPropertyDefinition("Textures.Texture1.EmitterTextureFileData.SphericalMap", new Guid("4a71894b-0f60-41b8-a46b-67b04ade9ac7"))
            );

            // Output : mipLevel
            // Inputs : AvailableMipMapLevel
            BinaryConversionInfoBase.AddBinaryFieldDefinition(
                emitterBinary,
                SendModificationTypes.ModifiedDataOnly,
                null,
                new ConverterDefinition(typeof(DefaultConverter)),
                null,
                new InputPropertyDefinition("Textures.Texture1.EmitterTextureFileData.AvailableMipMapLevel", new Guid("6348c8d1-df8d-4f75-9f33-25c75193a9fb"))
            );

            // Output : mipMapBias
            // Inputs : MipMapBias
            BinaryConversionInfoBase.AddBinaryFieldDefinition(
                emitterBinary,
                SendModificationTypes.ModifiedDataOnly,
                null,
                new ConverterDefinition(typeof(DefaultConverter)),
                null,
                new InputPropertyDefinition("Textures.Texture1.EmitterTextureFileData.MipMapBias", new Guid("e875d783-a6d3-4445-b8c6-a231b4555638"))
            );

            // Output : mipLevelLimit
            // Inputs : MipMapLevelLimit
            BinaryConversionInfoBase.AddBinaryFieldDefinition(
                emitterBinary,
                SendModificationTypes.FullBinary,
                null,
                new ConverterDefinition(typeof(DefaultConverter)),
                null,
                new InputPropertyDefinition("Textures.Texture1.EmitterTextureFileData.MipMapLevelLimit", new Guid("9e949eb5-af3e-40bf-8854-3ca091a58914"))
            );

            // Output : isDensityFixedU
            // Inputs : IsDensityFixedU
            BinaryConversionInfoBase.AddBinaryFieldDefinition(
                emitterBinary,
                SendModificationTypes.FullBinary,
                null,
                new ConverterDefinition(typeof(DefaultConverter)),
                null,
                new InputPropertyDefinition("Textures.Texture1.EmitterTextureOptionData.IsDensityFixedU", new Guid("cf3e87a8-6f05-4bf8-9fb0-066cc1f4ce50"))
            );

            // Output : isDensityFixedV
            // Inputs : IsDensityFixedV
            BinaryConversionInfoBase.AddBinaryFieldDefinition(
                emitterBinary,
                SendModificationTypes.FullBinary,
                null,
                new ConverterDefinition(typeof(DefaultConverter)),
                null,
                new InputPropertyDefinition("Textures.Texture1.EmitterTextureOptionData.IsDensityFixedV", new Guid("b15d5a28-e5ed-456c-a888-c71ee0567ff1"))
            );

            // Output : isSquareRgb
            // Inputs : IsSquareRGB
            BinaryConversionInfoBase.AddBinaryFieldDefinition(
                emitterBinary,
                SendModificationTypes.FullBinary,
                null,
                new ConverterDefinition(typeof(DefaultConverter)),
                null,
                new InputPropertyDefinition("Textures.Texture1.EmitterTextureFileData.IsSquareRGB", new Guid("56196fed-b992-4c32-bbf6-3815dcf1c387"))
            );

            // Output : isOnAnotherBinary
            // Inputs : FilePath
            BinaryConversionInfoBase.AddBinaryFieldDefinition(
                emitterBinary,
                SendModificationTypes.ModifiedDataOnly,
                null,
                new ConverterDefinition(typeof(TextureLocationConverter)),
                null,
                new InputPropertyDefinition("Textures.Texture1.EmitterTextureFileData.FilePath", new Guid("592dc31f-ed3c-4f2b-b100-73e6fbc84159"))
            );

            // Output : reserved0
            // Inputs : None
            BinaryConversionInfoBase.AddFixedSizeFieldDefinition(
                7,
                emitterBinary,
                SendModificationTypes.ModifiedDataOnly,
                null,
                new ConverterDefinition(typeof(DefaultConverter)),
                null
            );

            // Output : guid
            // Inputs : FilePath
            BinaryConversionInfoBase.AddBinaryFieldDefinition(
                emitterBinary,
                SendModificationTypes.FullBinary,
                null,
                new ConverterDefinition(typeof(TextureIDConverter)),
                null,
                new InputPropertyDefinition("Textures.Texture2.EmitterTextureFileData.FilePath", new Guid("592dc31f-ed3c-4f2b-b100-73e6fbc84159"))
            );

            // Output : wrapU
            // Inputs : WrapTypeU
            BinaryConversionInfoBase.AddBinaryFieldDefinition(
                emitterBinary,
                SendModificationTypes.ModifiedDataOnly,
                null,
                new ConverterDefinition(typeof(TypeConversionConverter),
                    new ConverterParam("TargetType", typeof(System.Byte))),
                null,
                new InputPropertyDefinition("Textures.Texture2.EmitterTextureFileData.WrapTypeU", new Guid("3aec6259-dee6-4a34-bf6a-51e5af7ac77f"))
            );

            // Output : wrapV
            // Inputs : WrapTypeV
            BinaryConversionInfoBase.AddBinaryFieldDefinition(
                emitterBinary,
                SendModificationTypes.ModifiedDataOnly,
                null,
                new ConverterDefinition(typeof(TypeConversionConverter),
                    new ConverterParam("TargetType", typeof(System.Byte))),
                null,
                new InputPropertyDefinition("Textures.Texture2.EmitterTextureFileData.WrapTypeV", new Guid("11f32d42-3add-4b70-a56c-b8bdb1dda0bd"))
            );

            // Output : filter
            // Inputs : FilterMode
            BinaryConversionInfoBase.AddBinaryFieldDefinition(
                emitterBinary,
                SendModificationTypes.ModifiedDataOnly,
                null,
                new ConverterDefinition(typeof(TypeConversionConverter),
                    new ConverterParam("TargetType", typeof(System.Byte))),
                null,
                new InputPropertyDefinition("Textures.Texture2.EmitterTextureFileData.FilterMode", new Guid("6883aa33-6884-45f3-ab00-0b096afb0b19"))
            );

            // Output : isSphereMap
            // Inputs : SphericalMap
            BinaryConversionInfoBase.AddBinaryFieldDefinition(
                emitterBinary,
                SendModificationTypes.FullBinary,
                null,
                new ConverterDefinition(typeof(SwitchCaseConverter),
                    new ConverterParam("Cases", new SwitchCase[] { new SwitchCase(true, (byte)1) }),
                    new ConverterParam("DefaultOutput", (byte)0)),
                null,
                new InputPropertyDefinition("Textures.Texture2.EmitterTextureFileData.SphericalMap", new Guid("4a71894b-0f60-41b8-a46b-67b04ade9ac7"))
            );

            // Output : mipLevel
            // Inputs : AvailableMipMapLevel
            BinaryConversionInfoBase.AddBinaryFieldDefinition(
                emitterBinary,
                SendModificationTypes.ModifiedDataOnly,
                null,
                new ConverterDefinition(typeof(DefaultConverter)),
                null,
                new InputPropertyDefinition("Textures.Texture2.EmitterTextureFileData.AvailableMipMapLevel", new Guid("6348c8d1-df8d-4f75-9f33-25c75193a9fb"))
            );

            // Output : mipMapBias
            // Inputs : MipMapBias
            BinaryConversionInfoBase.AddBinaryFieldDefinition(
                emitterBinary,
                SendModificationTypes.ModifiedDataOnly,
                null,
                new ConverterDefinition(typeof(DefaultConverter)),
                null,
                new InputPropertyDefinition("Textures.Texture2.EmitterTextureFileData.MipMapBias", new Guid("e875d783-a6d3-4445-b8c6-a231b4555638"))
            );

            // Output : mipLevelLimit
            // Inputs : MipMapLevelLimit
            BinaryConversionInfoBase.AddBinaryFieldDefinition(
                emitterBinary,
                SendModificationTypes.FullBinary,
                null,
                new ConverterDefinition(typeof(DefaultConverter)),
                null,
                new InputPropertyDefinition("Textures.Texture2.EmitterTextureFileData.MipMapLevelLimit", new Guid("9e949eb5-af3e-40bf-8854-3ca091a58914"))
            );

            // Output : isDensityFixedU
            // Inputs : IsDensityFixedU
            BinaryConversionInfoBase.AddBinaryFieldDefinition(
                emitterBinary,
                SendModificationTypes.FullBinary,
                null,
                new ConverterDefinition(typeof(DefaultConverter)),
                null,
                new InputPropertyDefinition("Textures.Texture2.EmitterTextureOptionData.IsDensityFixedU", new Guid("cf3e87a8-6f05-4bf8-9fb0-066cc1f4ce50"))
            );

            // Output : isDensityFixedV
            // Inputs : IsDensityFixedV
            BinaryConversionInfoBase.AddBinaryFieldDefinition(
                emitterBinary,
                SendModificationTypes.FullBinary,
                null,
                new ConverterDefinition(typeof(DefaultConverter)),
                null,
                new InputPropertyDefinition("Textures.Texture2.EmitterTextureOptionData.IsDensityFixedV", new Guid("b15d5a28-e5ed-456c-a888-c71ee0567ff1"))
            );

            // Output : isSquareRgb
            // Inputs : IsSquareRGB
            BinaryConversionInfoBase.AddBinaryFieldDefinition(
                emitterBinary,
                SendModificationTypes.FullBinary,
                null,
                new ConverterDefinition(typeof(DefaultConverter)),
                null,
                new InputPropertyDefinition("Textures.Texture2.EmitterTextureFileData.IsSquareRGB", new Guid("56196fed-b992-4c32-bbf6-3815dcf1c387"))
            );

            // Output : isOnAnotherBinary
            // Inputs : FilePath
            BinaryConversionInfoBase.AddBinaryFieldDefinition(
                emitterBinary,
                SendModificationTypes.ModifiedDataOnly,
                null,
                new ConverterDefinition(typeof(TextureLocationConverter)),
                null,
                new InputPropertyDefinition("Textures.Texture2.EmitterTextureFileData.FilePath", new Guid("592dc31f-ed3c-4f2b-b100-73e6fbc84159"))
            );

            // Output : reserved0
            // Inputs : None
            BinaryConversionInfoBase.AddFixedSizeFieldDefinition(
                7,
                emitterBinary,
                SendModificationTypes.ModifiedDataOnly,
                null,
                new ConverterDefinition(typeof(DefaultConverter)),
                null
            );

            // Output : patternAnimType
            // Inputs : PatternAnimType
            BinaryConversionInfoBase.AddBinaryFieldDefinition(
                emitterBinary,
                SendModificationTypes.FullBinary,
                null,
                new ConverterDefinition(typeof(TypeConversionConverter),
                    new ConverterParam("TargetType", typeof(System.Byte))),
                null,
                new InputPropertyDefinition("Textures.Texture0.EmitterTexturePatternAnimationData.PatternAnimType", new Guid("dabd4b10-4cd5-4a0b-bc00-ee99e2aa5ff1"))
            );

            // Output : isScroll
            // Inputs : EnableUvScrollAnimation
            BinaryConversionInfoBase.AddBinaryFieldDefinition(
                emitterBinary,
                SendModificationTypes.FullBinary,
                null,
                new ConverterDefinition(typeof(SwitchCaseConverter),
                    new ConverterParam("Cases", new SwitchCase[] { new SwitchCase(true, (byte)1) }),
                    new ConverterParam("DefaultOutput", (byte)0)),
                null,
                new InputPropertyDefinition("Textures.Texture0.EmitterTextureUvAnimationData.EnableUvScrollAnimation", new Guid("462d0a1f-35dd-4519-bfe6-21912d553e14"))
            );

            // Output : isRotate
            // Inputs : EnableUvRotAnimation
            BinaryConversionInfoBase.AddBinaryFieldDefinition(
                emitterBinary,
                SendModificationTypes.ModifiedDataOnly,
                null,
                new ConverterDefinition(typeof(SwitchCaseConverter),
                    new ConverterParam("Cases", new SwitchCase[] { new SwitchCase(true, (byte)1) }),
                    new ConverterParam("DefaultOutput", (byte)0)),
                null,
                new InputPropertyDefinition("Textures.Texture0.EmitterTextureUvAnimationData.EnableUvRotAnimation", new Guid("6c04e929-236d-445a-a001-af02b34fbb97"))
            );

            // Output : isScale
            // Inputs : EnableUvScaleAnimation
            BinaryConversionInfoBase.AddBinaryFieldDefinition(
                emitterBinary,
                SendModificationTypes.FullBinary,
                null,
                new ConverterDefinition(typeof(SwitchCaseConverter),
                    new ConverterParam("Cases", new SwitchCase[] { new SwitchCase(true, (byte)1) }),
                    new ConverterParam("DefaultOutput", (byte)0)),
                null,
                new InputPropertyDefinition("Textures.Texture0.EmitterTextureUvAnimationData.EnableUvScaleAnimation", new Guid("23974ff9-26cc-4494-be63-4db604a517ba"))
            );

            // Output : repeat
            // Inputs : RepeatCount
            BinaryConversionInfoBase.AddBinaryFieldDefinition(
                emitterBinary,
                SendModificationTypes.ModifiedDataOnly,
                null,
                new ConverterDefinition(typeof(TypeConversionConverter),
                    new ConverterParam("TargetType", typeof(System.Byte))),
                null,
                new InputPropertyDefinition("Textures.Texture0.EmitterTextureFileData.RepeatCount", new Guid("496e1963-6dbc-42aa-b567-a7edbe4fe727"))
            );

            // Output : invRandU
            // Inputs : RandomInvU
            BinaryConversionInfoBase.AddBinaryFieldDefinition(
                emitterBinary,
                SendModificationTypes.ModifiedDataOnly,
                null,
                new ConverterDefinition(typeof(SwitchCaseConverter),
                    new ConverterParam("Cases", new SwitchCase[] { new SwitchCase(true, (byte)1) }),
                    new ConverterParam("DefaultOutput", (byte)0)),
                null,
                new InputPropertyDefinition("Textures.Texture0.EmitterTextureFileData.RandomInvU", new Guid("54106bc9-6043-4768-9f9b-4e2b3df502cd"))
            );

            // Output : invRandV
            // Inputs : RandomInvV
            BinaryConversionInfoBase.AddBinaryFieldDefinition(
                emitterBinary,
                SendModificationTypes.ModifiedDataOnly,
                null,
                new ConverterDefinition(typeof(SwitchCaseConverter),
                    new ConverterParam("Cases", new SwitchCase[] { new SwitchCase(true, (byte)1) }),
                    new ConverterParam("DefaultOutput", (byte)0)),
                null,
                new InputPropertyDefinition("Textures.Texture0.EmitterTextureFileData.RandomInvV", new Guid("f5234fc9-f48b-4b23-b501-20061d344d81"))
            );

            // Output : isPatAnimLoopRandom
            // Inputs : EnableSimpleTableRandom
            BinaryConversionInfoBase.AddBinaryFieldDefinition(
                emitterBinary,
                SendModificationTypes.ModifiedDataOnly,
                null,
                new ConverterDefinition(typeof(SwitchCaseConverter),
                    new ConverterParam("Cases", new SwitchCase[] { new SwitchCase(true, (byte)1) }),
                    new ConverterParam("DefaultOutput", (byte)0)),
                null,
                new InputPropertyDefinition("Textures.Texture0.EmitterTexturePatternAnimationData.EnableSimpleTableRandom", new Guid("447492e2-2562-421b-8e4a-f38e05c90476"))
            );

            // Output : uvChannel
            // Inputs : UvChannel
            BinaryConversionInfoBase.AddBinaryFieldDefinition(
                emitterBinary,
                SendModificationTypes.FullBinary,
                null,
                new ConverterDefinition(typeof(TypeConversionConverter),
                    new ConverterParam("TargetType", typeof(System.Byte))),
                null,
                new InputPropertyDefinition("Textures.Texture0.EmitterTextureFileData.UvChannel", new Guid("310db07a-7857-4d95-a964-a7ff14fe50df"))
            );

            // Output : isCrossfade
            // Inputs : EnableCrossfade
            BinaryConversionInfoBase.AddBinaryFieldDefinition(
                emitterBinary,
                SendModificationTypes.FullBinary,
                null,
                new ConverterDefinition(typeof(SwitchCaseConverter),
                    new ConverterParam("Cases", new SwitchCase[] { new SwitchCase(true, (byte)1) }),
                    new ConverterParam("DefaultOutput", (byte)0)),
                null,
                new InputPropertyDefinition("Textures.Texture0.EmitterTexturePatternAnimationData.EnableCrossfade", new Guid("cde2a639-99ed-480e-8f85-fe18967e6f89"))
            );

            // Output : reserved0
            // Inputs : None
            BinaryConversionInfoBase.AddFixedSizeFieldDefinition(
                6,
                emitterBinary,
                SendModificationTypes.ModifiedDataOnly,
                null,
                new ConverterDefinition(typeof(DefaultConverter)),
                null
            );

            // Output : patternAnimType
            // Inputs : PatternAnimType
            BinaryConversionInfoBase.AddBinaryFieldDefinition(
                emitterBinary,
                SendModificationTypes.FullBinary,
                null,
                new ConverterDefinition(typeof(TypeConversionConverter),
                    new ConverterParam("TargetType", typeof(System.Byte))),
                null,
                new InputPropertyDefinition("Textures.Texture1.EmitterTexturePatternAnimationData.PatternAnimType", new Guid("dabd4b10-4cd5-4a0b-bc00-ee99e2aa5ff1"))
            );

            // Output : isScroll
            // Inputs : EnableUvScrollAnimation
            BinaryConversionInfoBase.AddBinaryFieldDefinition(
                emitterBinary,
                SendModificationTypes.FullBinary,
                null,
                new ConverterDefinition(typeof(SwitchCaseConverter),
                    new ConverterParam("Cases", new SwitchCase[] { new SwitchCase(true, (byte)1) }),
                    new ConverterParam("DefaultOutput", (byte)0)),
                null,
                new InputPropertyDefinition("Textures.Texture1.EmitterTextureUvAnimationData.EnableUvScrollAnimation", new Guid("462d0a1f-35dd-4519-bfe6-21912d553e14"))
            );

            // Output : isRotate
            // Inputs : EnableUvRotAnimation
            BinaryConversionInfoBase.AddBinaryFieldDefinition(
                emitterBinary,
                SendModificationTypes.FullBinary,
                null,
                new ConverterDefinition(typeof(SwitchCaseConverter),
                    new ConverterParam("Cases", new SwitchCase[] { new SwitchCase(true, (byte)1) }),
                    new ConverterParam("DefaultOutput", (byte)0)),
                null,
                new InputPropertyDefinition("Textures.Texture1.EmitterTextureUvAnimationData.EnableUvRotAnimation", new Guid("6c04e929-236d-445a-a001-af02b34fbb97"))
            );

            // Output : isScale
            // Inputs : EnableUvScaleAnimation
            BinaryConversionInfoBase.AddBinaryFieldDefinition(
                emitterBinary,
                SendModificationTypes.FullBinary,
                null,
                new ConverterDefinition(typeof(SwitchCaseConverter),
                    new ConverterParam("Cases", new SwitchCase[] { new SwitchCase(true, (byte)1) }),
                    new ConverterParam("DefaultOutput", (byte)0)),
                null,
                new InputPropertyDefinition("Textures.Texture1.EmitterTextureUvAnimationData.EnableUvScaleAnimation", new Guid("23974ff9-26cc-4494-be63-4db604a517ba"))
            );

            // Output : repeat
            // Inputs : RepeatCount
            BinaryConversionInfoBase.AddBinaryFieldDefinition(
                emitterBinary,
                SendModificationTypes.ModifiedDataOnly,
                null,
                new ConverterDefinition(typeof(TypeConversionConverter),
                    new ConverterParam("TargetType", typeof(System.Byte))),
                null,
                new InputPropertyDefinition("Textures.Texture1.EmitterTextureFileData.RepeatCount", new Guid("496e1963-6dbc-42aa-b567-a7edbe4fe727"))
            );

            // Output : invRandU
            // Inputs : RandomInvU
            BinaryConversionInfoBase.AddBinaryFieldDefinition(
                emitterBinary,
                SendModificationTypes.ModifiedDataOnly,
                null,
                new ConverterDefinition(typeof(SwitchCaseConverter),
                    new ConverterParam("Cases", new SwitchCase[] { new SwitchCase(true, (byte)1) }),
                    new ConverterParam("DefaultOutput", (byte)0)),
                null,
                new InputPropertyDefinition("Textures.Texture1.EmitterTextureFileData.RandomInvU", new Guid("54106bc9-6043-4768-9f9b-4e2b3df502cd"))
            );

            // Output : invRandV
            // Inputs : RandomInvV
            BinaryConversionInfoBase.AddBinaryFieldDefinition(
                emitterBinary,
                SendModificationTypes.ModifiedDataOnly,
                null,
                new ConverterDefinition(typeof(SwitchCaseConverter),
                    new ConverterParam("DefaultOutput", (byte)0),
                    new ConverterParam("Cases", new SwitchCase[] { new SwitchCase(true, (byte)1) })),
                null,
                new InputPropertyDefinition("Textures.Texture1.EmitterTextureFileData.RandomInvV", new Guid("f5234fc9-f48b-4b23-b501-20061d344d81"))
            );

            // Output : isPatAnimLoopRandom
            // Inputs : EnableSimpleTableRandom
            BinaryConversionInfoBase.AddBinaryFieldDefinition(
                emitterBinary,
                SendModificationTypes.ModifiedDataOnly,
                null,
                new ConverterDefinition(typeof(SwitchCaseConverter),
                    new ConverterParam("Cases", new SwitchCase[] { new SwitchCase(true, (byte)1) }),
                    new ConverterParam("DefaultOutput", (byte)0)),
                null,
                new InputPropertyDefinition("Textures.Texture1.EmitterTexturePatternAnimationData.EnableSimpleTableRandom", new Guid("447492e2-2562-421b-8e4a-f38e05c90476"))
            );

            // Output : uvChannel
            // Inputs : UvChannel
            BinaryConversionInfoBase.AddBinaryFieldDefinition(
                emitterBinary,
                SendModificationTypes.FullBinary,
                null,
                new ConverterDefinition(typeof(TypeConversionConverter),
                    new ConverterParam("TargetType", typeof(System.Byte))),
                null,
                new InputPropertyDefinition("Textures.Texture1.EmitterTextureFileData.UvChannel", new Guid("310db07a-7857-4d95-a964-a7ff14fe50df"))
            );

            // Output : isCrossfade
            // Inputs : EnableCrossfade
            BinaryConversionInfoBase.AddBinaryFieldDefinition(
                emitterBinary,
                SendModificationTypes.FullBinary,
                null,
                new ConverterDefinition(typeof(SwitchCaseConverter),
                    new ConverterParam("Cases", new SwitchCase[] { new SwitchCase(true, (byte)1) }),
                    new ConverterParam("DefaultOutput", (byte)0)),
                null,
                new InputPropertyDefinition("Textures.Texture1.EmitterTexturePatternAnimationData.EnableCrossfade", new Guid("cde2a639-99ed-480e-8f85-fe18967e6f89"))
            );

            // Output : reserved0
            // Inputs : None
            BinaryConversionInfoBase.AddFixedSizeFieldDefinition(
                6,
                emitterBinary,
                SendModificationTypes.ModifiedDataOnly,
                null,
                new ConverterDefinition(typeof(DefaultConverter)),
                null
            );

            // Output : patternAnimType
            // Inputs : PatternAnimType
            BinaryConversionInfoBase.AddBinaryFieldDefinition(
                emitterBinary,
                SendModificationTypes.FullBinary,
                null,
                new ConverterDefinition(typeof(TypeConversionConverter),
                    new ConverterParam("TargetType", typeof(System.Byte))),
                null,
                new InputPropertyDefinition("Textures.Texture2.EmitterTexturePatternAnimationData.PatternAnimType", new Guid("dabd4b10-4cd5-4a0b-bc00-ee99e2aa5ff1"))
            );

            // Output : isScroll
            // Inputs : EnableUvScrollAnimation
            BinaryConversionInfoBase.AddBinaryFieldDefinition(
                emitterBinary,
                SendModificationTypes.FullBinary,
                null,
                new ConverterDefinition(typeof(SwitchCaseConverter),
                    new ConverterParam("Cases", new SwitchCase[] { new SwitchCase(true, (byte)1) }),
                    new ConverterParam("DefaultOutput", (byte)0)),
                null,
                new InputPropertyDefinition("Textures.Texture2.EmitterTextureUvAnimationData.EnableUvScrollAnimation", new Guid("462d0a1f-35dd-4519-bfe6-21912d553e14"))
            );

            // Output : isRotate
            // Inputs : EnableUvRotAnimation
            BinaryConversionInfoBase.AddBinaryFieldDefinition(
                emitterBinary,
                SendModificationTypes.FullBinary,
                null,
                new ConverterDefinition(typeof(SwitchCaseConverter),
                    new ConverterParam("Cases", new SwitchCase[] { new SwitchCase(true, (byte)1) }),
                    new ConverterParam("DefaultOutput", (byte)0)),
                null,
                new InputPropertyDefinition("Textures.Texture2.EmitterTextureUvAnimationData.EnableUvRotAnimation", new Guid("6c04e929-236d-445a-a001-af02b34fbb97"))
            );

            // Output : isScale
            // Inputs : EnableUvScaleAnimation
            BinaryConversionInfoBase.AddBinaryFieldDefinition(
                emitterBinary,
                SendModificationTypes.FullBinary,
                null,
                new ConverterDefinition(typeof(SwitchCaseConverter),
                    new ConverterParam("Cases", new SwitchCase[] { new SwitchCase(true, (byte)1) }),
                    new ConverterParam("DefaultOutput", (byte)0)),
                null,
                new InputPropertyDefinition("Textures.Texture2.EmitterTextureUvAnimationData.EnableUvScaleAnimation", new Guid("23974ff9-26cc-4494-be63-4db604a517ba"))
            );

            // Output : repeat
            // Inputs : RepeatCount
            BinaryConversionInfoBase.AddBinaryFieldDefinition(
                emitterBinary,
                SendModificationTypes.ModifiedDataOnly,
                null,
                new ConverterDefinition(typeof(TypeConversionConverter),
                    new ConverterParam("TargetType", typeof(System.Byte))),
                null,
                new InputPropertyDefinition("Textures.Texture2.EmitterTextureFileData.RepeatCount", new Guid("496e1963-6dbc-42aa-b567-a7edbe4fe727"))
            );

            // Output : invRandU
            // Inputs : RandomInvU
            BinaryConversionInfoBase.AddBinaryFieldDefinition(
                emitterBinary,
                SendModificationTypes.ModifiedDataOnly,
                null,
                new ConverterDefinition(typeof(SwitchCaseConverter),
                    new ConverterParam("Cases", new SwitchCase[] { new SwitchCase(true, (byte)1) }),
                    new ConverterParam("DefaultOutput", (byte)0)),
                null,
                new InputPropertyDefinition("Textures.Texture2.EmitterTextureFileData.RandomInvU", new Guid("54106bc9-6043-4768-9f9b-4e2b3df502cd"))
            );

            // Output : invRandV
            // Inputs : RandomInvV
            BinaryConversionInfoBase.AddBinaryFieldDefinition(
                emitterBinary,
                SendModificationTypes.ModifiedDataOnly,
                null,
                new ConverterDefinition(typeof(SwitchCaseConverter),
                    new ConverterParam("Cases", new SwitchCase[] { new SwitchCase(true, (byte)1) }),
                    new ConverterParam("DefaultOutput", (byte)0)),
                null,
                new InputPropertyDefinition("Textures.Texture2.EmitterTextureFileData.RandomInvV", new Guid("f5234fc9-f48b-4b23-b501-20061d344d81"))
            );

            // Output : isPatAnimLoopRandom
            // Inputs : EnableSimpleTableRandom
            BinaryConversionInfoBase.AddBinaryFieldDefinition(
                emitterBinary,
                SendModificationTypes.ModifiedDataOnly,
                null,
                new ConverterDefinition(typeof(SwitchCaseConverter),
                    new ConverterParam("Cases", new SwitchCase[] { new SwitchCase(true, (byte)1) }),
                    new ConverterParam("DefaultOutput", (byte)0)),
                null,
                new InputPropertyDefinition("Textures.Texture2.EmitterTexturePatternAnimationData.EnableSimpleTableRandom", new Guid("447492e2-2562-421b-8e4a-f38e05c90476"))
            );

            // Output : uvChannel
            // Inputs : UvChannel
            BinaryConversionInfoBase.AddBinaryFieldDefinition(
                emitterBinary,
                SendModificationTypes.FullBinary,
                null,
                new ConverterDefinition(typeof(TypeConversionConverter),
                    new ConverterParam("TargetType", typeof(System.Byte))),
                null,
                new InputPropertyDefinition("Textures.Texture2.EmitterTextureFileData.UvChannel", new Guid("310db07a-7857-4d95-a964-a7ff14fe50df"))
            );

            // Output : isCrossfade
            // Inputs : EnableCrossfade
            BinaryConversionInfoBase.AddBinaryFieldDefinition(
                emitterBinary,
                SendModificationTypes.FullBinary,
                null,
                new ConverterDefinition(typeof(SwitchCaseConverter),
                    new ConverterParam("Cases", new SwitchCase[] { new SwitchCase(true, (byte)1) }),
                    new ConverterParam("DefaultOutput", (byte)0)),
                null,
                new InputPropertyDefinition("Textures.Texture2.EmitterTexturePatternAnimationData.EnableCrossfade", new Guid("cde2a639-99ed-480e-8f85-fe18967e6f89"))
            );

            // Output : reserved0
            // Inputs : None
            BinaryConversionInfoBase.AddFixedSizeFieldDefinition(
                6,
                emitterBinary,
                SendModificationTypes.ModifiedDataOnly,
                null,
                new ConverterDefinition(typeof(DefaultConverter)),
                null
            );

            // Output : reservedArea
            // Inputs : None
            BinaryConversionInfoBase.AddFixedSizeFieldDefinition(
                64,
                emitterBinary,
                SendModificationTypes.ModifiedDataOnly,
                null,
                new ConverterDefinition(typeof(DefaultConverter)),
                null
            );

            var emitterCustomShaderBinary = new BinaryStructDefinition(null) { HasBinaryHeader = true };

            // Output : EmitterCustomShaderBinary
            // Inputs : SelectedSettingData
            BinaryConversionInfoBase.AddSelectBinaryDataFieldDefinition(
                emitterBinary,
                SendModificationTypes.FullBinary,
                null,
                new ConverterDefinition(typeof(AssignDataModelConverter)),
                emitterCustomShaderBinary,
                new InputPropertyDefinition("EmitterCustomShaderData.SelectedSettingData", new Guid("ee0ac50f-ec8d-4a96-aa25-7c3db40e6e3a"))
            );

            var customActionBinary = new BinaryStructDefinition(null) { HasBinaryHeader = true };

            // Output : CustomActionBinary
            // Inputs : ActiveCustomActionData
            BinaryConversionInfoBase.AddSelectBinaryDataFieldDefinition(
                emitterBinary,
                SendModificationTypes.FullBinary,
                null,
                new ConverterDefinition(typeof(AssignDataModelConverter)),
                customActionBinary,
                new InputPropertyDefinition("ActiveCustomActionData", new Guid("cbe4243a-377e-4e22-ad44-ae452c7267b4"))
            );

            var emitterExtParamsBinary = new BinaryStructDefinition(null) { HasBinaryHeader = true };

            // Output : EmitterExtParamsBinary
            // Inputs : SelectedEmitterExtParams
            BinaryConversionInfoBase.AddSelectBinaryDataFieldDefinition(
                emitterBinary,
                SendModificationTypes.FullBinary,
                null,
                new ConverterDefinition(typeof(AssignDataModelConverter)),
                emitterExtParamsBinary,
                new InputPropertyDefinition("SelectedEmitterExtParams", new Guid("43f1f93b-04a0-46fe-93a1-d7e6c450a665"))
            );

            var reservedShaderBinary = new BinaryStructDefinition(typeof(ReservedShaderNodeData)) { HasBinaryHeader = true };

            // Output : ReservedShaderBinary
            // Inputs : ActiveReservedShader
            BinaryConversionInfoBase.AddBinaryFieldDefinition(
                emitterBinary,
                SendModificationTypes.FullBinary,
                null,
                new ConverterDefinition(typeof(AssignDataModelConverter)),
                reservedShaderBinary,
                new InputPropertyDefinition("ActiveReservedShader", new Guid("5422149a-1c2c-4d4e-a5d0-bc8edeb11d36"))
            );

            var fieldListBinary = new BinaryStructDefinition(null) { HasBinaryHeader = true };

            // Output : FieldListBinary
            // Inputs : ActiveFieldList
            BinaryConversionInfoBase.AddSelectBinaryDataFieldDefinition(
                emitterBinary,
                SendModificationTypes.FullBinary,
                null,
                new ConverterDefinition(typeof(AssignDataModelConverter)),
                fieldListBinary,
                new InputPropertyDefinition("ActiveFieldList", new Guid("5b83601a-5d32-476c-84cb-9ae09e1c07e0"))
            );

            var emitterAnimationListBinary = new BinaryStructDefinition(null) { HasBinaryHeader = true };

            // Output : EmitterAnimationListBinary
            // Inputs : ActiveEmitterAnimationList
            BinaryConversionInfoBase.AddSelectBinaryDataFieldDefinition(
                emitterBinary,
                SendModificationTypes.FullBinary,
                null,
                new ConverterDefinition(typeof(AssignDataModelConverter)),
                emitterAnimationListBinary,
                new InputPropertyDefinition("ActiveEmitterAnimationList", new Guid("bdec19c8-3bdb-44b2-8e8f-6a2d70486f81"))
            );

            var emitterSetBinary = new BinaryStructDefinition(typeof(EmitterSetData)) { HasBinaryHeader = true };

            // Output : flag
            // Inputs : None
            BinaryConversionInfoBase.AddFixedSizeFieldDefinition(
                4,
                emitterSetBinary,
                SendModificationTypes.ModifiedDataOnly,
                null,
                new ConverterDefinition(typeof(DefaultConverter)),
                null
            );

            // Output : randomSeed
            // Inputs : None
            BinaryConversionInfoBase.AddFixedSizeFieldDefinition(
                4,
                emitterSetBinary,
                SendModificationTypes.ModifiedDataOnly,
                null,
                new ConverterDefinition(typeof(DefaultConverter)),
                null
            );

            // Output : reserved0
            // Inputs : None
            BinaryConversionInfoBase.AddFixedSizeFieldDefinition(
                8,
                emitterSetBinary,
                SendModificationTypes.ModifiedDataOnly,
                null,
                new ConverterDefinition(typeof(DefaultConverter)),
                null
            );

            // Output : name
            // Inputs : Name
            BinaryConversionInfoBase.AddBinaryFieldDefinition(
                emitterSetBinary,
                SendModificationTypes.ModifiedDataOnly,
                null,
                new ConverterDefinition(typeof(FixSizeStringConverter),
                    new ConverterParam("CharArrayLength", 64)),
                null,
                new InputPropertyDefinition("Name", new Guid("0b3a8c4e-2327-4f8d-8384-6139531dd500"))
            );

            // Output : emitterAllNum
            // Inputs : AllActiveChildEmitters
            BinaryConversionInfoBase.AddBinaryFieldDefinition(
                emitterSetBinary,
                SendModificationTypes.ModifiedDataOnly,
                null,
                new ConverterDefinition(typeof(CollectionCountConverter)),
                null,
                new InputPropertyDefinition("AllActiveChildEmitters", new Guid("6536aa93-6224-4aeb-958d-ae1cc3f9b3ca"))
            );

            // Output : UserDataBit
            // Inputs : Flags
            BinaryConversionInfoBase.AddBinaryFieldDefinition(
                emitterSetBinary,
                SendModificationTypes.ModifiedDataOnly,
                null,
                new ConverterDefinition(typeof(DefaultConverter)),
                null,
                new InputPropertyDefinition("EmitterSetUserData.EmitterSetUserFlagData.Flags", new Guid("9a3814b8-b0c4-4e80-a25e-e7e2962d99a8"))
            );

            // Output : reserved0
            // Inputs : None
            BinaryConversionInfoBase.AddFixedSizeFieldDefinition(
                2,
                emitterSetBinary,
                SendModificationTypes.ModifiedDataOnly,
                null,
                new ConverterDefinition(typeof(DefaultConverter)),
                null
            );

            // Output : UserDataValue1
            // Inputs : Value1
            BinaryConversionInfoBase.AddBinaryFieldDefinition(
                emitterSetBinary,
                SendModificationTypes.ModifiedDataOnly,
                null,
                new ConverterDefinition(typeof(DefaultConverter)),
                null,
                new InputPropertyDefinition("EmitterSetUserData.EmitterSetUserValueData.Value1", new Guid("9f4e5ccf-9ff5-4d89-a3f6-0196769f27ae"))
            );

            // Output : UserDataValue2
            // Inputs : Value2
            BinaryConversionInfoBase.AddBinaryFieldDefinition(
                emitterSetBinary,
                SendModificationTypes.ModifiedDataOnly,
                null,
                new ConverterDefinition(typeof(DefaultConverter)),
                null,
                new InputPropertyDefinition("EmitterSetUserData.EmitterSetUserValueData.Value2", new Guid("f989e311-e919-4996-a0e8-c952f1524bf1"))
            );

            // Output : UserDataValue3
            // Inputs : Value3
            BinaryConversionInfoBase.AddBinaryFieldDefinition(
                emitterSetBinary,
                SendModificationTypes.ModifiedDataOnly,
                null,
                new ConverterDefinition(typeof(DefaultConverter)),
                null,
                new InputPropertyDefinition("EmitterSetUserData.EmitterSetUserValueData.Value3", new Guid("cf5246af-0f56-49c7-b210-fd8ff4947068"))
            );

            // Output : UserDataValue4
            // Inputs : Value4
            BinaryConversionInfoBase.AddBinaryFieldDefinition(
                emitterSetBinary,
                SendModificationTypes.ModifiedDataOnly,
                null,
                new ConverterDefinition(typeof(DefaultConverter)),
                null,
                new InputPropertyDefinition("EmitterSetUserData.EmitterSetUserValueData.Value4", new Guid("6a2eca1c-3abc-4773-b4f4-ff7dc08bd44f"))
            );

            // Output : EmitterBinary
            // Inputs : AllActiveChildEmitters
            BinaryConversionInfoBase.AddBinaryFieldDefinition(
                emitterSetBinary,
                SendModificationTypes.FullBinary,
                null,
                new ConverterDefinition(typeof(AssignDataModelConverter)),
                emitterBinary,
                new InputPropertyDefinition("AllActiveChildEmitters", new Guid("6536aa93-6224-4aeb-958d-ae1cc3f9b3ca"))
            );

            var addLocationFieldBinary = new BinaryStructDefinition(typeof(AddLocationData)) { HasBinaryHeader = true };

            // Output : isFieldPosAddGlobal
            // Inputs : AddGlobal
            BinaryConversionInfoBase.AddBinaryFieldDefinition(
                addLocationFieldBinary,
                SendModificationTypes.ModifiedDataOnly,
                null,
                new ConverterDefinition(typeof(SwitchCaseConverter),
                    new ConverterParam("Cases", new SwitchCase[] { new SwitchCase(true, (byte)1) }),
                    new ConverterParam("DefaultOutput", (byte)0)),
                null,
                new InputPropertyDefinition("FieldAddLocationParam.AddGlobal", new Guid("7d76d9a8-4678-45db-9ff2-93ef369d0d8d"))
            );

            // Output : reserved0
            // Inputs : None
            BinaryConversionInfoBase.AddFixedSizeFieldDefinition(
                3,
                addLocationFieldBinary,
                SendModificationTypes.ModifiedDataOnly,
                null,
                new ConverterDefinition(typeof(DefaultConverter)),
                null
            );

            // Output : fieldPosAdd
            // Inputs : Addition
            BinaryConversionInfoBase.AddBinaryFieldDefinition(
                addLocationFieldBinary,
                SendModificationTypes.ModifiedDataOnly,
                null,
                new ConverterDefinition(typeof(DefaultConverter)),
                null,
                new InputPropertyDefinition("FieldAddLocationParam.Addition", new Guid("ffcb33b5-660b-4e6d-b74c-d03801097de3"))
            );

            // Output : enable
            // Inputs : EnableAnimation
            BinaryConversionInfoBase.AddBinaryFieldDefinition(
                addLocationFieldBinary,
                SendModificationTypes.ModifiedDataOnly,
                null,
                new ConverterDefinition(typeof(DefaultConverter)),
                null,
                new InputPropertyDefinition("FieldAddLocationParam.EnableAnimation", new Guid("036d10aa-8d95-416b-8a48-492990e7e6de"))
            );

            // Output : loop
            // Inputs : LoopMode
            BinaryConversionInfoBase.AddBinaryFieldDefinition(
                addLocationFieldBinary,
                SendModificationTypes.ModifiedDataOnly,
                null,
                new ConverterDefinition(typeof(DefaultConverter)),
                null,
                new InputPropertyDefinition("FieldAddLocationParam.LoopMode", new Guid("6cc3a5b5-c68f-4771-95fa-39e69438e128"))
            );

            // Output : startRandom
            // Inputs : Randomize
            BinaryConversionInfoBase.AddBinaryFieldDefinition(
                addLocationFieldBinary,
                SendModificationTypes.ModifiedDataOnly,
                null,
                new ConverterDefinition(typeof(DefaultConverter)),
                null,
                new InputPropertyDefinition("FieldAddLocationParam.Randomize", new Guid("e8cebe60-47a0-4ff2-afe8-0f4a20125f9a"))
            );

            // Output : keyNum
            // Inputs : AnimationTable
            BinaryConversionInfoBase.AddBinaryFieldDefinition(
                addLocationFieldBinary,
                SendModificationTypes.ModifiedDataOnly,
                null,
                new ConverterDefinition(typeof(AnimationTableCountConverter)),
                null,
                new InputPropertyDefinition("FieldAddLocationParam.AnimationTable", new Guid("7b091aff-4c7f-4820-9a27-b31f5274875e"))
            );

            // Output : loopNum
            // Inputs : LoopEnd
            BinaryConversionInfoBase.AddBinaryFieldDefinition(
                addLocationFieldBinary,
                SendModificationTypes.ModifiedDataOnly,
                null,
                new ConverterDefinition(typeof(DefaultConverter)),
                null,
                new InputPropertyDefinition("FieldAddLocationParam.LoopEnd", new Guid("8e8b9076-d30b-4e4d-a410-dba9d884b928"))
            );

            // Output : keyValue
            // Inputs : AnimationTable
            BinaryConversionInfoBase.AddBinaryFieldDefinition(
                addLocationFieldBinary,
                SendModificationTypes.ModifiedDataOnly,
                null,
                new ConverterDefinition(typeof(AnimationTableConverter),
                    new ConverterParam("MaxKeyFrameCount", 8),
                    new ConverterParam("FrameConvertMode", 0)),
                null,
                new InputPropertyDefinition("FieldAddLocationParam.AnimationTable", new Guid("7b091aff-4c7f-4820-9a27-b31f5274875e"))
            );

            var collisionFieldBinary = new BinaryStructDefinition(typeof(CollisionData)) { HasBinaryHeader = true };

            // Output : fieldCollisionType
            // Inputs : ActionType
            BinaryConversionInfoBase.AddBinaryFieldDefinition(
                collisionFieldBinary,
                SendModificationTypes.ModifiedDataOnly,
                null,
                new ConverterDefinition(typeof(SwitchCaseConverter),
                    new ConverterParam("Cases", new SwitchCase[] { new SwitchCase(0, (byte)1), new SwitchCase(1, (byte)0), new SwitchCase(2, (byte)2) }),
                    new ConverterParam("DefaultOutput", (byte)0)),
                null,
                new InputPropertyDefinition("CollisionParamData.ActionType", new Guid("4fb16e75-0da9-4e54-8bb1-5472640b5468"))
            );

            // Output : fieldCollisionIsWorld
            // Inputs : IsWorld
            BinaryConversionInfoBase.AddBinaryFieldDefinition(
                collisionFieldBinary,
                SendModificationTypes.ModifiedDataOnly,
                null,
                new ConverterDefinition(typeof(SwitchCaseConverter),
                    new ConverterParam("Cases", new SwitchCase[] { new SwitchCase(true, (byte)1) }),
                    new ConverterParam("DefaultOutput", (byte)0)),
                null,
                new InputPropertyDefinition("CollisionParamData.IsWorld", new Guid("360c5cce-e9fe-48f7-9b15-fdf32fcf5e73"))
            );

            // Output : fieldCollisionIsCommonCoord
            // Inputs : UseSharedPlane
            BinaryConversionInfoBase.AddBinaryFieldDefinition(
                collisionFieldBinary,
                SendModificationTypes.ModifiedDataOnly,
                null,
                new ConverterDefinition(typeof(SwitchCaseConverter),
                    new ConverterParam("Cases", new SwitchCase[] { new SwitchCase(true, (byte)1) }),
                    new ConverterParam("DefaultOutput", (byte)0)),
                null,
                new InputPropertyDefinition("CollisionParamData.UseSharedPlane", new Guid("52cf4a84-78f1-41e8-a961-7efa5fcf783b"))
            );

            // Output : reserved0
            // Inputs : None
            BinaryConversionInfoBase.AddFixedSizeFieldDefinition(
                1,
                collisionFieldBinary,
                SendModificationTypes.ModifiedDataOnly,
                null,
                new ConverterDefinition(typeof(DefaultConverter)),
                null
            );

            // Output : fieldCollisionCoord
            // Inputs : Coordinate
            BinaryConversionInfoBase.AddBinaryFieldDefinition(
                collisionFieldBinary,
                SendModificationTypes.ModifiedDataOnly,
                null,
                new ConverterDefinition(typeof(DefaultConverter)),
                null,
                new InputPropertyDefinition("CollisionParamData.Coordinate", new Guid("5c238714-2e4a-4ab9-a377-ed42a8b468d8"))
            );

            // Output : fieldCollisionCoef
            // Inputs : BounceRate
            BinaryConversionInfoBase.AddBinaryFieldDefinition(
                collisionFieldBinary,
                SendModificationTypes.ModifiedDataOnly,
                null,
                new ConverterDefinition(typeof(DefaultConverter)),
                null,
                new InputPropertyDefinition("CollisionParamData.BounceRate", new Guid("01b198b1-99da-4d40-b3e6-4e28781687d9"))
            );

            // Output : fieldCollisionCnt
            // Inputs : BounceCount
            BinaryConversionInfoBase.AddBinaryFieldDefinition(
                collisionFieldBinary,
                SendModificationTypes.ModifiedDataOnly,
                null,
                new ConverterDefinition(typeof(DefaultConverter)),
                null,
                new InputPropertyDefinition("CollisionParamData.BounceCount", new Guid("bc304eef-4bc7-4751-9d23-4796899106ae"))
            );

            // Output : fieldCollisionRegist
            // Inputs : FrictionCoefficient
            BinaryConversionInfoBase.AddBinaryFieldDefinition(
                collisionFieldBinary,
                SendModificationTypes.ModifiedDataOnly,
                null,
                new ConverterDefinition(typeof(DefaultConverter)),
                null,
                new InputPropertyDefinition("CollisionParamData.FrictionCoefficient", new Guid("cd9b3814-7c56-4473-a6c1-23c7d46e24c3"))
            );

            var convergeFieldBinary = new BinaryStructDefinition(typeof(ConvergeData)) { HasBinaryHeader = true };

            // Output : fieldConvergenceType
            // Inputs : FollowEmitter
            BinaryConversionInfoBase.AddBinaryFieldDefinition(
                convergeFieldBinary,
                SendModificationTypes.ModifiedDataOnly,
                null,
                new ConverterDefinition(typeof(SwitchCaseConverter),
                    new ConverterParam("Cases", new SwitchCase[] { new SwitchCase(true, (byte)1) }),
                    new ConverterParam("DefaultOutput", (byte)0)),
                null,
                new InputPropertyDefinition("ConvergeParamData.FollowEmitter", new Guid("b7516a69-7a5c-44d8-a6f1-ede119b91c1c"))
            );

            // Output : reserved0
            // Inputs : None
            BinaryConversionInfoBase.AddFixedSizeFieldDefinition(
                3,
                convergeFieldBinary,
                SendModificationTypes.ModifiedDataOnly,
                null,
                new ConverterDefinition(typeof(DefaultConverter)),
                null
            );

            // Output : fieldConvergencePos
            // Inputs : Position
            BinaryConversionInfoBase.AddBinaryFieldDefinition(
                convergeFieldBinary,
                SendModificationTypes.ModifiedDataOnly,
                null,
                new ConverterDefinition(typeof(DefaultConverter)),
                null,
                new InputPropertyDefinition("ConvergeParamData.Position", new Guid("7934cf1b-729d-416a-9a28-eaa507c5bf36"))
            );

            // Output : fieldConvergenceRatio
            // Inputs : Ratio
            BinaryConversionInfoBase.AddBinaryFieldDefinition(
                convergeFieldBinary,
                SendModificationTypes.ModifiedDataOnly,
                null,
                new ConverterDefinition(typeof(DefaultConverter)),
                null,
                new InputPropertyDefinition("ConvergeParamData.Ratio", new Guid("1d200814-797d-44e1-bb8e-f3e62ac11ce3"))
            );

            // Output : enable
            // Inputs : EnableAnimation
            BinaryConversionInfoBase.AddBinaryFieldDefinition(
                convergeFieldBinary,
                SendModificationTypes.ModifiedDataOnly,
                null,
                new ConverterDefinition(typeof(DefaultConverter)),
                null,
                new InputPropertyDefinition("ConvergeParamData.EnableAnimation", new Guid("671e8d10-91fb-42fc-b053-740deaef6a2e"))
            );

            // Output : loop
            // Inputs : LoopMode
            BinaryConversionInfoBase.AddBinaryFieldDefinition(
                convergeFieldBinary,
                SendModificationTypes.ModifiedDataOnly,
                null,
                new ConverterDefinition(typeof(DefaultConverter)),
                null,
                new InputPropertyDefinition("ConvergeParamData.LoopMode", new Guid("710eff85-5219-4bd9-b445-ab573f2a48c3"))
            );

            // Output : startRandom
            // Inputs : Randomize
            BinaryConversionInfoBase.AddBinaryFieldDefinition(
                convergeFieldBinary,
                SendModificationTypes.ModifiedDataOnly,
                null,
                new ConverterDefinition(typeof(DefaultConverter)),
                null,
                new InputPropertyDefinition("ConvergeParamData.Randomize", new Guid("c34ac6fa-46ff-49d0-8bf8-d33c884e3753"))
            );

            // Output : keyNum
            // Inputs : AnimationTable
            BinaryConversionInfoBase.AddBinaryFieldDefinition(
                convergeFieldBinary,
                SendModificationTypes.ModifiedDataOnly,
                null,
                new ConverterDefinition(typeof(AnimationTableCountConverter)),
                null,
                new InputPropertyDefinition("ConvergeParamData.AnimationTable", new Guid("212a8b4c-28b9-40be-a597-f487115a5a16"))
            );

            // Output : loopNum
            // Inputs : LoopEnd
            BinaryConversionInfoBase.AddBinaryFieldDefinition(
                convergeFieldBinary,
                SendModificationTypes.ModifiedDataOnly,
                null,
                new ConverterDefinition(typeof(DefaultConverter)),
                null,
                new InputPropertyDefinition("ConvergeParamData.LoopEnd", new Guid("ea2268ca-f62b-4d8b-b725-881f050f05e2"))
            );

            // Output : keyValue
            // Inputs : AnimationTable
            BinaryConversionInfoBase.AddBinaryFieldDefinition(
                convergeFieldBinary,
                SendModificationTypes.ModifiedDataOnly,
                null,
                new ConverterDefinition(typeof(AnimationTableConverter),
                    new ConverterParam("MaxKeyFrameCount", 8),
                    new ConverterParam("FrameConvertMode", 0)),
                null,
                new InputPropertyDefinition("ConvergeParamData.AnimationTable", new Guid("212a8b4c-28b9-40be-a597-f487115a5a16"))
            );

            var curlNoiseFieldBinary = new BinaryStructDefinition(typeof(CurlNoiseData)) { HasBinaryHeader = true };

            // Output : isFieldCurlNoiseInterpolation
            // Inputs : Interpolation
            BinaryConversionInfoBase.AddBinaryFieldDefinition(
                curlNoiseFieldBinary,
                SendModificationTypes.ModifiedDataOnly,
                null,
                new ConverterDefinition(typeof(SwitchCaseConverter),
                    new ConverterParam("Cases", new SwitchCase[] { new SwitchCase(true, (byte)1) }),
                    new ConverterParam("DefaultOutput", (byte)0)),
                null,
                new InputPropertyDefinition("CurlNoiseParamData.Interpolation", new Guid("509a439e-0429-467d-93fd-e31f7cc41c30"))
            );

            // Output : isFieldCurlNoiseBaseRandom
            // Inputs : RandomOffset
            BinaryConversionInfoBase.AddBinaryFieldDefinition(
                curlNoiseFieldBinary,
                SendModificationTypes.ModifiedDataOnly,
                null,
                new ConverterDefinition(typeof(SwitchCaseConverter),
                    new ConverterParam("Cases", new SwitchCase[] { new SwitchCase(true, (byte)1) }),
                    new ConverterParam("DefaultOutput", (byte)0)),
                null,
                new InputPropertyDefinition("CurlNoiseParamData.RandomOffset", new Guid("f80f0dbb-335b-4ee6-ad62-c7cb5d796fa8"))
            );

            // Output : isWorldCoordinate
            // Inputs : IsWorldCoordinate
            BinaryConversionInfoBase.AddBinaryFieldDefinition(
                curlNoiseFieldBinary,
                SendModificationTypes.ModifiedDataOnly,
                null,
                new ConverterDefinition(typeof(SwitchCaseConverter),
                    new ConverterParam("Cases", new SwitchCase[] { new SwitchCase(true, (byte)1) }),
                    new ConverterParam("DefaultOutput", (byte)0)),
                null,
                new InputPropertyDefinition("CurlNoiseParamData.IsWorldCoordinate", new Guid("deb7899d-4986-4c21-b8b2-2dd10cb8eede"))
            );

            // Output : reserved0
            // Inputs : None
            BinaryConversionInfoBase.AddFixedSizeFieldDefinition(
                1,
                curlNoiseFieldBinary,
                SendModificationTypes.ModifiedDataOnly,
                null,
                new ConverterDefinition(typeof(DefaultConverter)),
                null
            );

            // Output : fieldCurlNoiseSpeed
            // Inputs : Speed
            BinaryConversionInfoBase.AddBinaryFieldDefinition(
                curlNoiseFieldBinary,
                SendModificationTypes.ModifiedDataOnly,
                null,
                new ConverterDefinition(typeof(ValueScalingConverter),
                    new ConverterParam("Scale", 0.1)),
                null,
                new InputPropertyDefinition("CurlNoiseParamData.Speed", new Guid("84e86313-5101-4a44-97de-cb905bd8acd0"))
            );

            // Output : fieldCurlNoiseInfluence
            // Inputs : CurlNoiseInfluence
            BinaryConversionInfoBase.AddBinaryFieldDefinition(
                curlNoiseFieldBinary,
                SendModificationTypes.ModifiedDataOnly,
                null,
                new ConverterDefinition(typeof(ValueScalingConverter),
                    new ConverterParam("Scale", 0.1)),
                null,
                new InputPropertyDefinition("CurlNoiseParamData.CurlNoiseInfluence", new Guid("b8e595b4-0dee-41ff-b082-8fb8e066a686"))
            );

            // Output : fieldCurlNoiseScale
            // Inputs : CurlNoiseScale
            BinaryConversionInfoBase.AddBinaryFieldDefinition(
                curlNoiseFieldBinary,
                SendModificationTypes.ModifiedDataOnly,
                null,
                new ConverterDefinition(typeof(DefaultConverter)),
                null,
                new InputPropertyDefinition("CurlNoiseParamData.CurlNoiseScale", new Guid("52c98a87-13ef-483b-b5af-80a244a969c4"))
            );

            // Output : fieldCurlNoiseBase
            // Inputs : InitialValue
            BinaryConversionInfoBase.AddBinaryFieldDefinition(
                curlNoiseFieldBinary,
                SendModificationTypes.ModifiedDataOnly,
                null,
                new ConverterDefinition(typeof(DefaultConverter)),
                null,
                new InputPropertyDefinition("CurlNoiseParamData.InitialValue", new Guid("15bea2e9-f25e-421d-afaa-0c43a4bb7a3e"))
            );

            var magnetFieldBinary = new BinaryStructDefinition(typeof(MagnetData)) { HasBinaryHeader = true };

            // Output : isFollowEmitter
            // Inputs : FollowEmitter
            BinaryConversionInfoBase.AddBinaryFieldDefinition(
                magnetFieldBinary,
                SendModificationTypes.ModifiedDataOnly,
                null,
                new ConverterDefinition(typeof(SwitchCaseConverter),
                    new ConverterParam("Cases", new SwitchCase[] { new SwitchCase(true, (byte)1) }),
                    new ConverterParam("DefaultOutput", (byte)0)),
                null,
                new InputPropertyDefinition("MagnetParamData.FollowEmitter", new Guid("59047701-6603-4835-95a8-2ea39aa1e759"))
            );

            // Output : fieldMagnetFlagX
            // Inputs : EnableAxisX
            BinaryConversionInfoBase.AddBinaryFieldDefinition(
                magnetFieldBinary,
                SendModificationTypes.ModifiedDataOnly,
                null,
                new ConverterDefinition(typeof(SwitchCaseConverter),
                    new ConverterParam("Cases", new SwitchCase[] { new SwitchCase(true, (byte)1) }),
                    new ConverterParam("DefaultOutput", (byte)0)),
                null,
                new InputPropertyDefinition("MagnetParamData.EnableAxisX", new Guid("d80f1128-5f61-4fc4-b491-fd671ac803d2"))
            );

            // Output : fieldMagnetFlagY
            // Inputs : EnableAxisY
            BinaryConversionInfoBase.AddBinaryFieldDefinition(
                magnetFieldBinary,
                SendModificationTypes.ModifiedDataOnly,
                null,
                new ConverterDefinition(typeof(SwitchCaseConverter),
                    new ConverterParam("Cases", new SwitchCase[] { new SwitchCase(true, (byte)1) }),
                    new ConverterParam("DefaultOutput", (byte)0)),
                null,
                new InputPropertyDefinition("MagnetParamData.EnableAxisY", new Guid("33be7ebe-0785-499a-95f9-378d8af7179d"))
            );

            // Output : fieldMangetFlagZ
            // Inputs : EnableAxisZ
            BinaryConversionInfoBase.AddBinaryFieldDefinition(
                magnetFieldBinary,
                SendModificationTypes.ModifiedDataOnly,
                null,
                new ConverterDefinition(typeof(SwitchCaseConverter),
                    new ConverterParam("Cases", new SwitchCase[] { new SwitchCase(true, (byte)1) }),
                    new ConverterParam("DefaultOutput", (byte)0)),
                null,
                new InputPropertyDefinition("MagnetParamData.EnableAxisZ", new Guid("166e6021-ffab-4340-a104-e02f137ab5b3"))
            );

            // Output : fieldMagnetPower
            // Inputs : MagnetPower
            BinaryConversionInfoBase.AddBinaryFieldDefinition(
                magnetFieldBinary,
                SendModificationTypes.ModifiedDataOnly,
                null,
                new ConverterDefinition(typeof(DefaultConverter)),
                null,
                new InputPropertyDefinition("MagnetParamData.MagnetPower", new Guid("e4397697-3102-43b5-9579-e258abb4548c"))
            );

            // Output : fieldMagnetPos
            // Inputs : MagnetPos
            BinaryConversionInfoBase.AddBinaryFieldDefinition(
                magnetFieldBinary,
                SendModificationTypes.ModifiedDataOnly,
                null,
                new ConverterDefinition(typeof(DefaultConverter)),
                null,
                new InputPropertyDefinition("MagnetParamData.MagnetPos", new Guid("54072949-e538-4b36-bdb5-866023c068bd"))
            );

            // Output : enable
            // Inputs : EnableAnimation
            BinaryConversionInfoBase.AddBinaryFieldDefinition(
                magnetFieldBinary,
                SendModificationTypes.ModifiedDataOnly,
                null,
                new ConverterDefinition(typeof(DefaultConverter)),
                null,
                new InputPropertyDefinition("MagnetParamData.EnableAnimation", new Guid("7e55448f-8ccc-436e-9f0c-a2153f7b3271"))
            );

            // Output : loop
            // Inputs : LoopMode
            BinaryConversionInfoBase.AddBinaryFieldDefinition(
                magnetFieldBinary,
                SendModificationTypes.ModifiedDataOnly,
                null,
                new ConverterDefinition(typeof(DefaultConverter)),
                null,
                new InputPropertyDefinition("MagnetParamData.LoopMode", new Guid("36b514c8-1068-4905-b3d6-e7a678b502d9"))
            );

            // Output : startRandom
            // Inputs : Randomize
            BinaryConversionInfoBase.AddBinaryFieldDefinition(
                magnetFieldBinary,
                SendModificationTypes.ModifiedDataOnly,
                null,
                new ConverterDefinition(typeof(DefaultConverter)),
                null,
                new InputPropertyDefinition("MagnetParamData.Randomize", new Guid("f48306f8-b601-458e-af8e-9b1a0ebc9fbf"))
            );

            // Output : keyNum
            // Inputs : AnimationTable
            BinaryConversionInfoBase.AddBinaryFieldDefinition(
                magnetFieldBinary,
                SendModificationTypes.ModifiedDataOnly,
                null,
                new ConverterDefinition(typeof(AnimationTableCountConverter)),
                null,
                new InputPropertyDefinition("MagnetParamData.AnimationTable", new Guid("a7f08f5d-d451-4429-88b0-88d96b866fb2"))
            );

            // Output : loopNum
            // Inputs : LoopEnd
            BinaryConversionInfoBase.AddBinaryFieldDefinition(
                magnetFieldBinary,
                SendModificationTypes.ModifiedDataOnly,
                null,
                new ConverterDefinition(typeof(DefaultConverter)),
                null,
                new InputPropertyDefinition("MagnetParamData.LoopEnd", new Guid("d79ac03b-61d7-4e46-a3be-a399649cd39b"))
            );

            // Output : keyValue
            // Inputs : AnimationTable
            BinaryConversionInfoBase.AddBinaryFieldDefinition(
                magnetFieldBinary,
                SendModificationTypes.ModifiedDataOnly,
                null,
                new ConverterDefinition(typeof(AnimationTableConverter),
                    new ConverterParam("MaxKeyFrameCount", 8),
                    new ConverterParam("FrameConvertMode", 0)),
                null,
                new InputPropertyDefinition("MagnetParamData.AnimationTable", new Guid("a7f08f5d-d451-4429-88b0-88d96b866fb2"))
            );

            var randomFieldBinary = new BinaryStructDefinition(typeof(RandomData)) { HasBinaryHeader = true };

            // Output : enableUnifiedPhase
            // Inputs : EnableUnifiedPhase
            BinaryConversionInfoBase.AddBinaryFieldDefinition(
                randomFieldBinary,
                SendModificationTypes.ModifiedDataOnly,
                null,
                new ConverterDefinition(typeof(SwitchCaseConverter),
                    new ConverterParam("Cases", new SwitchCase[] { new SwitchCase(true, (byte)1) }),
                    new ConverterParam("DefaultOutput", (byte)0)),
                null,
                new InputPropertyDefinition("RandomUnifiedPhaseParam.EnableUnifiedPhase", new Guid("e131473b-8220-4688-8184-16c55fc3c717"))
            );

            // Output : enableDetailedOption
            // Inputs : EnableDetailedOption
            BinaryConversionInfoBase.AddBinaryFieldDefinition(
                randomFieldBinary,
                SendModificationTypes.ModifiedDataOnly,
                null,
                new ConverterDefinition(typeof(SwitchCaseConverter),
                    new ConverterParam("Cases", new SwitchCase[] { new SwitchCase(true, (byte)1) }),
                    new ConverterParam("DefaultOutput", (byte)0)),
                null,
                new InputPropertyDefinition("RandomDetailedOption.EnableDetailedOption", new Guid("b01b3b03-cc42-452c-82be-f2292c95baed"))
            );

            // Output : enableAirRegist
            // Inputs : EnableAirRegist
            BinaryConversionInfoBase.AddBinaryFieldDefinition(
                randomFieldBinary,
                SendModificationTypes.ModifiedDataOnly,
                null,
                new ConverterDefinition(typeof(SwitchCaseConverter),
                    new ConverterParam("Cases", new SwitchCase[] { new SwitchCase(true, (byte)1) }),
                    new ConverterParam("DefaultOutput", (byte)0)),
                null,
                new InputPropertyDefinition("RandomBasicSetting.EnableAirRegist", new Guid("85bd3be0-f8ad-41ab-832a-c604e649b505"))
            );

            // Output : reserved0
            // Inputs : None
            BinaryConversionInfoBase.AddFixedSizeFieldDefinition(
                1,
                randomFieldBinary,
                SendModificationTypes.ModifiedDataOnly,
                null,
                new ConverterDefinition(typeof(DefaultConverter)),
                null
            );

            // Output : randomVel
            // Inputs : RandomVel
            BinaryConversionInfoBase.AddBinaryFieldDefinition(
                randomFieldBinary,
                SendModificationTypes.ModifiedDataOnly,
                null,
                new ConverterDefinition(typeof(DefaultConverter)),
                null,
                new InputPropertyDefinition("RandomBasicSetting.RandomVel", new Guid("fa047502-ca68-4e12-8972-89b9853499c4"))
            );

            // Output : blank
            // Inputs : BaseFrequency
            BinaryConversionInfoBase.AddBinaryFieldDefinition(
                randomFieldBinary,
                SendModificationTypes.ModifiedDataOnly,
                null,
                new ConverterDefinition(typeof(DefaultConverter)),
                null,
                new InputPropertyDefinition("RandomBasicSetting.BaseFrequency", new Guid("03fafded-212e-4544-8985-23b8c7ea8302"))
            );

            // Output : unifiedPhaseSpeed
            // Inputs : Speed
            BinaryConversionInfoBase.AddBinaryFieldDefinition(
                randomFieldBinary,
                SendModificationTypes.ModifiedDataOnly,
                null,
                new ConverterDefinition(typeof(DefaultConverter)),
                null,
                new InputPropertyDefinition("RandomUnifiedPhaseParam.Speed", new Guid("559eba3b-3a0a-42fe-a6fb-4d7b9460f9c0"))
            );

            // Output : unifiedPhaseDistribution
            // Inputs : Distribution
            BinaryConversionInfoBase.AddBinaryFieldDefinition(
                randomFieldBinary,
                SendModificationTypes.ModifiedDataOnly,
                null,
                new ConverterDefinition(typeof(DefaultConverter)),
                null,
                new InputPropertyDefinition("RandomUnifiedPhaseParam.Distribution", new Guid("180151e9-94e3-417d-afa9-c19be155ceae"))
            );

            // Output : waveParam0
            // Inputs : WaveAddParam0
            BinaryConversionInfoBase.AddBinaryFieldDefinition(
                randomFieldBinary,
                SendModificationTypes.ModifiedDataOnly,
                null,
                new ConverterDefinition(typeof(DefaultConverter)),
                null,
                new InputPropertyDefinition("RandomDetailedOption.WaveAddParam0", new Guid("d7d0bef6-4fd0-461b-815e-16e173126b41"))
            );

            // Output : waveParam1
            // Inputs : WaveAddParam1
            BinaryConversionInfoBase.AddBinaryFieldDefinition(
                randomFieldBinary,
                SendModificationTypes.ModifiedDataOnly,
                null,
                new ConverterDefinition(typeof(DefaultConverter)),
                null,
                new InputPropertyDefinition("RandomDetailedOption.WaveAddParam1", new Guid("ce4dbc0f-1740-49eb-b44e-391de2afe135"))
            );

            // Output : waveParam2
            // Inputs : WaveAddParam2
            BinaryConversionInfoBase.AddBinaryFieldDefinition(
                randomFieldBinary,
                SendModificationTypes.ModifiedDataOnly,
                null,
                new ConverterDefinition(typeof(DefaultConverter)),
                null,
                new InputPropertyDefinition("RandomDetailedOption.WaveAddParam2", new Guid("d86291b1-3674-4e78-8583-16132a984452"))
            );

            // Output : waveParam3
            // Inputs : WaveAddParam3
            BinaryConversionInfoBase.AddBinaryFieldDefinition(
                randomFieldBinary,
                SendModificationTypes.ModifiedDataOnly,
                null,
                new ConverterDefinition(typeof(DefaultConverter)),
                null,
                new InputPropertyDefinition("RandomDetailedOption.WaveAddParam3", new Guid("a64a406b-70e9-4147-bc65-47b89a0134d5"))
            );

            // Output : waveParamHzRate0
            // Inputs : WaveCycleRate0
            BinaryConversionInfoBase.AddBinaryFieldDefinition(
                randomFieldBinary,
                SendModificationTypes.ModifiedDataOnly,
                null,
                new ConverterDefinition(typeof(DefaultConverter)),
                null,
                new InputPropertyDefinition("RandomDetailedOption.WaveCycleRate0", new Guid("a94d57d0-7160-4a19-b91a-dc785969ad84"))
            );

            // Output : waveParamHzRate1
            // Inputs : WaveCycleRate1
            BinaryConversionInfoBase.AddBinaryFieldDefinition(
                randomFieldBinary,
                SendModificationTypes.ModifiedDataOnly,
                null,
                new ConverterDefinition(typeof(DefaultConverter)),
                null,
                new InputPropertyDefinition("RandomDetailedOption.WaveCycleRate1", new Guid("ad48a8fd-c528-4284-8455-408488c5e7a5"))
            );

            // Output : waveParamHzRate2
            // Inputs : WaveCycleRate2
            BinaryConversionInfoBase.AddBinaryFieldDefinition(
                randomFieldBinary,
                SendModificationTypes.ModifiedDataOnly,
                null,
                new ConverterDefinition(typeof(DefaultConverter)),
                null,
                new InputPropertyDefinition("RandomDetailedOption.WaveCycleRate2", new Guid("d16ba26c-eb31-448d-8b30-0fb0a0c3e1f9"))
            );

            // Output : waveParamHzRate3
            // Inputs : WaveCycleRate3
            BinaryConversionInfoBase.AddBinaryFieldDefinition(
                randomFieldBinary,
                SendModificationTypes.ModifiedDataOnly,
                null,
                new ConverterDefinition(typeof(DefaultConverter)),
                null,
                new InputPropertyDefinition("RandomDetailedOption.WaveCycleRate3", new Guid("88c70ad6-da79-493f-9178-da758ff32c86"))
            );

            // Output : enable
            // Inputs : EnableAnimation
            BinaryConversionInfoBase.AddBinaryFieldDefinition(
                randomFieldBinary,
                SendModificationTypes.ModifiedDataOnly,
                null,
                new ConverterDefinition(typeof(DefaultConverter)),
                null,
                new InputPropertyDefinition("RandomBasicSetting.EnableAnimation", new Guid("3fa94b91-e1b2-434b-b9d3-163c8c7c9be2"))
            );

            // Output : loop
            // Inputs : LoopMode
            BinaryConversionInfoBase.AddBinaryFieldDefinition(
                randomFieldBinary,
                SendModificationTypes.ModifiedDataOnly,
                null,
                new ConverterDefinition(typeof(DefaultConverter)),
                null,
                new InputPropertyDefinition("RandomBasicSetting.LoopMode", new Guid("4a60dd4a-143b-412e-b00f-753c75742c8e"))
            );

            // Output : startRandom
            // Inputs : Randomize
            BinaryConversionInfoBase.AddBinaryFieldDefinition(
                randomFieldBinary,
                SendModificationTypes.ModifiedDataOnly,
                null,
                new ConverterDefinition(typeof(DefaultConverter)),
                null,
                new InputPropertyDefinition("RandomBasicSetting.Randomize", new Guid("c3b437c0-394a-4bad-961e-e27dd6b194bf"))
            );

            // Output : keyNum
            // Inputs : AnimationTable
            BinaryConversionInfoBase.AddBinaryFieldDefinition(
                randomFieldBinary,
                SendModificationTypes.ModifiedDataOnly,
                null,
                new ConverterDefinition(typeof(AnimationTableCountConverter)),
                null,
                new InputPropertyDefinition("RandomBasicSetting.AnimationTable", new Guid("36cfd537-a0f5-4941-b517-058e85f40bfe"))
            );

            // Output : loopNum
            // Inputs : LoopEnd
            BinaryConversionInfoBase.AddBinaryFieldDefinition(
                randomFieldBinary,
                SendModificationTypes.ModifiedDataOnly,
                null,
                new ConverterDefinition(typeof(DefaultConverter)),
                null,
                new InputPropertyDefinition("RandomBasicSetting.LoopEnd", new Guid("9759b009-382a-4439-82c2-073fdca8e791"))
            );

            // Output : keyValue
            // Inputs : AnimationTable
            BinaryConversionInfoBase.AddBinaryFieldDefinition(
                randomFieldBinary,
                SendModificationTypes.ModifiedDataOnly,
                null,
                new ConverterDefinition(typeof(AnimationTableConverter),
                    new ConverterParam("MaxKeyFrameCount", 8),
                    new ConverterParam("FrameConvertMode", 0)),
                null,
                new InputPropertyDefinition("RandomBasicSetting.AnimationTable", new Guid("36cfd537-a0f5-4941-b517-058e85f40bfe"))
            );

            var spinFieldBinary = new BinaryStructDefinition(typeof(SpinData)) { HasBinaryHeader = true };

            // Output : fieldSpinRotate
            // Inputs : SpinVelocity
            BinaryConversionInfoBase.AddBinaryFieldDefinition(
                spinFieldBinary,
                SendModificationTypes.ModifiedDataOnly,
                null,
                new ConverterDefinition(typeof(RadianConverter)),
                null,
                new InputPropertyDefinition("SpinParamData.SpinVelocity", new Guid("07bf2f8a-6756-4105-8d15-893c4c928c06"))
            );

            // Output : fieldSpinAxis
            // Inputs : SpinAxis
            BinaryConversionInfoBase.AddBinaryFieldDefinition(
                spinFieldBinary,
                SendModificationTypes.ModifiedDataOnly,
                null,
                new ConverterDefinition(typeof(TypeConversionConverter),
                    new ConverterParam("TargetType", typeof(System.UInt32))),
                null,
                new InputPropertyDefinition("SpinParamData.SpinAxis", new Guid("692241a0-c08d-467a-98e1-8fc02e29c083"))
            );

            // Output : fieldSpinOuter
            // Inputs : SpinOuter
            BinaryConversionInfoBase.AddBinaryFieldDefinition(
                spinFieldBinary,
                SendModificationTypes.ModifiedDataOnly,
                null,
                new ConverterDefinition(typeof(DefaultConverter)),
                null,
                new InputPropertyDefinition("SpinParamData.SpinOuter", new Guid("8fdce9b0-fab2-44ac-9103-12d0f451d9b8"))
            );

            // Output : enable
            // Inputs : EnableVelocityAnimation
            BinaryConversionInfoBase.AddBinaryFieldDefinition(
                spinFieldBinary,
                SendModificationTypes.ModifiedDataOnly,
                null,
                new ConverterDefinition(typeof(DefaultConverter)),
                null,
                new InputPropertyDefinition("SpinParamData.EnableVelocityAnimation", new Guid("084640a7-6727-478e-b9a4-95b4dbdf65bd"))
            );

            // Output : loop
            // Inputs : VelocityLoopMode
            BinaryConversionInfoBase.AddBinaryFieldDefinition(
                spinFieldBinary,
                SendModificationTypes.ModifiedDataOnly,
                null,
                new ConverterDefinition(typeof(DefaultConverter)),
                null,
                new InputPropertyDefinition("SpinParamData.VelocityLoopMode", new Guid("fd5b3e1a-f276-4ce9-9237-d3452c98fdb5"))
            );

            // Output : startRandom
            // Inputs : VelocityRandomize
            BinaryConversionInfoBase.AddBinaryFieldDefinition(
                spinFieldBinary,
                SendModificationTypes.ModifiedDataOnly,
                null,
                new ConverterDefinition(typeof(DefaultConverter)),
                null,
                new InputPropertyDefinition("SpinParamData.VelocityRandomize", new Guid("c541a99b-4657-40b0-8c79-e96c0111d81e"))
            );

            // Output : keyNum
            // Inputs : VelocityAnimationTable
            BinaryConversionInfoBase.AddBinaryFieldDefinition(
                spinFieldBinary,
                SendModificationTypes.ModifiedDataOnly,
                null,
                new ConverterDefinition(typeof(AnimationTableCountConverter)),
                null,
                new InputPropertyDefinition("SpinParamData.VelocityAnimationTable", new Guid("3b9e9d5c-c0b8-4685-842e-4ea27e67972b"))
            );

            // Output : loopNum
            // Inputs : VelocityLoopEnd
            BinaryConversionInfoBase.AddBinaryFieldDefinition(
                spinFieldBinary,
                SendModificationTypes.ModifiedDataOnly,
                null,
                new ConverterDefinition(typeof(DefaultConverter)),
                null,
                new InputPropertyDefinition("SpinParamData.VelocityLoopEnd", new Guid("f90c724f-434a-48df-89b0-344c4e2963d6"))
            );

            // Output : keyValue
            // Inputs : VelocityAnimationTable
            BinaryConversionInfoBase.AddBinaryFieldDefinition(
                spinFieldBinary,
                SendModificationTypes.ModifiedDataOnly,
                null,
                new ConverterDefinition(typeof(AnimationTableConverter),
                    new ConverterParam("MaxKeyFrameCount", 8),
                    new ConverterParam("FrameConvertMode", 0)),
                null,
                new InputPropertyDefinition("SpinParamData.VelocityAnimationTable", new Guid("3b9e9d5c-c0b8-4685-842e-4ea27e67972b"))
            );

            // Output : enable
            // Inputs : EnableOuterAnimation
            BinaryConversionInfoBase.AddBinaryFieldDefinition(
                spinFieldBinary,
                SendModificationTypes.ModifiedDataOnly,
                null,
                new ConverterDefinition(typeof(DefaultConverter)),
                null,
                new InputPropertyDefinition("SpinParamData.EnableOuterAnimation", new Guid("4155a4d8-25f0-40f8-a30e-cae4adc384b4"))
            );

            // Output : loop
            // Inputs : OuterLoopMode
            BinaryConversionInfoBase.AddBinaryFieldDefinition(
                spinFieldBinary,
                SendModificationTypes.ModifiedDataOnly,
                null,
                new ConverterDefinition(typeof(DefaultConverter)),
                null,
                new InputPropertyDefinition("SpinParamData.OuterLoopMode", new Guid("0fcf5a29-3f45-47fe-b91b-373d0564659a"))
            );

            // Output : startRandom
            // Inputs : OuterRandomize
            BinaryConversionInfoBase.AddBinaryFieldDefinition(
                spinFieldBinary,
                SendModificationTypes.ModifiedDataOnly,
                null,
                new ConverterDefinition(typeof(DefaultConverter)),
                null,
                new InputPropertyDefinition("SpinParamData.OuterRandomize", new Guid("9c71f888-9a60-4385-8b64-f29a49f9275a"))
            );

            // Output : keyNum
            // Inputs : OuterAnimationTable
            BinaryConversionInfoBase.AddBinaryFieldDefinition(
                spinFieldBinary,
                SendModificationTypes.ModifiedDataOnly,
                null,
                new ConverterDefinition(typeof(AnimationTableCountConverter)),
                null,
                new InputPropertyDefinition("SpinParamData.OuterAnimationTable", new Guid("60ca061d-4023-420c-9a5b-a3c9b5edb44d"))
            );

            // Output : loopNum
            // Inputs : OuterLoopEnd
            BinaryConversionInfoBase.AddBinaryFieldDefinition(
                spinFieldBinary,
                SendModificationTypes.ModifiedDataOnly,
                null,
                new ConverterDefinition(typeof(DefaultConverter)),
                null,
                new InputPropertyDefinition("SpinParamData.OuterLoopEnd", new Guid("cc885e1c-c0cf-4e72-a9d1-711a0de10a4c"))
            );

            // Output : keyValue
            // Inputs : OuterAnimationTable
            BinaryConversionInfoBase.AddBinaryFieldDefinition(
                spinFieldBinary,
                SendModificationTypes.ModifiedDataOnly,
                null,
                new ConverterDefinition(typeof(AnimationTableConverter),
                    new ConverterParam("MaxKeyFrameCount", 8),
                    new ConverterParam("FrameConvertMode", 0)),
                null,
                new InputPropertyDefinition("SpinParamData.OuterAnimationTable", new Guid("60ca061d-4023-420c-9a5b-a3c9b5edb44d"))
            );

            var basicScaleEmitterAnimationBinary = new BinaryStructDefinition(typeof(EmitterAnimationCommonData)) { HasBinaryHeader = true };

            // Output : enable
            // Inputs : EnableAnimation
            BinaryConversionInfoBase.AddBinaryFieldDefinition(
                basicScaleEmitterAnimationBinary,
                SendModificationTypes.FullBinary,
                null,
                new ConverterDefinition(typeof(SwitchCaseConverter),
                    new ConverterParam("Cases", new SwitchCase[] { new SwitchCase(true, (byte)1) }),
                    new ConverterParam("DefaultOutput", (byte)0)),
                null,
                new InputPropertyDefinition("EnableAnimation", new Guid("2502dfb1-1df2-419f-acf1-095e3a9abf13"))
            );

            // Output : loop
            // Inputs : LoopMode
            BinaryConversionInfoBase.AddBinaryFieldDefinition(
                basicScaleEmitterAnimationBinary,
                SendModificationTypes.ModifiedDataOnly,
                null,
                new ConverterDefinition(typeof(TypeConversionConverter),
                    new ConverterParam("TargetType", typeof(System.Byte))),
                null,
                new InputPropertyDefinition("LoopMode", new Guid("978261f5-5da3-4d3f-8c24-f39307f7d8e9"))
            );

            // Output : startRandom
            // Inputs : InterpolationMode
            BinaryConversionInfoBase.AddBinaryFieldDefinition(
                basicScaleEmitterAnimationBinary,
                SendModificationTypes.ModifiedDataOnly,
                null,
                new ConverterDefinition(typeof(TypeConversionConverter),
                    new ConverterParam("TargetType", typeof(System.Byte))),
                null,
                new InputPropertyDefinition("InterpolationMode", new Guid("3a4aece1-b135-4509-ad42-fc8503a7c890"))
            );

            // Output : reserved0
            // Inputs : None
            BinaryConversionInfoBase.AddFixedSizeFieldDefinition(
                1,
                basicScaleEmitterAnimationBinary,
                SendModificationTypes.ModifiedDataOnly,
                null,
                new ConverterDefinition(typeof(DefaultConverter)),
                null
            );

            // Output : keyNum
            // Inputs : AnimationTable
            BinaryConversionInfoBase.AddBinaryFieldDefinition(
                basicScaleEmitterAnimationBinary,
                SendModificationTypes.ModifiedDataOnly,
                null,
                new ConverterDefinition(typeof(AnimationTableCountConverter)),
                null,
                new InputPropertyDefinition("AnimationTable", new Guid("d1470e0c-e2fa-4fa9-a2d5-6f545f85cbd3"))
            );

            // Output : loopNum
            // Inputs : None
            BinaryConversionInfoBase.AddFixedSizeFieldDefinition(
                4,
                basicScaleEmitterAnimationBinary,
                SendModificationTypes.ModifiedDataOnly,
                null,
                new ConverterDefinition(typeof(DefaultConverter)),
                null
            );

            // Output : keyValue
            // Inputs : AnimationTable
            BinaryConversionInfoBase.AddBinaryFieldDefinition(
                basicScaleEmitterAnimationBinary,
                SendModificationTypes.ModifiedDataOnly,
                null,
                new ConverterDefinition(typeof(AnimationTableConverter),
                    new ConverterParam("MaxKeyFrameCount", -1),
                    new ConverterParam("FrameConvertMode", 1)),
                null,
                new InputPropertyDefinition("AnimationTable", new Guid("d1470e0c-e2fa-4fa9-a2d5-6f545f85cbd3"))
            );

            var emitterTransformScaleAnimationBinary = new BinaryStructDefinition(typeof(EmitterAnimationCommonData)) { HasBinaryHeader = true };

            // Output : enable
            // Inputs : EnableAnimation
            BinaryConversionInfoBase.AddBinaryFieldDefinition(
                emitterTransformScaleAnimationBinary,
                SendModificationTypes.FullBinary,
                null,
                new ConverterDefinition(typeof(SwitchCaseConverter),
                    new ConverterParam("Cases", new SwitchCase[] { new SwitchCase(true, (byte)1) }),
                    new ConverterParam("DefaultOutput", (byte)0)),
                null,
                new InputPropertyDefinition("EnableAnimation", new Guid("2502dfb1-1df2-419f-acf1-095e3a9abf13"))
            );

            // Output : loop
            // Inputs : LoopMode
            BinaryConversionInfoBase.AddBinaryFieldDefinition(
                emitterTransformScaleAnimationBinary,
                SendModificationTypes.ModifiedDataOnly,
                null,
                new ConverterDefinition(typeof(TypeConversionConverter),
                    new ConverterParam("TargetType", typeof(System.Byte))),
                null,
                new InputPropertyDefinition("LoopMode", new Guid("978261f5-5da3-4d3f-8c24-f39307f7d8e9"))
            );

            // Output : startRandom
            // Inputs : InterpolationMode
            BinaryConversionInfoBase.AddBinaryFieldDefinition(
                emitterTransformScaleAnimationBinary,
                SendModificationTypes.ModifiedDataOnly,
                null,
                new ConverterDefinition(typeof(TypeConversionConverter),
                    new ConverterParam("TargetType", typeof(System.Byte))),
                null,
                new InputPropertyDefinition("InterpolationMode", new Guid("3a4aece1-b135-4509-ad42-fc8503a7c890"))
            );

            // Output : reserved0
            // Inputs : None
            BinaryConversionInfoBase.AddFixedSizeFieldDefinition(
                1,
                emitterTransformScaleAnimationBinary,
                SendModificationTypes.ModifiedDataOnly,
                null,
                new ConverterDefinition(typeof(DefaultConverter)),
                null
            );

            // Output : keyNum
            // Inputs : AnimationTable
            BinaryConversionInfoBase.AddBinaryFieldDefinition(
                emitterTransformScaleAnimationBinary,
                SendModificationTypes.ModifiedDataOnly,
                null,
                new ConverterDefinition(typeof(AnimationTableCountConverter)),
                null,
                new InputPropertyDefinition("AnimationTable", new Guid("d1470e0c-e2fa-4fa9-a2d5-6f545f85cbd3"))
            );

            // Output : loopNum
            // Inputs : None
            BinaryConversionInfoBase.AddFixedSizeFieldDefinition(
                4,
                emitterTransformScaleAnimationBinary,
                SendModificationTypes.ModifiedDataOnly,
                null,
                new ConverterDefinition(typeof(DefaultConverter)),
                null
            );

            // Output : keyValue
            // Inputs : AnimationTable
            BinaryConversionInfoBase.AddBinaryFieldDefinition(
                emitterTransformScaleAnimationBinary,
                SendModificationTypes.ModifiedDataOnly,
                null,
                new ConverterDefinition(typeof(AnimationTableConverter),
                    new ConverterParam("MaxKeyFrameCount", -1),
                    new ConverterParam("FrameConvertMode", 1)),
                null,
                new InputPropertyDefinition("AnimationTable", new Guid("d1470e0c-e2fa-4fa9-a2d5-6f545f85cbd3"))
            );

            var emitterTransformRotationAnimationBinary = new BinaryStructDefinition(typeof(EmitterAnimationCommonData)) { HasBinaryHeader = true };

            // Output : enable
            // Inputs : EnableAnimation
            BinaryConversionInfoBase.AddBinaryFieldDefinition(
                emitterTransformRotationAnimationBinary,
                SendModificationTypes.FullBinary,
                null,
                new ConverterDefinition(typeof(SwitchCaseConverter),
                    new ConverterParam("Cases", new SwitchCase[] { new SwitchCase(true, (byte)1) }),
                    new ConverterParam("DefaultOutput", (byte)0)),
                null,
                new InputPropertyDefinition("EnableAnimation", new Guid("2502dfb1-1df2-419f-acf1-095e3a9abf13"))
            );

            // Output : loop
            // Inputs : LoopMode
            BinaryConversionInfoBase.AddBinaryFieldDefinition(
                emitterTransformRotationAnimationBinary,
                SendModificationTypes.ModifiedDataOnly,
                null,
                new ConverterDefinition(typeof(TypeConversionConverter),
                    new ConverterParam("TargetType", typeof(System.Byte))),
                null,
                new InputPropertyDefinition("LoopMode", new Guid("978261f5-5da3-4d3f-8c24-f39307f7d8e9"))
            );

            // Output : startRandom
            // Inputs : InterpolationMode
            BinaryConversionInfoBase.AddBinaryFieldDefinition(
                emitterTransformRotationAnimationBinary,
                SendModificationTypes.ModifiedDataOnly,
                null,
                new ConverterDefinition(typeof(TypeConversionConverter),
                    new ConverterParam("TargetType", typeof(System.Byte))),
                null,
                new InputPropertyDefinition("InterpolationMode", new Guid("3a4aece1-b135-4509-ad42-fc8503a7c890"))
            );

            // Output : reserved0
            // Inputs : None
            BinaryConversionInfoBase.AddFixedSizeFieldDefinition(
                1,
                emitterTransformRotationAnimationBinary,
                SendModificationTypes.ModifiedDataOnly,
                null,
                new ConverterDefinition(typeof(DefaultConverter)),
                null
            );

            // Output : keyNum
            // Inputs : AnimationTable
            BinaryConversionInfoBase.AddBinaryFieldDefinition(
                emitterTransformRotationAnimationBinary,
                SendModificationTypes.ModifiedDataOnly,
                null,
                new ConverterDefinition(typeof(AnimationTableCountConverter)),
                null,
                new InputPropertyDefinition("AnimationTable", new Guid("d1470e0c-e2fa-4fa9-a2d5-6f545f85cbd3"))
            );

            // Output : loopNum
            // Inputs : None
            BinaryConversionInfoBase.AddFixedSizeFieldDefinition(
                4,
                emitterTransformRotationAnimationBinary,
                SendModificationTypes.ModifiedDataOnly,
                null,
                new ConverterDefinition(typeof(DefaultConverter)),
                null
            );

            // Output : keyValue
            // Inputs : AnimationTable
            BinaryConversionInfoBase.AddBinaryFieldDefinition(
                emitterTransformRotationAnimationBinary,
                SendModificationTypes.ModifiedDataOnly,
                null,
                new ConverterDefinition(typeof(AnimationTableConverter),
                    new ConverterParam("MaxKeyFrameCount", -1),
                    new ConverterParam("FrameConvertMode", 1)),
                null,
                new InputPropertyDefinition("AnimationTable", new Guid("d1470e0c-e2fa-4fa9-a2d5-6f545f85cbd3"))
            );

            var emitterTransformPositionAnimationBinary = new BinaryStructDefinition(typeof(EmitterAnimationCommonData)) { HasBinaryHeader = true };

            // Output : enable
            // Inputs : EnableAnimation
            BinaryConversionInfoBase.AddBinaryFieldDefinition(
                emitterTransformPositionAnimationBinary,
                SendModificationTypes.FullBinary,
                null,
                new ConverterDefinition(typeof(SwitchCaseConverter),
                    new ConverterParam("Cases", new SwitchCase[] { new SwitchCase(true, (byte)1) }),
                    new ConverterParam("DefaultOutput", (byte)0)),
                null,
                new InputPropertyDefinition("EnableAnimation", new Guid("2502dfb1-1df2-419f-acf1-095e3a9abf13"))
            );

            // Output : loop
            // Inputs : LoopMode
            BinaryConversionInfoBase.AddBinaryFieldDefinition(
                emitterTransformPositionAnimationBinary,
                SendModificationTypes.ModifiedDataOnly,
                null,
                new ConverterDefinition(typeof(TypeConversionConverter),
                    new ConverterParam("TargetType", typeof(System.Byte))),
                null,
                new InputPropertyDefinition("LoopMode", new Guid("978261f5-5da3-4d3f-8c24-f39307f7d8e9"))
            );

            // Output : startRandom
            // Inputs : InterpolationMode
            BinaryConversionInfoBase.AddBinaryFieldDefinition(
                emitterTransformPositionAnimationBinary,
                SendModificationTypes.ModifiedDataOnly,
                null,
                new ConverterDefinition(typeof(TypeConversionConverter),
                    new ConverterParam("TargetType", typeof(System.Byte))),
                null,
                new InputPropertyDefinition("InterpolationMode", new Guid("3a4aece1-b135-4509-ad42-fc8503a7c890"))
            );

            // Output : reserved0
            // Inputs : None
            BinaryConversionInfoBase.AddFixedSizeFieldDefinition(
                1,
                emitterTransformPositionAnimationBinary,
                SendModificationTypes.ModifiedDataOnly,
                null,
                new ConverterDefinition(typeof(DefaultConverter)),
                null
            );

            // Output : keyNum
            // Inputs : AnimationTable
            BinaryConversionInfoBase.AddBinaryFieldDefinition(
                emitterTransformPositionAnimationBinary,
                SendModificationTypes.ModifiedDataOnly,
                null,
                new ConverterDefinition(typeof(AnimationTableCountConverter)),
                null,
                new InputPropertyDefinition("AnimationTable", new Guid("d1470e0c-e2fa-4fa9-a2d5-6f545f85cbd3"))
            );

            // Output : loopNum
            // Inputs : None
            BinaryConversionInfoBase.AddFixedSizeFieldDefinition(
                4,
                emitterTransformPositionAnimationBinary,
                SendModificationTypes.ModifiedDataOnly,
                null,
                new ConverterDefinition(typeof(DefaultConverter)),
                null
            );

            // Output : keyValue
            // Inputs : AnimationTable
            BinaryConversionInfoBase.AddBinaryFieldDefinition(
                emitterTransformPositionAnimationBinary,
                SendModificationTypes.ModifiedDataOnly,
                null,
                new ConverterDefinition(typeof(AnimationTableConverter),
                    new ConverterParam("MaxKeyFrameCount", -1),
                    new ConverterParam("FrameConvertMode", 1)),
                null,
                new InputPropertyDefinition("AnimationTable", new Guid("d1470e0c-e2fa-4fa9-a2d5-6f545f85cbd3"))
            );

            var emissionTimingRateAnimationBinary = new BinaryStructDefinition(typeof(EmitterAnimationCommonData)) { HasBinaryHeader = true };

            // Output : enable
            // Inputs : EnableAnimation
            BinaryConversionInfoBase.AddBinaryFieldDefinition(
                emissionTimingRateAnimationBinary,
                SendModificationTypes.FullBinary,
                null,
                new ConverterDefinition(typeof(SwitchCaseConverter),
                    new ConverterParam("Cases", new SwitchCase[] { new SwitchCase(true, (byte)1) }),
                    new ConverterParam("DefaultOutput", (byte)0)),
                null,
                new InputPropertyDefinition("EnableAnimation", new Guid("2502dfb1-1df2-419f-acf1-095e3a9abf13"))
            );

            // Output : loop
            // Inputs : LoopMode
            BinaryConversionInfoBase.AddBinaryFieldDefinition(
                emissionTimingRateAnimationBinary,
                SendModificationTypes.ModifiedDataOnly,
                null,
                new ConverterDefinition(typeof(TypeConversionConverter),
                    new ConverterParam("TargetType", typeof(System.Byte))),
                null,
                new InputPropertyDefinition("LoopMode", new Guid("978261f5-5da3-4d3f-8c24-f39307f7d8e9"))
            );

            // Output : startRandom
            // Inputs : InterpolationMode
            BinaryConversionInfoBase.AddBinaryFieldDefinition(
                emissionTimingRateAnimationBinary,
                SendModificationTypes.ModifiedDataOnly,
                null,
                new ConverterDefinition(typeof(TypeConversionConverter),
                    new ConverterParam("TargetType", typeof(System.Byte))),
                null,
                new InputPropertyDefinition("InterpolationMode", new Guid("3a4aece1-b135-4509-ad42-fc8503a7c890"))
            );

            // Output : reserved0
            // Inputs : None
            BinaryConversionInfoBase.AddFixedSizeFieldDefinition(
                1,
                emissionTimingRateAnimationBinary,
                SendModificationTypes.ModifiedDataOnly,
                null,
                new ConverterDefinition(typeof(DefaultConverter)),
                null
            );

            // Output : keyNum
            // Inputs : AnimationTable
            BinaryConversionInfoBase.AddBinaryFieldDefinition(
                emissionTimingRateAnimationBinary,
                SendModificationTypes.ModifiedDataOnly,
                null,
                new ConverterDefinition(typeof(AnimationTableCountConverter)),
                null,
                new InputPropertyDefinition("AnimationTable", new Guid("d1470e0c-e2fa-4fa9-a2d5-6f545f85cbd3"))
            );

            // Output : loopNum
            // Inputs : None
            BinaryConversionInfoBase.AddFixedSizeFieldDefinition(
                4,
                emissionTimingRateAnimationBinary,
                SendModificationTypes.ModifiedDataOnly,
                null,
                new ConverterDefinition(typeof(DefaultConverter)),
                null
            );

            // Output : keyValue
            // Inputs : AnimationTable
            BinaryConversionInfoBase.AddBinaryFieldDefinition(
                emissionTimingRateAnimationBinary,
                SendModificationTypes.ModifiedDataOnly,
                null,
                new ConverterDefinition(typeof(AnimationTableConverter),
                    new ConverterParam("MaxKeyFrameCount", -1),
                    new ConverterParam("FrameConvertMode", 1)),
                null,
                new InputPropertyDefinition("AnimationTable", new Guid("d1470e0c-e2fa-4fa9-a2d5-6f545f85cbd3"))
            );

            var emissionOmniVelocityAnimationBinary = new BinaryStructDefinition(typeof(EmitterAnimationCommonData)) { HasBinaryHeader = true };

            // Output : enable
            // Inputs : EnableAnimation
            BinaryConversionInfoBase.AddBinaryFieldDefinition(
                emissionOmniVelocityAnimationBinary,
                SendModificationTypes.FullBinary,
                null,
                new ConverterDefinition(typeof(SwitchCaseConverter),
                    new ConverterParam("Cases", new SwitchCase[] { new SwitchCase(true, (byte)1) }),
                    new ConverterParam("DefaultOutput", (byte)0)),
                null,
                new InputPropertyDefinition("EnableAnimation", new Guid("2502dfb1-1df2-419f-acf1-095e3a9abf13"))
            );

            // Output : loop
            // Inputs : LoopMode
            BinaryConversionInfoBase.AddBinaryFieldDefinition(
                emissionOmniVelocityAnimationBinary,
                SendModificationTypes.ModifiedDataOnly,
                null,
                new ConverterDefinition(typeof(TypeConversionConverter),
                    new ConverterParam("TargetType", typeof(System.Byte))),
                null,
                new InputPropertyDefinition("LoopMode", new Guid("978261f5-5da3-4d3f-8c24-f39307f7d8e9"))
            );

            // Output : startRandom
            // Inputs : InterpolationMode
            BinaryConversionInfoBase.AddBinaryFieldDefinition(
                emissionOmniVelocityAnimationBinary,
                SendModificationTypes.ModifiedDataOnly,
                null,
                new ConverterDefinition(typeof(TypeConversionConverter),
                    new ConverterParam("TargetType", typeof(System.Byte))),
                null,
                new InputPropertyDefinition("InterpolationMode", new Guid("3a4aece1-b135-4509-ad42-fc8503a7c890"))
            );

            // Output : reserved0
            // Inputs : None
            BinaryConversionInfoBase.AddFixedSizeFieldDefinition(
                1,
                emissionOmniVelocityAnimationBinary,
                SendModificationTypes.ModifiedDataOnly,
                null,
                new ConverterDefinition(typeof(DefaultConverter)),
                null
            );

            // Output : keyNum
            // Inputs : AnimationTable
            BinaryConversionInfoBase.AddBinaryFieldDefinition(
                emissionOmniVelocityAnimationBinary,
                SendModificationTypes.ModifiedDataOnly,
                null,
                new ConverterDefinition(typeof(AnimationTableCountConverter)),
                null,
                new InputPropertyDefinition("AnimationTable", new Guid("d1470e0c-e2fa-4fa9-a2d5-6f545f85cbd3"))
            );

            // Output : loopNum
            // Inputs : None
            BinaryConversionInfoBase.AddFixedSizeFieldDefinition(
                4,
                emissionOmniVelocityAnimationBinary,
                SendModificationTypes.ModifiedDataOnly,
                null,
                new ConverterDefinition(typeof(DefaultConverter)),
                null
            );

            // Output : keyValue
            // Inputs : AnimationTable
            BinaryConversionInfoBase.AddBinaryFieldDefinition(
                emissionOmniVelocityAnimationBinary,
                SendModificationTypes.ModifiedDataOnly,
                null,
                new ConverterDefinition(typeof(AnimationTableConverter),
                    new ConverterParam("MaxKeyFrameCount", -1),
                    new ConverterParam("FrameConvertMode", 1)),
                null,
                new InputPropertyDefinition("AnimationTable", new Guid("d1470e0c-e2fa-4fa9-a2d5-6f545f85cbd3"))
            );

            var emissionOrientedVelocityAnimationBinary = new BinaryStructDefinition(typeof(EmitterAnimationCommonData)) { HasBinaryHeader = true };

            // Output : enable
            // Inputs : EnableAnimation
            BinaryConversionInfoBase.AddBinaryFieldDefinition(
                emissionOrientedVelocityAnimationBinary,
                SendModificationTypes.FullBinary,
                null,
                new ConverterDefinition(typeof(SwitchCaseConverter),
                    new ConverterParam("Cases", new SwitchCase[] { new SwitchCase(true, (byte)1) }),
                    new ConverterParam("DefaultOutput", (byte)0)),
                null,
                new InputPropertyDefinition("EnableAnimation", new Guid("2502dfb1-1df2-419f-acf1-095e3a9abf13"))
            );

            // Output : loop
            // Inputs : LoopMode
            BinaryConversionInfoBase.AddBinaryFieldDefinition(
                emissionOrientedVelocityAnimationBinary,
                SendModificationTypes.ModifiedDataOnly,
                null,
                new ConverterDefinition(typeof(TypeConversionConverter),
                    new ConverterParam("TargetType", typeof(System.Byte))),
                null,
                new InputPropertyDefinition("LoopMode", new Guid("978261f5-5da3-4d3f-8c24-f39307f7d8e9"))
            );

            // Output : startRandom
            // Inputs : InterpolationMode
            BinaryConversionInfoBase.AddBinaryFieldDefinition(
                emissionOrientedVelocityAnimationBinary,
                SendModificationTypes.ModifiedDataOnly,
                null,
                new ConverterDefinition(typeof(TypeConversionConverter),
                    new ConverterParam("TargetType", typeof(System.Byte))),
                null,
                new InputPropertyDefinition("InterpolationMode", new Guid("3a4aece1-b135-4509-ad42-fc8503a7c890"))
            );

            // Output : reserved0
            // Inputs : None
            BinaryConversionInfoBase.AddFixedSizeFieldDefinition(
                1,
                emissionOrientedVelocityAnimationBinary,
                SendModificationTypes.ModifiedDataOnly,
                null,
                new ConverterDefinition(typeof(DefaultConverter)),
                null
            );

            // Output : keyNum
            // Inputs : AnimationTable
            BinaryConversionInfoBase.AddBinaryFieldDefinition(
                emissionOrientedVelocityAnimationBinary,
                SendModificationTypes.ModifiedDataOnly,
                null,
                new ConverterDefinition(typeof(AnimationTableCountConverter)),
                null,
                new InputPropertyDefinition("AnimationTable", new Guid("d1470e0c-e2fa-4fa9-a2d5-6f545f85cbd3"))
            );

            // Output : loopNum
            // Inputs : None
            BinaryConversionInfoBase.AddFixedSizeFieldDefinition(
                4,
                emissionOrientedVelocityAnimationBinary,
                SendModificationTypes.ModifiedDataOnly,
                null,
                new ConverterDefinition(typeof(DefaultConverter)),
                null
            );

            // Output : keyValue
            // Inputs : AnimationTable
            BinaryConversionInfoBase.AddBinaryFieldDefinition(
                emissionOrientedVelocityAnimationBinary,
                SendModificationTypes.ModifiedDataOnly,
                null,
                new ConverterDefinition(typeof(AnimationTableConverter),
                    new ConverterParam("MaxKeyFrameCount", -1),
                    new ConverterParam("FrameConvertMode", 1)),
                null,
                new InputPropertyDefinition("AnimationTable", new Guid("d1470e0c-e2fa-4fa9-a2d5-6f545f85cbd3"))
            );

            var emissionGravityAnimationBinary = new BinaryStructDefinition(typeof(EmitterAnimationCommonData)) { HasBinaryHeader = true };

            // Output : enable
            // Inputs : EnableAnimation
            BinaryConversionInfoBase.AddBinaryFieldDefinition(
                emissionGravityAnimationBinary,
                SendModificationTypes.FullBinary,
                null,
                new ConverterDefinition(typeof(SwitchCaseConverter),
                    new ConverterParam("Cases", new SwitchCase[] { new SwitchCase(true, (byte)1) }),
                    new ConverterParam("DefaultOutput", (byte)0)),
                null,
                new InputPropertyDefinition("EnableAnimation", new Guid("2502dfb1-1df2-419f-acf1-095e3a9abf13"))
            );

            // Output : loop
            // Inputs : LoopMode
            BinaryConversionInfoBase.AddBinaryFieldDefinition(
                emissionGravityAnimationBinary,
                SendModificationTypes.ModifiedDataOnly,
                null,
                new ConverterDefinition(typeof(TypeConversionConverter),
                    new ConverterParam("TargetType", typeof(System.Byte))),
                null,
                new InputPropertyDefinition("LoopMode", new Guid("978261f5-5da3-4d3f-8c24-f39307f7d8e9"))
            );

            // Output : startRandom
            // Inputs : InterpolationMode
            BinaryConversionInfoBase.AddBinaryFieldDefinition(
                emissionGravityAnimationBinary,
                SendModificationTypes.ModifiedDataOnly,
                null,
                new ConverterDefinition(typeof(TypeConversionConverter),
                    new ConverterParam("TargetType", typeof(System.Byte))),
                null,
                new InputPropertyDefinition("InterpolationMode", new Guid("3a4aece1-b135-4509-ad42-fc8503a7c890"))
            );

            // Output : reserved0
            // Inputs : None
            BinaryConversionInfoBase.AddFixedSizeFieldDefinition(
                1,
                emissionGravityAnimationBinary,
                SendModificationTypes.ModifiedDataOnly,
                null,
                new ConverterDefinition(typeof(DefaultConverter)),
                null
            );

            // Output : keyNum
            // Inputs : AnimationTable
            BinaryConversionInfoBase.AddBinaryFieldDefinition(
                emissionGravityAnimationBinary,
                SendModificationTypes.ModifiedDataOnly,
                null,
                new ConverterDefinition(typeof(AnimationTableCountConverter)),
                null,
                new InputPropertyDefinition("AnimationTable", new Guid("d1470e0c-e2fa-4fa9-a2d5-6f545f85cbd3"))
            );

            // Output : loopNum
            // Inputs : None
            BinaryConversionInfoBase.AddFixedSizeFieldDefinition(
                4,
                emissionGravityAnimationBinary,
                SendModificationTypes.ModifiedDataOnly,
                null,
                new ConverterDefinition(typeof(DefaultConverter)),
                null
            );

            // Output : keyValue
            // Inputs : AnimationTable
            BinaryConversionInfoBase.AddBinaryFieldDefinition(
                emissionGravityAnimationBinary,
                SendModificationTypes.ModifiedDataOnly,
                null,
                new ConverterDefinition(typeof(AnimationTableConverter),
                    new ConverterParam("MaxKeyFrameCount", -1),
                    new ConverterParam("FrameConvertMode", 1)),
                null,
                new InputPropertyDefinition("AnimationTable", new Guid("d1470e0c-e2fa-4fa9-a2d5-6f545f85cbd3"))
            );

            var particleLifeAnimationBinary = new BinaryStructDefinition(typeof(EmitterAnimationCommonData)) { HasBinaryHeader = true };

            // Output : enable
            // Inputs : EnableAnimation
            BinaryConversionInfoBase.AddBinaryFieldDefinition(
                particleLifeAnimationBinary,
                SendModificationTypes.FullBinary,
                null,
                new ConverterDefinition(typeof(SwitchCaseConverter),
                    new ConverterParam("Cases", new SwitchCase[] { new SwitchCase(true, (byte)1) }),
                    new ConverterParam("DefaultOutput", (byte)0)),
                null,
                new InputPropertyDefinition("EnableAnimation", new Guid("2502dfb1-1df2-419f-acf1-095e3a9abf13"))
            );

            // Output : loop
            // Inputs : LoopMode
            BinaryConversionInfoBase.AddBinaryFieldDefinition(
                particleLifeAnimationBinary,
                SendModificationTypes.ModifiedDataOnly,
                null,
                new ConverterDefinition(typeof(TypeConversionConverter),
                    new ConverterParam("TargetType", typeof(System.Byte))),
                null,
                new InputPropertyDefinition("LoopMode", new Guid("978261f5-5da3-4d3f-8c24-f39307f7d8e9"))
            );

            // Output : startRandom
            // Inputs : InterpolationMode
            BinaryConversionInfoBase.AddBinaryFieldDefinition(
                particleLifeAnimationBinary,
                SendModificationTypes.ModifiedDataOnly,
                null,
                new ConverterDefinition(typeof(TypeConversionConverter),
                    new ConverterParam("TargetType", typeof(System.Byte))),
                null,
                new InputPropertyDefinition("InterpolationMode", new Guid("3a4aece1-b135-4509-ad42-fc8503a7c890"))
            );

            // Output : reserved0
            // Inputs : None
            BinaryConversionInfoBase.AddFixedSizeFieldDefinition(
                1,
                particleLifeAnimationBinary,
                SendModificationTypes.ModifiedDataOnly,
                null,
                new ConverterDefinition(typeof(DefaultConverter)),
                null
            );

            // Output : keyNum
            // Inputs : AnimationTable
            BinaryConversionInfoBase.AddBinaryFieldDefinition(
                particleLifeAnimationBinary,
                SendModificationTypes.ModifiedDataOnly,
                null,
                new ConverterDefinition(typeof(AnimationTableCountConverter)),
                null,
                new InputPropertyDefinition("AnimationTable", new Guid("d1470e0c-e2fa-4fa9-a2d5-6f545f85cbd3"))
            );

            // Output : loopNum
            // Inputs : None
            BinaryConversionInfoBase.AddFixedSizeFieldDefinition(
                4,
                particleLifeAnimationBinary,
                SendModificationTypes.ModifiedDataOnly,
                null,
                new ConverterDefinition(typeof(DefaultConverter)),
                null
            );

            // Output : keyValue
            // Inputs : AnimationTable
            BinaryConversionInfoBase.AddBinaryFieldDefinition(
                particleLifeAnimationBinary,
                SendModificationTypes.ModifiedDataOnly,
                null,
                new ConverterDefinition(typeof(AnimationTableConverter),
                    new ConverterParam("MaxKeyFrameCount", -1),
                    new ConverterParam("FrameConvertMode", 1)),
                null,
                new InputPropertyDefinition("AnimationTable", new Guid("d1470e0c-e2fa-4fa9-a2d5-6f545f85cbd3"))
            );

            var globalColor0AnimationBinary = new BinaryStructDefinition(typeof(EmitterAnimationCommonData)) { HasBinaryHeader = true };

            // Output : enable
            // Inputs : EnableAnimation
            BinaryConversionInfoBase.AddBinaryFieldDefinition(
                globalColor0AnimationBinary,
                SendModificationTypes.FullBinary,
                null,
                new ConverterDefinition(typeof(SwitchCaseConverter),
                    new ConverterParam("Cases", new SwitchCase[] { new SwitchCase(true, (byte)1) }),
                    new ConverterParam("DefaultOutput", (byte)0)),
                null,
                new InputPropertyDefinition("EnableAnimation", new Guid("2502dfb1-1df2-419f-acf1-095e3a9abf13"))
            );

            // Output : loop
            // Inputs : LoopMode
            BinaryConversionInfoBase.AddBinaryFieldDefinition(
                globalColor0AnimationBinary,
                SendModificationTypes.ModifiedDataOnly,
                null,
                new ConverterDefinition(typeof(TypeConversionConverter),
                    new ConverterParam("TargetType", typeof(System.Byte))),
                null,
                new InputPropertyDefinition("LoopMode", new Guid("978261f5-5da3-4d3f-8c24-f39307f7d8e9"))
            );

            // Output : startRandom
            // Inputs : InterpolationMode
            BinaryConversionInfoBase.AddBinaryFieldDefinition(
                globalColor0AnimationBinary,
                SendModificationTypes.ModifiedDataOnly,
                null,
                new ConverterDefinition(typeof(TypeConversionConverter),
                    new ConverterParam("TargetType", typeof(System.Byte))),
                null,
                new InputPropertyDefinition("InterpolationMode", new Guid("3a4aece1-b135-4509-ad42-fc8503a7c890"))
            );

            // Output : reserved0
            // Inputs : None
            BinaryConversionInfoBase.AddFixedSizeFieldDefinition(
                1,
                globalColor0AnimationBinary,
                SendModificationTypes.ModifiedDataOnly,
                null,
                new ConverterDefinition(typeof(DefaultConverter)),
                null
            );

            // Output : keyNum
            // Inputs : AnimationTable
            BinaryConversionInfoBase.AddBinaryFieldDefinition(
                globalColor0AnimationBinary,
                SendModificationTypes.ModifiedDataOnly,
                null,
                new ConverterDefinition(typeof(AnimationTableCountConverter)),
                null,
                new InputPropertyDefinition("AnimationTable", new Guid("d1470e0c-e2fa-4fa9-a2d5-6f545f85cbd3"))
            );

            // Output : loopNum
            // Inputs : None
            BinaryConversionInfoBase.AddFixedSizeFieldDefinition(
                4,
                globalColor0AnimationBinary,
                SendModificationTypes.ModifiedDataOnly,
                null,
                new ConverterDefinition(typeof(DefaultConverter)),
                null
            );

            // Output : keyValue
            // Inputs : AnimationTable
            BinaryConversionInfoBase.AddBinaryFieldDefinition(
                globalColor0AnimationBinary,
                SendModificationTypes.ModifiedDataOnly,
                null,
                new ConverterDefinition(typeof(AnimationTableConverter),
                    new ConverterParam("MaxKeyFrameCount", -1),
                    new ConverterParam("FrameConvertMode", 1)),
                null,
                new InputPropertyDefinition("AnimationTable", new Guid("d1470e0c-e2fa-4fa9-a2d5-6f545f85cbd3"))
            );

            var globalColor1AnimationBinary = new BinaryStructDefinition(typeof(EmitterAnimationCommonData)) { HasBinaryHeader = true };

            // Output : enable
            // Inputs : EnableAnimation
            BinaryConversionInfoBase.AddBinaryFieldDefinition(
                globalColor1AnimationBinary,
                SendModificationTypes.FullBinary,
                null,
                new ConverterDefinition(typeof(SwitchCaseConverter),
                    new ConverterParam("Cases", new SwitchCase[] { new SwitchCase(true, (byte)1) }),
                    new ConverterParam("DefaultOutput", (byte)0)),
                null,
                new InputPropertyDefinition("EnableAnimation", new Guid("2502dfb1-1df2-419f-acf1-095e3a9abf13"))
            );

            // Output : loop
            // Inputs : LoopMode
            BinaryConversionInfoBase.AddBinaryFieldDefinition(
                globalColor1AnimationBinary,
                SendModificationTypes.ModifiedDataOnly,
                null,
                new ConverterDefinition(typeof(TypeConversionConverter),
                    new ConverterParam("TargetType", typeof(System.Byte))),
                null,
                new InputPropertyDefinition("LoopMode", new Guid("978261f5-5da3-4d3f-8c24-f39307f7d8e9"))
            );

            // Output : startRandom
            // Inputs : InterpolationMode
            BinaryConversionInfoBase.AddBinaryFieldDefinition(
                globalColor1AnimationBinary,
                SendModificationTypes.ModifiedDataOnly,
                null,
                new ConverterDefinition(typeof(TypeConversionConverter),
                    new ConverterParam("TargetType", typeof(System.Byte))),
                null,
                new InputPropertyDefinition("InterpolationMode", new Guid("3a4aece1-b135-4509-ad42-fc8503a7c890"))
            );

            // Output : reserved0
            // Inputs : None
            BinaryConversionInfoBase.AddFixedSizeFieldDefinition(
                1,
                globalColor1AnimationBinary,
                SendModificationTypes.ModifiedDataOnly,
                null,
                new ConverterDefinition(typeof(DefaultConverter)),
                null
            );

            // Output : keyNum
            // Inputs : AnimationTable
            BinaryConversionInfoBase.AddBinaryFieldDefinition(
                globalColor1AnimationBinary,
                SendModificationTypes.ModifiedDataOnly,
                null,
                new ConverterDefinition(typeof(AnimationTableCountConverter)),
                null,
                new InputPropertyDefinition("AnimationTable", new Guid("d1470e0c-e2fa-4fa9-a2d5-6f545f85cbd3"))
            );

            // Output : loopNum
            // Inputs : None
            BinaryConversionInfoBase.AddFixedSizeFieldDefinition(
                4,
                globalColor1AnimationBinary,
                SendModificationTypes.ModifiedDataOnly,
                null,
                new ConverterDefinition(typeof(DefaultConverter)),
                null
            );

            // Output : keyValue
            // Inputs : AnimationTable
            BinaryConversionInfoBase.AddBinaryFieldDefinition(
                globalColor1AnimationBinary,
                SendModificationTypes.ModifiedDataOnly,
                null,
                new ConverterDefinition(typeof(AnimationTableConverter),
                    new ConverterParam("MaxKeyFrameCount", -1),
                    new ConverterParam("FrameConvertMode", 1)),
                null,
                new InputPropertyDefinition("AnimationTable", new Guid("d1470e0c-e2fa-4fa9-a2d5-6f545f85cbd3"))
            );

            var globalAlpha0AnimationBinary = new BinaryStructDefinition(typeof(EmitterAnimationCommonData)) { HasBinaryHeader = true };

            // Output : enable
            // Inputs : EnableAnimation
            BinaryConversionInfoBase.AddBinaryFieldDefinition(
                globalAlpha0AnimationBinary,
                SendModificationTypes.FullBinary,
                null,
                new ConverterDefinition(typeof(SwitchCaseConverter),
                    new ConverterParam("Cases", new SwitchCase[] { new SwitchCase(true, (byte)1) }),
                    new ConverterParam("DefaultOutput", (byte)0)),
                null,
                new InputPropertyDefinition("EnableAnimation", new Guid("2502dfb1-1df2-419f-acf1-095e3a9abf13"))
            );

            // Output : loop
            // Inputs : LoopMode
            BinaryConversionInfoBase.AddBinaryFieldDefinition(
                globalAlpha0AnimationBinary,
                SendModificationTypes.ModifiedDataOnly,
                null,
                new ConverterDefinition(typeof(TypeConversionConverter),
                    new ConverterParam("TargetType", typeof(System.Byte))),
                null,
                new InputPropertyDefinition("LoopMode", new Guid("978261f5-5da3-4d3f-8c24-f39307f7d8e9"))
            );

            // Output : startRandom
            // Inputs : InterpolationMode
            BinaryConversionInfoBase.AddBinaryFieldDefinition(
                globalAlpha0AnimationBinary,
                SendModificationTypes.ModifiedDataOnly,
                null,
                new ConverterDefinition(typeof(TypeConversionConverter),
                    new ConverterParam("TargetType", typeof(System.Byte))),
                null,
                new InputPropertyDefinition("InterpolationMode", new Guid("3a4aece1-b135-4509-ad42-fc8503a7c890"))
            );

            // Output : reserved0
            // Inputs : None
            BinaryConversionInfoBase.AddFixedSizeFieldDefinition(
                1,
                globalAlpha0AnimationBinary,
                SendModificationTypes.ModifiedDataOnly,
                null,
                new ConverterDefinition(typeof(DefaultConverter)),
                null
            );

            // Output : keyNum
            // Inputs : AnimationTable
            BinaryConversionInfoBase.AddBinaryFieldDefinition(
                globalAlpha0AnimationBinary,
                SendModificationTypes.ModifiedDataOnly,
                null,
                new ConverterDefinition(typeof(AnimationTableCountConverter)),
                null,
                new InputPropertyDefinition("AnimationTable", new Guid("d1470e0c-e2fa-4fa9-a2d5-6f545f85cbd3"))
            );

            // Output : loopNum
            // Inputs : None
            BinaryConversionInfoBase.AddFixedSizeFieldDefinition(
                4,
                globalAlpha0AnimationBinary,
                SendModificationTypes.ModifiedDataOnly,
                null,
                new ConverterDefinition(typeof(DefaultConverter)),
                null
            );

            // Output : keyValue
            // Inputs : AnimationTable
            BinaryConversionInfoBase.AddBinaryFieldDefinition(
                globalAlpha0AnimationBinary,
                SendModificationTypes.ModifiedDataOnly,
                null,
                new ConverterDefinition(typeof(AnimationTableConverter),
                    new ConverterParam("MaxKeyFrameCount", -1),
                    new ConverterParam("FrameConvertMode", 1)),
                null,
                new InputPropertyDefinition("AnimationTable", new Guid("d1470e0c-e2fa-4fa9-a2d5-6f545f85cbd3"))
            );

            var globalAlpha1AnimationBinary = new BinaryStructDefinition(typeof(EmitterAnimationCommonData)) { HasBinaryHeader = true };

            // Output : enable
            // Inputs : EnableAnimation
            BinaryConversionInfoBase.AddBinaryFieldDefinition(
                globalAlpha1AnimationBinary,
                SendModificationTypes.FullBinary,
                null,
                new ConverterDefinition(typeof(SwitchCaseConverter),
                    new ConverterParam("Cases", new SwitchCase[] { new SwitchCase(true, (byte)1) }),
                    new ConverterParam("DefaultOutput", (byte)0)),
                null,
                new InputPropertyDefinition("EnableAnimation", new Guid("2502dfb1-1df2-419f-acf1-095e3a9abf13"))
            );

            // Output : loop
            // Inputs : LoopMode
            BinaryConversionInfoBase.AddBinaryFieldDefinition(
                globalAlpha1AnimationBinary,
                SendModificationTypes.ModifiedDataOnly,
                null,
                new ConverterDefinition(typeof(TypeConversionConverter),
                    new ConverterParam("TargetType", typeof(System.Byte))),
                null,
                new InputPropertyDefinition("LoopMode", new Guid("978261f5-5da3-4d3f-8c24-f39307f7d8e9"))
            );

            // Output : startRandom
            // Inputs : InterpolationMode
            BinaryConversionInfoBase.AddBinaryFieldDefinition(
                globalAlpha1AnimationBinary,
                SendModificationTypes.ModifiedDataOnly,
                null,
                new ConverterDefinition(typeof(TypeConversionConverter),
                    new ConverterParam("TargetType", typeof(System.Byte))),
                null,
                new InputPropertyDefinition("InterpolationMode", new Guid("3a4aece1-b135-4509-ad42-fc8503a7c890"))
            );

            // Output : reserved0
            // Inputs : None
            BinaryConversionInfoBase.AddFixedSizeFieldDefinition(
                1,
                globalAlpha1AnimationBinary,
                SendModificationTypes.ModifiedDataOnly,
                null,
                new ConverterDefinition(typeof(DefaultConverter)),
                null
            );

            // Output : keyNum
            // Inputs : AnimationTable
            BinaryConversionInfoBase.AddBinaryFieldDefinition(
                globalAlpha1AnimationBinary,
                SendModificationTypes.ModifiedDataOnly,
                null,
                new ConverterDefinition(typeof(AnimationTableCountConverter)),
                null,
                new InputPropertyDefinition("AnimationTable", new Guid("d1470e0c-e2fa-4fa9-a2d5-6f545f85cbd3"))
            );

            // Output : loopNum
            // Inputs : None
            BinaryConversionInfoBase.AddFixedSizeFieldDefinition(
                4,
                globalAlpha1AnimationBinary,
                SendModificationTypes.ModifiedDataOnly,
                null,
                new ConverterDefinition(typeof(DefaultConverter)),
                null
            );

            // Output : keyValue
            // Inputs : AnimationTable
            BinaryConversionInfoBase.AddBinaryFieldDefinition(
                globalAlpha1AnimationBinary,
                SendModificationTypes.ModifiedDataOnly,
                null,
                new ConverterDefinition(typeof(AnimationTableConverter),
                    new ConverterParam("MaxKeyFrameCount", -1),
                    new ConverterParam("FrameConvertMode", 1)),
                null,
                new InputPropertyDefinition("AnimationTable", new Guid("d1470e0c-e2fa-4fa9-a2d5-6f545f85cbd3"))
            );

            var shapeScaleAnimationBinary = new BinaryStructDefinition(typeof(EmitterAnimationCommonData)) { HasBinaryHeader = true };

            // Output : enable
            // Inputs : EnableAnimation
            BinaryConversionInfoBase.AddBinaryFieldDefinition(
                shapeScaleAnimationBinary,
                SendModificationTypes.FullBinary,
                null,
                new ConverterDefinition(typeof(SwitchCaseConverter),
                    new ConverterParam("Cases", new SwitchCase[] { new SwitchCase(true, (byte)1) }),
                    new ConverterParam("DefaultOutput", (byte)0)),
                null,
                new InputPropertyDefinition("EnableAnimation", new Guid("2502dfb1-1df2-419f-acf1-095e3a9abf13"))
            );

            // Output : loop
            // Inputs : LoopMode
            BinaryConversionInfoBase.AddBinaryFieldDefinition(
                shapeScaleAnimationBinary,
                SendModificationTypes.ModifiedDataOnly,
                null,
                new ConverterDefinition(typeof(TypeConversionConverter),
                    new ConverterParam("TargetType", typeof(System.Byte))),
                null,
                new InputPropertyDefinition("LoopMode", new Guid("978261f5-5da3-4d3f-8c24-f39307f7d8e9"))
            );

            // Output : startRandom
            // Inputs : InterpolationMode
            BinaryConversionInfoBase.AddBinaryFieldDefinition(
                shapeScaleAnimationBinary,
                SendModificationTypes.ModifiedDataOnly,
                null,
                new ConverterDefinition(typeof(TypeConversionConverter),
                    new ConverterParam("TargetType", typeof(System.Byte))),
                null,
                new InputPropertyDefinition("InterpolationMode", new Guid("3a4aece1-b135-4509-ad42-fc8503a7c890"))
            );

            // Output : reserved0
            // Inputs : None
            BinaryConversionInfoBase.AddFixedSizeFieldDefinition(
                1,
                shapeScaleAnimationBinary,
                SendModificationTypes.ModifiedDataOnly,
                null,
                new ConverterDefinition(typeof(DefaultConverter)),
                null
            );

            // Output : keyNum
            // Inputs : AnimationTable
            BinaryConversionInfoBase.AddBinaryFieldDefinition(
                shapeScaleAnimationBinary,
                SendModificationTypes.ModifiedDataOnly,
                null,
                new ConverterDefinition(typeof(AnimationTableCountConverter)),
                null,
                new InputPropertyDefinition("AnimationTable", new Guid("d1470e0c-e2fa-4fa9-a2d5-6f545f85cbd3"))
            );

            // Output : loopNum
            // Inputs : None
            BinaryConversionInfoBase.AddFixedSizeFieldDefinition(
                4,
                shapeScaleAnimationBinary,
                SendModificationTypes.ModifiedDataOnly,
                null,
                new ConverterDefinition(typeof(DefaultConverter)),
                null
            );

            // Output : keyValue
            // Inputs : AnimationTable
            BinaryConversionInfoBase.AddBinaryFieldDefinition(
                shapeScaleAnimationBinary,
                SendModificationTypes.ModifiedDataOnly,
                null,
                new ConverterDefinition(typeof(AnimationTableConverter),
                    new ConverterParam("MaxKeyFrameCount", -1),
                    new ConverterParam("FrameConvertMode", 1)),
                null,
                new InputPropertyDefinition("AnimationTable", new Guid("d1470e0c-e2fa-4fa9-a2d5-6f545f85cbd3"))
            );

            var randomFe1FieldBinary = new BinaryStructDefinition(typeof(RandomFe1Data)) { HasBinaryHeader = true };

            // Output : randomVel
            // Inputs : RandomRange
            BinaryConversionInfoBase.AddBinaryFieldDefinition(
                randomFe1FieldBinary,
                SendModificationTypes.ModifiedDataOnly,
                null,
                new ConverterDefinition(typeof(DefaultConverter)),
                null,
                new InputPropertyDefinition("RandomFe1ParamData.RandomRange", new Guid("0c491828-90ab-4fb4-95f3-098115d96253"))
            );

            // Output : blank
            // Inputs : BlankFrames
            BinaryConversionInfoBase.AddBinaryFieldDefinition(
                randomFe1FieldBinary,
                SendModificationTypes.ModifiedDataOnly,
                null,
                new ConverterDefinition(typeof(DefaultConverter)),
                null,
                new InputPropertyDefinition("RandomFe1ParamData.BlankFrames", new Guid("870c4b56-846a-41a8-a3b7-e35336377749"))
            );

            // Output : enable
            // Inputs : EnableAnimation
            BinaryConversionInfoBase.AddBinaryFieldDefinition(
                randomFe1FieldBinary,
                SendModificationTypes.ModifiedDataOnly,
                null,
                new ConverterDefinition(typeof(DefaultConverter)),
                null,
                new InputPropertyDefinition("RandomFe1ParamData.EnableAnimation", new Guid("59e5d441-d056-482a-9723-1cf6ffa7a59b"))
            );

            // Output : loop
            // Inputs : LoopMode
            BinaryConversionInfoBase.AddBinaryFieldDefinition(
                randomFe1FieldBinary,
                SendModificationTypes.ModifiedDataOnly,
                null,
                new ConverterDefinition(typeof(DefaultConverter)),
                null,
                new InputPropertyDefinition("RandomFe1ParamData.LoopMode", new Guid("4927aa32-f066-44d4-8923-761ffadd3674"))
            );

            // Output : startRandom
            // Inputs : Randomize
            BinaryConversionInfoBase.AddBinaryFieldDefinition(
                randomFe1FieldBinary,
                SendModificationTypes.ModifiedDataOnly,
                null,
                new ConverterDefinition(typeof(DefaultConverter)),
                null,
                new InputPropertyDefinition("RandomFe1ParamData.Randomize", new Guid("2840fb6a-94db-445f-b37a-609cb14c7128"))
            );

            // Output : keyNum
            // Inputs : AnimationTable
            BinaryConversionInfoBase.AddBinaryFieldDefinition(
                randomFe1FieldBinary,
                SendModificationTypes.ModifiedDataOnly,
                null,
                new ConverterDefinition(typeof(AnimationTableCountConverter)),
                null,
                new InputPropertyDefinition("RandomFe1ParamData.AnimationTable", new Guid("65a0c3cd-6e4d-444f-ac70-3b00a19a3b3b"))
            );

            // Output : loopNum
            // Inputs : LoopEnd
            BinaryConversionInfoBase.AddBinaryFieldDefinition(
                randomFe1FieldBinary,
                SendModificationTypes.ModifiedDataOnly,
                null,
                new ConverterDefinition(typeof(DefaultConverter)),
                null,
                new InputPropertyDefinition("RandomFe1ParamData.LoopEnd", new Guid("2f529fe4-7e31-4700-ab9e-0221ba1f31c3"))
            );

            // Output : keyValue
            // Inputs : AnimationTable
            BinaryConversionInfoBase.AddBinaryFieldDefinition(
                randomFe1FieldBinary,
                SendModificationTypes.ModifiedDataOnly,
                null,
                new ConverterDefinition(typeof(AnimationTableConverter),
                    new ConverterParam("MaxKeyFrameCount", 8),
                    new ConverterParam("FrameConvertMode", 0)),
                null,
                new InputPropertyDefinition("RandomFe1ParamData.AnimationTable", new Guid("65a0c3cd-6e4d-444f-ac70-3b00a19a3b3b"))
            );

            var reservedShaderUserDataBinary = new BinaryStructDefinition(null) { HasBinaryHeader = false };

            // Output : ReservedShaderUserDataBinary
            // Inputs : ContentsData
            BinaryConversionInfoBase.AddSelectBinaryDataFieldDefinition(
                reservedShaderBinary,
                SendModificationTypes.ModifiedDataOnly,
                null,
                new ConverterDefinition(typeof(AssignDataModelConverter)),
                reservedShaderUserDataBinary,
                new InputPropertyDefinition("PageData.ContentsData", new Guid("e32b5d9a-2d76-4687-a92d-986678e751d9"))
            );

            var customFieldBinary = new BinaryStructDefinition(typeof(CustomFieldData)) { HasBinaryHeader = true };

            // Output : flags
            // Inputs : Flags
            BinaryConversionInfoBase.AddBinaryFieldDefinition(
                customFieldBinary,
                SendModificationTypes.ModifiedDataOnly,
                null,
                new ConverterDefinition(typeof(DefaultConverter)),
                null,
                new InputPropertyDefinition("FlagData.Flags", new Guid("cc69273d-0b5f-4d4b-943f-805038777187"))
            );

            // Output : value0
            // Inputs : Value0
            BinaryConversionInfoBase.AddBinaryFieldDefinition(
                customFieldBinary,
                SendModificationTypes.ModifiedDataOnly,
                null,
                new ConverterDefinition(typeof(DefaultConverter)),
                null,
                new InputPropertyDefinition("ValueData.Value0", new Guid("66a7c568-0fa3-418a-8d02-27cb600eb199"))
            );

            // Output : value1
            // Inputs : Value1
            BinaryConversionInfoBase.AddBinaryFieldDefinition(
                customFieldBinary,
                SendModificationTypes.ModifiedDataOnly,
                null,
                new ConverterDefinition(typeof(DefaultConverter)),
                null,
                new InputPropertyDefinition("ValueData.Value1", new Guid("9279025b-672b-403a-8da5-6cf6f3dca92f"))
            );

            // Output : value2
            // Inputs : Value2
            BinaryConversionInfoBase.AddBinaryFieldDefinition(
                customFieldBinary,
                SendModificationTypes.ModifiedDataOnly,
                null,
                new ConverterDefinition(typeof(DefaultConverter)),
                null,
                new InputPropertyDefinition("ValueData.Value2", new Guid("741d5102-aec9-433d-82f9-0e5726a4036b"))
            );

            // Output : value3
            // Inputs : Value3
            BinaryConversionInfoBase.AddBinaryFieldDefinition(
                customFieldBinary,
                SendModificationTypes.ModifiedDataOnly,
                null,
                new ConverterDefinition(typeof(DefaultConverter)),
                null,
                new InputPropertyDefinition("ValueData.Value3", new Guid("39d57b4b-8a69-4e1b-9156-bc929b290168"))
            );

            // Output : value4
            // Inputs : Value4
            BinaryConversionInfoBase.AddBinaryFieldDefinition(
                customFieldBinary,
                SendModificationTypes.ModifiedDataOnly,
                null,
                new ConverterDefinition(typeof(DefaultConverter)),
                null,
                new InputPropertyDefinition("ValueData.Value4", new Guid("8646f988-1abd-447e-9f78-0158841a7e9b"))
            );

            // Output : value5
            // Inputs : Value5
            BinaryConversionInfoBase.AddBinaryFieldDefinition(
                customFieldBinary,
                SendModificationTypes.ModifiedDataOnly,
                null,
                new ConverterDefinition(typeof(DefaultConverter)),
                null,
                new InputPropertyDefinition("ValueData.Value5", new Guid("d530c18e-c38a-473e-a89f-6a6e3f6f33c9"))
            );

            // Output : value6
            // Inputs : Value6
            BinaryConversionInfoBase.AddBinaryFieldDefinition(
                customFieldBinary,
                SendModificationTypes.ModifiedDataOnly,
                null,
                new ConverterDefinition(typeof(DefaultConverter)),
                null,
                new InputPropertyDefinition("ValueData.Value6", new Guid("2fd12a4d-cc62-4fb0-acca-9ff47119182b"))
            );

            // Output : value7
            // Inputs : Value7
            BinaryConversionInfoBase.AddBinaryFieldDefinition(
                customFieldBinary,
                SendModificationTypes.ModifiedDataOnly,
                null,
                new ConverterDefinition(typeof(DefaultConverter)),
                null,
                new InputPropertyDefinition("ValueData.Value7", new Guid("3e45b428-c5bd-47fc-9030-aa35d93755ea"))
            );

            // Output : value8
            // Inputs : Value8
            BinaryConversionInfoBase.AddBinaryFieldDefinition(
                customFieldBinary,
                SendModificationTypes.ModifiedDataOnly,
                null,
                new ConverterDefinition(typeof(DefaultConverter)),
                null,
                new InputPropertyDefinition("ValueData.Value8", new Guid("d452f141-34bc-440c-af7d-447c21c0c1ba"))
            );

            // Output : value9
            // Inputs : Value9
            BinaryConversionInfoBase.AddBinaryFieldDefinition(
                customFieldBinary,
                SendModificationTypes.ModifiedDataOnly,
                null,
                new ConverterDefinition(typeof(DefaultConverter)),
                null,
                new InputPropertyDefinition("ValueData.Value9", new Guid("7141d073-f5f8-4b38-9754-e9ba9475eac8"))
            );

            // Output : value10
            // Inputs : Value10
            BinaryConversionInfoBase.AddBinaryFieldDefinition(
                customFieldBinary,
                SendModificationTypes.ModifiedDataOnly,
                null,
                new ConverterDefinition(typeof(DefaultConverter)),
                null,
                new InputPropertyDefinition("ValueData.Value10", new Guid("ef329004-4a5a-4772-bcb3-81ab70e5a69d"))
            );

            // Output : value11
            // Inputs : Value11
            BinaryConversionInfoBase.AddBinaryFieldDefinition(
                customFieldBinary,
                SendModificationTypes.ModifiedDataOnly,
                null,
                new ConverterDefinition(typeof(DefaultConverter)),
                null,
                new InputPropertyDefinition("ValueData.Value11", new Guid("60a5da44-a37f-434b-b3c5-63656801356d"))
            );

            // Output : value12
            // Inputs : Value12
            BinaryConversionInfoBase.AddBinaryFieldDefinition(
                customFieldBinary,
                SendModificationTypes.ModifiedDataOnly,
                null,
                new ConverterDefinition(typeof(DefaultConverter)),
                null,
                new InputPropertyDefinition("ValueData.Value12", new Guid("4df93d43-cf67-453e-98b1-acfc8cd70b0c"))
            );

            // Output : value13
            // Inputs : Value13
            BinaryConversionInfoBase.AddBinaryFieldDefinition(
                customFieldBinary,
                SendModificationTypes.ModifiedDataOnly,
                null,
                new ConverterDefinition(typeof(DefaultConverter)),
                null,
                new InputPropertyDefinition("ValueData.Value13", new Guid("f0201f28-c4ea-4a68-9424-b362d63a8ea7"))
            );

            // Output : value14
            // Inputs : Value14
            BinaryConversionInfoBase.AddBinaryFieldDefinition(
                customFieldBinary,
                SendModificationTypes.ModifiedDataOnly,
                null,
                new ConverterDefinition(typeof(DefaultConverter)),
                null,
                new InputPropertyDefinition("ValueData.Value14", new Guid("80eb5984-4a57-4cb8-a73c-522c78927e26"))
            );

            // Output : value15
            // Inputs : Value15
            BinaryConversionInfoBase.AddBinaryFieldDefinition(
                customFieldBinary,
                SendModificationTypes.ModifiedDataOnly,
                null,
                new ConverterDefinition(typeof(DefaultConverter)),
                null,
                new InputPropertyDefinition("ValueData.Value15", new Guid("afa6e591-b820-4b3a-869e-5a6b4d1ebd80"))
            );


            //-----------------------------------------------------------------
            // Save the binary structure definition.
            //-----------------------------------------------------------------
            rootBinaryDefinition = emitterSetBinary;

            //-----------------------------------------------------------------
            // Register events.
            //-----------------------------------------------------------------
            BinaryConversionInfoManager.DataModelCreated   += OnDataModelCreated;
            BinaryConversionInfoManager.DataModelDestroyed += OnDataModelDestroyed;
        }

        /// <summary>
        /// The constructor.
        /// </summary>
        /// <param name="dataModel">The data model to convert.</param>
        private EmitterSetBinaryConversionInfo(DataModelBase dataModel)
        {
            this.rootBinaryInstance = rootBinaryDefinition.CreateInstance(null, dataModel);
            this.rootBinaryInstance.ConvertBinary();
        }

        /// <summary>
        /// Dispose.
        /// </summary>
        public override void Dispose()
        {
            // Dispose the binary structure instance.
            if (this.rootBinaryInstance != null)
            {
                this.rootBinaryInstance.Dispose();
            }
        }

        /// <summary>
        /// Handle DataModelCreated event from the manager.
        /// </summary>
        /// <param name="sender">The sender of the event, should be null.</param>
        /// <param name="dataModel">The created data model.</param>
        private static void OnDataModelCreated(object sender, DataModelBase dataModel)
        {
            if (typeof(EmitterSetData).IsInstanceOfType(dataModel) == true)
            {
                var instance = new EmitterSetBinaryConversionInfo(dataModel);
                instanceMap.Add(dataModel, instance);

                SendModifiedBinaryContext.BeginSession();
                SendModifiedBinaryContext.AddBinaryStructToSend(instance.rootBinaryInstance);
                SendModifiedBinaryContext.EndSession();
            }
        }

        /// <summary>
        /// Handle DataModelCreated event from the manager.
        /// </summary>
        /// <param name="sender">The sender of the event, should be null.</param>
        /// <param name="dataModel">The created data model.</param>
        private static void OnDataModelDestroyed(object sender, DataModelBase dataModel)
        {
            if (typeof(EmitterSetData).IsInstanceOfType(dataModel) == true)
            {
                if (instanceMap.ContainsKey(dataModel))
                {
                    var instance = instanceMap[dataModel];
                    instanceMap.Remove(dataModel);
                    instance.Dispose();
                }
            }
        }

    }
}
