﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

using System;

namespace EffectMaker.BusinessLogic.ViewerMessages
{
    /// <summary>
    /// Enum for viewer message types.
    /// </summary>
    public enum MessageTypes : int
    {
        /// <summary>The type of the message is unknown.</summary>
        Unkonwn = 0,

        /// <summary>A viewer control message.</summary>
        Control = 1,

        /// <summary>Message to send binary data to the viewer.</summary>
        SendBinary = 2,

        /// <summary>Message to create an instance of a sent binary data.</summary>
        CreateInstance = 3,

        /// <summary>Message to send only the modified part of the binary data.</summary>
        Modify = 4,

        /// <summary>Message to delete an instance of a sent binary data.</summary>
        DeleteInstance = 5,

        /// <summary>Message to delete a binary data that was sent to the viewer.</summary>
        DeleteBinary = 6,

        /// <summary>Message to receive model info.</summary>
        ModelInfo = 7,

        /// <summary>Message from viewer to control editor operation.</summary>
        Operation = 8,

        /// <summary> Binary data message from viewer.</summary>
        BinaryData = 9,
    }
}
