﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

using System;

namespace EffectMaker.BusinessLogic.ViewerMessages
{
    /// <summary>
    /// Enum for asset types in a message sent to the viewer.
    /// </summary>
    public enum AssetTypes : int
    {
        /// <summary>
        /// 未定義データ.
        /// </summary>
        Unknown = -1,

        /// <summary>
        /// エミッタ―セット.
        /// </summary>
        EmitterSet = 0,

        /// <summary>
        /// エミッター.
        /// </summary>
        Emitter = 1,

        /// <summary>
        /// テクスチャ.
        /// </summary>
        Texture = 2,

        /// <summary>
        /// プリミティブ.
        /// </summary>
        Primitive = 3,

        /// <summary>
        /// シェーダ.
        /// </summary>
        Shader = 4,

        /// <summary>
        /// プレビュー.
        /// </summary>
        Preview = 5,

        /// <summary>
        /// ビューアデータ.
        /// </summary>
        ViewerData = 6,

        /// <summary>
        /// ビューアモデル.
        /// </summary>
        ViewerModel = 7,

        /// <summary>
        /// ビューアメッセージ.
        /// </summary>
        ViewerMessage = 8,
    }
}
