﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace EffectMaker.BusinessLogic.UserData
{
    /// <summary>
    /// Manages user data for custom actions.
    /// </summary>
    public static class EmitterExtParamsUserDataManager
    {
        /// <summary>
        /// Get or set the Emitter Extension Parameters definition.
        /// </summary>
        public static EmitterExtParamsDefinition Definition { get; set; }

        /// <summary>
        /// Find the user data info for the Emitter Extension Parameters.
        /// </summary>
        /// <returns>The user data info or null if the custom action doesn't exist.</returns>
        public static UserDataInfo FindEmitterExtParamsUserDataInfo()
        {
            return UserDataManager.FindUserDataByName(EmitterExtParamsDefinitionLoader.EmitterExtParamsOwnerName);
        }
    }
}
