﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace EffectMaker.BusinessLogic.UserData
{
    /// <summary>
    /// Manages user data for custom actions.
    /// </summary>
    public static class CustomActionUserDataManager
    {
        /// <summary>
        /// Get or set the custom action definition list.
        /// </summary>
        public static CustomActionDefinitionList Definition { get; set; }

        /// <summary>
        /// Get the custom action definition at the specified index.
        /// </summary>
        /// <param name="index">The index to the custom action definition.</param>
        /// <returns>The custom action definition or null if doesn't exist.</returns>
        public static CustomActionDefinition GetCustomActionDefinition(int index)
        {
            if (Definition == null)
            {
                return null;
            }

            if (index < 0 || index >= Definition.CustomActionDefinitions.Count)
            {
                return null;
            }

            return Definition.CustomActionDefinitions[index];
        }

        /// <summary>
        /// Find the user data info for the custom action at the specified index.
        /// </summary>
        /// <param name="index">The custom action index.</param>
        /// <returns>The user data info or null if the custom action doesn't exist.</returns>
        public static UserDataInfo FindCustomActionUserDataInfo(int index)
        {
            var name = string.Format(CustomActionDefinitionLoader.CustomActionNamePattern, index);
            return UserDataManager.FindUserDataByName(name);
        }

        /// <summary>
        /// Enumerate all the custom action user data informations.
        /// </summary>
        /// <returns>all the custom action user data informations.</returns>
        public static IEnumerable<UserDataInfo> EnumerateCustomActionUserDataInfo()
        {
            return UserDataManager.EnumerateUserDataInfoForOwner(
                CustomActionDefinitionLoader.CustomActionOwnerName);
        }
    }
}
