﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

using System;

namespace EffectMaker.BusinessLogic
{
    /// <summary>
    /// AssetTypes;
    /// </summary>
    public enum AssetResourceTypes
    {
        /// <summary>
        /// テクスチャ
        /// </summary>
        Texture,

        /// <summary>
        /// プリミティブ
        /// </summary>
        Primitive,

        /// <summary>
        /// コンバイナシェーダ
        /// </summary>
        CombinerShader,
    }

    /// <summary>
    /// The types of the updated user data.
    /// </summary>
    public enum UpdatedUserDataTypes
    {
        /// <summary>The general user pages. E.g. Model, Preview, ...</summary>
        GeneralUserPage = 0x00000001,

        /// <summary>The custom shader user data.</summary>
        CustomShader = 0x00000002,

        /// <summary>The custom action user data.</summary>
        CustomAction = 0x00000004,

        /// <summary>The reserved shader user data.</summary>
        ReservedShader = 0x00000008,

        /// <summary>The Emitter Extension Parameters user data.</summary>
        EmitterExtParams = 0x000000010,

        /// <summary>The custom field user data.</summary>
        CustomField = 0x000000020,

        /// <summary>The custom shader and custom action user data.</summary>
        CustomShaderAndAction = 0x00000006,

        /// <summary>The general user pages, custom shader and custom action user data.</summary>
        AllExceptReservedShader = 0x00000037,

        /// <summary>All of the user data.</summary>
        All = 0x00000003F,
    }

    /// <summary>
    /// The statuses of a viewer message.
    /// </summary>
    public enum MessageStatus
    {
        /// <summary>The message is still waiting to be ready and cannot be sent yet.</summary>
        Awaiting,

        /// <summary>The message is ready to be send.</summary>
        ReadyToSend,

        /// <summary>The message is canceled and should not be sent.</summary>
        Canceled,
    }
}
