﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using EffectMaker.BusinessLogic.ViewerMessages;
using EffectMaker.DataModel.Specific.DataModels;
using EffectMaker.Foundation.Primitives;
using EffectMaker.Foundation.Utility;

namespace EffectMaker.BusinessLogic.Protocol
{
    public class CameraMessage : MessageBase
    {
        /// <summary>
        /// コンストラクタ
        /// </summary>
        public CameraMessage()
        {
            this.CameraPosition = new Vector3f(0.0f, 0.0f, 0.0f);
            this.CameraTarget = new Vector3f(0.0f, 0.0f, 0.0f);
        }

        /// <summary>
        /// Get the type of the message.
        /// </summary>
        public override MessageTypes MessageType
        {
            get
            {
                return MessageTypes.BinaryData;
            }
        }

        /// <summary>
        /// Get the size of the message.
        /// </summary>
        public override int MessageSize
        {
            get
            {
                return this.ReceivedMessageSize;
            }
        }

        // <summary>
        /// カメラの位置です.
        /// </summary>
        public Vector3f CameraPosition { get; set; }

        /// <summary>
        /// カメラの注視点です.
        /// </summary>
        public Vector3f CameraTarget { get; set; }

        /// <summary>
        /// Read message data from binary data.
        /// </summary>
        /// <param name="stream">The stream contains the message's binary data.</param>
        /// <returns>True on success.</returns>
        public override bool Read(System.IO.Stream stream)
        {
            if (base.Read(stream) == false)
            {
                return false;
            }

            // メッセージタイプを取得
            var messageType = BinaryConversionUtility.ForProtocol.ReadStream<uint>(stream);

            // サイズを取得
            uint size = BinaryConversionUtility.ForProtocol.ReadStream<uint>(stream);

            /// カメラの位置です.
            Vector3f cameraPosition = new Vector3f();
            this.CameraPosition.X = BinaryConversionUtility.ForProtocol.ReadStream<float>(stream);
            this.CameraPosition.Y = BinaryConversionUtility.ForProtocol.ReadStream<float>(stream);
            this.CameraPosition.Z = BinaryConversionUtility.ForProtocol.ReadStream<float>(stream);
            float padding = BinaryConversionUtility.ForProtocol.ReadStream<float>(stream);

            /// カメラの注視点です.
            Vector3f cameraTarget = new Vector3f();
            this.CameraTarget.X = BinaryConversionUtility.ForProtocol.ReadStream<float>(stream);
            this.CameraTarget.Y = BinaryConversionUtility.ForProtocol.ReadStream<float>(stream);
            this.CameraTarget.Z = BinaryConversionUtility.ForProtocol.ReadStream<float>(stream);
            padding = BinaryConversionUtility.ForProtocol.ReadStream<float>(stream);

            return true;
        }
    }
}
