﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Xml.Serialization;

using EffectMaker.Foundation.Serialization;

namespace EffectMaker.BusinessLogic.Options
{
    /// <summary>
    /// Effet Browser options.
    /// </summary>
    public class EffectBrowserOptions : OptionsBase
    {
        /// <summary>
        /// Initializes the EffectBrowserOptions instance.
        /// </summary>
        public EffectBrowserOptions()
        {
        }

        /// <summary>
        /// Copy the EffectBrowserOptions instance.
        /// </summary>
        /// <param name="src">The source optins to copy from.</param>
        public EffectBrowserOptions(EffectBrowserOptions src)
            : this()
        {
            this.Set(src);
        }

        /// <summary>
        /// Gets or sets the flag telling whether to show the hidden entries or not.
        /// </summary>
        [XmlAttribute]
        public bool ShowHiddenEntries { get; set; }

        /// <summary>
        /// ミニプレビューを表示するかどうか取得または設定します。
        /// </summary>
        public bool ShowMiniPreview { get; set; } = true;

        /// <summary>
        /// Set data from the source options.
        /// </summary>
        /// <param name="src">The source options.</param>
        /// <returns>True on success.</returns>
        public override bool Set(object src)
        {
            var options = src as EffectBrowserOptions;

            if (options == null)
            {
                return false;
            }

            this.ShowHiddenEntries = options.ShowHiddenEntries;
            this.ShowMiniPreview = options.ShowMiniPreview;

            return true;
        }

        /// <summary>
        /// Deserializes from the given XML node.
        /// </summary>
        /// <param name="context">The data context needed for the deserialization.</param>
        /// <returns>True on success.</returns>
        public override bool ReadXml(XmlDocSerializationContext context)
        {
            this.ShowHiddenEntries = this.ReadAttribute(
                context,
                "ShowHiddenEntries",
                this.ShowHiddenEntries);

            this.ShowMiniPreview = this.ReadElement(
                context,
                "ShowMiniPreview",
                this.ShowMiniPreview);

            return true;
        }

        /// <summary>
        /// Serializes this object to a XML node.
        /// </summary>
        /// <param name="context">The data context needed for the serialization.</param>
        /// <returns>True on success.</returns>
        public override bool WriteXml(XmlDocSerializationContext context)
        {
            this.WriteAttribute(context, "ShowHiddenEntries", this.ShowHiddenEntries);
            this.WriteElement(context, "ShowMiniPreview", this.ShowMiniPreview);

            return true;
        }
    }
}
