﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using EffectMaker.Foundation.Primitives;

namespace EffectMaker.BusinessLogic.CurveEditorParameters
{
    /// <summary>
    /// The initial key values.
    /// </summary>
    public static class InitialKeyValues
    {
        /// <summary>
        /// The shape scale.
        /// </summary>
        public static readonly Vector4f ShapeScale = new Vector4f(1.0f, 1.0f, 1.0f, 0.0f);

        /// <summary>
        /// The emitter position.
        /// </summary>
        public static readonly Vector4f EmitterPosition = new Vector4f(0.0f, 0.0f, 0.0f, 0.0f);

        /// <summary>
        /// The emitter rotation.
        /// </summary>
        public static readonly Vector4f EmitterRotation = new Vector4f(0.0f, 0.0f, 0.0f, 0.0f);

        /// <summary>
        /// The emitter scale.
        /// </summary>
        public static readonly Vector4f EmitterScale = new Vector4f(1.0f, 1.0f, 1.0f, 0.0f);

        /// <summary>
        /// The emit time rate.
        /// </summary>
        public static readonly Vector4f EmitTimeRate = new Vector4f(1.0f, 0.0f, 0.0f, 0.0f);

        /// <summary>
        /// The omni velocity.
        /// </summary>
        public static readonly Vector4f OmniVelocity = new Vector4f(0.1f, 0.0f, 0.0f, 0.0f);

        /// <summary>
        /// The oriented velocity.
        /// </summary>
        public static readonly Vector4f OrientedVelocity = new Vector4f(0.0f, 0.0f, 0.0f, 0.0f);

        /// <summary>
        /// The emission gravity.
        /// </summary>
        public static readonly Vector4f EmissionGravity = new Vector4f(0.0f, 0.0f, 0.0f, 0.0f);

        /// <summary>
        /// The particle life.
        /// </summary>
        public static readonly Vector4f ParticleLife = new Vector4f(100.0f, 0.0f, 0.0f, 0.0f);

        /// <summary>
        /// The scale basic.
        /// </summary>
        public static readonly Vector4f ScaleBasic = new Vector4f(1.0f, 1.0f, 1.0f, 0.0f);

        /// <summary>
        /// The colors.
        /// </summary>
        public static readonly Vector4f Colors = new Vector4f(1.0f, 1.0f, 1.0f, 1.0f);
    }
}
