﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

using System;
using System.Collections;
using System.Collections.Generic;
using System.Linq;

using EffectMaker.DataModel.DataModels;
using EffectMaker.DataModel.Specific.DataModels;

namespace EffectMaker.BusinessLogic.BinaryHeaders.Helpers
{
    /// <summary>
    /// Binary header helper for texture pixel binary data structures.
    /// </summary>
    public class TexturePixelBinaryHeaderHelper : IBinaryHeaderHelper
    {
        /// <summary>The singleton instance of the helper.</summary>
        private static IBinaryHeaderHelper instance = null;

        /// <summary>
        /// Constructor.
        /// </summary>
        public TexturePixelBinaryHeaderHelper()
        {
        }

        /// <summary>
        /// Get the singleton instance of this binary header helper.
        /// </summary>
        public static IBinaryHeaderHelper Instance
        {
            get
            {
                if (instance == null)
                {
                    instance = new TexturePixelBinaryHeaderHelper();
                }

                return instance;
            }
        }

        /// <summary>
        /// Check if the given data model is accepted for this binary header helper.
        /// </summary>
        /// <param name="dataModel">The data model.</param>
        /// <returns>True if accepted.</returns>
        public bool IsAccepted(DataModelBase dataModel)
        {
            if (dataModel is EmitterTextureFileData)
            {
                return true;
            }

            return false;
        }

        /// <summary>
        /// Get tag string for the binary header.
        /// </summary>
        /// <returns>The tag string.</returns>
        public string GetTag()
        {
            return "TEXB";
        }

        /// <summary>
        /// Getting the next of the given data model.
        /// </summary>
        /// <param name="current">The current data model.</param>
        /// <returns>The next data model or null if the given is the last.</returns>
        public DataModelBase GetNext(DataModelBase current)
        {
            var eset = current as EmitterSetData;
            if (eset != null)
            {
                var workspace = eset.Parent as WorkspaceData;
                if (workspace != null)
                {
                    int index = workspace.EmitterSetList.IndexOf(eset);
                    if (index >= 0 && index < workspace.EmitterSetList.Count - 1)
                    {
                        return workspace.EmitterSetList[index + 1];
                    }
                }
            }

            return null;
        }

        /// <summary>
        /// Getting the first child of the given data model.
        /// </summary>
        /// <param name="current">The current data model.</param>
        /// <returns>The first child data model or null if the child does not exist.</returns>
        public DataModelBase GetChild(DataModelBase current)
        {
            return null;
        }

        /// <summary>
        /// Getting the first data model of the given data model's sub tree.
        /// </summary>
        /// <param name="current">The current data model.</param>
        /// <returns>The first data model of the sub tree or null there is no sub tree.</returns>
        public DataModelBase GetSub(DataModelBase current)
        {
            return null;
        }
    }
}
