﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace EffectMaker.Communicator
{
    /// <summary>
    /// メッセージキューです.
    /// </summary>
    public sealed class MessageQueue
    {
        /// <summary>
        /// メッセージキューです.
        /// </summary>
        private List<Message> queue = new List<Message>();

        /// <summary>
        /// コンストラクタです.
        /// </summary>
        public MessageQueue()
        {
            /* DO_NOTHING */
        }

        /// <summary>
        /// メッセージがあるかチェックします. メッセージがあればtrue, なければfalse.
        /// </summary>
        public bool HasMessage
        {
            get { return this.queue.Count > 0; }
        }

        /// <summary>
        /// キューに格納されているメッセージ数を返却します.
        /// </summary>
        public int Count
        {
            get { return this.queue.Count; }
        }

        /// <summary>
        /// キューに追加します.
        /// </summary>
        /// <param name="message">追加するメッセージです</param>
        public void Push(Message message)
        {
            // 排他制御.
            lock (this.queue)
            {
            #if false
                ////// 同じメッセージが既に存在したらキューから削除.
                ////for (int i = this.queue.Count - 1; i >= 0; --i)
                ////{
                ////    Message msg = this.queue[i];

                ////    // 同じメッセージかチェック.
                ////    if (msg != null && msg.IsEqual(message))
                ////    {
                ////        // キューから削除.
                ////        this.queue.RemoveAt(i);
                ////    }
                ////}
            #endif

                // 最後にメッセージを追加.
                this.queue.Add(message);
            }
        }

        /// <summary>
        /// キューから取り出します.
        /// </summary>
        /// <returns>メッセージを返却します</returns>
        public Message Pop()
        {
            // メッセージがあるかチェック.
            if (this.HasMessage == true)
            {
                // 排他制御.
                lock (this.queue)
                {
                    // 再度チェック.
                    if (this.HasMessage == true)
                    {
                        // 先頭を取り出し.
                        Message msg = this.queue[0];

                        // 先頭を削除.
                        this.queue.RemoveAt(0);

                        // メッセージを返却.
                        return msg;
                    }
                }
            }

            // 何もないのでnullを返却.
            return null;
        }

        /// <summary>
        /// キューからメッセージ配列を取り出します.
        /// </summary>
        /// <returns>メッセージ配列を返却します</returns>
        public Message[] PopMessages()
        {
            // メッセージがあるかチェック.
            if (this.HasMessage == true)
            {
                // 排他制御.
                lock (this.queue)
                {
                    // 再度チェック.
                    if (this.HasMessage == true)
                    {
                        // 全て配列に変換.
                        Message[] msgs = this.queue.ToArray();

                        // キューをクリア.
                        this.queue.Clear();

                        // 配列を返却.
                        return msgs;
                    }
                }
            }

            // 何もないのでnullを返却.
            return null;
        }
    }
}
