﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

namespace EffectMaker.Communicator
{
    /// <summary>
    /// 接続状態を伝えるインタフェースです.
    /// </summary>
    public interface IConnectionStateListener
    {
        /// <summary>
        /// 状態が変わった時の処理です.
        /// </summary>
        /// <param name="prevState">以前の状態</param>
        /// <param name="currState">現在の状態</param>
        void OnConnectionStateChanged(ConnectionStates prevState, ConnectionStates currState);
    }
}
