﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once
#include <windows.h>
#include <tchar.h>
#include <vector>

#define PCGX_HIODEV_MUTEX_NAME              _T("MUTEX_NW4C_PCVIEWER")
#define PCGX_HIODEV_DISABLE_MUTEX_NAME      _T("MUTEX_NW4C_DISABLE_HIO")
#define PCGX_HIODEV_ID                      (0x01234567)                    //    PCGX のデバイスID
#define PCGX_HIO_MUTEX_NAME                 _T("MUTEX_PCGX_HIO")            //    HIO 排他処理用 ミューテックス名前
#define PCGX_SIOMEM_NAME_FMT                _T("SHMEM_PCGX_SIO_%04X")       //    シリアルチャンネル用 共有メモリ名前 (＋ チャンネル番号16進４桁)
#define PCGX_SIOBUF_SIZE                    (0x20000)
#define PCGX_SIOMEM_SIZE                    ((sizeof(UINT)*2)+((sizeof(UINT)*2)+PCGX_SIOBUF_SIZE)*2)    //    シリアルチャンネル用 共有メモリサイズ
#define PCGX_SIO_WAIT_INTERVAL              2

#define PCGX_SIO_ATTR_NONE                  0
#define PCGX_SIO_ATTR_NO_WAIT               1
#define PCGX_SIO_ATTR_IN_PC                 2

#define PCGX_HIO_ACCESS_MODE_READ           (1u << 31)
#define PCGX_HIO_ACCESS_MODE_WRITE          (1u << 30)
#define PCGX_HIO_ACCESS_MODE_READ_WRITE     (PCGX_HIO_ACCESS_MODE_READ|PCGX_HIO_ACCESS_MODE_WRITE)

////////////////////////////////////////////////////////////////
//    PCGX_HostFile
////////////////////////////////////////////////////////////////
class PCGX_HostFile{
public:
    PCGX_HostFile();
    virtual ~PCGX_HostFile();
    void    Release();

    int      fd;
    FILE    *fp;
};

////////////////////////////////////////////////////////////////
//    PCGX_SIOMemory
////////////////////////////////////////////////////////////////
class PCGX_SIOMemory{
public:
    PCGX_SIOMemory();
    virtual ~PCGX_SIOMemory();
    HRESULT     Init(int _ch);
    void        Release();
    HRESULT     Map();
    void        Unmap();
    size_t      GetReadDataSize();
    size_t      GetWriteDataSize();
    size_t      GetWritableSize();
    void        Write(const void *buf, size_t size);
    void        Read(void *buf, size_t size);

    int         ch;
    HANDLE      hSharedMemory;
    BYTE        *pAllMem;
    UINT        *pRefCount;
    UINT        *pState;
    BYTE        *pBuf[2];
    UINT        *pReadCur[2];
    UINT        *pWriteCur[2];
};

////////////////////////////////////////////////////////////////
//    PCGX_HIO
////////////////////////////////////////////////////////////////
class PCGX_HIO{
public:
    PCGX_HIO();
    virtual ~PCGX_HIO();

    static bool     IsHIODevRunning();
    static bool     IsHIODevDisable();
    PCGX_HostFile   *SearchFile(int fd);
    PCGX_SIOMemory  *SearchSIO(int ch);
    void            MUTEX_LOCK();
    void            MUTEX_UNLOCK();

    HANDLE hioMutex;
    std::vector<PCGX_HostFile *>    _fileList;
    std::vector<PCGX_SIOMemory *>   _sioList;

    int SeekHostFile (int fd, INT64* pPosition, INT64 offset, int type);
    int OpenHostFile (int fd, const char* path, int accessMode);
    int OpenHostFile (int fd, const wchar_t* path, int accessMode);
    int CloseHostFile(int fd);
    int ReadHostFile (int fd, size_t* pRead, void* buf, size_t size);
    int WriteHostFile(int fd, size_t* pWritten, const void* buf, size_t size);

    //    DEVHIO WRAPPER
    int Find               (unsigned long *ids, int size);
    int Connect            (unsigned long id);
    int Disconnect         ();
    int OpenSio            (int ch);
    int CloseSio           (int ch);
    int ConnectSio         (int ch);
    int WaitSio            (int ch, int attr);
    int DisconnectSio      (int ch);
    int FlushSio           (int ch);
    int ReadSio            (int ch, void* buf, int length, int attr);
    int WriteSio           (int ch, const void* buf, int length, int attr);
    int GetReadableBytesSio(int ch, int attr=PCGX_SIO_ATTR_NONE);
    int GetWritableBytesSio(int ch, int attr=PCGX_SIO_ATTR_NONE);
};

#ifndef NN_PCGX_HIO_DEV
////////////////////////////////////////////////////////////////
//    PCGX_HIODevice
//    CCTRHostIO と PCGX_HIO を切り替えるだけのクラス
////////////////////////////////////////////////////////////////
#include "CDEVHIO.h"
#include "CTRHostIO.h"

enum PCGX_HIODEV_MODE{
    PCGX_HIODEV_USE_PCGX,
    PCGX_HIODEV_USE_CTR,
};

class PCGX_HIODevice{
public:
    PCGX_HIODevice()                    { mpDevhio = new CCTRHostIO();    mConnectID = 0; }
    virtual ~PCGX_HIODevice()           { if(mpDevhio){ delete mpDevhio; mpDevhio=NULL; } }

    //    DEVHIO WRAPPER
    int Find               (unsigned long *ids, int size);
    int Connect            (unsigned long id);
    int Disconnect         ();
    int OpenSio            (int ch);
    int CloseSio           (int ch);
    int ConnectSio         (int ch);
    int WaitSio            (int ch, int attr);
    int DisconnectSio      (int ch);
    int FlushSio           (int ch);
    int ReadSio            (int ch, void* buf, int length, int attr);
    int WriteSio           (int ch, const void* buf, int length, int attr);
    int GetReadableBytesSio(int ch, int attr=PCGX_SIO_ATTR_NONE);
    int GetWritableBytesSio(int ch, int attr=PCGX_SIO_ATTR_NONE);
    unsigned long    GetConnectId()    { return mConnectID; }

private:
    PCGX_HIO        mPCGXDev;
    CCTRHostIO      *mpDevhio;
    unsigned long   mConnectID;
};
#endif
