﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include "stdafx.h"

#include "CDEVHIO.h"
#include "CTRHostIO.h"
#include "SingletonHolder.h"

using namespace System;
using namespace NintendoWare::HostIODriver;


/*!--------------------------------------------------------------------------*
  ---------------------------------------------------------------------------*/
bool SingletonHolder::ConnectHIO()
{
    if (m_pDevhio == NULL){
        return false;
    }

    unsigned long id = (unsigned long)-1;

    if (m_pDevhio->Find( &id, 0 ) <= 0) {
//        printf("[ERROR] NO DEVICES FOUND");
        return false;
    }

    if (m_pDevhio->Connect( id ) < 0) {
//        printf("[ERROR] CONNECT ERROR\n");
        return false;
    }

    m_IsConnected = true;

    return true;
}

/*!--------------------------------------------------------------------------*
  ---------------------------------------------------------------------------*/
bool SingletonHolder::DisconnectHIO()
{
    if (m_pDevhio == NULL){
        return false;
    }

    m_pDevhio->Disconnect();

    m_IsConnected = false;

    return true;
}

/*!--------------------------------------------------------------------------*
  ---------------------------------------------------------------------------*/
unsigned long SingletonHolder::GetConnectID()
{
    if (m_pDevhio == NULL)
    {
        return 0;
    }

    return m_pDevhio->GetConnectId();
}

/*!--------------------------------------------------------------------------*
  ---------------------------------------------------------------------------*/
bool SingletonHolder::OpenSerialIO( const int channel )
{
    if (m_pDevhio == NULL){
        return false;
    }

    /*
        シリアル通信の確立
    */
    if ( m_pDevhio->OpenSio( channel ) < 0 )
    {
//        printf( "[ERROR] Serial I/O Open Error\n" );
        return false;
    }

    return true;
}

/*!--------------------------------------------------------------------------*
  ---------------------------------------------------------------------------*/
bool SingletonHolder::CloseSerialIO( const int channel )
{
    if (m_pDevhio == NULL){
        return false;
    }

    /*
        シリアル通信の切断 & 終了
    */
    m_pDevhio->CloseSio( channel );

    return true;
}

/*!--------------------------------------------------------------------------*
  ---------------------------------------------------------------------------*/
bool SingletonHolder::ConnectSerialIO( const int channel )
{
    if (m_pDevhio == NULL){
        return false;
    }

    /*
        シリアル通信の確立
    */
    if ( m_pDevhio->ConnectSio( channel ) < 0 )
    {
//        printf( "[ERROR] Serial I/O Connect Error\n" );
        return false;
    }

    return true;
}

/*!--------------------------------------------------------------------------*
  ---------------------------------------------------------------------------*/
bool SingletonHolder::DisconnectSerialIO( const int channel )
{
    if (m_pDevhio == NULL){
        return false;
    }

    /*
        シリアル通信の切断 & 終了
    */
    m_pDevhio->DisconnectSio( channel );

    return true;
}

/*!--------------------------------------------------------------------------*
  ---------------------------------------------------------------------------*/
bool SingletonHolder::SendPacket( void* packet, const int packetSize, const int channel )
{
    bool result = true;

#if 0
    //    SIO オープン
    if ( !OpenSerialIO( channel ) ) {
        //m_logger->Error->AddMessage("Error : ＳＩＯオープンに失敗しました");
        result = false;
    }
    else
    {
        ConnectSerialIO( channel );
        try {
            // データを転送
            int ret = m_pDevhio->WriteSio( channel, packet, packetSize, DEVHIO_SIO_ATTR_NONE );
            if ( ret != packetSize ) {
                //printf( "[ERROR] Serial I/O Write Error\n" );
                return false;
            }

            ret = m_pDevhio->FlushSio( channel );
            if ( ret != 0 ) {
                //printf( "[ERROR] Serial I/O Flush Error\n" );
                return false;
            }

            NW4R::Protocol3D::Header reply;
            ret = m_pDevhio->ReadSio( channel, &reply, sizeof(NW4R::Protocol3D::Header), DEVHIO_SIO_ATTR_NONE );
            if ( ret < 0 ) {
                //printf( "[ERROR] Serial I/O Read Error\n" );
                return false;
            }
        }
        catch (Exception^ exception){
            //m_logger->Error->AddMessage(
            //    String::Format("Error : {0}", exception->Message));
            result = false;
        }
        finally {
            //    SIO クローズ
            DisconnectSerialIO( channel );
            CloseSerialIO( channel );
        }
    }
#else
    try {
        // データを転送
        int ret = m_pDevhio->WriteSio( channel, packet, packetSize, DEVHIO_SIO_ATTR_NONE );
        if ( ret != packetSize ) {
            //printf( "[ERROR] Serial I/O Write Error\n" );
            return false;
        }

        ret = m_pDevhio->FlushSio( channel );
        if ( ret != 0 ) {
            //printf( "[ERROR] Serial I/O Flush Error\n" );
            return false;
        }

        int reply;
        ret = m_pDevhio->ReadSio( channel, &reply, sizeof(int), DEVHIO_SIO_ATTR_NONE );
        if ( ret < 0 ) {
            //printf( "[ERROR] Serial I/O Read Error\n" );
            return false;
        }
    }
    catch (Exception^ /*exception*/){
        //m_logger->Error->AddMessage(
        //    String::Format("Error : {0}", exception->Message));
        result = false;
    }
    finally {
        //    SIO クローズ
        //DisconnectSerialIO( channel );
        //CloseSerialIO( channel );
    }
#endif

    return result;
}

/*!--------------------------------------------------------------------------*
  ---------------------------------------------------------------------------*/
bool SingletonHolder::WriteSerialIO( array<Byte> ^buffer, const int size, const int channel )
{
    bool result = true;
    pin_ptr<Byte> ptr = &buffer[0];

    try {
        // データを転送
        int ret = m_pDevhio->WriteSio( channel, ptr, size, DEVHIO_SIO_ATTR_NONE );
        if ( ret != size ) {
            //printf( "[ERROR] Serial I/O Write Error\n" );
            return false;
        }

        ret = m_pDevhio->FlushSio( channel );
        if ( ret != 0 ) {
            //printf( "[ERROR] Serial I/O Flush Error\n" );
            return false;
        }
    }

    catch (Exception^ /*exception*/)
    {
        result = false;
    }

    finally
    {
    }

    return result;
}

/*!--------------------------------------------------------------------------*
  ---------------------------------------------------------------------------*/
bool SingletonHolder::Send(MemoryStream ^memoryStream, const int channel)
{
    array<Byte>^ arr  = memoryStream->ToArray();
    return Send( arr, (const int)memoryStream->Length, channel );
}

/*!--------------------------------------------------------------------------*
  ---------------------------------------------------------------------------*/
bool SingletonHolder::Send( array<Byte> ^buffer,
                            const int iSize,
                            const int channel)
{
    pin_ptr<Byte> ptr = &buffer[0];

    return SendPacket(ptr, iSize, channel);
}

/*!--------------------------------------------------------------------------*
  ---------------------------------------------------------------------------*/
bool SingletonHolder::Read(MemoryStream ^memoryStream, const int channel)
{
    bool result = true;

    try {
        array<Byte>^  arr = memoryStream->GetBuffer();
        pin_ptr<Byte> ptr = &arr[0];

        int iDataSize = GetIncomingDataSize(channel);
        if ( iDataSize>(int)memoryStream->Length )
            iDataSize = (int)memoryStream->Length;

        // Read data
        int ret = m_pDevhio->ReadSio( channel,
                                      ptr,
                                      iDataSize,
                                      DEVHIO_SIO_ATTR_NONE );
        if ( ret <= 0 ) {
            //printf( "[ERROR] Serial I/O Write Error\n" );
            return false;
        }
    }
    catch (Exception^ /*exception*/){
        //m_logger->Error->AddMessage(
        //    String::Format("Error : {0}", exception->Message));
        result = false;
    }
    finally {
        //    SIO クローズ
        //DisconnectSerialIO( channel );
        //CloseSerialIO( channel );
    }

    return result;
}

/*!--------------------------------------------------------------------------*
  ---------------------------------------------------------------------------*/
bool SingletonHolder::ReadSerialIO( array<Byte> ^buffer, const int size, const int channel)
{
    bool result = true;

    try {
        //array<Byte>^  arr = stream->GetBuffer();
        pin_ptr<Byte> ptr = &buffer[0];

        int iDataSize = GetIncomingDataSize(channel);
        if ( iDataSize<size )
        {
            return false;
        }

        // Read data
        int ret = m_pDevhio->ReadSio( channel,
                                      ptr,
                                      size,
                                      DEVHIO_SIO_ATTR_NONE );
        if ( ret <= 0 ) {
            //printf( "[ERROR] Serial I/O Write Error\n" );
            return false;
        }
    }

    catch (Exception^ /*exception*/)
    {
        result = false;
    }

    finally
    {
    }

    return result;
}

/*!--------------------------------------------------------------------------*
  ---------------------------------------------------------------------------*/
int SingletonHolder::GetIncomingDataSize(const int channel)
{
    return m_pDevhio->GetReadableBytesSio( channel,
                                           DEVHIO_SIO_ATTR_NONE );
}

/*!--------------------------------------------------------------------------*
  ---------------------------------------------------------------------------*/
int SingletonHolder::GetWritableDataSize(const int channel)
{
    return m_pDevhio->GetWritableBytesSio( channel,
                                           DEVHIO_SIO_ATTR_NONE );
}
