﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

namespace EffectMaker.Foundation.Texture
{
    /// <summary>
    /// テクスチャタイプ
    /// </summary>
    public enum TextureTypes
    {
        /// <summary>
        /// １次元テクスチャ
        /// </summary>
        Dim1,

        /// <summary>
        /// ２次元テクスチャ
        /// </summary>
        Dim2,

        /// <summary>
        /// ３次元テクスチャ
        /// </summary>
        Dim3,

        /// <summary>
        /// キューブテクスチャ
        /// </summary>
        Cube,

        /// <summary>
        /// １次元配列テクスチャ
        /// </summary>
        ArrayDim1,

        /// <summary>
        /// ２次元配列テクスチャ
        /// </summary>
        ArrayDim2,

        /// <summary>
        /// ３次元配列テクスチャ
        /// </summary>
        ArrayDim3,

        /// <summary>
        /// キューブ配列テクスチャ
        /// </summary>
        ArrayCube,
    }
}
