﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

using System;
using System.Drawing;

using EffectMaker.Foundation.Utility;

namespace EffectMaker.Foundation.Render.Renderable
{
    /// <summary>
    /// Class that renders a rectangle.
    /// </summary>
    public class RectangleShape : RenderableBase
    {
        /// <summary>
        /// Default constructor.
        /// </summary>
        public RectangleShape() :
            base()
        {
            this.BorderColor = Color.Black;
            this.BorderThickness = 1.0f;
            this.FillColor = Color.White;
        }

        /// <summary>
        /// Render the item's background.
        /// </summary>
        /// <param name="g">The graphics object for rendering.</param>
        protected override void DrawBackground(Graphics g)
        {
            // Fill the rectangle.
            if (this.FillColor.Equals(Color.Transparent) == false)
            {
                using (var brush = new SolidBrush(this.FillColor))
                {
                    g.FillRectangle(brush, this.TransformedBounds);
                }
            }
        }

        /// <summary>
        /// Render the item's border.
        /// </summary>
        /// <param name="g">The graphics object for rendering.</param>
        protected override void DrawBorder(Graphics g)
        {
            // Draw the border.
            if (this.BorderThickness > 0.0f && this.BorderColor.Equals(Color.Transparent) == false)
            {
                using (var pen = new Pen(this.BorderColor, this.BorderThickness))
                {
                    // Render top border.
                    if (this.SavedRenderContext.IsViewRenctangleEmpty == true ||
                        this.TransformedBounds.Top > this.SavedRenderContext.ViewRectangle.Top)
                    {
                        g.DrawLine(
                            pen,
                            this.TransformedBounds.Left,
                            this.TransformedBounds.Top,
                            this.TransformedBounds.Right,
                            this.TransformedBounds.Top);
                    }

                    // Render bottom border.
                    if (this.SavedRenderContext.IsViewRenctangleEmpty == true ||
                        this.TransformedBounds.Bottom < this.SavedRenderContext.ViewRectangle.Bottom)
                    {
                        g.DrawLine(
                            pen,
                            this.TransformedBounds.Left,
                            this.TransformedBounds.Bottom,
                            this.TransformedBounds.Right,
                            this.TransformedBounds.Bottom);
                    }

                    // Render left border.
                    if (this.SavedRenderContext.IsViewRenctangleEmpty == true ||
                        this.TransformedBounds.Left > this.SavedRenderContext.ViewRectangle.Left)
                    {
                        g.DrawLine(
                            pen,
                            this.TransformedBounds.Left,
                            this.TransformedBounds.Top,
                            this.TransformedBounds.Left,
                            this.TransformedBounds.Bottom);
                    }

                    // Render right border.
                    if (this.SavedRenderContext.IsViewRenctangleEmpty == true ||
                        this.TransformedBounds.Right < this.SavedRenderContext.ViewRectangle.Right)
                    {
                        g.DrawLine(
                            pen,
                            this.TransformedBounds.Right,
                            this.TransformedBounds.Top,
                            this.TransformedBounds.Right,
                            this.TransformedBounds.Bottom);
                    }
                }
            }
        }
    }
}
