﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

namespace EffectMaker.Foundation.Primitives
{
    /// <summary>
    /// Generic class for a 3-element vector with unsigned integer values.
    /// </summary>
    public class Vector3u : Primitiveu
    {
        /// <summary>
        /// Default constructor.
        /// </summary>
        public Vector3u()
        {
        }

        /// <summary>
        /// Copy constructor.
        /// </summary>
        /// <param name="src">The source to copy from.</param>
        public Vector3u(Primitiveu src)
            : base(src)
        {
        }

        /// <summary>
        /// Copy constructor.
        /// </summary>
        /// <param name="src">The source array.</param>
        public Vector3u(uint[] src)
            : base(src)
        {
        }

        /// <summary>
        /// Setter constructor.
        /// </summary>
        /// <param name="x">The x value to set.</param>
        /// <param name="y">The y value to set.</param>
        /// <param name="z">The z value to set.</param>
        public Vector3u(
                        uint x,
                        uint y,
                        uint z) :
            base()
        {
            this.Set(x, y, z);
        }

        /// <summary>
        /// Get the number of value elements the primitive contains.
        /// </summary>
        public override int Count
        {
            get { return 3; }
        }

        /// <summary>
        /// Get or set the X element of the vector.
        /// </summary>
        public uint X
        {
            get { return this.Values[0]; }
            set { this.Values[0] = value; }
        }

        /// <summary>
        /// Get or set the Y element of the vector.
        /// </summary>
        public uint Y
        {
            get { return this.Values[1]; }
            set { this.Values[1] = value; }
        }

        /// <summary>
        /// Get or set the Z element of the vector.
        /// </summary>
        public uint Z
        {
            get { return this.Values[2]; }
            set { this.Values[2] = value; }
        }

        /// <summary>
        /// Set value to the instance.
        /// </summary>
        /// <param name="x">The x value to set.</param>
        /// <param name="y">The y value to set.</param>
        /// <param name="z">The z value to set.</param>
        /// <returns>True on success.</returns>
        public bool Set(
                        uint x,
                        uint y,
                        uint z)
        {
            this.Values[0] = x;
            this.Values[1] = y;
            this.Values[2] = z;

            return true;
        }
    }
}
