﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

using EffectMaker.Foundation.Model.Types;

namespace EffectMaker.Foundation.Model
{
    /// <summary>
    /// Vertex elements.
    /// </summary>
    public class VertexElement
    {
        /// <summary>
        /// コンストラクタです。
        /// </summary>
        public VertexElement()
        {
        }

        /// <summary>
        /// コンストラクタです。
        /// </summary>
        /// <param name="elementData">THe vertex element data.</param>
        /// <param name="column">The number of values in a single entry.</param>
        /// <param name="usage">The count of entries.</param>
        public VertexElement(float[] elementData, int column, VertexElementUsages usage)
        {
            this.ElementData = elementData;
            this.Column = column;
            this.Usage = usage;
        }

        /// <summary>
        /// Get the vertex element data.
        /// </summary>
        public float[] ElementData { get; set; }

        /// <summary>
        /// Get the number of values in a single entry.
        /// </summary>
        public int Column { get; set; }

        /// <summary>
        /// Get the count of entries.
        /// </summary>
        public int Count
        {
            get
            {
                return (this.Column == 0) ? 0 : this.ElementData.Length / this.Column;
            }
        }

        /// <summary>
        /// Get the usage of the vertex element.
        /// </summary>
        public VertexElementUsages Usage { get; set; }

        /// <summary>
        /// シェーダ上でのフォーマット
        /// </summary>
        public int Type { get; set; }

        /// <summary>
        /// 実際の頂点バッファのフォーマット
        /// </summary>
        public int QuantizeType { get; set; }

        /// <summary>
        /// 頂点バッファのインデックス
        /// </summary>
        public int AttributeIndex { get; set; }
    }
}
