﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

namespace EffectMaker.Foundation.Model
{
    /// <summary>
    /// モデルデータです。
    /// </summary>
    public class ModelData
    {
        /// <summary>
        /// 頂点座標要素を取得または設定します。
        /// </summary>
        public VertexElement Position { get; set; }

        /// <summary>
        /// 頂点座標要素の名前を取得または設定します。
        /// </summary>
        public string PositionName { get; set; }

        /// <summary>
        /// 法線ベクトル要素を取得または設定します。
        /// </summary>
        public VertexElement Normal { get; set; }

        /// <summary>
        /// 法線ベクトル要素の名前を取得または設定します。
        /// </summary>
        public string NormalName { get; set; }

        /// <summary>
        /// 接線ベクトル要素を取得または設定します。
        /// </summary>
        public VertexElement Tangent { get; set; }

        /// <summary>
        /// 接線ベクトル要素の名前を取得または設定します。
        /// </summary>
        public string TangentName { get; set; }

        /// <summary>
        /// テクスチャ座標要素0を取得または設定します。
        /// </summary>
        public VertexElement TexCoord0 { get; set; }

        /// <summary>
        /// テクスチャ座標要素0の名前を取得または設定します。
        /// </summary>
        public string TexCoordName0 { get; set; }

        /// <summary>
        /// テクスチャ座標要素1を取得または設定します。
        /// </summary>
        public VertexElement TexCoord1 { get; set; }

        /// <summary>
        /// テクスチャ座標要素1の名前を取得または設定します。
        /// </summary>
        public string TexCoordName1 { get; set; }

        /// <summary>
        /// 頂点カラー要素を取得または設定します。
        /// </summary>
        public VertexElement Color { get; set; }

        /// <summary>
        /// 頂点カラー要素の名前を取得または設定します。
        /// </summary>
        public string ColorName { get; set; }

        /// <summary>G
        /// インデックスバッファの数を取得または設定します。
        /// </summary>
        public IndexBuffer Indexes { get; set; }

        /// <summary>
        /// テクスチャ座標要素の数を取得または設定します。
        /// </summary>
        public int NumberOfTexCoords { get; set; }

        /// <summary>
        /// モデルから参照しているテクスチャの数を取得または設定します。
        /// </summary>
        public int NumberOfTextures { get; set; }

        /// <summary>
        /// LOD数を取得または設定します。
        /// </summary>
        public int LodCount { get; set; }

        /// <summary>
        /// メモリーサイズを取得します。
        /// </summary>
        public int MemorySize
        {
            get
            {
                var size = this.Position.ElementData.Length;
                size += this.Normal.ElementData.Length;
                size += this.Tangent.ElementData.Length;
                size += this.TexCoord0.ElementData.Length;
                size += this.TexCoord1.ElementData.Length;
                size += this.Color.ElementData.Length;
                size += this.Indexes.Indexes.Length;

                return size;
            }
        }
    }
}
