﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

using System.Collections.Generic;
using EffectMaker.Foundation.Model.Types;

namespace EffectMaker.Foundation.Model
{
    /// <summary>
    /// モデル読み込み結果の詳細メッセージです.
    /// </summary>
    public class LoadModelMessage
    {
        /// <summary>
        /// コンストラクタです.
        /// </summary>
        /// <param name="code">メッセージコード</param>
        /// <param name="args">メッセージ引数</param>
        public LoadModelMessage(LoadModelMessageCodes code, params object[] args)
        {
            this.MessageCode = code;
            this.MessageArgs = args;
        }

        /// <summary>
        /// メッセージコードを取得します.
        /// </summary>
        public LoadModelMessageCodes MessageCode { get; private set; }

        /// <summary>
        /// メッセージ引数を取得します.
        /// </summary>
        public object[] MessageArgs { get; private set; }
    }

    /// <summary>
    /// 読み込み結果と読み込んだモデルデータ
    /// </summary>
    public class LoadModelResultWithData
    {
        /// <summary>
        /// 読み込み結果
        /// </summary>
        public LoadModelResults Result { get; set; }

        /// <summary>
        /// モデルデータ
        /// </summary>
        public ModelData ModelData { get; set; }

        /// <summary>
        /// 結果詳細
        /// </summary>
        public List<LoadModelMessage> DetailMessages { get; set; }
    }

    /// <summary>
    /// 読み込んだ結果とモデルデータのファイルパス
    /// </summary>
    public class LoadModelResultWithFilePath
    {
        /// <summary>
        /// 読み込み結果
        /// </summary>
        public LoadModelResults Result { get; set; }

        /// <summary>
        /// モデルのファイルパス
        /// </summary>
        public string FilePath { get; set; }

        /// <summary>
        /// 結果詳細
        /// </summary>
        public List<LoadModelMessage> DetailMessages { get; set; }
    }

    /// <summary>
    /// 中間ファイルのコメント情報
    /// </summary>
    public class LoadComment
    {
        /// <summary>
        /// コメントテキスト
        /// </summary>
        public string Comment { get; set; }

        /// <summary>
        /// ラベルカラー(floatスペース区切り)
        /// </summary>
        public string Color { get; set; }
    }
}
