﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

using System;

namespace EffectMaker.Foundation.Interfaces
{
    /// <summary>
    /// Defines a way to execute method in a loose-coupled manner.
    /// </summary>
    public interface IExecutable
    {
        /// <summary>
        /// Raise when the capability of the executable to execute changes.
        /// </summary>
        event EventHandler CanExecuteChanged;

        /// <summary>
        /// Tells whether the executable can be executed or not.
        /// </summary>
        /// <param name="parameter">Custom parameter.</param>
        /// <returns>Returns true if the executable can be executed, false otherwise.</returns>
        bool CanExecute(object parameter);

        /// <summary>
        /// Execute the executable.
        /// </summary>
        /// <param name="parameter">Custom parameter.</param>
        void Execute(object parameter);
    }
}
