﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

namespace EffectMaker.Foundation.EventArguments
{
    /// <summary>
    /// チェックボックスのチェック状態が変わったときのイベントです.
    /// </summary>
    public class CheckBoxChangedEventArgs
    {
        /// <summary>
        /// CheckBoxChangedEventArgsのインスタンスを初期化します.
        /// </summary>
        /// <param name="value">チェックボックスのチェック状態です.</param>
        /// <param name="customParameter">カスタムパラメータです.</param>
        public CheckBoxChangedEventArgs(
            bool value,
            object customParameter = null)
        {
            this.Value = value;
            this.CustomParameter = customParameter;
        }

        /// <summary>
        /// チェックボックスのチェック状態を取得します.
        /// </summary>
        public bool Value { get; private set; }

        /// <summary>
        /// カスタムパラメータを取得します.
        /// </summary>
        public object CustomParameter { get; private set; }
    }
}
